<?php
/**
 * PurchaseOrdersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Unleashed\ApiException;
use Unleashed\Configuration;
use Unleashed\FormDataProcessor;
use Unleashed\HeaderSelector;
use Unleashed\ObjectSerializer;

/**
 * PurchaseOrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PurchaseOrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addPurchaseOrderLines' => [
            'application/json',
            'application/xml',
        ],
        'completePurchaseOrder' => [
            'application/json',
        ],
        'createPurchaseOrder' => [
            'application/json',
            'application/xml',
        ],
        'getPurchaseOrders' => [
            'application/json',
        ],
        'getPurchaseOrdersId' => [
            'application/json',
        ],
        'getPurchaseOrdersIdCosts' => [
            'application/json',
        ],
        'updatePurchaseOrder' => [
            'application/json',
            'application/xml',
        ],
        'updatePurchaseOrderLines' => [
            'application/json',
            'application/xml',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addPurchaseOrderLines
     *
     * Add Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PurchaseOrder
     */
    public function addPurchaseOrderLines($id, $body = null, string $contentType = self::contentTypes['addPurchaseOrderLines'][0])
    {
        list($response) = $this->addPurchaseOrderLinesWithHttpInfo($id, $body, $contentType);
        return $response;
    }

    /**
     * Operation addPurchaseOrderLinesWithHttpInfo
     *
     * Add Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function addPurchaseOrderLinesWithHttpInfo($id, $body = null, string $contentType = self::contentTypes['addPurchaseOrderLines'][0])
    {
        $request = $this->addPurchaseOrderLinesRequest($id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PurchaseOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PurchaseOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation addPurchaseOrderLinesAsync
     *
     * Add Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addPurchaseOrderLinesAsync($id, $body = null, string $contentType = self::contentTypes['addPurchaseOrderLines'][0])
    {
        return $this->addPurchaseOrderLinesAsyncWithHttpInfo($id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addPurchaseOrderLinesAsyncWithHttpInfo
     *
     * Add Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addPurchaseOrderLinesAsyncWithHttpInfo($id, $body = null, string $contentType = self::contentTypes['addPurchaseOrderLines'][0])
    {
        $returnType = '\Unleashed\Model\PurchaseOrder';
        $request = $this->addPurchaseOrderLinesRequest($id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addPurchaseOrderLines'
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addPurchaseOrderLinesRequest($id, $body = null, string $contentType = self::contentTypes['addPurchaseOrderLines'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling addPurchaseOrderLines'
            );
        }



        $resourcePath = '/PurchaseOrders/{id}/Lines';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation completePurchaseOrder
     *
     * Complete a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function completePurchaseOrder($id, string $contentType = self::contentTypes['completePurchaseOrder'][0])
    {
        list($response) = $this->completePurchaseOrderWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation completePurchaseOrderWithHttpInfo
     *
     * Complete a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function completePurchaseOrderWithHttpInfo($id, string $contentType = self::contentTypes['completePurchaseOrder'][0])
    {
        $request = $this->completePurchaseOrderRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation completePurchaseOrderAsync
     *
     * Complete a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completePurchaseOrderAsync($id, string $contentType = self::contentTypes['completePurchaseOrder'][0])
    {
        return $this->completePurchaseOrderAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation completePurchaseOrderAsyncWithHttpInfo
     *
     * Complete a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completePurchaseOrderAsyncWithHttpInfo($id, string $contentType = self::contentTypes['completePurchaseOrder'][0])
    {
        $returnType = 'object';
        $request = $this->completePurchaseOrderRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'completePurchaseOrder'
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function completePurchaseOrderRequest($id, string $contentType = self::contentTypes['completePurchaseOrder'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling completePurchaseOrder'
            );
        }


        $resourcePath = '/PurchaseOrders/{id}/Complete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPurchaseOrder
     *
     * Create a Purchase Order
     *
     * @param  \Unleashed\Model\PurchaseOrder|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPurchaseOrder'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PurchaseOrder
     */
    public function createPurchaseOrder($body = null, string $contentType = self::contentTypes['createPurchaseOrder'][0])
    {
        list($response) = $this->createPurchaseOrderWithHttpInfo($body, $contentType);
        return $response;
    }

    /**
     * Operation createPurchaseOrderWithHttpInfo
     *
     * Create a Purchase Order
     *
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPurchaseOrder'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPurchaseOrderWithHttpInfo($body = null, string $contentType = self::contentTypes['createPurchaseOrder'][0])
    {
        $request = $this->createPurchaseOrderRequest($body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PurchaseOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PurchaseOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createPurchaseOrderAsync
     *
     * Create a Purchase Order
     *
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderAsync($body = null, string $contentType = self::contentTypes['createPurchaseOrder'][0])
    {
        return $this->createPurchaseOrderAsyncWithHttpInfo($body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPurchaseOrderAsyncWithHttpInfo
     *
     * Create a Purchase Order
     *
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPurchaseOrderAsyncWithHttpInfo($body = null, string $contentType = self::contentTypes['createPurchaseOrder'][0])
    {
        $returnType = '\Unleashed\Model\PurchaseOrder';
        $request = $this->createPurchaseOrderRequest($body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPurchaseOrder'
     *
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPurchaseOrderRequest($body = null, string $contentType = self::contentTypes['createPurchaseOrder'][0])
    {



        $resourcePath = '/PurchaseOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPurchaseOrders
     *
     * List a page of Purchase Orders
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string|null $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string|null $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string|null $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string|null $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string|null $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string|null $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string|null $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string|null $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string|null $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string|null $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string|null $warehouse_code warehouse_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrders'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PagedPurchaseOrder
     */
    public function getPurchaseOrders($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null, string $contentType = self::contentTypes['getPurchaseOrders'][0])
    {
        list($response) = $this->getPurchaseOrdersWithHttpInfo($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code, $contentType);
        return $response;
    }

    /**
     * Operation getPurchaseOrdersWithHttpInfo
     *
     * List a page of Purchase Orders
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string|null $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string|null $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string|null $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string|null $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string|null $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string|null $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string|null $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string|null $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string|null $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string|null $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string|null $warehouse_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrders'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PagedPurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPurchaseOrdersWithHttpInfo($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null, string $contentType = self::contentTypes['getPurchaseOrders'][0])
    {
        $request = $this->getPurchaseOrdersRequest($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PagedPurchaseOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PagedPurchaseOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PagedPurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPurchaseOrdersAsync
     *
     * List a page of Purchase Orders
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string|null $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string|null $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string|null $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string|null $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string|null $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string|null $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string|null $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string|null $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string|null $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string|null $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string|null $warehouse_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersAsync($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null, string $contentType = self::contentTypes['getPurchaseOrders'][0])
    {
        return $this->getPurchaseOrdersAsyncWithHttpInfo($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPurchaseOrdersAsyncWithHttpInfo
     *
     * List a page of Purchase Orders
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string|null $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string|null $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string|null $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string|null $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string|null $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string|null $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string|null $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string|null $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string|null $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string|null $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string|null $warehouse_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersAsyncWithHttpInfo($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null, string $contentType = self::contentTypes['getPurchaseOrders'][0])
    {
        $returnType = '\Unleashed\Model\PagedPurchaseOrder';
        $request = $this->getPurchaseOrdersRequest($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPurchaseOrders'
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string|null $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string|null $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string|null $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string|null $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string|null $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string|null $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string|null $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string|null $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string|null $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string|null $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string|null $warehouse_code (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPurchaseOrdersRequest($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null, string $contentType = self::contentTypes['getPurchaseOrders'][0])
    {

        // verify the required parameter 'page_number' is set
        if ($page_number === null || (is_array($page_number) && count($page_number) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $page_number when calling getPurchaseOrders'
            );
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling PurchaseOrdersApi.getPurchaseOrders, must be smaller than or equal to 1000.');
        }
        if ($page_size !== null && $page_size < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling PurchaseOrdersApi.getPurchaseOrders, must be bigger than or equal to 1.');
        }
        













        $resourcePath = '/PurchaseOrders/Page/{pageNumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'pageSize', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $brief,
            'brief', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $completed_after,
            'completedAfter', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $completed_before,
            'completedBefore', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $custom_order_status,
            'customOrderStatus', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $modified_since,
            'modifiedSince', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'orderNumber', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_status,
            'orderStatus', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $serial_batch,
            'serialBatch', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $supplier_code,
            'supplierCode', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_code,
            'warehouseCode', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                '{' . 'pageNumber' . '}',
                ObjectSerializer::toPathValue($page_number),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPurchaseOrdersId
     *
     * Get a Purchase Order by ID
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersId'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PurchaseOrder
     */
    public function getPurchaseOrdersId($id, string $contentType = self::contentTypes['getPurchaseOrdersId'][0])
    {
        list($response) = $this->getPurchaseOrdersIdWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getPurchaseOrdersIdWithHttpInfo
     *
     * Get a Purchase Order by ID
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersId'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPurchaseOrdersIdWithHttpInfo($id, string $contentType = self::contentTypes['getPurchaseOrdersId'][0])
    {
        $request = $this->getPurchaseOrdersIdRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PurchaseOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PurchaseOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPurchaseOrdersIdAsync
     *
     * Get a Purchase Order by ID
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersIdAsync($id, string $contentType = self::contentTypes['getPurchaseOrdersId'][0])
    {
        return $this->getPurchaseOrdersIdAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPurchaseOrdersIdAsyncWithHttpInfo
     *
     * Get a Purchase Order by ID
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersIdAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getPurchaseOrdersId'][0])
    {
        $returnType = '\Unleashed\Model\PurchaseOrder';
        $request = $this->getPurchaseOrdersIdRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPurchaseOrdersId'
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPurchaseOrdersIdRequest($id, string $contentType = self::contentTypes['getPurchaseOrdersId'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getPurchaseOrdersId'
            );
        }


        $resourcePath = '/PurchaseOrders/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPurchaseOrdersIdCosts
     *
     * Get Purchase Order Costs
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersIdCosts'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PurchaseOrderCosts
     */
    public function getPurchaseOrdersIdCosts($id, string $contentType = self::contentTypes['getPurchaseOrdersIdCosts'][0])
    {
        list($response) = $this->getPurchaseOrdersIdCostsWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getPurchaseOrdersIdCostsWithHttpInfo
     *
     * Get Purchase Order Costs
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersIdCosts'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PurchaseOrderCosts, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPurchaseOrdersIdCostsWithHttpInfo($id, string $contentType = self::contentTypes['getPurchaseOrdersIdCosts'][0])
    {
        $request = $this->getPurchaseOrdersIdCostsRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PurchaseOrderCosts',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PurchaseOrderCosts',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PurchaseOrderCosts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getPurchaseOrdersIdCostsAsync
     *
     * Get Purchase Order Costs
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersIdCosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersIdCostsAsync($id, string $contentType = self::contentTypes['getPurchaseOrdersIdCosts'][0])
    {
        return $this->getPurchaseOrdersIdCostsAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPurchaseOrdersIdCostsAsyncWithHttpInfo
     *
     * Get Purchase Order Costs
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersIdCosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersIdCostsAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getPurchaseOrdersIdCosts'][0])
    {
        $returnType = '\Unleashed\Model\PurchaseOrderCosts';
        $request = $this->getPurchaseOrdersIdCostsRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPurchaseOrdersIdCosts'
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPurchaseOrdersIdCosts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPurchaseOrdersIdCostsRequest($id, string $contentType = self::contentTypes['getPurchaseOrdersIdCosts'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getPurchaseOrdersIdCosts'
            );
        }


        $resourcePath = '/PurchaseOrders/{id}/Costs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePurchaseOrder
     *
     * Update a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrder|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PurchaseOrder
     */
    public function updatePurchaseOrder($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrder'][0])
    {
        list($response) = $this->updatePurchaseOrderWithHttpInfo($id, $body, $contentType);
        return $response;
    }

    /**
     * Operation updatePurchaseOrderWithHttpInfo
     *
     * Update a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePurchaseOrderWithHttpInfo($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrder'][0])
    {
        $request = $this->updatePurchaseOrderRequest($id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PurchaseOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PurchaseOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePurchaseOrderAsync
     *
     * Update a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePurchaseOrderAsync($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrder'][0])
    {
        return $this->updatePurchaseOrderAsyncWithHttpInfo($id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePurchaseOrderAsyncWithHttpInfo
     *
     * Update a Purchase Order
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePurchaseOrderAsyncWithHttpInfo($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrder'][0])
    {
        $returnType = '\Unleashed\Model\PurchaseOrder';
        $request = $this->updatePurchaseOrderRequest($id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePurchaseOrder'
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrder|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePurchaseOrderRequest($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrder'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updatePurchaseOrder'
            );
        }



        $resourcePath = '/PurchaseOrders/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePurchaseOrderLines
     *
     * Update Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PurchaseOrder
     */
    public function updatePurchaseOrderLines($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrderLines'][0])
    {
        list($response) = $this->updatePurchaseOrderLinesWithHttpInfo($id, $body, $contentType);
        return $response;
    }

    /**
     * Operation updatePurchaseOrderLinesWithHttpInfo
     *
     * Update Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePurchaseOrderLinesWithHttpInfo($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrderLines'][0])
    {
        $request = $this->updatePurchaseOrderLinesRequest($id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PurchaseOrder',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PurchaseOrder',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updatePurchaseOrderLinesAsync
     *
     * Update Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePurchaseOrderLinesAsync($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrderLines'][0])
    {
        return $this->updatePurchaseOrderLinesAsyncWithHttpInfo($id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePurchaseOrderLinesAsyncWithHttpInfo
     *
     * Update Purchase Order Lines
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePurchaseOrderLinesAsyncWithHttpInfo($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrderLines'][0])
    {
        $returnType = '\Unleashed\Model\PurchaseOrder';
        $request = $this->updatePurchaseOrderLinesRequest($id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePurchaseOrderLines'
     *
     * @param  string $id internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 (required)
     * @param  \Unleashed\Model\PurchaseOrderLine[]|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePurchaseOrderLines'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePurchaseOrderLinesRequest($id, $body = null, string $contentType = self::contentTypes['updatePurchaseOrderLines'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updatePurchaseOrderLines'
            );
        }



        $resourcePath = '/PurchaseOrders/{id}/Lines';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
