# Unleashed\WarehousesApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getWarehouses()**](WarehousesApi.md#getWarehouses) | **GET** /Warehouses |  |


## `getWarehouses()`

```php
getWarehouses($warehouse_code, $warehouse_name, $modified_since): \Unleashed\Model\PagedWarehouse
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehousesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$warehouse_code = 'warehouse_code_example'; // string
$warehouse_name = 'warehouse_name_example'; // string
$modified_since = 'modified_since_example'; // string

try {
    $result = $apiInstance->getWarehouses($warehouse_code, $warehouse_name, $modified_since);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehousesApi->getWarehouses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **warehouse_code** | **string**|  | [optional] |
| **warehouse_name** | **string**|  | [optional] |
| **modified_since** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedWarehouse**](../Model/PagedWarehouse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
