# Unleashed\WarehouseStockTransfersApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**completeWarehouseStockTransfer()**](WarehouseStockTransfersApi.md#completeWarehouseStockTransfer) | **POST** /WarehouseStockTransfers/{id}/Complete | Complete an existing Warehouse Stock Transfer |
| [**createWarehouseStockTransfer()**](WarehouseStockTransfersApi.md#createWarehouseStockTransfer) | **POST** /WarehouseStockTransfers | Create a new Warehouse Stock Transfer |
| [**createWarehouseStockTransfersLine()**](WarehouseStockTransfersApi.md#createWarehouseStockTransfersLine) | **POST** /WarehouseStockTransfers/{id}/Lines | Create a new line to a Warehouse Stock Transfer |
| [**deleteWarehouseStockTransfer()**](WarehouseStockTransfersApi.md#deleteWarehouseStockTransfer) | **DELETE** /WarehouseStockTransfers/{id} | Delete a Parked Warehouse Stock Transfer |
| [**deleteWarehouseStockTransferLine()**](WarehouseStockTransfersApi.md#deleteWarehouseStockTransferLine) | **DELETE** /WarehouseStockTransfers/{id}/Lines/{lineId} | Delete existing line of a Warehouse Stock Transfer |
| [**getWarehouseStockTransfer()**](WarehouseStockTransfersApi.md#getWarehouseStockTransfer) | **GET** /WarehouseStockTransfers/{id} | View a Warehouse Stock Transfer with the specified Guid |
| [**getWarehouseStockTransfers()**](WarehouseStockTransfersApi.md#getWarehouseStockTransfers) | **GET** /WarehouseStockTransfers | List a page of Warehouse Stock Transfers |
| [**updateWarehouseStockTransfer()**](WarehouseStockTransfersApi.md#updateWarehouseStockTransfer) | **PUT** /WarehouseStockTransfers/{id} | Update an existing Warehouse Stock Transfer and existing lines |
| [**updateWarehouseStockTransferLine()**](WarehouseStockTransfersApi.md#updateWarehouseStockTransferLine) | **PUT** /WarehouseStockTransfers/{id}/Lines/{lineId} | Update an existing line of a Warehouse Stock Transfer |


## `completeWarehouseStockTransfer()`

```php
completeWarehouseStockTransfer($id)
```

Complete an existing Warehouse Stock Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $apiInstance->completeWarehouseStockTransfer($id);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->completeWarehouseStockTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createWarehouseStockTransfer()`

```php
createWarehouseStockTransfer($body): \Unleashed\Model\WarehouseStockTransfer
```

Create a new Warehouse Stock Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\WarehouseStockTransfer(); // \Unleashed\Model\WarehouseStockTransfer

try {
    $result = $apiInstance->createWarehouseStockTransfer($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->createWarehouseStockTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Unleashed\Model\WarehouseStockTransfer**](../Model/WarehouseStockTransfer.md)|  | [optional] |

### Return type

[**\Unleashed\Model\WarehouseStockTransfer**](../Model/WarehouseStockTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createWarehouseStockTransfersLine()`

```php
createWarehouseStockTransfersLine($id, $body): \Unleashed\Model\TransferDetail
```

Create a new line to a Warehouse Stock Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = new \Unleashed\Model\TransferDetail(); // \Unleashed\Model\TransferDetail

try {
    $result = $apiInstance->createWarehouseStockTransfersLine($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->createWarehouseStockTransfersLine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **body** | [**\Unleashed\Model\TransferDetail**](../Model/TransferDetail.md)|  | [optional] |

### Return type

[**\Unleashed\Model\TransferDetail**](../Model/TransferDetail.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteWarehouseStockTransfer()`

```php
deleteWarehouseStockTransfer($id)
```

Delete a Parked Warehouse Stock Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $apiInstance->deleteWarehouseStockTransfer($id);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->deleteWarehouseStockTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteWarehouseStockTransferLine()`

```php
deleteWarehouseStockTransferLine($id, $line_id)
```

Delete existing line of a Warehouse Stock Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$line_id = 'line_id_example'; // string

try {
    $apiInstance->deleteWarehouseStockTransferLine($id, $line_id);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->deleteWarehouseStockTransferLine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **line_id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseStockTransfer()`

```php
getWarehouseStockTransfer($id): \Unleashed\Model\WarehouseStockTransfer
```

View a Warehouse Stock Transfer with the specified Guid

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->getWarehouseStockTransfer($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->getWarehouseStockTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

[**\Unleashed\Model\WarehouseStockTransfer**](../Model/WarehouseStockTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseStockTransfers()`

```php
getWarehouseStockTransfers($modified_since, $page_size, $transfer_status): \Unleashed\Model\PagedwarehouseStockTransfer
```

List a page of Warehouse Stock Transfers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$modified_since = 'modified_since_example'; // string
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$transfer_status = 'transfer_status_example'; // string | If the filter is not provided, returns all orders including deleted Warehouse Stock Transfers. Returns Warehouse Stock Transfers with the specified status. Multiple selection can be specified as comma separated. For example: transferStatus=Parked,Completed.

try {
    $result = $apiInstance->getWarehouseStockTransfers($modified_since, $page_size, $transfer_status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->getWarehouseStockTransfers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **modified_since** | **string**|  | [optional] |
| **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional] |
| **transfer_status** | **string**| If the filter is not provided, returns all orders including deleted Warehouse Stock Transfers. Returns Warehouse Stock Transfers with the specified status. Multiple selection can be specified as comma separated. For example: transferStatus&#x3D;Parked,Completed. | [optional] |

### Return type

[**\Unleashed\Model\PagedwarehouseStockTransfer**](../Model/PagedwarehouseStockTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateWarehouseStockTransfer()`

```php
updateWarehouseStockTransfer($id, $body): \Unleashed\Model\WarehouseStockTransfer
```

Update an existing Warehouse Stock Transfer and existing lines

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = new \Unleashed\Model\WarehouseStockTransfer(); // \Unleashed\Model\WarehouseStockTransfer

try {
    $result = $apiInstance->updateWarehouseStockTransfer($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->updateWarehouseStockTransfer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **body** | [**\Unleashed\Model\WarehouseStockTransfer**](../Model/WarehouseStockTransfer.md)|  | [optional] |

### Return type

[**\Unleashed\Model\WarehouseStockTransfer**](../Model/WarehouseStockTransfer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateWarehouseStockTransferLine()`

```php
updateWarehouseStockTransferLine($id, $line_id, $body): \Unleashed\Model\TransferDetail
```

Update an existing line of a Warehouse Stock Transfer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\WarehouseStockTransfersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$line_id = 'line_id_example'; // string
$body = new \Unleashed\Model\TransferDetail(); // \Unleashed\Model\TransferDetail

try {
    $result = $apiInstance->updateWarehouseStockTransferLine($id, $line_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling WarehouseStockTransfersApi->updateWarehouseStockTransferLine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **line_id** | **string**|  | |
| **body** | [**\Unleashed\Model\TransferDetail**](../Model/TransferDetail.md)|  | [optional] |

### Return type

[**\Unleashed\Model\TransferDetail**](../Model/TransferDetail.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
