# Unleashed\TaxesApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getTaxes()**](TaxesApi.md#getTaxes) | **GET** /Taxes |  |


## `getTaxes()`

```php
getTaxes($can_apply_to_revenue, $can_apply_to_expenses): \Unleashed\Model\PagedTax
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$can_apply_to_revenue = 'can_apply_to_revenue_example'; // string
$can_apply_to_expenses = 'can_apply_to_expenses_example'; // string

try {
    $result = $apiInstance->getTaxes($can_apply_to_revenue, $can_apply_to_expenses);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->getTaxes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **can_apply_to_revenue** | **string**|  | [optional] |
| **can_apply_to_expenses** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedTax**](../Model/PagedTax.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
