# Unleashed\SalesShipmentsApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createSalesShipment()**](SalesShipmentsApi.md#createSalesShipment) | **POST** /SalesShipments |  |
| [**deleteSalesShipment()**](SalesShipmentsApi.md#deleteSalesShipment) | **DELETE** /SalesShipments/{id} |  |
| [**deleteSalesShipmentLine()**](SalesShipmentsApi.md#deleteSalesShipmentLine) | **DELETE** /SalesShipments/Lines/{id} |  |
| [**getSalesShipment()**](SalesShipmentsApi.md#getSalesShipment) | **GET** /SalesShipments/{id} |  |
| [**getSalesShipments()**](SalesShipmentsApi.md#getSalesShipments) | **GET** /SalesShipments/Page/{pageNumber} |  |
| [**updateSalesShipment()**](SalesShipmentsApi.md#updateSalesShipment) | **PUT** /SalesShipments/{id} |  |


## `createSalesShipment()`

```php
createSalesShipment($serial_batch, $body): \Unleashed\Model\SalesShipment
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$serial_batch = True; // bool
$body = new \Unleashed\Model\SalesShipment(); // \Unleashed\Model\SalesShipment

try {
    $result = $apiInstance->createSalesShipment($serial_batch, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentsApi->createSalesShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **serial_batch** | **bool**|  | [optional] |
| **body** | [**\Unleashed\Model\SalesShipment**](../Model/SalesShipment.md)|  | [optional] |

### Return type

[**\Unleashed\Model\SalesShipment**](../Model/SalesShipment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSalesShipment()`

```php
deleteSalesShipment($id): \Unleashed\Model\SalesShipment
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->deleteSalesShipment($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentsApi->deleteSalesShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\Unleashed\Model\SalesShipment**](../Model/SalesShipment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSalesShipmentLine()`

```php
deleteSalesShipmentLine($id): object
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->deleteSalesShipmentLine($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentsApi->deleteSalesShipmentLine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesShipment()`

```php
getSalesShipment($id): \Unleashed\Model\SalesShipment
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->getSalesShipment($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentsApi->getSalesShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\Unleashed\Model\SalesShipment**](../Model/SalesShipment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesShipments()`

```php
getSalesShipments($page_number, $page_size, $shipment_status, $start_date, $end_date, $modified_since, $order_number, $serial_batch): \Unleashed\Model\PagedSalesShipment
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int
$shipment_status = 'shipment_status_example'; // string
$start_date = 'start_date_example'; // string
$end_date = 'end_date_example'; // string
$modified_since = 'modified_since_example'; // string
$order_number = 'order_number_example'; // string
$serial_batch = True; // bool

try {
    $result = $apiInstance->getSalesShipments($page_number, $page_size, $shipment_status, $start_date, $end_date, $modified_since, $order_number, $serial_batch);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentsApi->getSalesShipments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1] |
| **page_size** | **int**|  | [optional] |
| **shipment_status** | **string**|  | [optional] |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |
| **modified_since** | **string**|  | [optional] |
| **order_number** | **string**|  | [optional] |
| **serial_batch** | **bool**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedSalesShipment**](../Model/PagedSalesShipment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSalesShipment()`

```php
updateSalesShipment($id, $serial_batch, $body): \Unleashed\Model\SalesShipment
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesShipmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$serial_batch = 'serial_batch_example'; // string | If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned.
$body = new \Unleashed\Model\SalesShipment(); // \Unleashed\Model\SalesShipment

try {
    $result = $apiInstance->updateSalesShipment($id, $serial_batch, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentsApi->updateSalesShipment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **serial_batch** | **string**| If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. | [optional] |
| **body** | [**\Unleashed\Model\SalesShipment**](../Model/SalesShipment.md)|  | [optional] |

### Return type

[**\Unleashed\Model\SalesShipment**](../Model/SalesShipment.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
