# Unleashed\PurchaseOrdersApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**addPurchaseOrderLines()**](PurchaseOrdersApi.md#addPurchaseOrderLines) | **POST** /PurchaseOrders/{id}/Lines | Add Purchase Order Lines |
| [**completePurchaseOrder()**](PurchaseOrdersApi.md#completePurchaseOrder) | **POST** /PurchaseOrders/{id}/Complete | Complete a Purchase Order |
| [**createPurchaseOrder()**](PurchaseOrdersApi.md#createPurchaseOrder) | **POST** /PurchaseOrders | Create a Purchase Order |
| [**getPurchaseOrders()**](PurchaseOrdersApi.md#getPurchaseOrders) | **GET** /PurchaseOrders/Page/{pageNumber} | List a page of Purchase Orders |
| [**getPurchaseOrdersId()**](PurchaseOrdersApi.md#getPurchaseOrdersId) | **GET** /PurchaseOrders/{id} | Get a Purchase Order by ID |
| [**getPurchaseOrdersIdCosts()**](PurchaseOrdersApi.md#getPurchaseOrdersIdCosts) | **GET** /PurchaseOrders/{id}/Costs | Get Purchase Order Costs |
| [**updatePurchaseOrder()**](PurchaseOrdersApi.md#updatePurchaseOrder) | **PUT** /PurchaseOrders/{id} | Update a Purchase Order |
| [**updatePurchaseOrderLines()**](PurchaseOrdersApi.md#updatePurchaseOrderLines) | **PUT** /PurchaseOrders/{id}/Lines | Update Purchase Order Lines |


## `addPurchaseOrderLines()`

```php
addPurchaseOrderLines($id, $body): \Unleashed\Model\PurchaseOrder
```

Add Purchase Order Lines

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = array(new \Unleashed\Model\PurchaseOrderLine()); // \Unleashed\Model\PurchaseOrderLine[]

try {
    $result = $apiInstance->addPurchaseOrderLines($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->addPurchaseOrderLines: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **body** | [**\Unleashed\Model\PurchaseOrderLine[]**](../Model/PurchaseOrderLine.md)|  | [optional] |

### Return type

[**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `completePurchaseOrder()`

```php
completePurchaseOrder($id): object
```

Complete a Purchase Order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->completePurchaseOrder($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->completePurchaseOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createPurchaseOrder()`

```php
createPurchaseOrder($body): \Unleashed\Model\PurchaseOrder
```

Create a Purchase Order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\PurchaseOrder(); // \Unleashed\Model\PurchaseOrder

try {
    $result = $apiInstance->createPurchaseOrder($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->createPurchaseOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)|  | [optional] |

### Return type

[**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseOrders()`

```php
getPurchaseOrders($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code): \Unleashed\Model\PagedPurchaseOrder
```

List a page of Purchase Orders

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$brief = 'brief_example'; // string | Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group.
$completed_after = 'completed_after_example'; // string | Returns purchase orders completed after the specified date.
$completed_before = 'completed_before_example'; // string | Returns purchase orders completed before the specified date
$custom_order_status = 'custom_order_status_example'; // string | Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter.
$end_date = 'end_date_example'; // string | Only return purchases with OrderDate before a specified date
$modified_since = 'modified_since_example'; // string | Returns orders created or edited after a specified date, must be UTC format
$order_number = 'order_number_example'; // string | Returns a single order with the specified order number. If set, it overrides all other filters
$order_status = 'order_status_example'; // string | If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter.
$serial_batch = 'serial_batch_example'; // string | If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned.
$start_date = 'start_date_example'; // string | Only return purchases with OrderDate after a specified date
$supplier_code = 'supplier_code_example'; // string | Only return suppliers that start with the specific supplier code
$warehouse_code = 'warehouse_code_example'; // string

try {
    $result = $apiInstance->getPurchaseOrders($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->getPurchaseOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1] |
| **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional] |
| **brief** | **string**| Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. | [optional] |
| **completed_after** | **string**| Returns purchase orders completed after the specified date. | [optional] |
| **completed_before** | **string**| Returns purchase orders completed before the specified date | [optional] |
| **custom_order_status** | **string**| Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. | [optional] |
| **end_date** | **string**| Only return purchases with OrderDate before a specified date | [optional] |
| **modified_since** | **string**| Returns orders created or edited after a specified date, must be UTC format | [optional] |
| **order_number** | **string**| Returns a single order with the specified order number. If set, it overrides all other filters | [optional] |
| **order_status** | **string**| If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. | [optional] |
| **serial_batch** | **string**| If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. | [optional] |
| **start_date** | **string**| Only return purchases with OrderDate after a specified date | [optional] |
| **supplier_code** | **string**| Only return suppliers that start with the specific supplier code | [optional] |
| **warehouse_code** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedPurchaseOrder**](../Model/PagedPurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseOrdersId()`

```php
getPurchaseOrdersId($id): \Unleashed\Model\PurchaseOrder
```

Get a Purchase Order by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->getPurchaseOrdersId($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->getPurchaseOrdersId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

[**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseOrdersIdCosts()`

```php
getPurchaseOrdersIdCosts($id): \Unleashed\Model\PurchaseOrderCosts
```

Get Purchase Order Costs

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->getPurchaseOrdersIdCosts($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->getPurchaseOrdersIdCosts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

[**\Unleashed\Model\PurchaseOrderCosts**](../Model/PurchaseOrderCosts.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePurchaseOrder()`

```php
updatePurchaseOrder($id, $body): \Unleashed\Model\PurchaseOrder
```

Update a Purchase Order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = new \Unleashed\Model\PurchaseOrder(); // \Unleashed\Model\PurchaseOrder

try {
    $result = $apiInstance->updatePurchaseOrder($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->updatePurchaseOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **body** | [**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)|  | [optional] |

### Return type

[**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePurchaseOrderLines()`

```php
updatePurchaseOrderLines($id, $body): \Unleashed\Model\PurchaseOrder
```

Update Purchase Order Lines

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = array(new \Unleashed\Model\PurchaseOrderLine()); // \Unleashed\Model\PurchaseOrderLine[]

try {
    $result = $apiInstance->updatePurchaseOrderLines($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->updatePurchaseOrderLines: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **body** | [**\Unleashed\Model\PurchaseOrderLine[]**](../Model/PurchaseOrderLine.md)|  | [optional] |

### Return type

[**\Unleashed\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
