# Unleashed\ProductsApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createProduct()**](ProductsApi.md#createProduct) | **POST** /Products |  |
| [**getProduct()**](ProductsApi.md#getProduct) | **GET** /Products/{id} | View any Product |
| [**getProductBrands()**](ProductsApi.md#getProductBrands) | **GET** /ProductBrands | List a page of Product Brands |
| [**getProducts()**](ProductsApi.md#getProducts) | **GET** /Products |  |
| [**getProductsPaged()**](ProductsApi.md#getProductsPaged) | **GET** /Products/Page/{pageNumber} |  |
| [**updateProduct()**](ProductsApi.md#updateProduct) | **POST** /Products/{id} | Update Product |


## `createProduct()`

```php
createProduct($include_attributes, $body): \Unleashed\Model\Product
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$include_attributes = 'include_attributes_example'; // string
$body = new \Unleashed\Model\Product(); // \Unleashed\Model\Product

try {
    $result = $apiInstance->createProduct($include_attributes, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->createProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **include_attributes** | **string**|  | [optional] |
| **body** | [**\Unleashed\Model\Product**](../Model/Product.md)|  | [optional] |

### Return type

[**\Unleashed\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProduct()`

```php
getProduct($id, $include_attributes): \Unleashed\Model\Product
```

View any Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$include_attributes = 'include_attributes_example'; // string

try {
    $result = $apiInstance->getProduct($id, $include_attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **include_attributes** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductBrands()`

```php
getProductBrands($product_brand): \Unleashed\Model\PagedBrand
```

List a page of Product Brands

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_brand = 'product_brand_example'; // string | Only returns Product Brands starting with the given string

try {
    $result = $apiInstance->getProductBrands($product_brand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProductBrands: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_brand** | **string**| Only returns Product Brands starting with the given string | [optional] |

### Return type

[**\Unleashed\Model\PagedBrand**](../Model/PagedBrand.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProducts()`

```php
getProducts($include_attributes): \Unleashed\Model\Product
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$include_attributes = 'include_attributes_example'; // string

try {
    $result = $apiInstance->getProducts($include_attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **include_attributes** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductsPaged()`

```php
getProductsPaged($page_number, $page_size, $product_id, $product_group, $product_code, $product_description, $product, $modified_since, $include_obsolete, $product_bar_code, $order_by, $smart, $sort, $brief, $include_attributes, $customer_code, $exclude_assembled, $exclude_components): \Unleashed\Model\PagedProduct
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$product_id = 'product_id_example'; // string
$product_group = 'product_group_example'; // string
$product_code = 'product_code_example'; // string
$product_description = 'product_description_example'; // string
$product = 'product_example'; // string
$modified_since = 'modified_since_example'; // string
$include_obsolete = 'include_obsolete_example'; // string
$product_bar_code = 'product_bar_code_example'; // string
$order_by = 'order_by_example'; // string
$smart = 'smart_example'; // string
$sort = 'sort_example'; // string
$brief = 'brief_example'; // string
$include_attributes = 'include_attributes_example'; // string
$customer_code = 'customer_code_example'; // string
$exclude_assembled = 'exclude_assembled_example'; // string
$exclude_components = 'exclude_components_example'; // string

try {
    $result = $apiInstance->getProductsPaged($page_number, $page_size, $product_id, $product_group, $product_code, $product_description, $product, $modified_since, $include_obsolete, $product_bar_code, $order_by, $smart, $sort, $brief, $include_attributes, $customer_code, $exclude_assembled, $exclude_components);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProductsPaged: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1] |
| **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional] |
| **product_id** | **string**|  | [optional] |
| **product_group** | **string**|  | [optional] |
| **product_code** | **string**|  | [optional] |
| **product_description** | **string**|  | [optional] |
| **product** | **string**|  | [optional] |
| **modified_since** | **string**|  | [optional] |
| **include_obsolete** | **string**|  | [optional] |
| **product_bar_code** | **string**|  | [optional] |
| **order_by** | **string**|  | [optional] |
| **smart** | **string**|  | [optional] |
| **sort** | **string**|  | [optional] |
| **brief** | **string**|  | [optional] |
| **include_attributes** | **string**|  | [optional] |
| **customer_code** | **string**|  | [optional] |
| **exclude_assembled** | **string**|  | [optional] |
| **exclude_components** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedProduct**](../Model/PagedProduct.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProduct()`

```php
updateProduct($id, $include_attributes, $body): \Unleashed\Model\Product
```

Update Product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$include_attributes = 'include_attributes_example'; // string
$body = new \Unleashed\Model\Product(); // \Unleashed\Model\Product

try {
    $result = $apiInstance->updateProduct($id, $include_attributes, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->updateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **include_attributes** | **string**|  | [optional] |
| **body** | [**\Unleashed\Model\Product**](../Model/Product.md)|  | [optional] |

### Return type

[**\Unleashed\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
