# Unleashed\CustomersApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createCustomer()**](CustomersApi.md#createCustomer) | **POST** /Customers |  |
| [**createCustomerContact()**](CustomersApi.md#createCustomerContact) | **POST** /Customers/{id}/Contacts | Create a new Customer Contact |
| [**deleteCustomerContact()**](CustomersApi.md#deleteCustomerContact) | **DELETE** /Customers/{id}/Contacts/{contactId} | Delete an existing Customer Contact |
| [**getCustomer()**](CustomersApi.md#getCustomer) | **GET** /Customers/{id} | View any Customer |
| [**getCustomerContacts()**](CustomersApi.md#getCustomerContacts) | **GET** /Customers/{id}/Contacts | List all contacts for a specific Customer |
| [**getCustomers()**](CustomersApi.md#getCustomers) | **GET** /Customers |  |
| [**getCustomersPaged()**](CustomersApi.md#getCustomersPaged) | **GET** /Customers/Page/{pageNumber} |  |
| [**updateCustomer()**](CustomersApi.md#updateCustomer) | **POST** /Customers/{id} | Update Customer |
| [**updateCustomerContact()**](CustomersApi.md#updateCustomerContact) | **PUT** /Customers/{id}/Contacts/{contactId} | Update an existing Customer Contact |


## `createCustomer()`

```php
createCustomer($body): \Unleashed\Model\Customer
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\Customer(); // \Unleashed\Model\Customer

try {
    $result = $apiInstance->createCustomer($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Unleashed\Model\Customer**](../Model/Customer.md)|  | [optional] |

### Return type

[**\Unleashed\Model\Customer**](../Model/Customer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCustomerContact()`

```php
createCustomerContact($id, $body)
```

Create a new Customer Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$body = new \Unleashed\Model\CustomerContact(); // \Unleashed\Model\CustomerContact

try {
    $apiInstance->createCustomerContact($id, $body);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createCustomerContact: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **body** | [**\Unleashed\Model\CustomerContact**](../Model/CustomerContact.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCustomerContact()`

```php
deleteCustomerContact($id, $contact_id)
```

Delete an existing Customer Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$contact_id = 'contact_id_example'; // string

try {
    $apiInstance->deleteCustomerContact($id, $contact_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->deleteCustomerContact: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **contact_id** | **string**|  | |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomer()`

```php
getCustomer($id): \Unleashed\Model\Customer
```

View any Customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->getCustomer($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |

### Return type

[**\Unleashed\Model\Customer**](../Model/Customer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerContacts()`

```php
getCustomerContacts($id, $order_by, $page, $page_size, $sort): \Unleashed\Model\PagedCustomerContact
```

List all contacts for a specific Customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$order_by = 'order_by_example'; // string
$page = 56; // int
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$sort = 'sort_example'; // string

try {
    $result = $apiInstance->getCustomerContacts($id, $order_by, $page, $page_size, $sort);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomerContacts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **order_by** | **string**|  | [optional] |
| **page** | **int**|  | [optional] |
| **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional] |
| **sort** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedCustomerContact**](../Model/PagedCustomerContact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomers()`

```php
getCustomers(): \Unleashed\Model\Customer
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getCustomers();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Unleashed\Model\Customer**](../Model/Customer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomersPaged()`

```php
getCustomersPaged($page_number, $page_size, $customer_type, $sell_price_tier, $currency, $customer, $customer_code, $customer_name, $contact_email, $modified_since, $include_obsolete, $xero_contact_id, $order_by, $sort, $include_all_contacts): \Unleashed\Model\PagedCustomer
```



The Customers resource allows Customers to be listed, viewed, created, and updated. An individual Customer’s details can be viewed, or updated by appending its identifier (a GUID formatted as XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX) to the URI. Here are some example URIs:  /Customers/E6E8163F-6911-40e9-B740-90E5A0A3A996 - returns details of a particular customer. /Customers/Page/1 - returns the first page of 200 customers. /Customers/1 - also returns the first page of 200 customers. /Customers - also returns the first 200 customers because page number 1 is the default. /Customers/3?pageSize=100 - returns the third page of 100 customers; ie. the 201st to 300th customers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$customer_type = 'customer_type_example'; // string
$sell_price_tier = 'sell_price_tier_example'; // string
$currency = 'currency_example'; // string
$customer = 'customer_example'; // string
$customer_code = 'customer_code_example'; // string
$customer_name = 'customer_name_example'; // string
$contact_email = 'contact_email_example'; // string
$modified_since = 'modified_since_example'; // string
$include_obsolete = 'include_obsolete_example'; // string
$xero_contact_id = 'xero_contact_id_example'; // string
$order_by = 'order_by_example'; // string
$sort = 'sort_example'; // string
$include_all_contacts = 'include_all_contacts_example'; // string

try {
    $result = $apiInstance->getCustomersPaged($page_number, $page_size, $customer_type, $sell_price_tier, $currency, $customer, $customer_code, $customer_name, $contact_email, $modified_since, $include_obsolete, $xero_contact_id, $order_by, $sort, $include_all_contacts);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomersPaged: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1] |
| **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional] |
| **customer_type** | **string**|  | [optional] |
| **sell_price_tier** | **string**|  | [optional] |
| **currency** | **string**|  | [optional] |
| **customer** | **string**|  | [optional] |
| **customer_code** | **string**|  | [optional] |
| **customer_name** | **string**|  | [optional] |
| **contact_email** | **string**|  | [optional] |
| **modified_since** | **string**|  | [optional] |
| **include_obsolete** | **string**|  | [optional] |
| **xero_contact_id** | **string**|  | [optional] |
| **order_by** | **string**|  | [optional] |
| **sort** | **string**|  | [optional] |
| **include_all_contacts** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedCustomer**](../Model/PagedCustomer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCustomer()`

```php
updateCustomer($id, $body): \Unleashed\Model\Customer
```

Update Customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = new \Unleashed\Model\Customer(); // \Unleashed\Model\Customer

try {
    $result = $apiInstance->updateCustomer($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->updateCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **body** | [**\Unleashed\Model\Customer**](../Model/Customer.md)|  | [optional] |

### Return type

[**\Unleashed\Model\Customer**](../Model/Customer.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCustomerContact()`

```php
updateCustomerContact($id, $contact_id, $body): \Unleashed\Model\CustomerContact
```

Update an existing Customer Contact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$contact_id = 'contact_id_example'; // string
$body = new \Unleashed\Model\CustomerContact(); // \Unleashed\Model\CustomerContact

try {
    $result = $apiInstance->updateCustomerContact($id, $contact_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->updateCustomerContact: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 | |
| **contact_id** | **string**|  | |
| **body** | [**\Unleashed\Model\CustomerContact**](../Model/CustomerContact.md)|  | [optional] |

### Return type

[**\Unleashed\Model\CustomerContact**](../Model/CustomerContact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
