# Unleashed\BatchNumbersApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getBatchNumber()**](BatchNumbersApi.md#getBatchNumber) | **GET** /BatchNumbers/Page/{pageNumber} |  |


## `getBatchNumber()`

```php
getBatchNumber($page_number, $page_size, $product_code, $warehouse_code, $start_date, $end_date, $expiry_from, $expiry_to, $modified_since, $batch_number, $available): \Unleashed\Model\PagedBatchNumber
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\BatchNumbersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$product_code = 'product_code_example'; // string
$warehouse_code = 'warehouse_code_example'; // string
$start_date = 'start_date_example'; // string
$end_date = 'end_date_example'; // string
$expiry_from = 'expiry_from_example'; // string
$expiry_to = 'expiry_to_example'; // string
$modified_since = 'modified_since_example'; // string
$batch_number = 'batch_number_example'; // string
$available = 'available_example'; // string

try {
    $result = $apiInstance->getBatchNumber($page_number, $page_size, $product_code, $warehouse_code, $start_date, $end_date, $expiry_from, $expiry_to, $modified_since, $batch_number, $available);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BatchNumbersApi->getBatchNumber: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1] |
| **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional] |
| **product_code** | **string**|  | [optional] |
| **warehouse_code** | **string**|  | [optional] |
| **start_date** | **string**|  | [optional] |
| **end_date** | **string**|  | [optional] |
| **expiry_from** | **string**|  | [optional] |
| **expiry_to** | **string**|  | [optional] |
| **modified_since** | **string**|  | [optional] |
| **batch_number** | **string**|  | [optional] |
| **available** | **string**|  | [optional] |

### Return type

[**\Unleashed\Model\PagedBatchNumber**](../Model/PagedBatchNumber.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
