# Unleashed\AttributeSetsApi

All URIs are relative to https://api.unleashedsoftware.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createAttributeSet()**](AttributeSetsApi.md#createAttributeSet) | **POST** /AttributeSets |  |
| [**getAttributeSet()**](AttributeSetsApi.md#getAttributeSet) | **GET** /AttributeSets/{id} |  |
| [**getAttributeSets()**](AttributeSetsApi.md#getAttributeSets) | **GET** /AttributeSets |  |
| [**updateAttributeSet()**](AttributeSetsApi.md#updateAttributeSet) | **POST** /AttributeSets/{id} |  |


## `createAttributeSet()`

```php
createAttributeSet($body): \Unleashed\Model\AttributeSet
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AttributeSetsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\AttributeSet(); // \Unleashed\Model\AttributeSet

try {
    $result = $apiInstance->createAttributeSet($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributeSetsApi->createAttributeSet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **body** | [**\Unleashed\Model\AttributeSet**](../Model/AttributeSet.md)|  | [optional] |

### Return type

[**\Unleashed\Model\AttributeSet**](../Model/AttributeSet.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttributeSet()`

```php
getAttributeSet($id): \Unleashed\Model\AttributeSet
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AttributeSetsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->getAttributeSet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributeSetsApi->getAttributeSet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |

### Return type

[**\Unleashed\Model\AttributeSet**](../Model/AttributeSet.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttributeSets()`

```php
getAttributeSets(): \Unleashed\Model\AttributeSetList
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AttributeSetsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAttributeSets();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributeSetsApi->getAttributeSets: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Unleashed\Model\AttributeSetList**](../Model/AttributeSetList.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateAttributeSet()`

```php
updateAttributeSet($id, $body): \Unleashed\Model\AttributeSet
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AttributeSetsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$body = new \Unleashed\Model\AttributeSet(); // \Unleashed\Model\AttributeSet

try {
    $result = $apiInstance->updateAttributeSet($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributeSetsApi->updateAttributeSet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | |
| **body** | [**\Unleashed\Model\AttributeSet**](../Model/AttributeSet.md)|  | [optional] |

### Return type

[**\Unleashed\Model\AttributeSet**](../Model/AttributeSet.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
