<?php
/**
 * Stockonhand
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Stockonhand Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Stockonhand implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'stockonhand';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'product_code' => 'string',
        'product_description' => 'string',
        'product_guid' => 'string',
        'product_source_id' => 'string',
        'product_group_name' => 'string',
        'warehouse_id' => 'string',
        'warehouse' => 'string',
        'warehouse_code' => 'string',
        'days_since_last_sale' => 'int',
        'on_purchase' => 'int',
        'allocated_qty' => 'int',
        'available_qty' => 'int',
        'qty_on_hand' => 'int',
        'avg_cost' => 'int',
        'total_cost' => 'int',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'product_code' => null,
        'product_description' => null,
        'product_guid' => null,
        'product_source_id' => null,
        'product_group_name' => null,
        'warehouse_id' => null,
        'warehouse' => null,
        'warehouse_code' => null,
        'days_since_last_sale' => null,
        'on_purchase' => null,
        'allocated_qty' => null,
        'available_qty' => null,
        'qty_on_hand' => null,
        'avg_cost' => null,
        'total_cost' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'product_code' => 'ProductCode',
        'product_description' => 'ProductDescription',
        'product_guid' => 'ProductGuid',
        'product_source_id' => 'ProductSourceId',
        'product_group_name' => 'ProductGroupName',
        'warehouse_id' => 'WarehouseId',
        'warehouse' => 'Warehouse',
        'warehouse_code' => 'WarehouseCode',
        'days_since_last_sale' => 'DaysSinceLastSale',
        'on_purchase' => 'OnPurchase',
        'allocated_qty' => 'AllocatedQty',
        'available_qty' => 'AvailableQty',
        'qty_on_hand' => 'QtyOnHand',
        'avg_cost' => 'AvgCost',
        'total_cost' => 'TotalCost',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'product_code' => 'setProductCode',
        'product_description' => 'setProductDescription',
        'product_guid' => 'setProductGuid',
        'product_source_id' => 'setProductSourceId',
        'product_group_name' => 'setProductGroupName',
        'warehouse_id' => 'setWarehouseId',
        'warehouse' => 'setWarehouse',
        'warehouse_code' => 'setWarehouseCode',
        'days_since_last_sale' => 'setDaysSinceLastSale',
        'on_purchase' => 'setOnPurchase',
        'allocated_qty' => 'setAllocatedQty',
        'available_qty' => 'setAvailableQty',
        'qty_on_hand' => 'setQtyOnHand',
        'avg_cost' => 'setAvgCost',
        'total_cost' => 'setTotalCost',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'product_code' => 'getProductCode',
        'product_description' => 'getProductDescription',
        'product_guid' => 'getProductGuid',
        'product_source_id' => 'getProductSourceId',
        'product_group_name' => 'getProductGroupName',
        'warehouse_id' => 'getWarehouseId',
        'warehouse' => 'getWarehouse',
        'warehouse_code' => 'getWarehouseCode',
        'days_since_last_sale' => 'getDaysSinceLastSale',
        'on_purchase' => 'getOnPurchase',
        'allocated_qty' => 'getAllocatedQty',
        'available_qty' => 'getAvailableQty',
        'qty_on_hand' => 'getQtyOnHand',
        'avg_cost' => 'getAvgCost',
        'total_cost' => 'getTotalCost',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['product_code'] = $data['product_code'] ?? null;
        $this->container['product_description'] = $data['product_description'] ?? null;
        $this->container['product_guid'] = $data['product_guid'] ?? null;
        $this->container['product_source_id'] = $data['product_source_id'] ?? null;
        $this->container['product_group_name'] = $data['product_group_name'] ?? null;
        $this->container['warehouse_id'] = $data['warehouse_id'] ?? null;
        $this->container['warehouse'] = $data['warehouse'] ?? null;
        $this->container['warehouse_code'] = $data['warehouse_code'] ?? null;
        $this->container['days_since_last_sale'] = $data['days_since_last_sale'] ?? null;
        $this->container['on_purchase'] = $data['on_purchase'] ?? null;
        $this->container['allocated_qty'] = $data['allocated_qty'] ?? null;
        $this->container['available_qty'] = $data['available_qty'] ?? null;
        $this->container['qty_on_hand'] = $data['qty_on_hand'] ?? null;
        $this->container['avg_cost'] = $data['avg_cost'] ?? null;
        $this->container['total_cost'] = $data['total_cost'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets product_code
     *
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->container['product_code'];
    }

    /**
     * Sets product_code
     *
     * @param string|null $product_code product_code
     *
     * @return self
     */
    public function setProductCode($product_code)
    {
        $this->container['product_code'] = $product_code;

        return $this;
    }

    /**
     * Gets product_description
     *
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->container['product_description'];
    }

    /**
     * Sets product_description
     *
     * @param string|null $product_description product_description
     *
     * @return self
     */
    public function setProductDescription($product_description)
    {
        $this->container['product_description'] = $product_description;

        return $this;
    }

    /**
     * Gets product_guid
     *
     * @return string|null
     */
    public function getProductGuid()
    {
        return $this->container['product_guid'];
    }

    /**
     * Sets product_guid
     *
     * @param string|null $product_guid product_guid
     *
     * @return self
     */
    public function setProductGuid($product_guid)
    {
        $this->container['product_guid'] = $product_guid;

        return $this;
    }

    /**
     * Gets product_source_id
     *
     * @return string|null
     */
    public function getProductSourceId()
    {
        return $this->container['product_source_id'];
    }

    /**
     * Sets product_source_id
     *
     * @param string|null $product_source_id product_source_id
     *
     * @return self
     */
    public function setProductSourceId($product_source_id)
    {
        $this->container['product_source_id'] = $product_source_id;

        return $this;
    }

    /**
     * Gets product_group_name
     *
     * @return string|null
     */
    public function getProductGroupName()
    {
        return $this->container['product_group_name'];
    }

    /**
     * Sets product_group_name
     *
     * @param string|null $product_group_name product_group_name
     *
     * @return self
     */
    public function setProductGroupName($product_group_name)
    {
        $this->container['product_group_name'] = $product_group_name;

        return $this;
    }

    /**
     * Gets warehouse_id
     *
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->container['warehouse_id'];
    }

    /**
     * Sets warehouse_id
     *
     * @param string|null $warehouse_id warehouse_id
     *
     * @return self
     */
    public function setWarehouseId($warehouse_id)
    {
        $this->container['warehouse_id'] = $warehouse_id;

        return $this;
    }

    /**
     * Gets warehouse
     *
     * @return string|null
     */
    public function getWarehouse()
    {
        return $this->container['warehouse'];
    }

    /**
     * Sets warehouse
     *
     * @param string|null $warehouse warehouse
     *
     * @return self
     */
    public function setWarehouse($warehouse)
    {
        $this->container['warehouse'] = $warehouse;

        return $this;
    }

    /**
     * Gets warehouse_code
     *
     * @return string|null
     */
    public function getWarehouseCode()
    {
        return $this->container['warehouse_code'];
    }

    /**
     * Sets warehouse_code
     *
     * @param string|null $warehouse_code warehouse_code
     *
     * @return self
     */
    public function setWarehouseCode($warehouse_code)
    {
        $this->container['warehouse_code'] = $warehouse_code;

        return $this;
    }

    /**
     * Gets days_since_last_sale
     *
     * @return int|null
     */
    public function getDaysSinceLastSale()
    {
        return $this->container['days_since_last_sale'];
    }

    /**
     * Sets days_since_last_sale
     *
     * @param int|null $days_since_last_sale days_since_last_sale
     *
     * @return self
     */
    public function setDaysSinceLastSale($days_since_last_sale)
    {
        $this->container['days_since_last_sale'] = $days_since_last_sale;

        return $this;
    }

    /**
     * Gets on_purchase
     *
     * @return int|null
     */
    public function getOnPurchase()
    {
        return $this->container['on_purchase'];
    }

    /**
     * Sets on_purchase
     *
     * @param int|null $on_purchase on_purchase
     *
     * @return self
     */
    public function setOnPurchase($on_purchase)
    {
        $this->container['on_purchase'] = $on_purchase;

        return $this;
    }

    /**
     * Gets allocated_qty
     *
     * @return int|null
     */
    public function getAllocatedQty()
    {
        return $this->container['allocated_qty'];
    }

    /**
     * Sets allocated_qty
     *
     * @param int|null $allocated_qty allocated_qty
     *
     * @return self
     */
    public function setAllocatedQty($allocated_qty)
    {
        $this->container['allocated_qty'] = $allocated_qty;

        return $this;
    }

    /**
     * Gets available_qty
     *
     * @return int|null
     */
    public function getAvailableQty()
    {
        return $this->container['available_qty'];
    }

    /**
     * Sets available_qty
     *
     * @param int|null $available_qty available_qty
     *
     * @return self
     */
    public function setAvailableQty($available_qty)
    {
        $this->container['available_qty'] = $available_qty;

        return $this;
    }

    /**
     * Gets qty_on_hand
     *
     * @return int|null
     */
    public function getQtyOnHand()
    {
        return $this->container['qty_on_hand'];
    }

    /**
     * Sets qty_on_hand
     *
     * @param int|null $qty_on_hand qty_on_hand
     *
     * @return self
     */
    public function setQtyOnHand($qty_on_hand)
    {
        $this->container['qty_on_hand'] = $qty_on_hand;

        return $this;
    }

    /**
     * Gets avg_cost
     *
     * @return int|null
     */
    public function getAvgCost()
    {
        return $this->container['avg_cost'];
    }

    /**
     * Sets avg_cost
     *
     * @param int|null $avg_cost avg_cost
     *
     * @return self
     */
    public function setAvgCost($avg_cost)
    {
        $this->container['avg_cost'] = $avg_cost;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return int|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param int|null $total_cost total_cost
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


