<?php
/**
 * CustomerContact
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * CustomerContact Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CustomerContact implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'customerContact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'for_invoicing' => 'bool',
        'for_shipping' => 'bool',
        'for_ordering' => 'bool',
        'is_default' => 'bool',
        'ddi_number' => 'string',
        'email_address' => 'string',
        'fax_number' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'mobile_phone' => 'string',
        'notes' => 'string',
        'office_phone' => 'string',
        'phone_number' => 'string',
        'toll_free_number' => 'string',
        'website' => 'string',
        'guid' => 'string',
        'delivery_address' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'for_invoicing' => null,
        'for_shipping' => null,
        'for_ordering' => null,
        'is_default' => null,
        'ddi_number' => null,
        'email_address' => null,
        'fax_number' => null,
        'first_name' => null,
        'last_name' => null,
        'mobile_phone' => null,
        'notes' => null,
        'office_phone' => null,
        'phone_number' => null,
        'toll_free_number' => null,
        'website' => null,
        'guid' => null,
        'delivery_address' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'for_invoicing' => 'ForInvoicing',
        'for_shipping' => 'ForShipping',
        'for_ordering' => 'ForOrdering',
        'is_default' => 'IsDefault',
        'ddi_number' => 'DDINumber',
        'email_address' => 'EmailAddress',
        'fax_number' => 'FaxNumber',
        'first_name' => 'FirstName',
        'last_name' => 'LastName',
        'mobile_phone' => 'MobilePhone',
        'notes' => 'Notes',
        'office_phone' => 'OfficePhone',
        'phone_number' => 'PhoneNumber',
        'toll_free_number' => 'TollFreeNumber',
        'website' => 'Website',
        'guid' => 'Guid',
        'delivery_address' => 'DeliveryAddress'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'for_invoicing' => 'setForInvoicing',
        'for_shipping' => 'setForShipping',
        'for_ordering' => 'setForOrdering',
        'is_default' => 'setIsDefault',
        'ddi_number' => 'setDdiNumber',
        'email_address' => 'setEmailAddress',
        'fax_number' => 'setFaxNumber',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'mobile_phone' => 'setMobilePhone',
        'notes' => 'setNotes',
        'office_phone' => 'setOfficePhone',
        'phone_number' => 'setPhoneNumber',
        'toll_free_number' => 'setTollFreeNumber',
        'website' => 'setWebsite',
        'guid' => 'setGuid',
        'delivery_address' => 'setDeliveryAddress'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'for_invoicing' => 'getForInvoicing',
        'for_shipping' => 'getForShipping',
        'for_ordering' => 'getForOrdering',
        'is_default' => 'getIsDefault',
        'ddi_number' => 'getDdiNumber',
        'email_address' => 'getEmailAddress',
        'fax_number' => 'getFaxNumber',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'mobile_phone' => 'getMobilePhone',
        'notes' => 'getNotes',
        'office_phone' => 'getOfficePhone',
        'phone_number' => 'getPhoneNumber',
        'toll_free_number' => 'getTollFreeNumber',
        'website' => 'getWebsite',
        'guid' => 'getGuid',
        'delivery_address' => 'getDeliveryAddress'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['for_invoicing'] = $data['for_invoicing'] ?? null;
        $this->container['for_shipping'] = $data['for_shipping'] ?? null;
        $this->container['for_ordering'] = $data['for_ordering'] ?? null;
        $this->container['is_default'] = $data['is_default'] ?? null;
        $this->container['ddi_number'] = $data['ddi_number'] ?? null;
        $this->container['email_address'] = $data['email_address'] ?? null;
        $this->container['fax_number'] = $data['fax_number'] ?? null;
        $this->container['first_name'] = $data['first_name'] ?? null;
        $this->container['last_name'] = $data['last_name'] ?? null;
        $this->container['mobile_phone'] = $data['mobile_phone'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['office_phone'] = $data['office_phone'] ?? null;
        $this->container['phone_number'] = $data['phone_number'] ?? null;
        $this->container['toll_free_number'] = $data['toll_free_number'] ?? null;
        $this->container['website'] = $data['website'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['delivery_address'] = $data['delivery_address'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets for_invoicing
     *
     * @return bool|null
     */
    public function getForInvoicing()
    {
        return $this->container['for_invoicing'];
    }

    /**
     * Sets for_invoicing
     *
     * @param bool|null $for_invoicing for_invoicing
     *
     * @return self
     */
    public function setForInvoicing($for_invoicing)
    {
        $this->container['for_invoicing'] = $for_invoicing;

        return $this;
    }

    /**
     * Gets for_shipping
     *
     * @return bool|null
     */
    public function getForShipping()
    {
        return $this->container['for_shipping'];
    }

    /**
     * Sets for_shipping
     *
     * @param bool|null $for_shipping for_shipping
     *
     * @return self
     */
    public function setForShipping($for_shipping)
    {
        $this->container['for_shipping'] = $for_shipping;

        return $this;
    }

    /**
     * Gets for_ordering
     *
     * @return bool|null
     */
    public function getForOrdering()
    {
        return $this->container['for_ordering'];
    }

    /**
     * Sets for_ordering
     *
     * @param bool|null $for_ordering for_ordering
     *
     * @return self
     */
    public function setForOrdering($for_ordering)
    {
        $this->container['for_ordering'] = $for_ordering;

        return $this;
    }

    /**
     * Gets is_default
     *
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->container['is_default'];
    }

    /**
     * Sets is_default
     *
     * @param bool|null $is_default is_default
     *
     * @return self
     */
    public function setIsDefault($is_default)
    {
        $this->container['is_default'] = $is_default;

        return $this;
    }

    /**
     * Gets ddi_number
     *
     * @return string|null
     */
    public function getDdiNumber()
    {
        return $this->container['ddi_number'];
    }

    /**
     * Sets ddi_number
     *
     * @param string|null $ddi_number ddi_number
     *
     * @return self
     */
    public function setDdiNumber($ddi_number)
    {
        $this->container['ddi_number'] = $ddi_number;

        return $this;
    }

    /**
     * Gets email_address
     *
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->container['email_address'];
    }

    /**
     * Sets email_address
     *
     * @param string|null $email_address email_address
     *
     * @return self
     */
    public function setEmailAddress($email_address)
    {
        $this->container['email_address'] = $email_address;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number fax_number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name first_name
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name last_name
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets mobile_phone
     *
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->container['mobile_phone'];
    }

    /**
     * Sets mobile_phone
     *
     * @param string|null $mobile_phone mobile_phone
     *
     * @return self
     */
    public function setMobilePhone($mobile_phone)
    {
        $this->container['mobile_phone'] = $mobile_phone;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets office_phone
     *
     * @return string|null
     */
    public function getOfficePhone()
    {
        return $this->container['office_phone'];
    }

    /**
     * Sets office_phone
     *
     * @param string|null $office_phone office_phone
     *
     * @return self
     */
    public function setOfficePhone($office_phone)
    {
        $this->container['office_phone'] = $office_phone;

        return $this;
    }

    /**
     * Gets phone_number
     *
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     *
     * @param string|null $phone_number phone_number
     *
     * @return self
     */
    public function setPhoneNumber($phone_number)
    {
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets toll_free_number
     *
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->container['toll_free_number'];
    }

    /**
     * Sets toll_free_number
     *
     * @param string|null $toll_free_number toll_free_number
     *
     * @return self
     */
    public function setTollFreeNumber($toll_free_number)
    {
        $this->container['toll_free_number'] = $toll_free_number;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets delivery_address
     *
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['delivery_address'];
    }

    /**
     * Sets delivery_address
     *
     * @param string|null $delivery_address delivery_address
     *
     * @return self
     */
    public function setDeliveryAddress($delivery_address)
    {
        $this->container['delivery_address'] = $delivery_address;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


