<?php
/**
 * Assembly
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Assembly Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Assembly implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'assembly';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'assembly_number' => 'string',
        'assembly_date' => 'string',
        'assembly_type' => 'string',
        'assembly_status' => 'string',
        'custom_assembly_status' => 'string',
        'auto_assembly' => 'bool',
        'quantity' => 'int',
        'assemble_by' => 'string',
        'comments' => 'string',
        'can_assemble_quantity' => 'float',
        'batch_numbers' => 'object[]',
        'serial_numbers' => 'object[]',
        'product' => '\Unleashed\Model\Product',
        'assembly_lines' => '\Unleashed\Model\AssemblyLine[]',
        'supplier_costs' => 'object[]',
        'source_warehouse' => '\Unleashed\Model\Warehouse',
        'destination_warehouse' => '\Unleashed\Model\Warehouse',
        'total' => 'float',
        'total_cost' => 'float',
        'disassemble_cost_total' => 'float',
        'supplier_costs_tax' => 'float',
        'supplier_costs_sub_total' => 'float',
        'sales_order_number' => 'string',
        'last_modified_by' => 'string',
        'created_by' => 'string',
        'created_on' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'assembly_number' => null,
        'assembly_date' => null,
        'assembly_type' => null,
        'assembly_status' => null,
        'custom_assembly_status' => null,
        'auto_assembly' => null,
        'quantity' => null,
        'assemble_by' => null,
        'comments' => null,
        'can_assemble_quantity' => null,
        'batch_numbers' => null,
        'serial_numbers' => null,
        'product' => null,
        'assembly_lines' => null,
        'supplier_costs' => null,
        'source_warehouse' => null,
        'destination_warehouse' => null,
        'total' => null,
        'total_cost' => null,
        'disassemble_cost_total' => null,
        'supplier_costs_tax' => null,
        'supplier_costs_sub_total' => null,
        'sales_order_number' => null,
        'last_modified_by' => null,
        'created_by' => null,
        'created_on' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'assembly_number' => 'AssemblyNumber',
        'assembly_date' => 'AssemblyDate',
        'assembly_type' => 'AssemblyType',
        'assembly_status' => 'AssemblyStatus',
        'custom_assembly_status' => 'CustomAssemblyStatus',
        'auto_assembly' => 'AutoAssembly',
        'quantity' => 'Quantity',
        'assemble_by' => 'AssembleBy',
        'comments' => 'Comments',
        'can_assemble_quantity' => 'CanAssembleQuantity',
        'batch_numbers' => 'BatchNumbers',
        'serial_numbers' => 'SerialNumbers',
        'product' => 'Product',
        'assembly_lines' => 'AssemblyLines',
        'supplier_costs' => 'SupplierCosts',
        'source_warehouse' => 'SourceWarehouse',
        'destination_warehouse' => 'DestinationWarehouse',
        'total' => 'Total',
        'total_cost' => 'TotalCost',
        'disassemble_cost_total' => 'DisassembleCostTotal',
        'supplier_costs_tax' => 'SupplierCostsTax',
        'supplier_costs_sub_total' => 'SupplierCostsSubTotal',
        'sales_order_number' => 'SalesOrderNumber',
        'last_modified_by' => 'LastModifiedBy',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'assembly_number' => 'setAssemblyNumber',
        'assembly_date' => 'setAssemblyDate',
        'assembly_type' => 'setAssemblyType',
        'assembly_status' => 'setAssemblyStatus',
        'custom_assembly_status' => 'setCustomAssemblyStatus',
        'auto_assembly' => 'setAutoAssembly',
        'quantity' => 'setQuantity',
        'assemble_by' => 'setAssembleBy',
        'comments' => 'setComments',
        'can_assemble_quantity' => 'setCanAssembleQuantity',
        'batch_numbers' => 'setBatchNumbers',
        'serial_numbers' => 'setSerialNumbers',
        'product' => 'setProduct',
        'assembly_lines' => 'setAssemblyLines',
        'supplier_costs' => 'setSupplierCosts',
        'source_warehouse' => 'setSourceWarehouse',
        'destination_warehouse' => 'setDestinationWarehouse',
        'total' => 'setTotal',
        'total_cost' => 'setTotalCost',
        'disassemble_cost_total' => 'setDisassembleCostTotal',
        'supplier_costs_tax' => 'setSupplierCostsTax',
        'supplier_costs_sub_total' => 'setSupplierCostsSubTotal',
        'sales_order_number' => 'setSalesOrderNumber',
        'last_modified_by' => 'setLastModifiedBy',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'assembly_number' => 'getAssemblyNumber',
        'assembly_date' => 'getAssemblyDate',
        'assembly_type' => 'getAssemblyType',
        'assembly_status' => 'getAssemblyStatus',
        'custom_assembly_status' => 'getCustomAssemblyStatus',
        'auto_assembly' => 'getAutoAssembly',
        'quantity' => 'getQuantity',
        'assemble_by' => 'getAssembleBy',
        'comments' => 'getComments',
        'can_assemble_quantity' => 'getCanAssembleQuantity',
        'batch_numbers' => 'getBatchNumbers',
        'serial_numbers' => 'getSerialNumbers',
        'product' => 'getProduct',
        'assembly_lines' => 'getAssemblyLines',
        'supplier_costs' => 'getSupplierCosts',
        'source_warehouse' => 'getSourceWarehouse',
        'destination_warehouse' => 'getDestinationWarehouse',
        'total' => 'getTotal',
        'total_cost' => 'getTotalCost',
        'disassemble_cost_total' => 'getDisassembleCostTotal',
        'supplier_costs_tax' => 'getSupplierCostsTax',
        'supplier_costs_sub_total' => 'getSupplierCostsSubTotal',
        'sales_order_number' => 'getSalesOrderNumber',
        'last_modified_by' => 'getLastModifiedBy',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['assembly_number'] = $data['assembly_number'] ?? null;
        $this->container['assembly_date'] = $data['assembly_date'] ?? null;
        $this->container['assembly_type'] = $data['assembly_type'] ?? null;
        $this->container['assembly_status'] = $data['assembly_status'] ?? null;
        $this->container['custom_assembly_status'] = $data['custom_assembly_status'] ?? null;
        $this->container['auto_assembly'] = $data['auto_assembly'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['assemble_by'] = $data['assemble_by'] ?? null;
        $this->container['comments'] = $data['comments'] ?? null;
        $this->container['can_assemble_quantity'] = $data['can_assemble_quantity'] ?? null;
        $this->container['batch_numbers'] = $data['batch_numbers'] ?? null;
        $this->container['serial_numbers'] = $data['serial_numbers'] ?? null;
        $this->container['product'] = $data['product'] ?? null;
        $this->container['assembly_lines'] = $data['assembly_lines'] ?? null;
        $this->container['supplier_costs'] = $data['supplier_costs'] ?? null;
        $this->container['source_warehouse'] = $data['source_warehouse'] ?? null;
        $this->container['destination_warehouse'] = $data['destination_warehouse'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['total_cost'] = $data['total_cost'] ?? null;
        $this->container['disassemble_cost_total'] = $data['disassemble_cost_total'] ?? null;
        $this->container['supplier_costs_tax'] = $data['supplier_costs_tax'] ?? null;
        $this->container['supplier_costs_sub_total'] = $data['supplier_costs_sub_total'] ?? null;
        $this->container['sales_order_number'] = $data['sales_order_number'] ?? null;
        $this->container['last_modified_by'] = $data['last_modified_by'] ?? null;
        $this->container['created_by'] = $data['created_by'] ?? null;
        $this->container['created_on'] = $data['created_on'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets assembly_number
     *
     * @return string|null
     */
    public function getAssemblyNumber()
    {
        return $this->container['assembly_number'];
    }

    /**
     * Sets assembly_number
     *
     * @param string|null $assembly_number assembly_number
     *
     * @return self
     */
    public function setAssemblyNumber($assembly_number)
    {
        $this->container['assembly_number'] = $assembly_number;

        return $this;
    }

    /**
     * Gets assembly_date
     *
     * @return string|null
     */
    public function getAssemblyDate()
    {
        return $this->container['assembly_date'];
    }

    /**
     * Sets assembly_date
     *
     * @param string|null $assembly_date assembly_date
     *
     * @return self
     */
    public function setAssemblyDate($assembly_date)
    {
        $this->container['assembly_date'] = $assembly_date;

        return $this;
    }

    /**
     * Gets assembly_type
     *
     * @return string|null
     */
    public function getAssemblyType()
    {
        return $this->container['assembly_type'];
    }

    /**
     * Sets assembly_type
     *
     * @param string|null $assembly_type assembly_type
     *
     * @return self
     */
    public function setAssemblyType($assembly_type)
    {
        $this->container['assembly_type'] = $assembly_type;

        return $this;
    }

    /**
     * Gets assembly_status
     *
     * @return string|null
     */
    public function getAssemblyStatus()
    {
        return $this->container['assembly_status'];
    }

    /**
     * Sets assembly_status
     *
     * @param string|null $assembly_status assembly_status
     *
     * @return self
     */
    public function setAssemblyStatus($assembly_status)
    {
        $this->container['assembly_status'] = $assembly_status;

        return $this;
    }

    /**
     * Gets custom_assembly_status
     *
     * @return string|null
     */
    public function getCustomAssemblyStatus()
    {
        return $this->container['custom_assembly_status'];
    }

    /**
     * Sets custom_assembly_status
     *
     * @param string|null $custom_assembly_status custom_assembly_status
     *
     * @return self
     */
    public function setCustomAssemblyStatus($custom_assembly_status)
    {
        $this->container['custom_assembly_status'] = $custom_assembly_status;

        return $this;
    }

    /**
     * Gets auto_assembly
     *
     * @return bool|null
     */
    public function getAutoAssembly()
    {
        return $this->container['auto_assembly'];
    }

    /**
     * Sets auto_assembly
     *
     * @param bool|null $auto_assembly auto_assembly
     *
     * @return self
     */
    public function setAutoAssembly($auto_assembly)
    {
        $this->container['auto_assembly'] = $auto_assembly;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets assemble_by
     *
     * @return string|null
     */
    public function getAssembleBy()
    {
        return $this->container['assemble_by'];
    }

    /**
     * Sets assemble_by
     *
     * @param string|null $assemble_by assemble_by
     *
     * @return self
     */
    public function setAssembleBy($assemble_by)
    {
        $this->container['assemble_by'] = $assemble_by;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets can_assemble_quantity
     *
     * @return float|null
     */
    public function getCanAssembleQuantity()
    {
        return $this->container['can_assemble_quantity'];
    }

    /**
     * Sets can_assemble_quantity
     *
     * @param float|null $can_assemble_quantity can_assemble_quantity
     *
     * @return self
     */
    public function setCanAssembleQuantity($can_assemble_quantity)
    {
        $this->container['can_assemble_quantity'] = $can_assemble_quantity;

        return $this;
    }

    /**
     * Gets batch_numbers
     *
     * @return object[]|null
     */
    public function getBatchNumbers()
    {
        return $this->container['batch_numbers'];
    }

    /**
     * Sets batch_numbers
     *
     * @param object[]|null $batch_numbers batch_numbers
     *
     * @return self
     */
    public function setBatchNumbers($batch_numbers)
    {
        $this->container['batch_numbers'] = $batch_numbers;

        return $this;
    }

    /**
     * Gets serial_numbers
     *
     * @return object[]|null
     */
    public function getSerialNumbers()
    {
        return $this->container['serial_numbers'];
    }

    /**
     * Sets serial_numbers
     *
     * @param object[]|null $serial_numbers serial_numbers
     *
     * @return self
     */
    public function setSerialNumbers($serial_numbers)
    {
        $this->container['serial_numbers'] = $serial_numbers;

        return $this;
    }

    /**
     * Gets product
     *
     * @return \Unleashed\Model\Product|null
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param \Unleashed\Model\Product|null $product product
     *
     * @return self
     */
    public function setProduct($product)
    {
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets assembly_lines
     *
     * @return \Unleashed\Model\AssemblyLine[]|null
     */
    public function getAssemblyLines()
    {
        return $this->container['assembly_lines'];
    }

    /**
     * Sets assembly_lines
     *
     * @param \Unleashed\Model\AssemblyLine[]|null $assembly_lines assembly_lines
     *
     * @return self
     */
    public function setAssemblyLines($assembly_lines)
    {
        $this->container['assembly_lines'] = $assembly_lines;

        return $this;
    }

    /**
     * Gets supplier_costs
     *
     * @return object[]|null
     */
    public function getSupplierCosts()
    {
        return $this->container['supplier_costs'];
    }

    /**
     * Sets supplier_costs
     *
     * @param object[]|null $supplier_costs supplier_costs
     *
     * @return self
     */
    public function setSupplierCosts($supplier_costs)
    {
        $this->container['supplier_costs'] = $supplier_costs;

        return $this;
    }

    /**
     * Gets source_warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getSourceWarehouse()
    {
        return $this->container['source_warehouse'];
    }

    /**
     * Sets source_warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $source_warehouse source_warehouse
     *
     * @return self
     */
    public function setSourceWarehouse($source_warehouse)
    {
        $this->container['source_warehouse'] = $source_warehouse;

        return $this;
    }

    /**
     * Gets destination_warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getDestinationWarehouse()
    {
        return $this->container['destination_warehouse'];
    }

    /**
     * Sets destination_warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $destination_warehouse destination_warehouse
     *
     * @return self
     */
    public function setDestinationWarehouse($destination_warehouse)
    {
        $this->container['destination_warehouse'] = $destination_warehouse;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param float|null $total_cost total_cost
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets disassemble_cost_total
     *
     * @return float|null
     */
    public function getDisassembleCostTotal()
    {
        return $this->container['disassemble_cost_total'];
    }

    /**
     * Sets disassemble_cost_total
     *
     * @param float|null $disassemble_cost_total disassemble_cost_total
     *
     * @return self
     */
    public function setDisassembleCostTotal($disassemble_cost_total)
    {
        $this->container['disassemble_cost_total'] = $disassemble_cost_total;

        return $this;
    }

    /**
     * Gets supplier_costs_tax
     *
     * @return float|null
     */
    public function getSupplierCostsTax()
    {
        return $this->container['supplier_costs_tax'];
    }

    /**
     * Sets supplier_costs_tax
     *
     * @param float|null $supplier_costs_tax supplier_costs_tax
     *
     * @return self
     */
    public function setSupplierCostsTax($supplier_costs_tax)
    {
        $this->container['supplier_costs_tax'] = $supplier_costs_tax;

        return $this;
    }

    /**
     * Gets supplier_costs_sub_total
     *
     * @return float|null
     */
    public function getSupplierCostsSubTotal()
    {
        return $this->container['supplier_costs_sub_total'];
    }

    /**
     * Sets supplier_costs_sub_total
     *
     * @param float|null $supplier_costs_sub_total supplier_costs_sub_total
     *
     * @return self
     */
    public function setSupplierCostsSubTotal($supplier_costs_sub_total)
    {
        $this->container['supplier_costs_sub_total'] = $supplier_costs_sub_total;

        return $this;
    }

    /**
     * Gets sales_order_number
     *
     * @return string|null
     */
    public function getSalesOrderNumber()
    {
        return $this->container['sales_order_number'];
    }

    /**
     * Sets sales_order_number
     *
     * @param string|null $sales_order_number sales_order_number
     *
     * @return self
     */
    public function setSalesOrderNumber($sales_order_number)
    {
        $this->container['sales_order_number'] = $sales_order_number;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


