<?php
/**
 * PurchaseOrdersApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Unleashed\ApiException;
use Unleashed\Configuration;
use Unleashed\HeaderSelector;
use Unleashed\ObjectSerializer;

/**
 * PurchaseOrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PurchaseOrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getPurchaseOrders
     *
     * Your GET endpoint
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string $warehouse_code warehouse_code (optional)
     *
     * @throws \Unleashed\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PagedPurchaseOrder
     */
    public function getPurchaseOrders($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null)
    {
        list($response) = $this->getPurchaseOrdersWithHttpInfo($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code);
        return $response;
    }

    /**
     * Operation getPurchaseOrdersWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string $warehouse_code (optional)
     *
     * @throws \Unleashed\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PagedPurchaseOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPurchaseOrdersWithHttpInfo($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null)
    {
        $request = $this->getPurchaseOrdersRequest($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Unleashed\Model\PagedPurchaseOrder' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Unleashed\Model\PagedPurchaseOrder' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Unleashed\Model\PagedPurchaseOrder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Unleashed\Model\PagedPurchaseOrder';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PagedPurchaseOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPurchaseOrdersAsync
     *
     * Your GET endpoint
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string $warehouse_code (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersAsync($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null)
    {
        return $this->getPurchaseOrdersAsyncWithHttpInfo($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPurchaseOrdersAsyncWithHttpInfo
     *
     * Your GET endpoint
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string $warehouse_code (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseOrdersAsyncWithHttpInfo($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null)
    {
        $returnType = '\Unleashed\Model\PagedPurchaseOrder';
        $request = $this->getPurchaseOrdersRequest($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPurchaseOrders'
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int $page_size The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. (optional)
     * @param  string $brief Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. (optional)
     * @param  string $completed_after Returns purchase orders completed after the specified date. (optional)
     * @param  string $completed_before Returns purchase orders completed before the specified date (optional)
     * @param  string $custom_order_status Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. (optional)
     * @param  string $end_date Only return purchases with OrderDate before a specified date (optional)
     * @param  string $modified_since Returns orders created or edited after a specified date, must be UTC format (optional)
     * @param  string $order_number Returns a single order with the specified order number. If set, it overrides all other filters (optional)
     * @param  string $order_status If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. (optional)
     * @param  string $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  string $start_date Only return purchases with OrderDate after a specified date (optional)
     * @param  string $supplier_code Only return suppliers that start with the specific supplier code (optional)
     * @param  string $warehouse_code (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPurchaseOrdersRequest($page_number, $page_size = null, $brief = null, $completed_after = null, $completed_before = null, $custom_order_status = null, $end_date = null, $modified_since = null, $order_number = null, $order_status = null, $serial_batch = null, $start_date = null, $supplier_code = null, $warehouse_code = null)
    {
        // verify the required parameter 'page_number' is set
        if ($page_number === null || (is_array($page_number) && count($page_number) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $page_number when calling getPurchaseOrders'
            );
        }
        if ($page_size !== null && $page_size > 1000) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling PurchaseOrdersApi.getPurchaseOrders, must be smaller than or equal to 1000.');
        }
        if ($page_size !== null && $page_size < 1) {
            throw new \InvalidArgumentException('invalid value for "$page_size" when calling PurchaseOrdersApi.getPurchaseOrders, must be bigger than or equal to 1.');
        }


        $resourcePath = '/PurchaseOrders/Page/{pageNumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'pageSize', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $brief,
            'brief', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $completed_after,
            'completedAfter', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $completed_before,
            'completedBefore', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $custom_order_status,
            'customOrderStatus', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $modified_since,
            'modifiedSince', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'orderNumber', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_status,
            'orderStatus', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $serial_batch,
            'serialBatch', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $supplier_code,
            'supplierCode', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $warehouse_code,
            'warehouseCode', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                '{' . 'pageNumber' . '}',
                ObjectSerializer::toPathValue($page_number),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json', 'application/xml']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', 'application/xml'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
