# Unleashed\StockOnHandApi

All URIs are relative to https://api.unleashedsoftware.com.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getStockAllWarehouses()**](StockOnHandApi.md#getStockAllWarehouses) | **GET** /StockOnHand/{id}/AllWarehouses | 
[**getStockOnHand()**](StockOnHandApi.md#getStockOnHand) | **GET** /StockOnHand/{id} | 
[**getStocksOnHand()**](StockOnHandApi.md#getStocksOnHand) | **GET** /StockOnHand/Page/{pageNumber} | 


## `getStockAllWarehouses()`

```php
getStockAllWarehouses($id, $warehouse_code, $warehouse_name, $as_at_date, $modified_since, $order_by, $is_assembled, $product_id): \Unleashed\Model\PagedStockOnHand
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\StockOnHandApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$warehouse_code = 'warehouse_code_example'; // string
$warehouse_name = 'warehouse_name_example'; // string
$as_at_date = 'as_at_date_example'; // string
$modified_since = 'modified_since_example'; // string
$order_by = 'order_by_example'; // string
$is_assembled = 'is_assembled_example'; // string
$product_id = 'product_id_example'; // string

try {
    $result = $apiInstance->getStockAllWarehouses($id, $warehouse_code, $warehouse_name, $as_at_date, $modified_since, $order_by, $is_assembled, $product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockOnHandApi->getStockAllWarehouses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |
 **warehouse_code** | **string**|  | [optional]
 **warehouse_name** | **string**|  | [optional]
 **as_at_date** | **string**|  | [optional]
 **modified_since** | **string**|  | [optional]
 **order_by** | **string**|  | [optional]
 **is_assembled** | **string**|  | [optional]
 **product_id** | **string**|  | [optional]

### Return type

[**\Unleashed\Model\PagedStockOnHand**](../Model/PagedStockOnHand.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockOnHand()`

```php
getStockOnHand($id, $warehouse_code, $warehouse_name, $as_at_date, $modified_since, $order_by, $is_assembled, $product_id): \Unleashed\Model\Stockonhand
```



The StockOnHand resource allows StockOnHand to be listed, or viewed. An individual product’s StockOnHand details can be viewed by appending its identifier (a GUID formatted as XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX) to the URI. Here are some example URIs:  /StockOnHand - returns a list of all StockOnHand; /StockOnHand/E6E8163F-6911-40e9-B740-90E5A0A3A996 - returns details of a particular product;  Note: Products without any transactions will not be returned (i.e; zero quantity products with no previous transactions).

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\StockOnHandApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$warehouse_code = 'warehouse_code_example'; // string
$warehouse_name = 'warehouse_name_example'; // string
$as_at_date = 'as_at_date_example'; // string
$modified_since = 'modified_since_example'; // string
$order_by = 'order_by_example'; // string
$is_assembled = 'is_assembled_example'; // string
$product_id = 'product_id_example'; // string

try {
    $result = $apiInstance->getStockOnHand($id, $warehouse_code, $warehouse_name, $as_at_date, $modified_since, $order_by, $is_assembled, $product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockOnHandApi->getStockOnHand: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |
 **warehouse_code** | **string**|  | [optional]
 **warehouse_name** | **string**|  | [optional]
 **as_at_date** | **string**|  | [optional]
 **modified_since** | **string**|  | [optional]
 **order_by** | **string**|  | [optional]
 **is_assembled** | **string**|  | [optional]
 **product_id** | **string**|  | [optional]

### Return type

[**\Unleashed\Model\Stockonhand**](../Model/Stockonhand.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStocksOnHand()`

```php
getStocksOnHand($page_number, $page_size, $warehouse_code, $warehouse_name, $as_at_date, $modified_since, $order_by, $is_assembled, $product_id): \Unleashed\Model\PagedStockOnHand
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\StockOnHandApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$warehouse_code = 'warehouse_code_example'; // string
$warehouse_name = 'warehouse_name_example'; // string
$as_at_date = 'as_at_date_example'; // string
$modified_since = 'modified_since_example'; // string
$order_by = 'order_by_example'; // string
$is_assembled = 'is_assembled_example'; // string
$product_id = 'product_id_example'; // string

try {
    $result = $apiInstance->getStocksOnHand($page_number, $page_size, $warehouse_code, $warehouse_name, $as_at_date, $modified_since, $order_by, $is_assembled, $product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockOnHandApi->getStocksOnHand: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1]
 **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional]
 **warehouse_code** | **string**|  | [optional]
 **warehouse_name** | **string**|  | [optional]
 **as_at_date** | **string**|  | [optional]
 **modified_since** | **string**|  | [optional]
 **order_by** | **string**|  | [optional]
 **is_assembled** | **string**|  | [optional]
 **product_id** | **string**|  | [optional]

### Return type

[**\Unleashed\Model\PagedStockOnHand**](../Model/PagedStockOnHand.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
