# Unleashed\PurchaseOrdersApi

All URIs are relative to https://api.unleashedsoftware.com.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getPurchaseOrders()**](PurchaseOrdersApi.md#getPurchaseOrders) | **GET** /PurchaseOrders/Page/{pageNumber} | Your GET endpoint


## `getPurchaseOrders()`

```php
getPurchaseOrders($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code): \Unleashed\Model\PagedPurchaseOrder
```

Your GET endpoint

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$brief = 'brief_example'; // string | Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group.
$completed_after = 'completed_after_example'; // string | Returns purchase orders completed after the specified date.
$completed_before = 'completed_before_example'; // string | Returns purchase orders completed before the specified date
$custom_order_status = 'custom_order_status_example'; // string | Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter.
$end_date = 'end_date_example'; // string | Only return purchases with OrderDate before a specified date
$modified_since = 'modified_since_example'; // string | Returns orders created or edited after a specified date, must be UTC format
$order_number = 'order_number_example'; // string | Returns a single order with the specified order number. If set, it overrides all other filters
$order_status = 'order_status_example'; // string | If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter.
$serial_batch = 'serial_batch_example'; // string | If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned.
$start_date = 'start_date_example'; // string | Only return purchases with OrderDate after a specified date
$supplier_code = 'supplier_code_example'; // string | Only return suppliers that start with the specific supplier code
$warehouse_code = 'warehouse_code_example'; // string

try {
    $result = $apiInstance->getPurchaseOrders($page_number, $page_size, $brief, $completed_after, $completed_before, $custom_order_status, $end_date, $modified_since, $order_number, $order_status, $serial_batch, $start_date, $supplier_code, $warehouse_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->getPurchaseOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1]
 **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional]
 **brief** | **string**| Default is true. If set to true, returns a brief summary of the product list that only includes: Guid, ProductCode, and ProductDescription. If set to false, returns Guid, ProductCode, ProductDescription, SupplierProductDescription, SupplierProductCode, and Product Group. | [optional]
 **completed_after** | **string**| Returns purchase orders completed after the specified date. | [optional]
 **completed_before** | **string**| Returns purchase orders completed before the specified date | [optional]
 **custom_order_status** | **string**| Returns purchase orders with the specified custom status. If specified, this filter will override the orderStatus filter. | [optional]
 **end_date** | **string**| Only return purchases with OrderDate before a specified date | [optional]
 **modified_since** | **string**| Returns orders created or edited after a specified date, must be UTC format | [optional]
 **order_number** | **string**| Returns a single order with the specified order number. If set, it overrides all other filters | [optional]
 **order_status** | **string**| If filter is not provided, returns all non-deleted orders. Only returns deleted orders if explicitly specified in filter. | [optional]
 **serial_batch** | **string**| If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. | [optional]
 **start_date** | **string**| Only return purchases with OrderDate after a specified date | [optional]
 **supplier_code** | **string**| Only return suppliers that start with the specific supplier code | [optional]
 **warehouse_code** | **string**|  | [optional]

### Return type

[**\Unleashed\Model\PagedPurchaseOrder**](../Model/PagedPurchaseOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
