# Unleashed\AssembliesApi

All URIs are relative to https://api.unleashedsoftware.com.

Method | HTTP request | Description
------------- | ------------- | -------------
[**completeAssembly()**](AssembliesApi.md#completeAssembly) | **POST** /Assemblies/{id}/Complete | Complete an existing Assembly
[**createAssembly()**](AssembliesApi.md#createAssembly) | **POST** /Assemblies | Create a new Assembly with new lines
[**createAssemblyLines()**](AssembliesApi.md#createAssemblyLines) | **POST** /Assemblies/{id}/Lines | Create Assembly Lines against an existing Assembly.
[**deleteAssembly()**](AssembliesApi.md#deleteAssembly) | **DELETE** /Assemblies/{id} | Delete a Parked assembly.
[**getAssemblies()**](AssembliesApi.md#getAssemblies) | **GET** /Assemblies | List all Assemblies
[**getAssembly()**](AssembliesApi.md#getAssembly) | **GET** /Assemblies/{id} | View an assembly with the specified Guid
[**updateAssembly()**](AssembliesApi.md#updateAssembly) | **PUT** /Assemblies/{id} | Update an existing Assembly and existing lines


## `completeAssembly()`

```php
completeAssembly($id): \Unleashed\Model\Assembly
```

Complete an existing Assembly

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->completeAssembly($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->completeAssembly: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

[**\Unleashed\Model\Assembly**](../Model/Assembly.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createAssembly()`

```php
createAssembly($body): \Unleashed\Model\Assembly
```

Create a new Assembly with new lines

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\Assembly(); // \Unleashed\Model\Assembly

try {
    $result = $apiInstance->createAssembly($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->createAssembly: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Unleashed\Model\Assembly**](../Model/Assembly.md)|  | [optional]

### Return type

[**\Unleashed\Model\Assembly**](../Model/Assembly.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createAssemblyLines()`

```php
createAssemblyLines($id, $body): \Unleashed\Model\AssemblyLine
```

Create Assembly Lines against an existing Assembly.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = new \Unleashed\Model\AssemblyLine(); // \Unleashed\Model\AssemblyLine

try {
    $result = $apiInstance->createAssemblyLines($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->createAssemblyLines: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |
 **body** | [**\Unleashed\Model\AssemblyLine**](../Model/AssemblyLine.md)|  | [optional]

### Return type

[**\Unleashed\Model\AssemblyLine**](../Model/AssemblyLine.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAssembly()`

```php
deleteAssembly($id)
```

Delete a Parked assembly.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $apiInstance->deleteAssembly($id);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->deleteAssembly: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAssemblies()`

```php
getAssemblies($page_size, $assembly_status, $custom_assembly_status, $start_date, $end_date, $modified_since, $assembly_number): \Unleashed\Model\PagedAssembly
```

List all Assemblies

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$assembly_status = 'assembly_status_example'; // string | Returns assemblies for the specified status
$custom_assembly_status = 'custom_assembly_status_example'; // string
$start_date = 'start_date_example'; // string
$end_date = 'end_date_example'; // string
$modified_since = 'modified_since_example'; // string
$assembly_number = 'assembly_number_example'; // string | Returns a single assembly with the specified assembly number. If specified, it overrides all other filters.

try {
    $result = $apiInstance->getAssemblies($page_size, $assembly_status, $custom_assembly_status, $start_date, $end_date, $modified_since, $assembly_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->getAssemblies: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional]
 **assembly_status** | **string**| Returns assemblies for the specified status | [optional]
 **custom_assembly_status** | **string**|  | [optional]
 **start_date** | **string**|  | [optional]
 **end_date** | **string**|  | [optional]
 **modified_since** | **string**|  | [optional]
 **assembly_number** | **string**| Returns a single assembly with the specified assembly number. If specified, it overrides all other filters. | [optional]

### Return type

[**\Unleashed\Model\PagedAssembly**](../Model/PagedAssembly.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAssembly()`

```php
getAssembly($id): \Unleashed\Model\Assembly
```

View an assembly with the specified Guid

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->getAssembly($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->getAssembly: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

[**\Unleashed\Model\Assembly**](../Model/Assembly.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateAssembly()`

```php
updateAssembly($id, $body): \Unleashed\Model\Assembly
```

Update an existing Assembly and existing lines

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\AssembliesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$body = new \Unleashed\Model\Assembly(); // \Unleashed\Model\Assembly

try {
    $result = $apiInstance->updateAssembly($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssembliesApi->updateAssembly: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |
 **body** | [**\Unleashed\Model\Assembly**](../Model/Assembly.md)|  | [optional]

### Return type

[**\Unleashed\Model\Assembly**](../Model/Assembly.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
