<?php
/**
 * CreditNote
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * CreditNote Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CreditNote implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'creditNote';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'credit_note_number' => 'string',
        'credit_date' => 'string',
        'sales_invoice_date' => 'string',
        'required_delivery_date' => 'string',
        'warehouse' => '\Unleashed\Model\Warehouse',
        'customer' => '\Unleashed\Model\Customer',
        'credit_status' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'total' => 'float',
        'invoice_number' => 'string',
        'reference_number' => 'string',
        'credit_note_lines' => '\Unleashed\Model\CreditNoteLine[]',
        'comments' => 'string',
        'tax_rate' => 'float',
        'xero_tax_code' => 'string',
        'tax_total' => 'float',
        'sub_total' => 'float',
        'tax' => '\Unleashed\Model\Tax',
        'last_modified_by' => 'string',
        'last_modified_on' => 'string',
        'created_by' => 'string',
        'created_on' => 'string',
        'guid' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'credit_note_number' => null,
        'credit_date' => null,
        'sales_invoice_date' => null,
        'required_delivery_date' => null,
        'warehouse' => null,
        'customer' => null,
        'credit_status' => null,
        'currency' => null,
        'total' => null,
        'invoice_number' => null,
        'reference_number' => null,
        'credit_note_lines' => null,
        'comments' => null,
        'tax_rate' => null,
        'xero_tax_code' => null,
        'tax_total' => null,
        'sub_total' => null,
        'tax' => null,
        'last_modified_by' => null,
        'last_modified_on' => null,
        'created_by' => null,
        'created_on' => null,
        'guid' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'credit_note_number' => 'CreditNoteNumber',
        'credit_date' => 'CreditDate',
        'sales_invoice_date' => 'SalesInvoiceDate',
        'required_delivery_date' => 'RequiredDeliveryDate',
        'warehouse' => 'Warehouse',
        'customer' => 'Customer',
        'credit_status' => 'CreditStatus',
        'currency' => 'Currency',
        'total' => 'Total',
        'invoice_number' => 'InvoiceNumber',
        'reference_number' => 'ReferenceNumber',
        'credit_note_lines' => 'CreditNoteLines',
        'comments' => 'Comments',
        'tax_rate' => 'TaxRate',
        'xero_tax_code' => 'XeroTaxCode',
        'tax_total' => 'TaxTotal',
        'sub_total' => 'SubTotal',
        'tax' => 'Tax',
        'last_modified_by' => 'LastModifiedBy',
        'last_modified_on' => 'LastModifiedOn',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'guid' => 'Guid'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'credit_note_number' => 'setCreditNoteNumber',
        'credit_date' => 'setCreditDate',
        'sales_invoice_date' => 'setSalesInvoiceDate',
        'required_delivery_date' => 'setRequiredDeliveryDate',
        'warehouse' => 'setWarehouse',
        'customer' => 'setCustomer',
        'credit_status' => 'setCreditStatus',
        'currency' => 'setCurrency',
        'total' => 'setTotal',
        'invoice_number' => 'setInvoiceNumber',
        'reference_number' => 'setReferenceNumber',
        'credit_note_lines' => 'setCreditNoteLines',
        'comments' => 'setComments',
        'tax_rate' => 'setTaxRate',
        'xero_tax_code' => 'setXeroTaxCode',
        'tax_total' => 'setTaxTotal',
        'sub_total' => 'setSubTotal',
        'tax' => 'setTax',
        'last_modified_by' => 'setLastModifiedBy',
        'last_modified_on' => 'setLastModifiedOn',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'guid' => 'setGuid'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'credit_note_number' => 'getCreditNoteNumber',
        'credit_date' => 'getCreditDate',
        'sales_invoice_date' => 'getSalesInvoiceDate',
        'required_delivery_date' => 'getRequiredDeliveryDate',
        'warehouse' => 'getWarehouse',
        'customer' => 'getCustomer',
        'credit_status' => 'getCreditStatus',
        'currency' => 'getCurrency',
        'total' => 'getTotal',
        'invoice_number' => 'getInvoiceNumber',
        'reference_number' => 'getReferenceNumber',
        'credit_note_lines' => 'getCreditNoteLines',
        'comments' => 'getComments',
        'tax_rate' => 'getTaxRate',
        'xero_tax_code' => 'getXeroTaxCode',
        'tax_total' => 'getTaxTotal',
        'sub_total' => 'getSubTotal',
        'tax' => 'getTax',
        'last_modified_by' => 'getLastModifiedBy',
        'last_modified_on' => 'getLastModifiedOn',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'guid' => 'getGuid'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['credit_note_number'] = $data['credit_note_number'] ?? null;
        $this->container['credit_date'] = $data['credit_date'] ?? null;
        $this->container['sales_invoice_date'] = $data['sales_invoice_date'] ?? null;
        $this->container['required_delivery_date'] = $data['required_delivery_date'] ?? null;
        $this->container['warehouse'] = $data['warehouse'] ?? null;
        $this->container['customer'] = $data['customer'] ?? null;
        $this->container['credit_status'] = $data['credit_status'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['invoice_number'] = $data['invoice_number'] ?? null;
        $this->container['reference_number'] = $data['reference_number'] ?? null;
        $this->container['credit_note_lines'] = $data['credit_note_lines'] ?? null;
        $this->container['comments'] = $data['comments'] ?? null;
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['xero_tax_code'] = $data['xero_tax_code'] ?? null;
        $this->container['tax_total'] = $data['tax_total'] ?? null;
        $this->container['sub_total'] = $data['sub_total'] ?? null;
        $this->container['tax'] = $data['tax'] ?? null;
        $this->container['last_modified_by'] = $data['last_modified_by'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
        $this->container['created_by'] = $data['created_by'] ?? null;
        $this->container['created_on'] = $data['created_on'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets credit_note_number
     *
     * @return string|null
     */
    public function getCreditNoteNumber()
    {
        return $this->container['credit_note_number'];
    }

    /**
     * Sets credit_note_number
     *
     * @param string|null $credit_note_number credit_note_number
     *
     * @return self
     */
    public function setCreditNoteNumber($credit_note_number)
    {
        $this->container['credit_note_number'] = $credit_note_number;

        return $this;
    }

    /**
     * Gets credit_date
     *
     * @return string|null
     */
    public function getCreditDate()
    {
        return $this->container['credit_date'];
    }

    /**
     * Sets credit_date
     *
     * @param string|null $credit_date credit_date
     *
     * @return self
     */
    public function setCreditDate($credit_date)
    {
        $this->container['credit_date'] = $credit_date;

        return $this;
    }

    /**
     * Gets sales_invoice_date
     *
     * @return string|null
     */
    public function getSalesInvoiceDate()
    {
        return $this->container['sales_invoice_date'];
    }

    /**
     * Sets sales_invoice_date
     *
     * @param string|null $sales_invoice_date sales_invoice_date
     *
     * @return self
     */
    public function setSalesInvoiceDate($sales_invoice_date)
    {
        $this->container['sales_invoice_date'] = $sales_invoice_date;

        return $this;
    }

    /**
     * Gets required_delivery_date
     *
     * @return string|null
     */
    public function getRequiredDeliveryDate()
    {
        return $this->container['required_delivery_date'];
    }

    /**
     * Sets required_delivery_date
     *
     * @param string|null $required_delivery_date required_delivery_date
     *
     * @return self
     */
    public function setRequiredDeliveryDate($required_delivery_date)
    {
        $this->container['required_delivery_date'] = $required_delivery_date;

        return $this;
    }

    /**
     * Gets warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getWarehouse()
    {
        return $this->container['warehouse'];
    }

    /**
     * Sets warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $warehouse warehouse
     *
     * @return self
     */
    public function setWarehouse($warehouse)
    {
        $this->container['warehouse'] = $warehouse;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \Unleashed\Model\Customer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \Unleashed\Model\Customer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets credit_status
     *
     * @return string|null
     */
    public function getCreditStatus()
    {
        return $this->container['credit_status'];
    }

    /**
     * Sets credit_status
     *
     * @param string|null $credit_status credit_status
     *
     * @return self
     */
    public function setCreditStatus($credit_status)
    {
        $this->container['credit_status'] = $credit_status;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number invoice_number
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number reference_number
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets credit_note_lines
     *
     * @return \Unleashed\Model\CreditNoteLine[]|null
     */
    public function getCreditNoteLines()
    {
        return $this->container['credit_note_lines'];
    }

    /**
     * Sets credit_note_lines
     *
     * @param \Unleashed\Model\CreditNoteLine[]|null $credit_note_lines credit_note_lines
     *
     * @return self
     */
    public function setCreditNoteLines($credit_note_lines)
    {
        $this->container['credit_note_lines'] = $credit_note_lines;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total tax_total
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param float|null $sub_total sub_total
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return \Unleashed\Model\Tax|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param \Unleashed\Model\Tax|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


