# Unleashed\SalesOrdersApi

All URIs are relative to https://api.unleashedsoftware.com.

Method | HTTP request | Description
------------- | ------------- | -------------
[**completeSalesOrder()**](SalesOrdersApi.md#completeSalesOrder) | **POST** /SalesOrders/{id}/Complete | 
[**createSalesOrder()**](SalesOrdersApi.md#createSalesOrder) | **POST** /SalesOrders/{id} | 
[**deleteSalesOrder()**](SalesOrdersApi.md#deleteSalesOrder) | **DELETE** /SalesOrders/{id} | 
[**deleteSalesOrderLines()**](SalesOrdersApi.md#deleteSalesOrderLines) | **DELETE** /SalesOrders/Lines/{id} | 
[**getSalesOrder()**](SalesOrdersApi.md#getSalesOrder) | **GET** /SalesOrders/{id} | 
[**getSalesOrders()**](SalesOrdersApi.md#getSalesOrders) | **GET** /SalesOrders/Page/{pageNumber} | 
[**updateSalesOrder()**](SalesOrdersApi.md#updateSalesOrder) | **PUT** /SalesOrders/{id} | 


## `completeSalesOrder()`

```php
completeSalesOrder($id): object
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->completeSalesOrder($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->completeSalesOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createSalesOrder()`

```php
createSalesOrder($id, $tax_inclusive, $send_accounting_journal_only, $serial_batch, $body): \Unleashed\Model\SalesOrder
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$tax_inclusive = 'tax_inclusive_example'; // string | Order includes sales tax on each of the order lines. Note that Unleashed will re-calculate the order exclusive of tax before saving it.
$send_accounting_journal_only = 'send_accounting_journal_only_example'; // string | When creating a sales order, if you want to pass only a journal and not the invoice into Xero / QuickBooks Online, you can set the parameter to true.
$serial_batch = 'serial_batch_example'; // string | If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned.
$body = new \Unleashed\Model\SalesOrder(); // \Unleashed\Model\SalesOrder

try {
    $result = $apiInstance->createSalesOrder($id, $tax_inclusive, $send_accounting_journal_only, $serial_batch, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->createSalesOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |
 **tax_inclusive** | **string**| Order includes sales tax on each of the order lines. Note that Unleashed will re-calculate the order exclusive of tax before saving it. | [optional]
 **send_accounting_journal_only** | **string**| When creating a sales order, if you want to pass only a journal and not the invoice into Xero / QuickBooks Online, you can set the parameter to true. | [optional]
 **serial_batch** | **string**| If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. | [optional]
 **body** | [**\Unleashed\Model\SalesOrder**](../Model/SalesOrder.md)|  | [optional]

### Return type

[**\Unleashed\Model\SalesOrder**](../Model/SalesOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSalesOrder()`

```php
deleteSalesOrder($id): object
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->deleteSalesOrder($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->deleteSalesOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSalesOrderLines()`

```php
deleteSalesOrderLines($id): object
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->deleteSalesOrderLines($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->deleteSalesOrderLines: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesOrder()`

```php
getSalesOrder($id): \Unleashed\Model\SalesOrder
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996

try {
    $result = $apiInstance->getSalesOrder($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->getSalesOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |

### Return type

[**\Unleashed\Model\SalesOrder**](../Model/SalesOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesOrders()`

```php
getSalesOrders($page_number, $page_size, $customer_id, $customer_code, $start_date, $end_date, $modified_since, $order_number, $order_status, $source_id, $serial_batch, $save_address, $completed_after, $completed_before): \Unleashed\Model\PagedSalesOrder
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$customer_id = 'customer_id_example'; // string
$customer_code = 'customer_code_example'; // string
$start_date = 'start_date_example'; // string
$end_date = 'end_date_example'; // string
$modified_since = 'modified_since_example'; // string
$order_number = 'order_number_example'; // string
$order_status = 'order_status_example'; // string
$source_id = 'source_id_example'; // string
$serial_batch = 'serial_batch_example'; // string
$save_address = 'save_address_example'; // string
$completed_after = 'completed_after_example'; // string
$completed_before = 'completed_before_example'; // string

try {
    $result = $apiInstance->getSalesOrders($page_number, $page_size, $customer_id, $customer_code, $start_date, $end_date, $modified_since, $order_number, $order_status, $source_id, $serial_batch, $save_address, $completed_after, $completed_before);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->getSalesOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1]
 **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional]
 **customer_id** | **string**|  | [optional]
 **customer_code** | **string**|  | [optional]
 **start_date** | **string**|  | [optional]
 **end_date** | **string**|  | [optional]
 **modified_since** | **string**|  | [optional]
 **order_number** | **string**|  | [optional]
 **order_status** | **string**|  | [optional]
 **source_id** | **string**|  | [optional]
 **serial_batch** | **string**|  | [optional]
 **save_address** | **string**|  | [optional]
 **completed_after** | **string**|  | [optional]
 **completed_before** | **string**|  | [optional]

### Return type

[**\Unleashed\Model\PagedSalesOrder**](../Model/PagedSalesOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSalesOrder()`

```php
updateSalesOrder($id, $tax_inclusive, $send_accounting_journal_only, $serial_batch, $body): \Unleashed\Model\SalesOrder
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string | internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996
$tax_inclusive = 'tax_inclusive_example'; // string | Order includes sales tax on each of the order lines. Note that Unleashed will re-calculate the order exclusive of tax before saving it.
$send_accounting_journal_only = 'send_accounting_journal_only_example'; // string | When creating a sales order, if you want to pass only a journal and not the invoice into Xero / QuickBooks Online, you can set the parameter to true.
$serial_batch = 'serial_batch_example'; // string | If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned.
$body = new \Unleashed\Model\SalesOrder(); // \Unleashed\Model\SalesOrder

try {
    $result = $apiInstance->updateSalesOrder($id, $tax_inclusive, $send_accounting_journal_only, $serial_batch, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->updateSalesOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| internal GUID e.g. E6E8163F-6911-40e9-B740-90E5A0A3A996 |
 **tax_inclusive** | **string**| Order includes sales tax on each of the order lines. Note that Unleashed will re-calculate the order exclusive of tax before saving it. | [optional]
 **send_accounting_journal_only** | **string**| When creating a sales order, if you want to pass only a journal and not the invoice into Xero / QuickBooks Online, you can set the parameter to true. | [optional]
 **serial_batch** | **string**| If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. | [optional]
 **body** | [**\Unleashed\Model\SalesOrder**](../Model/SalesOrder.md)|  | [optional]

### Return type

[**\Unleashed\Model\SalesOrder**](../Model/SalesOrder.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
