# Unleashed\CreditNotesApi

All URIs are relative to https://api.unleashedsoftware.com.

Method | HTTP request | Description
------------- | ------------- | -------------
[**completeCreditNote()**](CreditNotesApi.md#completeCreditNote) | **POST** /CreditNotes/{id}/Complete | 
[**createCreditNoteLine()**](CreditNotesApi.md#createCreditNoteLine) | **POST** /CreditNotes/{id}/Lines | 
[**createFreeCreditNote()**](CreditNotesApi.md#createFreeCreditNote) | **POST** /CreditNotes/FreeCredit | 
[**deleteCreditNote()**](CreditNotesApi.md#deleteCreditNote) | **DELETE** /CreditNotes/{id} | 
[**getCreditNote()**](CreditNotesApi.md#getCreditNote) | **GET** /CreditNotes/{id} | 
[**getCreditNotes()**](CreditNotesApi.md#getCreditNotes) | **GET** /CreditNotes/Page/{pageNumber} | 
[**updateCreditNote()**](CreditNotesApi.md#updateCreditNote) | **PUT** /CreditNotes/{id} | 
[**updateCreditNoteLine()**](CreditNotesApi.md#updateCreditNoteLine) | **PUT** /CreditNotes/{id}/Lines/{line} | 


## `completeCreditNote()`

```php
completeCreditNote($id): \Unleashed\Model\CreditNote
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->completeCreditNote($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->completeCreditNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |

### Return type

[**\Unleashed\Model\CreditNote**](../Model/CreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCreditNoteLine()`

```php
createCreditNoteLine($id, $body): \Unleashed\Model\CreditNote
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$body = new \Unleashed\Model\FreeCredit(); // \Unleashed\Model\FreeCredit

try {
    $result = $apiInstance->createCreditNoteLine($id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->createCreditNoteLine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |
 **body** | [**\Unleashed\Model\FreeCredit**](../Model/FreeCredit.md)|  | [optional]

### Return type

[**\Unleashed\Model\CreditNote**](../Model/CreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createFreeCreditNote()`

```php
createFreeCreditNote($body): \Unleashed\Model\CreditNote
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\FreeCredit(); // \Unleashed\Model\FreeCredit

try {
    $result = $apiInstance->createFreeCreditNote($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->createFreeCreditNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Unleashed\Model\FreeCredit**](../Model/FreeCredit.md)|  | [optional]

### Return type

[**\Unleashed\Model\CreditNote**](../Model/CreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCreditNote()`

```php
deleteCreditNote($id): \Unleashed\Model\CreditNote
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->deleteCreditNote($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->deleteCreditNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |

### Return type

[**\Unleashed\Model\CreditNote**](../Model/CreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCreditNote()`

```php
getCreditNote($id): \Unleashed\Model\CreditNote
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->getCreditNote($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->getCreditNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |

### Return type

[**\Unleashed\Model\CreditNote**](../Model/CreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCreditNotes()`

```php
getCreditNotes($page_number, $page_size, $credit_status, $start_date, $end_date, $modified_since, $credit_number): \Unleashed\Model\PagedCreditNote
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$page_number = 1; // int | Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders
$page_size = 56; // int | The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize={pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize=500.
$credit_status = 'credit_status_example'; // string
$start_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$end_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$modified_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime
$credit_number = 'credit_number_example'; // string

try {
    $result = $apiInstance->getCreditNotes($page_number, $page_size, $credit_status, $start_date, $end_date, $modified_since, $credit_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->getCreditNotes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **page_number** | **int**| Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders | [default to 1]
 **page_size** | **int**| The default page size is 200 records, but is configurable by adding the desired page size in the URL querystring:  https://api.unleashedsoftware.com/{endpoint}/{pagenumber}?pageSize&#x3D;{pagesize}.  The minimum page size is 1 and the maximum page size is 1000 records.  If you want to retrieve the 3rd page of 500 SalesOrders records (ie. 1001st to 1500th record) then you would use this URL:  https://api.unleashedsoftware.com/SalesOrders/3?pageSize&#x3D;500. | [optional]
 **credit_status** | **string**|  | [optional]
 **start_date** | **\DateTime**|  | [optional]
 **end_date** | **\DateTime**|  | [optional]
 **modified_since** | **\DateTime**|  | [optional]
 **credit_number** | **string**|  | [optional]

### Return type

[**\Unleashed\Model\PagedCreditNote**](../Model/PagedCreditNote.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCreditNote()`

```php
updateCreditNote($id): object
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->updateCreditNote($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->updateCreditNote: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |

### Return type

**object**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCreditNoteLine()`

```php
updateCreditNoteLine($id, $line, $body): \Unleashed\Model\CreditNoteLine
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Unleashed\Api\CreditNotesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 'id_example'; // string
$line = 'line_example'; // string
$body = new \Unleashed\Model\CreditNoteLine(); // \Unleashed\Model\CreditNoteLine

try {
    $result = $apiInstance->updateCreditNoteLine($id, $line, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CreditNotesApi->updateCreditNoteLine: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**|  |
 **line** | **string**|  |
 **body** | [**\Unleashed\Model\CreditNoteLine**](../Model/CreditNoteLine.md)|  | [optional]

### Return type

[**\Unleashed\Model\CreditNoteLine**](../Model/CreditNoteLine.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`, `application/xml`
- **Accept**: `application/json`, `application/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
