# OpenAPIClient-php

The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.

Date format must be yyyy-MM-ddTHH:mm:ss.fff 

For more information, please visit [https://tideconnects.com](https://tideconnects.com).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/unleashed.git"
    }
  ],
  "require": {
    "talisman/unleashed": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Unleashed\Api\AttributeSetsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \Unleashed\Model\AttributeSet(); // \Unleashed\Model\AttributeSet

try {
    $result = $apiInstance->createAttributeSet($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AttributeSetsApi->createAttributeSet: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.unleashedsoftware.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AttributeSetsApi* | [**createAttributeSet**](docs/Api/AttributeSetsApi.md#createattributeset) | **POST** /AttributeSets | 
*AttributeSetsApi* | [**getAttributeSet**](docs/Api/AttributeSetsApi.md#getattributeset) | **GET** /AttributeSets/{id} | 
*AttributeSetsApi* | [**getAttributeSets**](docs/Api/AttributeSetsApi.md#getattributesets) | **GET** /AttributeSets | 
*AttributeSetsApi* | [**updateAttributeSet**](docs/Api/AttributeSetsApi.md#updateattributeset) | **POST** /AttributeSets/{id} | 
*BatchNumbersApi* | [**getBatchNumber**](docs/Api/BatchNumbersApi.md#getbatchnumber) | **GET** /BatchNumbers/Page/{pageNumber} | 
*CompaniesApi* | [**getCompanies**](docs/Api/CompaniesApi.md#getcompanies) | **GET** /Companies | 
*CreditNotesApi* | [**completeCreditNote**](docs/Api/CreditNotesApi.md#completecreditnote) | **POST** /CreditNotes/{id}/Complete | 
*CreditNotesApi* | [**createCreditNoteLine**](docs/Api/CreditNotesApi.md#createcreditnoteline) | **POST** /CreditNotes/{id}/Lines | 
*CreditNotesApi* | [**createFreeCreditNote**](docs/Api/CreditNotesApi.md#createfreecreditnote) | **POST** /CreditNotes/FreeCredit | 
*CreditNotesApi* | [**deleteCreditNote**](docs/Api/CreditNotesApi.md#deletecreditnote) | **DELETE** /CreditNotes/{id} | 
*CreditNotesApi* | [**getCreditNote**](docs/Api/CreditNotesApi.md#getcreditnote) | **GET** /CreditNotes/{id} | 
*CreditNotesApi* | [**getCreditNotes**](docs/Api/CreditNotesApi.md#getcreditnotes) | **GET** /CreditNotes/Page/{pageNumber} | 
*CreditNotesApi* | [**updateCreditNote**](docs/Api/CreditNotesApi.md#updatecreditnote) | **PUT** /CreditNotes/{id} | 
*CreditNotesApi* | [**updateCreditNoteLine**](docs/Api/CreditNotesApi.md#updatecreditnoteline) | **PUT** /CreditNotes/{id}/Lines/{line} | 
*CustomerTypesApi* | [**getCustomerTypes**](docs/Api/CustomerTypesApi.md#getcustomertypes) | **GET** /CustomerTypes | 
*CustomersApi* | [**createCustomer**](docs/Api/CustomersApi.md#createcustomer) | **POST** /Customers/{id} | 
*CustomersApi* | [**getCustomer**](docs/Api/CustomersApi.md#getcustomer) | **GET** /Customers/{id} | 
*CustomersApi* | [**getCustomers**](docs/Api/CustomersApi.md#getcustomers) | **GET** /Customers/Page/{pageNumber} | 
*DefaultApi* | [**getBatchNumbersId**](docs/Api/DefaultApi.md#getbatchnumbersid) | **GET** /BatchNumbers/{id} | Your GET endpoint
*DefaultApi* | [**getPurchaseOrdersId**](docs/Api/DefaultApi.md#getpurchaseordersid) | **GET** /PurchaseOrders/{id} | Your GET endpoint
*ProductGroupsApi* | [**getProductGroups**](docs/Api/ProductGroupsApi.md#getproductgroups) | **GET** /ProductGroups | 
*ProductsApi* | [**createProduct**](docs/Api/ProductsApi.md#createproduct) | **POST** /Products/{id} | 
*ProductsApi* | [**getProduct**](docs/Api/ProductsApi.md#getproduct) | **GET** /Products/{id} | 
*ProductsApi* | [**getProducts**](docs/Api/ProductsApi.md#getproducts) | **GET** /Products/Page/{pageNumber} | 
*PurchaseOrdersApi* | [**getPurchaseOrders**](docs/Api/PurchaseOrdersApi.md#getpurchaseorders) | **GET** /PurchaseOrders/Page/{pageNumber} | Your GET endpoint
*SalesOrderGroupApi* | [**getSaleOrderGroups**](docs/Api/SalesOrderGroupApi.md#getsaleordergroups) | **GET** /SalesOrderGroups | 
*SalesOrdersApi* | [**completeSalesOrder**](docs/Api/SalesOrdersApi.md#completesalesorder) | **POST** /SalesOrders/{id}/Complete | 
*SalesOrdersApi* | [**createSalesOrder**](docs/Api/SalesOrdersApi.md#createsalesorder) | **POST** /SalesOrders/{id} | 
*SalesOrdersApi* | [**deleteSalesOrder**](docs/Api/SalesOrdersApi.md#deletesalesorder) | **DELETE** /SalesOrders/{id} | 
*SalesOrdersApi* | [**deleteSalesOrderLines**](docs/Api/SalesOrdersApi.md#deletesalesorderlines) | **DELETE** /SalesOrders/Lines/{id} | 
*SalesOrdersApi* | [**getSalesOrder**](docs/Api/SalesOrdersApi.md#getsalesorder) | **GET** /SalesOrders/{id} | 
*SalesOrdersApi* | [**getSalesOrders**](docs/Api/SalesOrdersApi.md#getsalesorders) | **GET** /SalesOrders/Page/{pageNumber} | 
*SalesOrdersApi* | [**updateSalesOrder**](docs/Api/SalesOrdersApi.md#updatesalesorder) | **PUT** /SalesOrders/{id} | 
*SalesPersonsApi* | [**createSalesperson**](docs/Api/SalesPersonsApi.md#createsalesperson) | **POST** /Salespersons/{id} | 
*SalesPersonsApi* | [**getSalespersons**](docs/Api/SalesPersonsApi.md#getsalespersons) | **GET** /Salespersons | 
*SalesShipmentsApi* | [**createSalesShipment**](docs/Api/SalesShipmentsApi.md#createsalesshipment) | **POST** /SalesShipments | 
*SalesShipmentsApi* | [**deleteSalesShipment**](docs/Api/SalesShipmentsApi.md#deletesalesshipment) | **DELETE** /SalesShipments/{id} | 
*SalesShipmentsApi* | [**deleteSalesShipmentLine**](docs/Api/SalesShipmentsApi.md#deletesalesshipmentline) | **DELETE** /SalesShipments/Lines/{id} | 
*SalesShipmentsApi* | [**getSalesShipment**](docs/Api/SalesShipmentsApi.md#getsalesshipment) | **GET** /SalesShipments/{id} | 
*SalesShipmentsApi* | [**getSalesShipments**](docs/Api/SalesShipmentsApi.md#getsalesshipments) | **GET** /SalesShipments/Page/{pageNumber} | 
*SalesShipmentsApi* | [**updateSalesShipment**](docs/Api/SalesShipmentsApi.md#updatesalesshipment) | **PUT** /SalesShipments/{id} | 
*SellPriceTiersApi* | [**getSellPriceTiers**](docs/Api/SellPriceTiersApi.md#getsellpricetiers) | **GET** /SellPriceTiers | 
*SettingsApi* | [**getDeliveryMethods**](docs/Api/SettingsApi.md#getdeliverymethods) | **GET** /DeliveryMethods | 
*ShippingCompaniesApi* | [**getShippingCompanies**](docs/Api/ShippingCompaniesApi.md#getshippingcompanies) | **GET** /ShippingCompanies | 
*StockOnHandApi* | [**getStockAllWarehouses**](docs/Api/StockOnHandApi.md#getstockallwarehouses) | **GET** /StockOnHand/{id}/AllWarehouses | 
*StockOnHandApi* | [**getStockOnHand**](docs/Api/StockOnHandApi.md#getstockonhand) | **GET** /StockOnHand/{id} | 
*StockOnHandApi* | [**getStocksOnHand**](docs/Api/StockOnHandApi.md#getstocksonhand) | **GET** /StockOnHand/Page/{pageNumber} | 
*SuppliersApi* | [**getSupplier**](docs/Api/SuppliersApi.md#getsupplier) | **GET** /Suppliers/{id} | 
*SuppliersApi* | [**getSuppliers**](docs/Api/SuppliersApi.md#getsuppliers) | **GET** /Suppliers/Page/{pageNumber} | 
*TaxesApi* | [**getTaxes**](docs/Api/TaxesApi.md#gettaxes) | **GET** /Taxes | 
*WarehousesApi* | [**getWarehouses**](docs/Api/WarehousesApi.md#getwarehouses) | **GET** /Warehouses | 

## Models

- [Address](docs/Model/Address.md)
- [Attribute](docs/Model/Attribute.md)
- [AttributeSet](docs/Model/AttributeSet.md)
- [AttributeSetList](docs/Model/AttributeSetList.md)
- [Batch](docs/Model/Batch.md)
- [BatchNumber](docs/Model/BatchNumber.md)
- [Company](docs/Model/Company.md)
- [CompanyList](docs/Model/CompanyList.md)
- [Contact](docs/Model/Contact.md)
- [CreditNote](docs/Model/CreditNote.md)
- [CreditNoteLine](docs/Model/CreditNoteLine.md)
- [Currency](docs/Model/Currency.md)
- [Customer](docs/Model/Customer.md)
- [CustomerType](docs/Model/CustomerType.md)
- [CustomerTypeList](docs/Model/CustomerTypeList.md)
- [DeliveryContact](docs/Model/DeliveryContact.md)
- [DeliveryMethod](docs/Model/DeliveryMethod.md)
- [FreeCredit](docs/Model/FreeCredit.md)
- [Image](docs/Model/Image.md)
- [ImageCopy](docs/Model/ImageCopy.md)
- [PagedBatchNumber](docs/Model/PagedBatchNumber.md)
- [PagedCreditNote](docs/Model/PagedCreditNote.md)
- [PagedCustomer](docs/Model/PagedCustomer.md)
- [PagedDeliveryMethod](docs/Model/PagedDeliveryMethod.md)
- [PagedProduct](docs/Model/PagedProduct.md)
- [PagedPurchaseOrder](docs/Model/PagedPurchaseOrder.md)
- [PagedSalesOrder](docs/Model/PagedSalesOrder.md)
- [PagedSalesShipment](docs/Model/PagedSalesShipment.md)
- [PagedShippingCompany](docs/Model/PagedShippingCompany.md)
- [PagedStockOnHand](docs/Model/PagedStockOnHand.md)
- [PagedSupplier](docs/Model/PagedSupplier.md)
- [PagedTax](docs/Model/PagedTax.md)
- [PagedWarehouse](docs/Model/PagedWarehouse.md)
- [Pagination](docs/Model/Pagination.md)
- [PendingBatch](docs/Model/PendingBatch.md)
- [PendingSerial](docs/Model/PendingSerial.md)
- [Product](docs/Model/Product.md)
- [ProductGroup](docs/Model/ProductGroup.md)
- [ProductGroupList](docs/Model/ProductGroupList.md)
- [PurchaseOrder](docs/Model/PurchaseOrder.md)
- [PurchaseOrderLine](docs/Model/PurchaseOrderLine.md)
- [PurchaseOrderPurchaseOrderLinesInner](docs/Model/PurchaseOrderPurchaseOrderLinesInner.md)
- [SalesOrder](docs/Model/SalesOrder.md)
- [SalesOrderCustomer](docs/Model/SalesOrderCustomer.md)
- [SalesOrderGroup](docs/Model/SalesOrderGroup.md)
- [SalesOrderGroupLIst](docs/Model/SalesOrderGroupLIst.md)
- [SalesOrderLine](docs/Model/SalesOrderLine.md)
- [SalesOrderLineProduct](docs/Model/SalesOrderLineProduct.md)
- [SalesPerson](docs/Model/SalesPerson.md)
- [SalesPersons](docs/Model/SalesPersons.md)
- [SalesShipment](docs/Model/SalesShipment.md)
- [SalesShipmentLine](docs/Model/SalesShipmentLine.md)
- [SellPriceTier](docs/Model/SellPriceTier.md)
- [SellPriceTierName](docs/Model/SellPriceTierName.md)
- [SellPriceTierNameList](docs/Model/SellPriceTierNameList.md)
- [Serial](docs/Model/Serial.md)
- [SerialNumber](docs/Model/SerialNumber.md)
- [ShippingCompany](docs/Model/ShippingCompany.md)
- [Stockonhand](docs/Model/Stockonhand.md)
- [Supplier](docs/Model/Supplier.md)
- [SupplierWithProductCode](docs/Model/SupplierWithProductCode.md)
- [Tax](docs/Model/Tax.md)
- [UnitOfMeasure](docs/Model/UnitOfMeasure.md)
- [Warehouse](docs/Model/Warehouse.md)

## Authorization
All endpoints do not require authorization.
## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

steven.brookes@talisman-innovations.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `1`
    - Package version: `1.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
