<?php
/**
 * SalesShipment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * SalesShipment Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesShipment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'salesShipment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_number' => 'string',
        'shipment_number' => 'string',
        'shipment_status' => 'string',
        'dispatch_date' => 'string',
        'tracking_number' => 'string',
        'shipping_company' => '\Unleashed\Model\ShippingCompany',
        'comments' => 'string',
        'created_on' => 'string',
        'created_by' => 'string',
        'last_modified_by' => 'string',
        'sales_shipment_lines' => '\Unleashed\Model\SalesShipmentLine[]',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_number' => null,
        'shipment_number' => null,
        'shipment_status' => null,
        'dispatch_date' => null,
        'tracking_number' => null,
        'shipping_company' => null,
        'comments' => null,
        'created_on' => null,
        'created_by' => null,
        'last_modified_by' => null,
        'sales_shipment_lines' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_number' => 'OrderNumber',
        'shipment_number' => 'ShipmentNumber',
        'shipment_status' => 'ShipmentStatus',
        'dispatch_date' => 'DispatchDate',
        'tracking_number' => 'TrackingNumber',
        'shipping_company' => 'ShippingCompany',
        'comments' => 'Comments',
        'created_on' => 'CreatedOn',
        'created_by' => 'CreatedBy',
        'last_modified_by' => 'LastModifiedBy',
        'sales_shipment_lines' => 'SalesShipmentLines',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_number' => 'setOrderNumber',
        'shipment_number' => 'setShipmentNumber',
        'shipment_status' => 'setShipmentStatus',
        'dispatch_date' => 'setDispatchDate',
        'tracking_number' => 'setTrackingNumber',
        'shipping_company' => 'setShippingCompany',
        'comments' => 'setComments',
        'created_on' => 'setCreatedOn',
        'created_by' => 'setCreatedBy',
        'last_modified_by' => 'setLastModifiedBy',
        'sales_shipment_lines' => 'setSalesShipmentLines',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_number' => 'getOrderNumber',
        'shipment_number' => 'getShipmentNumber',
        'shipment_status' => 'getShipmentStatus',
        'dispatch_date' => 'getDispatchDate',
        'tracking_number' => 'getTrackingNumber',
        'shipping_company' => 'getShippingCompany',
        'comments' => 'getComments',
        'created_on' => 'getCreatedOn',
        'created_by' => 'getCreatedBy',
        'last_modified_by' => 'getLastModifiedBy',
        'sales_shipment_lines' => 'getSalesShipmentLines',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['order_number'] = $data['order_number'] ?? null;
        $this->container['shipment_number'] = $data['shipment_number'] ?? null;
        $this->container['shipment_status'] = $data['shipment_status'] ?? null;
        $this->container['dispatch_date'] = $data['dispatch_date'] ?? null;
        $this->container['tracking_number'] = $data['tracking_number'] ?? null;
        $this->container['shipping_company'] = $data['shipping_company'] ?? null;
        $this->container['comments'] = $data['comments'] ?? null;
        $this->container['created_on'] = $data['created_on'] ?? null;
        $this->container['created_by'] = $data['created_by'] ?? null;
        $this->container['last_modified_by'] = $data['last_modified_by'] ?? null;
        $this->container['sales_shipment_lines'] = $data['sales_shipment_lines'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_number
     *
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string|null $order_number order_number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets shipment_number
     *
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->container['shipment_number'];
    }

    /**
     * Sets shipment_number
     *
     * @param string|null $shipment_number shipment_number
     *
     * @return self
     */
    public function setShipmentNumber($shipment_number)
    {
        $this->container['shipment_number'] = $shipment_number;

        return $this;
    }

    /**
     * Gets shipment_status
     *
     * @return string|null
     */
    public function getShipmentStatus()
    {
        return $this->container['shipment_status'];
    }

    /**
     * Sets shipment_status
     *
     * @param string|null $shipment_status shipment_status
     *
     * @return self
     */
    public function setShipmentStatus($shipment_status)
    {
        $this->container['shipment_status'] = $shipment_status;

        return $this;
    }

    /**
     * Gets dispatch_date
     *
     * @return string|null
     */
    public function getDispatchDate()
    {
        return $this->container['dispatch_date'];
    }

    /**
     * Sets dispatch_date
     *
     * @param string|null $dispatch_date dispatch_date
     *
     * @return self
     */
    public function setDispatchDate($dispatch_date)
    {
        $this->container['dispatch_date'] = $dispatch_date;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number tracking_number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets shipping_company
     *
     * @return \Unleashed\Model\ShippingCompany|null
     */
    public function getShippingCompany()
    {
        return $this->container['shipping_company'];
    }

    /**
     * Sets shipping_company
     *
     * @param \Unleashed\Model\ShippingCompany|null $shipping_company shipping_company
     *
     * @return self
     */
    public function setShippingCompany($shipping_company)
    {
        $this->container['shipping_company'] = $shipping_company;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets sales_shipment_lines
     *
     * @return \Unleashed\Model\SalesShipmentLine[]|null
     */
    public function getSalesShipmentLines()
    {
        return $this->container['sales_shipment_lines'];
    }

    /**
     * Sets sales_shipment_lines
     *
     * @param \Unleashed\Model\SalesShipmentLine[]|null $sales_shipment_lines sales_shipment_lines
     *
     * @return self
     */
    public function setSalesShipmentLines($sales_shipment_lines)
    {
        $this->container['sales_shipment_lines'] = $sales_shipment_lines;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


