<?php
/**
 * SalesOrder
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * SalesOrder Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'salesOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sales_order_lines' => '\Unleashed\Model\SalesOrderLine[]',
        'order_number' => 'string',
        'order_date' => 'string',
        'required_date' => 'string',
        'completed_date' => 'string',
        'order_status' => 'string',
        'customer' => '\Unleashed\Model\SalesOrderCustomer',
        'customer_ref' => 'string',
        'comments' => 'string',
        'warehouse' => '\Unleashed\Model\Warehouse',
        'received_date' => 'string',
        'delivery_name' => 'string',
        'delivery_street_address' => 'string',
        'delivery_street_address2' => 'string',
        'delivery_suburb' => 'string',
        'delivery_city' => 'string',
        'delivery_region' => 'string',
        'delivery_country' => 'string',
        'delivery_post_code' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'exchange_rate' => 'int',
        'discount_rate' => 'int',
        'tax' => '\Unleashed\Model\Tax',
        'tax_rate' => 'float',
        'xero_tax_code' => 'string',
        'sub_total' => 'float',
        'tax_total' => 'float',
        'total' => 'float',
        'total_volume' => 'int',
        'total_weight' => 'int',
        'bc_sub_total' => 'float',
        'bc_tax_total' => 'float',
        'bc_total' => 'float',
        'payment_due_date' => 'string',
        'allocate_product' => 'bool',
        'sales_order_group' => 'string',
        'delivery_method' => 'string',
        'sales_person' => '\Unleashed\Model\SalesPerson',
        'send_accounting_journal_only' => 'bool',
        'source_id' => 'string',
        'created_by' => 'string',
        'created_on' => 'string',
        'last_modified_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string',
        'delivery_instruction' => 'string',
        'delivery_contact' => '\Unleashed\Model\DeliveryContact'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sales_order_lines' => null,
        'order_number' => null,
        'order_date' => null,
        'required_date' => null,
        'completed_date' => null,
        'order_status' => null,
        'customer' => null,
        'customer_ref' => null,
        'comments' => null,
        'warehouse' => null,
        'received_date' => null,
        'delivery_name' => null,
        'delivery_street_address' => null,
        'delivery_street_address2' => null,
        'delivery_suburb' => null,
        'delivery_city' => null,
        'delivery_region' => null,
        'delivery_country' => null,
        'delivery_post_code' => null,
        'currency' => null,
        'exchange_rate' => null,
        'discount_rate' => null,
        'tax' => null,
        'tax_rate' => null,
        'xero_tax_code' => null,
        'sub_total' => null,
        'tax_total' => null,
        'total' => null,
        'total_volume' => null,
        'total_weight' => null,
        'bc_sub_total' => null,
        'bc_tax_total' => null,
        'bc_total' => null,
        'payment_due_date' => null,
        'allocate_product' => null,
        'sales_order_group' => null,
        'delivery_method' => null,
        'sales_person' => null,
        'send_accounting_journal_only' => null,
        'source_id' => null,
        'created_by' => null,
        'created_on' => null,
        'last_modified_by' => null,
        'guid' => null,
        'last_modified_on' => null,
        'delivery_instruction' => null,
        'delivery_contact' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sales_order_lines' => 'SalesOrderLines',
        'order_number' => 'OrderNumber',
        'order_date' => 'OrderDate',
        'required_date' => 'RequiredDate',
        'completed_date' => 'CompletedDate',
        'order_status' => 'OrderStatus',
        'customer' => 'Customer',
        'customer_ref' => 'CustomerRef',
        'comments' => 'Comments',
        'warehouse' => 'Warehouse',
        'received_date' => 'ReceivedDate',
        'delivery_name' => 'DeliveryName',
        'delivery_street_address' => 'DeliveryStreetAddress',
        'delivery_street_address2' => 'DeliveryStreetAddress2',
        'delivery_suburb' => 'DeliverySuburb',
        'delivery_city' => 'DeliveryCity',
        'delivery_region' => 'DeliveryRegion',
        'delivery_country' => 'DeliveryCountry',
        'delivery_post_code' => 'DeliveryPostCode',
        'currency' => 'Currency',
        'exchange_rate' => 'ExchangeRate',
        'discount_rate' => 'DiscountRate',
        'tax' => 'Tax',
        'tax_rate' => 'TaxRate',
        'xero_tax_code' => 'XeroTaxCode',
        'sub_total' => 'SubTotal',
        'tax_total' => 'TaxTotal',
        'total' => 'Total',
        'total_volume' => 'TotalVolume',
        'total_weight' => 'TotalWeight',
        'bc_sub_total' => 'BCSubTotal',
        'bc_tax_total' => 'BCTaxTotal',
        'bc_total' => 'BCTotal',
        'payment_due_date' => 'PaymentDueDate',
        'allocate_product' => 'AllocateProduct',
        'sales_order_group' => 'SalesOrderGroup',
        'delivery_method' => 'DeliveryMethod',
        'sales_person' => 'SalesPerson',
        'send_accounting_journal_only' => 'SendAccountingJournalOnly',
        'source_id' => 'SourceId',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'last_modified_by' => 'LastModifiedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn',
        'delivery_instruction' => 'DeliveryInstruction',
        'delivery_contact' => 'DeliveryContact'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sales_order_lines' => 'setSalesOrderLines',
        'order_number' => 'setOrderNumber',
        'order_date' => 'setOrderDate',
        'required_date' => 'setRequiredDate',
        'completed_date' => 'setCompletedDate',
        'order_status' => 'setOrderStatus',
        'customer' => 'setCustomer',
        'customer_ref' => 'setCustomerRef',
        'comments' => 'setComments',
        'warehouse' => 'setWarehouse',
        'received_date' => 'setReceivedDate',
        'delivery_name' => 'setDeliveryName',
        'delivery_street_address' => 'setDeliveryStreetAddress',
        'delivery_street_address2' => 'setDeliveryStreetAddress2',
        'delivery_suburb' => 'setDeliverySuburb',
        'delivery_city' => 'setDeliveryCity',
        'delivery_region' => 'setDeliveryRegion',
        'delivery_country' => 'setDeliveryCountry',
        'delivery_post_code' => 'setDeliveryPostCode',
        'currency' => 'setCurrency',
        'exchange_rate' => 'setExchangeRate',
        'discount_rate' => 'setDiscountRate',
        'tax' => 'setTax',
        'tax_rate' => 'setTaxRate',
        'xero_tax_code' => 'setXeroTaxCode',
        'sub_total' => 'setSubTotal',
        'tax_total' => 'setTaxTotal',
        'total' => 'setTotal',
        'total_volume' => 'setTotalVolume',
        'total_weight' => 'setTotalWeight',
        'bc_sub_total' => 'setBcSubTotal',
        'bc_tax_total' => 'setBcTaxTotal',
        'bc_total' => 'setBcTotal',
        'payment_due_date' => 'setPaymentDueDate',
        'allocate_product' => 'setAllocateProduct',
        'sales_order_group' => 'setSalesOrderGroup',
        'delivery_method' => 'setDeliveryMethod',
        'sales_person' => 'setSalesPerson',
        'send_accounting_journal_only' => 'setSendAccountingJournalOnly',
        'source_id' => 'setSourceId',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'last_modified_by' => 'setLastModifiedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn',
        'delivery_instruction' => 'setDeliveryInstruction',
        'delivery_contact' => 'setDeliveryContact'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sales_order_lines' => 'getSalesOrderLines',
        'order_number' => 'getOrderNumber',
        'order_date' => 'getOrderDate',
        'required_date' => 'getRequiredDate',
        'completed_date' => 'getCompletedDate',
        'order_status' => 'getOrderStatus',
        'customer' => 'getCustomer',
        'customer_ref' => 'getCustomerRef',
        'comments' => 'getComments',
        'warehouse' => 'getWarehouse',
        'received_date' => 'getReceivedDate',
        'delivery_name' => 'getDeliveryName',
        'delivery_street_address' => 'getDeliveryStreetAddress',
        'delivery_street_address2' => 'getDeliveryStreetAddress2',
        'delivery_suburb' => 'getDeliverySuburb',
        'delivery_city' => 'getDeliveryCity',
        'delivery_region' => 'getDeliveryRegion',
        'delivery_country' => 'getDeliveryCountry',
        'delivery_post_code' => 'getDeliveryPostCode',
        'currency' => 'getCurrency',
        'exchange_rate' => 'getExchangeRate',
        'discount_rate' => 'getDiscountRate',
        'tax' => 'getTax',
        'tax_rate' => 'getTaxRate',
        'xero_tax_code' => 'getXeroTaxCode',
        'sub_total' => 'getSubTotal',
        'tax_total' => 'getTaxTotal',
        'total' => 'getTotal',
        'total_volume' => 'getTotalVolume',
        'total_weight' => 'getTotalWeight',
        'bc_sub_total' => 'getBcSubTotal',
        'bc_tax_total' => 'getBcTaxTotal',
        'bc_total' => 'getBcTotal',
        'payment_due_date' => 'getPaymentDueDate',
        'allocate_product' => 'getAllocateProduct',
        'sales_order_group' => 'getSalesOrderGroup',
        'delivery_method' => 'getDeliveryMethod',
        'sales_person' => 'getSalesPerson',
        'send_accounting_journal_only' => 'getSendAccountingJournalOnly',
        'source_id' => 'getSourceId',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'last_modified_by' => 'getLastModifiedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn',
        'delivery_instruction' => 'getDeliveryInstruction',
        'delivery_contact' => 'getDeliveryContact'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['sales_order_lines'] = $data['sales_order_lines'] ?? null;
        $this->container['order_number'] = $data['order_number'] ?? null;
        $this->container['order_date'] = $data['order_date'] ?? null;
        $this->container['required_date'] = $data['required_date'] ?? null;
        $this->container['completed_date'] = $data['completed_date'] ?? null;
        $this->container['order_status'] = $data['order_status'] ?? null;
        $this->container['customer'] = $data['customer'] ?? null;
        $this->container['customer_ref'] = $data['customer_ref'] ?? null;
        $this->container['comments'] = $data['comments'] ?? null;
        $this->container['warehouse'] = $data['warehouse'] ?? null;
        $this->container['received_date'] = $data['received_date'] ?? null;
        $this->container['delivery_name'] = $data['delivery_name'] ?? null;
        $this->container['delivery_street_address'] = $data['delivery_street_address'] ?? null;
        $this->container['delivery_street_address2'] = $data['delivery_street_address2'] ?? null;
        $this->container['delivery_suburb'] = $data['delivery_suburb'] ?? null;
        $this->container['delivery_city'] = $data['delivery_city'] ?? null;
        $this->container['delivery_region'] = $data['delivery_region'] ?? null;
        $this->container['delivery_country'] = $data['delivery_country'] ?? null;
        $this->container['delivery_post_code'] = $data['delivery_post_code'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['exchange_rate'] = $data['exchange_rate'] ?? null;
        $this->container['discount_rate'] = $data['discount_rate'] ?? null;
        $this->container['tax'] = $data['tax'] ?? null;
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['xero_tax_code'] = $data['xero_tax_code'] ?? null;
        $this->container['sub_total'] = $data['sub_total'] ?? null;
        $this->container['tax_total'] = $data['tax_total'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['total_volume'] = $data['total_volume'] ?? null;
        $this->container['total_weight'] = $data['total_weight'] ?? null;
        $this->container['bc_sub_total'] = $data['bc_sub_total'] ?? null;
        $this->container['bc_tax_total'] = $data['bc_tax_total'] ?? null;
        $this->container['bc_total'] = $data['bc_total'] ?? null;
        $this->container['payment_due_date'] = $data['payment_due_date'] ?? null;
        $this->container['allocate_product'] = $data['allocate_product'] ?? null;
        $this->container['sales_order_group'] = $data['sales_order_group'] ?? null;
        $this->container['delivery_method'] = $data['delivery_method'] ?? null;
        $this->container['sales_person'] = $data['sales_person'] ?? null;
        $this->container['send_accounting_journal_only'] = $data['send_accounting_journal_only'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['created_by'] = $data['created_by'] ?? null;
        $this->container['created_on'] = $data['created_on'] ?? null;
        $this->container['last_modified_by'] = $data['last_modified_by'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
        $this->container['delivery_instruction'] = $data['delivery_instruction'] ?? null;
        $this->container['delivery_contact'] = $data['delivery_contact'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sales_order_lines
     *
     * @return \Unleashed\Model\SalesOrderLine[]|null
     */
    public function getSalesOrderLines()
    {
        return $this->container['sales_order_lines'];
    }

    /**
     * Sets sales_order_lines
     *
     * @param \Unleashed\Model\SalesOrderLine[]|null $sales_order_lines sales_order_lines
     *
     * @return self
     */
    public function setSalesOrderLines($sales_order_lines)
    {
        $this->container['sales_order_lines'] = $sales_order_lines;

        return $this;
    }

    /**
     * Gets order_number
     *
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string|null $order_number order_number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets order_date
     *
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->container['order_date'];
    }

    /**
     * Sets order_date
     *
     * @param string|null $order_date order_date
     *
     * @return self
     */
    public function setOrderDate($order_date)
    {
        $this->container['order_date'] = $order_date;

        return $this;
    }

    /**
     * Gets required_date
     *
     * @return string|null
     */
    public function getRequiredDate()
    {
        return $this->container['required_date'];
    }

    /**
     * Sets required_date
     *
     * @param string|null $required_date required_date
     *
     * @return self
     */
    public function setRequiredDate($required_date)
    {
        $this->container['required_date'] = $required_date;

        return $this;
    }

    /**
     * Gets completed_date
     *
     * @return string|null
     */
    public function getCompletedDate()
    {
        return $this->container['completed_date'];
    }

    /**
     * Sets completed_date
     *
     * @param string|null $completed_date completed_date
     *
     * @return self
     */
    public function setCompletedDate($completed_date)
    {
        $this->container['completed_date'] = $completed_date;

        return $this;
    }

    /**
     * Gets order_status
     *
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->container['order_status'];
    }

    /**
     * Sets order_status
     *
     * @param string|null $order_status order_status
     *
     * @return self
     */
    public function setOrderStatus($order_status)
    {
        $this->container['order_status'] = $order_status;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \Unleashed\Model\SalesOrderCustomer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \Unleashed\Model\SalesOrderCustomer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets customer_ref
     *
     * @return string|null
     */
    public function getCustomerRef()
    {
        return $this->container['customer_ref'];
    }

    /**
     * Sets customer_ref
     *
     * @param string|null $customer_ref customer_ref
     *
     * @return self
     */
    public function setCustomerRef($customer_ref)
    {
        $this->container['customer_ref'] = $customer_ref;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getWarehouse()
    {
        return $this->container['warehouse'];
    }

    /**
     * Sets warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $warehouse warehouse
     *
     * @return self
     */
    public function setWarehouse($warehouse)
    {
        $this->container['warehouse'] = $warehouse;

        return $this;
    }

    /**
     * Gets received_date
     *
     * @return string|null
     */
    public function getReceivedDate()
    {
        return $this->container['received_date'];
    }

    /**
     * Sets received_date
     *
     * @param string|null $received_date received_date
     *
     * @return self
     */
    public function setReceivedDate($received_date)
    {
        $this->container['received_date'] = $received_date;

        return $this;
    }

    /**
     * Gets delivery_name
     *
     * @return string|null
     */
    public function getDeliveryName()
    {
        return $this->container['delivery_name'];
    }

    /**
     * Sets delivery_name
     *
     * @param string|null $delivery_name delivery_name
     *
     * @return self
     */
    public function setDeliveryName($delivery_name)
    {
        $this->container['delivery_name'] = $delivery_name;

        return $this;
    }

    /**
     * Gets delivery_street_address
     *
     * @return string|null
     */
    public function getDeliveryStreetAddress()
    {
        return $this->container['delivery_street_address'];
    }

    /**
     * Sets delivery_street_address
     *
     * @param string|null $delivery_street_address delivery_street_address
     *
     * @return self
     */
    public function setDeliveryStreetAddress($delivery_street_address)
    {
        $this->container['delivery_street_address'] = $delivery_street_address;

        return $this;
    }

    /**
     * Gets delivery_street_address2
     *
     * @return string|null
     */
    public function getDeliveryStreetAddress2()
    {
        return $this->container['delivery_street_address2'];
    }

    /**
     * Sets delivery_street_address2
     *
     * @param string|null $delivery_street_address2 delivery_street_address2
     *
     * @return self
     */
    public function setDeliveryStreetAddress2($delivery_street_address2)
    {
        $this->container['delivery_street_address2'] = $delivery_street_address2;

        return $this;
    }

    /**
     * Gets delivery_suburb
     *
     * @return string|null
     */
    public function getDeliverySuburb()
    {
        return $this->container['delivery_suburb'];
    }

    /**
     * Sets delivery_suburb
     *
     * @param string|null $delivery_suburb delivery_suburb
     *
     * @return self
     */
    public function setDeliverySuburb($delivery_suburb)
    {
        $this->container['delivery_suburb'] = $delivery_suburb;

        return $this;
    }

    /**
     * Gets delivery_city
     *
     * @return string|null
     */
    public function getDeliveryCity()
    {
        return $this->container['delivery_city'];
    }

    /**
     * Sets delivery_city
     *
     * @param string|null $delivery_city delivery_city
     *
     * @return self
     */
    public function setDeliveryCity($delivery_city)
    {
        $this->container['delivery_city'] = $delivery_city;

        return $this;
    }

    /**
     * Gets delivery_region
     *
     * @return string|null
     */
    public function getDeliveryRegion()
    {
        return $this->container['delivery_region'];
    }

    /**
     * Sets delivery_region
     *
     * @param string|null $delivery_region delivery_region
     *
     * @return self
     */
    public function setDeliveryRegion($delivery_region)
    {
        $this->container['delivery_region'] = $delivery_region;

        return $this;
    }

    /**
     * Gets delivery_country
     *
     * @return string|null
     */
    public function getDeliveryCountry()
    {
        return $this->container['delivery_country'];
    }

    /**
     * Sets delivery_country
     *
     * @param string|null $delivery_country delivery_country
     *
     * @return self
     */
    public function setDeliveryCountry($delivery_country)
    {
        $this->container['delivery_country'] = $delivery_country;

        return $this;
    }

    /**
     * Gets delivery_post_code
     *
     * @return string|null
     */
    public function getDeliveryPostCode()
    {
        return $this->container['delivery_post_code'];
    }

    /**
     * Sets delivery_post_code
     *
     * @param string|null $delivery_post_code delivery_post_code
     *
     * @return self
     */
    public function setDeliveryPostCode($delivery_post_code)
    {
        $this->container['delivery_post_code'] = $delivery_post_code;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets exchange_rate
     *
     * @return int|null
     */
    public function getExchangeRate()
    {
        return $this->container['exchange_rate'];
    }

    /**
     * Sets exchange_rate
     *
     * @param int|null $exchange_rate exchange_rate
     *
     * @return self
     */
    public function setExchangeRate($exchange_rate)
    {
        $this->container['exchange_rate'] = $exchange_rate;

        return $this;
    }

    /**
     * Gets discount_rate
     *
     * @return int|null
     */
    public function getDiscountRate()
    {
        return $this->container['discount_rate'];
    }

    /**
     * Sets discount_rate
     *
     * @param int|null $discount_rate discount_rate
     *
     * @return self
     */
    public function setDiscountRate($discount_rate)
    {
        $this->container['discount_rate'] = $discount_rate;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return \Unleashed\Model\Tax|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param \Unleashed\Model\Tax|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param float|null $sub_total sub_total
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total tax_total
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets total_volume
     *
     * @return int|null
     */
    public function getTotalVolume()
    {
        return $this->container['total_volume'];
    }

    /**
     * Sets total_volume
     *
     * @param int|null $total_volume total_volume
     *
     * @return self
     */
    public function setTotalVolume($total_volume)
    {
        $this->container['total_volume'] = $total_volume;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return int|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param int|null $total_weight total_weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets bc_sub_total
     *
     * @return float|null
     */
    public function getBcSubTotal()
    {
        return $this->container['bc_sub_total'];
    }

    /**
     * Sets bc_sub_total
     *
     * @param float|null $bc_sub_total bc_sub_total
     *
     * @return self
     */
    public function setBcSubTotal($bc_sub_total)
    {
        $this->container['bc_sub_total'] = $bc_sub_total;

        return $this;
    }

    /**
     * Gets bc_tax_total
     *
     * @return float|null
     */
    public function getBcTaxTotal()
    {
        return $this->container['bc_tax_total'];
    }

    /**
     * Sets bc_tax_total
     *
     * @param float|null $bc_tax_total bc_tax_total
     *
     * @return self
     */
    public function setBcTaxTotal($bc_tax_total)
    {
        $this->container['bc_tax_total'] = $bc_tax_total;

        return $this;
    }

    /**
     * Gets bc_total
     *
     * @return float|null
     */
    public function getBcTotal()
    {
        return $this->container['bc_total'];
    }

    /**
     * Sets bc_total
     *
     * @param float|null $bc_total bc_total
     *
     * @return self
     */
    public function setBcTotal($bc_total)
    {
        $this->container['bc_total'] = $bc_total;

        return $this;
    }

    /**
     * Gets payment_due_date
     *
     * @return string|null
     */
    public function getPaymentDueDate()
    {
        return $this->container['payment_due_date'];
    }

    /**
     * Sets payment_due_date
     *
     * @param string|null $payment_due_date payment_due_date
     *
     * @return self
     */
    public function setPaymentDueDate($payment_due_date)
    {
        $this->container['payment_due_date'] = $payment_due_date;

        return $this;
    }

    /**
     * Gets allocate_product
     *
     * @return bool|null
     */
    public function getAllocateProduct()
    {
        return $this->container['allocate_product'];
    }

    /**
     * Sets allocate_product
     *
     * @param bool|null $allocate_product allocate_product
     *
     * @return self
     */
    public function setAllocateProduct($allocate_product)
    {
        $this->container['allocate_product'] = $allocate_product;

        return $this;
    }

    /**
     * Gets sales_order_group
     *
     * @return string|null
     */
    public function getSalesOrderGroup()
    {
        return $this->container['sales_order_group'];
    }

    /**
     * Sets sales_order_group
     *
     * @param string|null $sales_order_group sales_order_group
     *
     * @return self
     */
    public function setSalesOrderGroup($sales_order_group)
    {
        $this->container['sales_order_group'] = $sales_order_group;

        return $this;
    }

    /**
     * Gets delivery_method
     *
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->container['delivery_method'];
    }

    /**
     * Sets delivery_method
     *
     * @param string|null $delivery_method delivery_method
     *
     * @return self
     */
    public function setDeliveryMethod($delivery_method)
    {
        $this->container['delivery_method'] = $delivery_method;

        return $this;
    }

    /**
     * Gets sales_person
     *
     * @return \Unleashed\Model\SalesPerson|null
     */
    public function getSalesPerson()
    {
        return $this->container['sales_person'];
    }

    /**
     * Sets sales_person
     *
     * @param \Unleashed\Model\SalesPerson|null $sales_person sales_person
     *
     * @return self
     */
    public function setSalesPerson($sales_person)
    {
        $this->container['sales_person'] = $sales_person;

        return $this;
    }

    /**
     * Gets send_accounting_journal_only
     *
     * @return bool|null
     */
    public function getSendAccountingJournalOnly()
    {
        return $this->container['send_accounting_journal_only'];
    }

    /**
     * Sets send_accounting_journal_only
     *
     * @param bool|null $send_accounting_journal_only send_accounting_journal_only
     *
     * @return self
     */
    public function setSendAccountingJournalOnly($send_accounting_journal_only)
    {
        $this->container['send_accounting_journal_only'] = $send_accounting_journal_only;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id source_id
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets delivery_instruction
     *
     * @return string|null
     */
    public function getDeliveryInstruction()
    {
        return $this->container['delivery_instruction'];
    }

    /**
     * Sets delivery_instruction
     *
     * @param string|null $delivery_instruction delivery_instruction
     *
     * @return self
     */
    public function setDeliveryInstruction($delivery_instruction)
    {
        $this->container['delivery_instruction'] = $delivery_instruction;

        return $this;
    }

    /**
     * Gets delivery_contact
     *
     * @return \Unleashed\Model\DeliveryContact|null
     */
    public function getDeliveryContact()
    {
        return $this->container['delivery_contact'];
    }

    /**
     * Sets delivery_contact
     *
     * @param \Unleashed\Model\DeliveryContact|null $delivery_contact delivery_contact
     *
     * @return self
     */
    public function setDeliveryContact($delivery_contact)
    {
        $this->container['delivery_contact'] = $delivery_contact;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


