<?php
/**
 * SupplierWithProductCode
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * SupplierWithProductCode Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SupplierWithProductCode implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'supplierWithProductCode';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'supplier_product_code' => 'string',
        'supplier_product_description' => 'string',
        'supplier_product_price' => 'float',
        'guid' => 'string',
        'supplier_code' => 'string',
        'supplier_name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'supplier_product_code' => null,
        'supplier_product_description' => null,
        'supplier_product_price' => null,
        'guid' => null,
        'supplier_code' => null,
        'supplier_name' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'supplier_product_code' => 'SupplierProductCode',
        'supplier_product_description' => 'SupplierProductDescription',
        'supplier_product_price' => 'SupplierProductPrice',
        'guid' => 'Guid',
        'supplier_code' => 'SupplierCode',
        'supplier_name' => 'SupplierName'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'supplier_product_code' => 'setSupplierProductCode',
        'supplier_product_description' => 'setSupplierProductDescription',
        'supplier_product_price' => 'setSupplierProductPrice',
        'guid' => 'setGuid',
        'supplier_code' => 'setSupplierCode',
        'supplier_name' => 'setSupplierName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'supplier_product_code' => 'getSupplierProductCode',
        'supplier_product_description' => 'getSupplierProductDescription',
        'supplier_product_price' => 'getSupplierProductPrice',
        'guid' => 'getGuid',
        'supplier_code' => 'getSupplierCode',
        'supplier_name' => 'getSupplierName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['supplier_product_code'] = $data['supplier_product_code'] ?? null;
        $this->container['supplier_product_description'] = $data['supplier_product_description'] ?? null;
        $this->container['supplier_product_price'] = $data['supplier_product_price'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['supplier_code'] = $data['supplier_code'] ?? null;
        $this->container['supplier_name'] = $data['supplier_name'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets supplier_product_code
     *
     * @return string|null
     */
    public function getSupplierProductCode()
    {
        return $this->container['supplier_product_code'];
    }

    /**
     * Sets supplier_product_code
     *
     * @param string|null $supplier_product_code supplier_product_code
     *
     * @return self
     */
    public function setSupplierProductCode($supplier_product_code)
    {
        $this->container['supplier_product_code'] = $supplier_product_code;

        return $this;
    }

    /**
     * Gets supplier_product_description
     *
     * @return string|null
     */
    public function getSupplierProductDescription()
    {
        return $this->container['supplier_product_description'];
    }

    /**
     * Sets supplier_product_description
     *
     * @param string|null $supplier_product_description supplier_product_description
     *
     * @return self
     */
    public function setSupplierProductDescription($supplier_product_description)
    {
        $this->container['supplier_product_description'] = $supplier_product_description;

        return $this;
    }

    /**
     * Gets supplier_product_price
     *
     * @return float|null
     */
    public function getSupplierProductPrice()
    {
        return $this->container['supplier_product_price'];
    }

    /**
     * Sets supplier_product_price
     *
     * @param float|null $supplier_product_price supplier_product_price
     *
     * @return self
     */
    public function setSupplierProductPrice($supplier_product_price)
    {
        $this->container['supplier_product_price'] = $supplier_product_price;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code supplier_code
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name supplier_name
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


