<?php
/**
 * Product
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'product_code' => 'string',
        'product_description' => 'string',
        'barcode' => 'string',
        'pack_size' => 'float',
        'width' => 'float',
        'height' => 'float',
        'depth' => 'float',
        'weight' => 'float',
        'min_stock_alert_level' => 'float',
        'max_stock_alert_level' => 'float',
        're_order_point' => 'float',
        'unit_of_measure' => '\Unleashed\Model\UnitOfMeasure',
        'never_diminishing' => 'bool',
        'last_cost' => 'float',
        'default_purchase_price' => 'float',
        'default_sell_price' => 'float',
        'customer_sell_price' => 'float',
        'average_land_price' => 'float',
        'obsolete' => 'bool',
        'notes' => 'string',
        'image_url' => 'string',
        'sell_price_tier1' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier2' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier3' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier4' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier5' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier6' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier7' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier8' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier9' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier10' => '\Unleashed\Model\SellPriceTier',
        'xero_tax_code' => 'string',
        'xero_tax_rate' => 'float',
        'taxable_purchase' => 'bool',
        'taxable_sales' => 'bool',
        'xero_sales_tax_code' => 'string',
        'xero_sales_tax_rate' => 'float',
        'is_component' => 'bool',
        'is_assembled_product' => 'bool',
        'product_group' => '\Unleashed\Model\ProductGroup',
        'xero_sales_account' => 'string',
        'xero_cost_of_goods_account' => 'string',
        'purchase_account' => 'string',
        'bin_location' => 'string',
        'supplier' => '\Unleashed\Model\SupplierWithProductCode',
        'attribute_set' => '\Unleashed\Model\AttributeSet',
        'source_id' => 'string',
        'source_variant_parent_id' => 'string',
        'is_serialized' => 'bool',
        'is_batch_tracked' => 'bool',
        'is_sellable' => 'bool',
        'minimum_sell_price' => 'float',
        'minimum_sale_quantity' => 'float',
        'minimum_order_quantity' => 'float',
        'created_by' => 'string',
        'created_on' => 'string',
        'last_modified_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'product_code' => null,
        'product_description' => null,
        'barcode' => null,
        'pack_size' => null,
        'width' => null,
        'height' => null,
        'depth' => null,
        'weight' => null,
        'min_stock_alert_level' => null,
        'max_stock_alert_level' => null,
        're_order_point' => null,
        'unit_of_measure' => null,
        'never_diminishing' => null,
        'last_cost' => null,
        'default_purchase_price' => null,
        'default_sell_price' => null,
        'customer_sell_price' => null,
        'average_land_price' => null,
        'obsolete' => null,
        'notes' => null,
        'image_url' => null,
        'sell_price_tier1' => null,
        'sell_price_tier2' => null,
        'sell_price_tier3' => null,
        'sell_price_tier4' => null,
        'sell_price_tier5' => null,
        'sell_price_tier6' => null,
        'sell_price_tier7' => null,
        'sell_price_tier8' => null,
        'sell_price_tier9' => null,
        'sell_price_tier10' => null,
        'xero_tax_code' => null,
        'xero_tax_rate' => null,
        'taxable_purchase' => null,
        'taxable_sales' => null,
        'xero_sales_tax_code' => null,
        'xero_sales_tax_rate' => null,
        'is_component' => null,
        'is_assembled_product' => null,
        'product_group' => null,
        'xero_sales_account' => null,
        'xero_cost_of_goods_account' => null,
        'purchase_account' => null,
        'bin_location' => null,
        'supplier' => null,
        'attribute_set' => null,
        'source_id' => null,
        'source_variant_parent_id' => null,
        'is_serialized' => null,
        'is_batch_tracked' => null,
        'is_sellable' => null,
        'minimum_sell_price' => null,
        'minimum_sale_quantity' => null,
        'minimum_order_quantity' => null,
        'created_by' => null,
        'created_on' => null,
        'last_modified_by' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'product_code' => 'ProductCode',
        'product_description' => 'ProductDescription',
        'barcode' => 'Barcode',
        'pack_size' => 'PackSize',
        'width' => 'Width',
        'height' => 'Height',
        'depth' => 'Depth',
        'weight' => 'Weight',
        'min_stock_alert_level' => 'MinStockAlertLevel',
        'max_stock_alert_level' => 'MaxStockAlertLevel',
        're_order_point' => 'ReOrderPoint',
        'unit_of_measure' => 'UnitOfMeasure',
        'never_diminishing' => 'NeverDiminishing',
        'last_cost' => 'LastCost',
        'default_purchase_price' => 'DefaultPurchasePrice',
        'default_sell_price' => 'DefaultSellPrice',
        'customer_sell_price' => 'CustomerSellPrice',
        'average_land_price' => 'AverageLandPrice',
        'obsolete' => 'Obsolete',
        'notes' => 'Notes',
        'image_url' => 'ImageUrl',
        'sell_price_tier1' => 'SellPriceTier1',
        'sell_price_tier2' => 'SellPriceTier2',
        'sell_price_tier3' => 'SellPriceTier3',
        'sell_price_tier4' => 'SellPriceTier4',
        'sell_price_tier5' => 'SellPriceTier5',
        'sell_price_tier6' => 'SellPriceTier6',
        'sell_price_tier7' => 'SellPriceTier7',
        'sell_price_tier8' => 'SellPriceTier8',
        'sell_price_tier9' => 'SellPriceTier9',
        'sell_price_tier10' => 'SellPriceTier10',
        'xero_tax_code' => 'XeroTaxCode',
        'xero_tax_rate' => 'XeroTaxRate',
        'taxable_purchase' => 'TaxablePurchase',
        'taxable_sales' => 'TaxableSales',
        'xero_sales_tax_code' => 'XeroSalesTaxCode',
        'xero_sales_tax_rate' => 'XeroSalesTaxRate',
        'is_component' => 'IsComponent',
        'is_assembled_product' => 'IsAssembledProduct',
        'product_group' => 'ProductGroup',
        'xero_sales_account' => 'XeroSalesAccount',
        'xero_cost_of_goods_account' => 'XeroCostOfGoodsAccount',
        'purchase_account' => 'PurchaseAccount',
        'bin_location' => 'BinLocation',
        'supplier' => 'Supplier',
        'attribute_set' => 'AttributeSet',
        'source_id' => 'SourceId',
        'source_variant_parent_id' => 'SourceVariantParentId',
        'is_serialized' => 'IsSerialized',
        'is_batch_tracked' => 'IsBatchTracked',
        'is_sellable' => 'IsSellable',
        'minimum_sell_price' => 'MinimumSellPrice',
        'minimum_sale_quantity' => 'MinimumSaleQuantity',
        'minimum_order_quantity' => 'MinimumOrderQuantity',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'last_modified_by' => 'LastModifiedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'product_code' => 'setProductCode',
        'product_description' => 'setProductDescription',
        'barcode' => 'setBarcode',
        'pack_size' => 'setPackSize',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'depth' => 'setDepth',
        'weight' => 'setWeight',
        'min_stock_alert_level' => 'setMinStockAlertLevel',
        'max_stock_alert_level' => 'setMaxStockAlertLevel',
        're_order_point' => 'setReOrderPoint',
        'unit_of_measure' => 'setUnitOfMeasure',
        'never_diminishing' => 'setNeverDiminishing',
        'last_cost' => 'setLastCost',
        'default_purchase_price' => 'setDefaultPurchasePrice',
        'default_sell_price' => 'setDefaultSellPrice',
        'customer_sell_price' => 'setCustomerSellPrice',
        'average_land_price' => 'setAverageLandPrice',
        'obsolete' => 'setObsolete',
        'notes' => 'setNotes',
        'image_url' => 'setImageUrl',
        'sell_price_tier1' => 'setSellPriceTier1',
        'sell_price_tier2' => 'setSellPriceTier2',
        'sell_price_tier3' => 'setSellPriceTier3',
        'sell_price_tier4' => 'setSellPriceTier4',
        'sell_price_tier5' => 'setSellPriceTier5',
        'sell_price_tier6' => 'setSellPriceTier6',
        'sell_price_tier7' => 'setSellPriceTier7',
        'sell_price_tier8' => 'setSellPriceTier8',
        'sell_price_tier9' => 'setSellPriceTier9',
        'sell_price_tier10' => 'setSellPriceTier10',
        'xero_tax_code' => 'setXeroTaxCode',
        'xero_tax_rate' => 'setXeroTaxRate',
        'taxable_purchase' => 'setTaxablePurchase',
        'taxable_sales' => 'setTaxableSales',
        'xero_sales_tax_code' => 'setXeroSalesTaxCode',
        'xero_sales_tax_rate' => 'setXeroSalesTaxRate',
        'is_component' => 'setIsComponent',
        'is_assembled_product' => 'setIsAssembledProduct',
        'product_group' => 'setProductGroup',
        'xero_sales_account' => 'setXeroSalesAccount',
        'xero_cost_of_goods_account' => 'setXeroCostOfGoodsAccount',
        'purchase_account' => 'setPurchaseAccount',
        'bin_location' => 'setBinLocation',
        'supplier' => 'setSupplier',
        'attribute_set' => 'setAttributeSet',
        'source_id' => 'setSourceId',
        'source_variant_parent_id' => 'setSourceVariantParentId',
        'is_serialized' => 'setIsSerialized',
        'is_batch_tracked' => 'setIsBatchTracked',
        'is_sellable' => 'setIsSellable',
        'minimum_sell_price' => 'setMinimumSellPrice',
        'minimum_sale_quantity' => 'setMinimumSaleQuantity',
        'minimum_order_quantity' => 'setMinimumOrderQuantity',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'last_modified_by' => 'setLastModifiedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'product_code' => 'getProductCode',
        'product_description' => 'getProductDescription',
        'barcode' => 'getBarcode',
        'pack_size' => 'getPackSize',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'depth' => 'getDepth',
        'weight' => 'getWeight',
        'min_stock_alert_level' => 'getMinStockAlertLevel',
        'max_stock_alert_level' => 'getMaxStockAlertLevel',
        're_order_point' => 'getReOrderPoint',
        'unit_of_measure' => 'getUnitOfMeasure',
        'never_diminishing' => 'getNeverDiminishing',
        'last_cost' => 'getLastCost',
        'default_purchase_price' => 'getDefaultPurchasePrice',
        'default_sell_price' => 'getDefaultSellPrice',
        'customer_sell_price' => 'getCustomerSellPrice',
        'average_land_price' => 'getAverageLandPrice',
        'obsolete' => 'getObsolete',
        'notes' => 'getNotes',
        'image_url' => 'getImageUrl',
        'sell_price_tier1' => 'getSellPriceTier1',
        'sell_price_tier2' => 'getSellPriceTier2',
        'sell_price_tier3' => 'getSellPriceTier3',
        'sell_price_tier4' => 'getSellPriceTier4',
        'sell_price_tier5' => 'getSellPriceTier5',
        'sell_price_tier6' => 'getSellPriceTier6',
        'sell_price_tier7' => 'getSellPriceTier7',
        'sell_price_tier8' => 'getSellPriceTier8',
        'sell_price_tier9' => 'getSellPriceTier9',
        'sell_price_tier10' => 'getSellPriceTier10',
        'xero_tax_code' => 'getXeroTaxCode',
        'xero_tax_rate' => 'getXeroTaxRate',
        'taxable_purchase' => 'getTaxablePurchase',
        'taxable_sales' => 'getTaxableSales',
        'xero_sales_tax_code' => 'getXeroSalesTaxCode',
        'xero_sales_tax_rate' => 'getXeroSalesTaxRate',
        'is_component' => 'getIsComponent',
        'is_assembled_product' => 'getIsAssembledProduct',
        'product_group' => 'getProductGroup',
        'xero_sales_account' => 'getXeroSalesAccount',
        'xero_cost_of_goods_account' => 'getXeroCostOfGoodsAccount',
        'purchase_account' => 'getPurchaseAccount',
        'bin_location' => 'getBinLocation',
        'supplier' => 'getSupplier',
        'attribute_set' => 'getAttributeSet',
        'source_id' => 'getSourceId',
        'source_variant_parent_id' => 'getSourceVariantParentId',
        'is_serialized' => 'getIsSerialized',
        'is_batch_tracked' => 'getIsBatchTracked',
        'is_sellable' => 'getIsSellable',
        'minimum_sell_price' => 'getMinimumSellPrice',
        'minimum_sale_quantity' => 'getMinimumSaleQuantity',
        'minimum_order_quantity' => 'getMinimumOrderQuantity',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'last_modified_by' => 'getLastModifiedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['product_code'] = $data['product_code'] ?? null;
        $this->container['product_description'] = $data['product_description'] ?? null;
        $this->container['barcode'] = $data['barcode'] ?? null;
        $this->container['pack_size'] = $data['pack_size'] ?? null;
        $this->container['width'] = $data['width'] ?? null;
        $this->container['height'] = $data['height'] ?? null;
        $this->container['depth'] = $data['depth'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['min_stock_alert_level'] = $data['min_stock_alert_level'] ?? null;
        $this->container['max_stock_alert_level'] = $data['max_stock_alert_level'] ?? null;
        $this->container['re_order_point'] = $data['re_order_point'] ?? null;
        $this->container['unit_of_measure'] = $data['unit_of_measure'] ?? null;
        $this->container['never_diminishing'] = $data['never_diminishing'] ?? null;
        $this->container['last_cost'] = $data['last_cost'] ?? null;
        $this->container['default_purchase_price'] = $data['default_purchase_price'] ?? null;
        $this->container['default_sell_price'] = $data['default_sell_price'] ?? null;
        $this->container['customer_sell_price'] = $data['customer_sell_price'] ?? null;
        $this->container['average_land_price'] = $data['average_land_price'] ?? null;
        $this->container['obsolete'] = $data['obsolete'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['image_url'] = $data['image_url'] ?? null;
        $this->container['sell_price_tier1'] = $data['sell_price_tier1'] ?? null;
        $this->container['sell_price_tier2'] = $data['sell_price_tier2'] ?? null;
        $this->container['sell_price_tier3'] = $data['sell_price_tier3'] ?? null;
        $this->container['sell_price_tier4'] = $data['sell_price_tier4'] ?? null;
        $this->container['sell_price_tier5'] = $data['sell_price_tier5'] ?? null;
        $this->container['sell_price_tier6'] = $data['sell_price_tier6'] ?? null;
        $this->container['sell_price_tier7'] = $data['sell_price_tier7'] ?? null;
        $this->container['sell_price_tier8'] = $data['sell_price_tier8'] ?? null;
        $this->container['sell_price_tier9'] = $data['sell_price_tier9'] ?? null;
        $this->container['sell_price_tier10'] = $data['sell_price_tier10'] ?? null;
        $this->container['xero_tax_code'] = $data['xero_tax_code'] ?? null;
        $this->container['xero_tax_rate'] = $data['xero_tax_rate'] ?? null;
        $this->container['taxable_purchase'] = $data['taxable_purchase'] ?? null;
        $this->container['taxable_sales'] = $data['taxable_sales'] ?? null;
        $this->container['xero_sales_tax_code'] = $data['xero_sales_tax_code'] ?? null;
        $this->container['xero_sales_tax_rate'] = $data['xero_sales_tax_rate'] ?? null;
        $this->container['is_component'] = $data['is_component'] ?? null;
        $this->container['is_assembled_product'] = $data['is_assembled_product'] ?? null;
        $this->container['product_group'] = $data['product_group'] ?? null;
        $this->container['xero_sales_account'] = $data['xero_sales_account'] ?? null;
        $this->container['xero_cost_of_goods_account'] = $data['xero_cost_of_goods_account'] ?? null;
        $this->container['purchase_account'] = $data['purchase_account'] ?? null;
        $this->container['bin_location'] = $data['bin_location'] ?? null;
        $this->container['supplier'] = $data['supplier'] ?? null;
        $this->container['attribute_set'] = $data['attribute_set'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_variant_parent_id'] = $data['source_variant_parent_id'] ?? null;
        $this->container['is_serialized'] = $data['is_serialized'] ?? null;
        $this->container['is_batch_tracked'] = $data['is_batch_tracked'] ?? null;
        $this->container['is_sellable'] = $data['is_sellable'] ?? null;
        $this->container['minimum_sell_price'] = $data['minimum_sell_price'] ?? null;
        $this->container['minimum_sale_quantity'] = $data['minimum_sale_quantity'] ?? null;
        $this->container['minimum_order_quantity'] = $data['minimum_order_quantity'] ?? null;
        $this->container['created_by'] = $data['created_by'] ?? null;
        $this->container['created_on'] = $data['created_on'] ?? null;
        $this->container['last_modified_by'] = $data['last_modified_by'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets product_code
     *
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->container['product_code'];
    }

    /**
     * Sets product_code
     *
     * @param string|null $product_code product_code
     *
     * @return self
     */
    public function setProductCode($product_code)
    {
        $this->container['product_code'] = $product_code;

        return $this;
    }

    /**
     * Gets product_description
     *
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->container['product_description'];
    }

    /**
     * Sets product_description
     *
     * @param string|null $product_description product_description
     *
     * @return self
     */
    public function setProductDescription($product_description)
    {
        $this->container['product_description'] = $product_description;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode barcode
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets pack_size
     *
     * @return float|null
     */
    public function getPackSize()
    {
        return $this->container['pack_size'];
    }

    /**
     * Sets pack_size
     *
     * @param float|null $pack_size pack_size
     *
     * @return self
     */
    public function setPackSize($pack_size)
    {
        $this->container['pack_size'] = $pack_size;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets min_stock_alert_level
     *
     * @return float|null
     */
    public function getMinStockAlertLevel()
    {
        return $this->container['min_stock_alert_level'];
    }

    /**
     * Sets min_stock_alert_level
     *
     * @param float|null $min_stock_alert_level min_stock_alert_level
     *
     * @return self
     */
    public function setMinStockAlertLevel($min_stock_alert_level)
    {
        $this->container['min_stock_alert_level'] = $min_stock_alert_level;

        return $this;
    }

    /**
     * Gets max_stock_alert_level
     *
     * @return float|null
     */
    public function getMaxStockAlertLevel()
    {
        return $this->container['max_stock_alert_level'];
    }

    /**
     * Sets max_stock_alert_level
     *
     * @param float|null $max_stock_alert_level max_stock_alert_level
     *
     * @return self
     */
    public function setMaxStockAlertLevel($max_stock_alert_level)
    {
        $this->container['max_stock_alert_level'] = $max_stock_alert_level;

        return $this;
    }

    /**
     * Gets re_order_point
     *
     * @return float|null
     */
    public function getReOrderPoint()
    {
        return $this->container['re_order_point'];
    }

    /**
     * Sets re_order_point
     *
     * @param float|null $re_order_point re_order_point
     *
     * @return self
     */
    public function setReOrderPoint($re_order_point)
    {
        $this->container['re_order_point'] = $re_order_point;

        return $this;
    }

    /**
     * Gets unit_of_measure
     *
     * @return \Unleashed\Model\UnitOfMeasure|null
     */
    public function getUnitOfMeasure()
    {
        return $this->container['unit_of_measure'];
    }

    /**
     * Sets unit_of_measure
     *
     * @param \Unleashed\Model\UnitOfMeasure|null $unit_of_measure unit_of_measure
     *
     * @return self
     */
    public function setUnitOfMeasure($unit_of_measure)
    {
        $this->container['unit_of_measure'] = $unit_of_measure;

        return $this;
    }

    /**
     * Gets never_diminishing
     *
     * @return bool|null
     */
    public function getNeverDiminishing()
    {
        return $this->container['never_diminishing'];
    }

    /**
     * Sets never_diminishing
     *
     * @param bool|null $never_diminishing never_diminishing
     *
     * @return self
     */
    public function setNeverDiminishing($never_diminishing)
    {
        $this->container['never_diminishing'] = $never_diminishing;

        return $this;
    }

    /**
     * Gets last_cost
     *
     * @return float|null
     */
    public function getLastCost()
    {
        return $this->container['last_cost'];
    }

    /**
     * Sets last_cost
     *
     * @param float|null $last_cost last_cost
     *
     * @return self
     */
    public function setLastCost($last_cost)
    {
        $this->container['last_cost'] = $last_cost;

        return $this;
    }

    /**
     * Gets default_purchase_price
     *
     * @return float|null
     */
    public function getDefaultPurchasePrice()
    {
        return $this->container['default_purchase_price'];
    }

    /**
     * Sets default_purchase_price
     *
     * @param float|null $default_purchase_price default_purchase_price
     *
     * @return self
     */
    public function setDefaultPurchasePrice($default_purchase_price)
    {
        $this->container['default_purchase_price'] = $default_purchase_price;

        return $this;
    }

    /**
     * Gets default_sell_price
     *
     * @return float|null
     */
    public function getDefaultSellPrice()
    {
        return $this->container['default_sell_price'];
    }

    /**
     * Sets default_sell_price
     *
     * @param float|null $default_sell_price default_sell_price
     *
     * @return self
     */
    public function setDefaultSellPrice($default_sell_price)
    {
        $this->container['default_sell_price'] = $default_sell_price;

        return $this;
    }

    /**
     * Gets customer_sell_price
     *
     * @return float|null
     */
    public function getCustomerSellPrice()
    {
        return $this->container['customer_sell_price'];
    }

    /**
     * Sets customer_sell_price
     *
     * @param float|null $customer_sell_price customer_sell_price
     *
     * @return self
     */
    public function setCustomerSellPrice($customer_sell_price)
    {
        $this->container['customer_sell_price'] = $customer_sell_price;

        return $this;
    }

    /**
     * Gets average_land_price
     *
     * @return float|null
     */
    public function getAverageLandPrice()
    {
        return $this->container['average_land_price'];
    }

    /**
     * Sets average_land_price
     *
     * @param float|null $average_land_price average_land_price
     *
     * @return self
     */
    public function setAverageLandPrice($average_land_price)
    {
        $this->container['average_land_price'] = $average_land_price;

        return $this;
    }

    /**
     * Gets obsolete
     *
     * @return bool|null
     */
    public function getObsolete()
    {
        return $this->container['obsolete'];
    }

    /**
     * Sets obsolete
     *
     * @param bool|null $obsolete obsolete
     *
     * @return self
     */
    public function setObsolete($obsolete)
    {
        $this->container['obsolete'] = $obsolete;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets sell_price_tier1
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier1()
    {
        return $this->container['sell_price_tier1'];
    }

    /**
     * Sets sell_price_tier1
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier1 sell_price_tier1
     *
     * @return self
     */
    public function setSellPriceTier1($sell_price_tier1)
    {
        $this->container['sell_price_tier1'] = $sell_price_tier1;

        return $this;
    }

    /**
     * Gets sell_price_tier2
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier2()
    {
        return $this->container['sell_price_tier2'];
    }

    /**
     * Sets sell_price_tier2
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier2 sell_price_tier2
     *
     * @return self
     */
    public function setSellPriceTier2($sell_price_tier2)
    {
        $this->container['sell_price_tier2'] = $sell_price_tier2;

        return $this;
    }

    /**
     * Gets sell_price_tier3
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier3()
    {
        return $this->container['sell_price_tier3'];
    }

    /**
     * Sets sell_price_tier3
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier3 sell_price_tier3
     *
     * @return self
     */
    public function setSellPriceTier3($sell_price_tier3)
    {
        $this->container['sell_price_tier3'] = $sell_price_tier3;

        return $this;
    }

    /**
     * Gets sell_price_tier4
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier4()
    {
        return $this->container['sell_price_tier4'];
    }

    /**
     * Sets sell_price_tier4
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier4 sell_price_tier4
     *
     * @return self
     */
    public function setSellPriceTier4($sell_price_tier4)
    {
        $this->container['sell_price_tier4'] = $sell_price_tier4;

        return $this;
    }

    /**
     * Gets sell_price_tier5
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier5()
    {
        return $this->container['sell_price_tier5'];
    }

    /**
     * Sets sell_price_tier5
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier5 sell_price_tier5
     *
     * @return self
     */
    public function setSellPriceTier5($sell_price_tier5)
    {
        $this->container['sell_price_tier5'] = $sell_price_tier5;

        return $this;
    }

    /**
     * Gets sell_price_tier6
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier6()
    {
        return $this->container['sell_price_tier6'];
    }

    /**
     * Sets sell_price_tier6
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier6 sell_price_tier6
     *
     * @return self
     */
    public function setSellPriceTier6($sell_price_tier6)
    {
        $this->container['sell_price_tier6'] = $sell_price_tier6;

        return $this;
    }

    /**
     * Gets sell_price_tier7
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier7()
    {
        return $this->container['sell_price_tier7'];
    }

    /**
     * Sets sell_price_tier7
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier7 sell_price_tier7
     *
     * @return self
     */
    public function setSellPriceTier7($sell_price_tier7)
    {
        $this->container['sell_price_tier7'] = $sell_price_tier7;

        return $this;
    }

    /**
     * Gets sell_price_tier8
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier8()
    {
        return $this->container['sell_price_tier8'];
    }

    /**
     * Sets sell_price_tier8
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier8 sell_price_tier8
     *
     * @return self
     */
    public function setSellPriceTier8($sell_price_tier8)
    {
        $this->container['sell_price_tier8'] = $sell_price_tier8;

        return $this;
    }

    /**
     * Gets sell_price_tier9
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier9()
    {
        return $this->container['sell_price_tier9'];
    }

    /**
     * Sets sell_price_tier9
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier9 sell_price_tier9
     *
     * @return self
     */
    public function setSellPriceTier9($sell_price_tier9)
    {
        $this->container['sell_price_tier9'] = $sell_price_tier9;

        return $this;
    }

    /**
     * Gets sell_price_tier10
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier10()
    {
        return $this->container['sell_price_tier10'];
    }

    /**
     * Sets sell_price_tier10
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier10 sell_price_tier10
     *
     * @return self
     */
    public function setSellPriceTier10($sell_price_tier10)
    {
        $this->container['sell_price_tier10'] = $sell_price_tier10;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets xero_tax_rate
     *
     * @return float|null
     */
    public function getXeroTaxRate()
    {
        return $this->container['xero_tax_rate'];
    }

    /**
     * Sets xero_tax_rate
     *
     * @param float|null $xero_tax_rate xero_tax_rate
     *
     * @return self
     */
    public function setXeroTaxRate($xero_tax_rate)
    {
        $this->container['xero_tax_rate'] = $xero_tax_rate;

        return $this;
    }

    /**
     * Gets taxable_purchase
     *
     * @return bool|null
     */
    public function getTaxablePurchase()
    {
        return $this->container['taxable_purchase'];
    }

    /**
     * Sets taxable_purchase
     *
     * @param bool|null $taxable_purchase taxable_purchase
     *
     * @return self
     */
    public function setTaxablePurchase($taxable_purchase)
    {
        $this->container['taxable_purchase'] = $taxable_purchase;

        return $this;
    }

    /**
     * Gets taxable_sales
     *
     * @return bool|null
     */
    public function getTaxableSales()
    {
        return $this->container['taxable_sales'];
    }

    /**
     * Sets taxable_sales
     *
     * @param bool|null $taxable_sales taxable_sales
     *
     * @return self
     */
    public function setTaxableSales($taxable_sales)
    {
        $this->container['taxable_sales'] = $taxable_sales;

        return $this;
    }

    /**
     * Gets xero_sales_tax_code
     *
     * @return string|null
     */
    public function getXeroSalesTaxCode()
    {
        return $this->container['xero_sales_tax_code'];
    }

    /**
     * Sets xero_sales_tax_code
     *
     * @param string|null $xero_sales_tax_code xero_sales_tax_code
     *
     * @return self
     */
    public function setXeroSalesTaxCode($xero_sales_tax_code)
    {
        $this->container['xero_sales_tax_code'] = $xero_sales_tax_code;

        return $this;
    }

    /**
     * Gets xero_sales_tax_rate
     *
     * @return float|null
     */
    public function getXeroSalesTaxRate()
    {
        return $this->container['xero_sales_tax_rate'];
    }

    /**
     * Sets xero_sales_tax_rate
     *
     * @param float|null $xero_sales_tax_rate xero_sales_tax_rate
     *
     * @return self
     */
    public function setXeroSalesTaxRate($xero_sales_tax_rate)
    {
        $this->container['xero_sales_tax_rate'] = $xero_sales_tax_rate;

        return $this;
    }

    /**
     * Gets is_component
     *
     * @return bool|null
     */
    public function getIsComponent()
    {
        return $this->container['is_component'];
    }

    /**
     * Sets is_component
     *
     * @param bool|null $is_component is_component
     *
     * @return self
     */
    public function setIsComponent($is_component)
    {
        $this->container['is_component'] = $is_component;

        return $this;
    }

    /**
     * Gets is_assembled_product
     *
     * @return bool|null
     */
    public function getIsAssembledProduct()
    {
        return $this->container['is_assembled_product'];
    }

    /**
     * Sets is_assembled_product
     *
     * @param bool|null $is_assembled_product is_assembled_product
     *
     * @return self
     */
    public function setIsAssembledProduct($is_assembled_product)
    {
        $this->container['is_assembled_product'] = $is_assembled_product;

        return $this;
    }

    /**
     * Gets product_group
     *
     * @return \Unleashed\Model\ProductGroup|null
     */
    public function getProductGroup()
    {
        return $this->container['product_group'];
    }

    /**
     * Sets product_group
     *
     * @param \Unleashed\Model\ProductGroup|null $product_group product_group
     *
     * @return self
     */
    public function setProductGroup($product_group)
    {
        $this->container['product_group'] = $product_group;

        return $this;
    }

    /**
     * Gets xero_sales_account
     *
     * @return string|null
     */
    public function getXeroSalesAccount()
    {
        return $this->container['xero_sales_account'];
    }

    /**
     * Sets xero_sales_account
     *
     * @param string|null $xero_sales_account xero_sales_account
     *
     * @return self
     */
    public function setXeroSalesAccount($xero_sales_account)
    {
        $this->container['xero_sales_account'] = $xero_sales_account;

        return $this;
    }

    /**
     * Gets xero_cost_of_goods_account
     *
     * @return string|null
     */
    public function getXeroCostOfGoodsAccount()
    {
        return $this->container['xero_cost_of_goods_account'];
    }

    /**
     * Sets xero_cost_of_goods_account
     *
     * @param string|null $xero_cost_of_goods_account xero_cost_of_goods_account
     *
     * @return self
     */
    public function setXeroCostOfGoodsAccount($xero_cost_of_goods_account)
    {
        $this->container['xero_cost_of_goods_account'] = $xero_cost_of_goods_account;

        return $this;
    }

    /**
     * Gets purchase_account
     *
     * @return string|null
     */
    public function getPurchaseAccount()
    {
        return $this->container['purchase_account'];
    }

    /**
     * Sets purchase_account
     *
     * @param string|null $purchase_account purchase_account
     *
     * @return self
     */
    public function setPurchaseAccount($purchase_account)
    {
        $this->container['purchase_account'] = $purchase_account;

        return $this;
    }

    /**
     * Gets bin_location
     *
     * @return string|null
     */
    public function getBinLocation()
    {
        return $this->container['bin_location'];
    }

    /**
     * Sets bin_location
     *
     * @param string|null $bin_location bin_location
     *
     * @return self
     */
    public function setBinLocation($bin_location)
    {
        $this->container['bin_location'] = $bin_location;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Unleashed\Model\SupplierWithProductCode|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Unleashed\Model\SupplierWithProductCode|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets attribute_set
     *
     * @return \Unleashed\Model\AttributeSet|null
     */
    public function getAttributeSet()
    {
        return $this->container['attribute_set'];
    }

    /**
     * Sets attribute_set
     *
     * @param \Unleashed\Model\AttributeSet|null $attribute_set attribute_set
     *
     * @return self
     */
    public function setAttributeSet($attribute_set)
    {
        $this->container['attribute_set'] = $attribute_set;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id source_id
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_variant_parent_id
     *
     * @return string|null
     */
    public function getSourceVariantParentId()
    {
        return $this->container['source_variant_parent_id'];
    }

    /**
     * Sets source_variant_parent_id
     *
     * @param string|null $source_variant_parent_id source_variant_parent_id
     *
     * @return self
     */
    public function setSourceVariantParentId($source_variant_parent_id)
    {
        $this->container['source_variant_parent_id'] = $source_variant_parent_id;

        return $this;
    }

    /**
     * Gets is_serialized
     *
     * @return bool|null
     */
    public function getIsSerialized()
    {
        return $this->container['is_serialized'];
    }

    /**
     * Sets is_serialized
     *
     * @param bool|null $is_serialized is_serialized
     *
     * @return self
     */
    public function setIsSerialized($is_serialized)
    {
        $this->container['is_serialized'] = $is_serialized;

        return $this;
    }

    /**
     * Gets is_batch_tracked
     *
     * @return bool|null
     */
    public function getIsBatchTracked()
    {
        return $this->container['is_batch_tracked'];
    }

    /**
     * Sets is_batch_tracked
     *
     * @param bool|null $is_batch_tracked is_batch_tracked
     *
     * @return self
     */
    public function setIsBatchTracked($is_batch_tracked)
    {
        $this->container['is_batch_tracked'] = $is_batch_tracked;

        return $this;
    }

    /**
     * Gets is_sellable
     *
     * @return bool|null
     */
    public function getIsSellable()
    {
        return $this->container['is_sellable'];
    }

    /**
     * Sets is_sellable
     *
     * @param bool|null $is_sellable is_sellable
     *
     * @return self
     */
    public function setIsSellable($is_sellable)
    {
        $this->container['is_sellable'] = $is_sellable;

        return $this;
    }

    /**
     * Gets minimum_sell_price
     *
     * @return float|null
     */
    public function getMinimumSellPrice()
    {
        return $this->container['minimum_sell_price'];
    }

    /**
     * Sets minimum_sell_price
     *
     * @param float|null $minimum_sell_price minimum_sell_price
     *
     * @return self
     */
    public function setMinimumSellPrice($minimum_sell_price)
    {
        $this->container['minimum_sell_price'] = $minimum_sell_price;

        return $this;
    }

    /**
     * Gets minimum_sale_quantity
     *
     * @return float|null
     */
    public function getMinimumSaleQuantity()
    {
        return $this->container['minimum_sale_quantity'];
    }

    /**
     * Sets minimum_sale_quantity
     *
     * @param float|null $minimum_sale_quantity minimum_sale_quantity
     *
     * @return self
     */
    public function setMinimumSaleQuantity($minimum_sale_quantity)
    {
        $this->container['minimum_sale_quantity'] = $minimum_sale_quantity;

        return $this;
    }

    /**
     * Gets minimum_order_quantity
     *
     * @return float|null
     */
    public function getMinimumOrderQuantity()
    {
        return $this->container['minimum_order_quantity'];
    }

    /**
     * Sets minimum_order_quantity
     *
     * @param float|null $minimum_order_quantity minimum_order_quantity
     *
     * @return self
     */
    public function setMinimumOrderQuantity($minimum_order_quantity)
    {
        $this->container['minimum_order_quantity'] = $minimum_order_quantity;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


