<?php
/**
 * Customer
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Customer Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Customer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'addresses' => '\Unleashed\Model\Address[]',
        'customer_code' => 'string',
        'customer_name' => 'string',
        'gstvat_number' => 'string',
        'bank_name' => 'string',
        'bank_branch' => 'string',
        'bank_account' => 'string',
        'website' => 'string',
        'phone_number' => 'string',
        'fax_number' => 'string',
        'mobile_number' => 'string',
        'ddi_number' => 'string',
        'toll_free_number' => 'string',
        'email' => 'string',
        'email_cc' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'notes' => 'string',
        'taxable' => 'bool',
        'xero_contact_id' => 'string',
        'sales_person' => '\Unleashed\Model\SalesPerson',
        'discount_rate' => 'float',
        'print_packing_slip_instead_of_invoice' => 'bool',
        'print_invoice' => 'bool',
        'stop_credit' => 'bool',
        'obsolete' => 'bool',
        'xero_sales_account' => 'string',
        'xero_cost_of_goods_account' => 'string',
        'sell_price_tier' => 'string',
        'customer_type' => 'string',
        'payment_term' => 'string',
        'contact_first_name' => 'string',
        'contact_last_name' => 'string',
        'source_id' => 'string',
        'created_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'addresses' => null,
        'customer_code' => null,
        'customer_name' => null,
        'gstvat_number' => null,
        'bank_name' => null,
        'bank_branch' => null,
        'bank_account' => null,
        'website' => null,
        'phone_number' => null,
        'fax_number' => null,
        'mobile_number' => null,
        'ddi_number' => null,
        'toll_free_number' => null,
        'email' => null,
        'email_cc' => null,
        'currency' => null,
        'notes' => null,
        'taxable' => null,
        'xero_contact_id' => null,
        'sales_person' => null,
        'discount_rate' => null,
        'print_packing_slip_instead_of_invoice' => null,
        'print_invoice' => null,
        'stop_credit' => null,
        'obsolete' => null,
        'xero_sales_account' => null,
        'xero_cost_of_goods_account' => null,
        'sell_price_tier' => null,
        'customer_type' => null,
        'payment_term' => null,
        'contact_first_name' => null,
        'contact_last_name' => null,
        'source_id' => null,
        'created_by' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'addresses' => 'Addresses',
        'customer_code' => 'CustomerCode',
        'customer_name' => 'CustomerName',
        'gstvat_number' => 'GSTVATNumber',
        'bank_name' => 'BankName',
        'bank_branch' => 'BankBranch',
        'bank_account' => 'BankAccount',
        'website' => 'Website',
        'phone_number' => 'PhoneNumber',
        'fax_number' => 'FaxNumber',
        'mobile_number' => 'MobileNumber',
        'ddi_number' => 'DDINumber',
        'toll_free_number' => 'TollFreeNumber',
        'email' => 'Email',
        'email_cc' => 'EmailCC',
        'currency' => 'Currency',
        'notes' => 'Notes',
        'taxable' => 'Taxable',
        'xero_contact_id' => 'XeroContactId',
        'sales_person' => 'SalesPerson',
        'discount_rate' => 'DiscountRate',
        'print_packing_slip_instead_of_invoice' => 'PrintPackingSlipInsteadOfInvoice',
        'print_invoice' => 'PrintInvoice',
        'stop_credit' => 'StopCredit',
        'obsolete' => 'Obsolete',
        'xero_sales_account' => 'XeroSalesAccount',
        'xero_cost_of_goods_account' => 'XeroCostOfGoodsAccount',
        'sell_price_tier' => 'SellPriceTier',
        'customer_type' => 'CustomerType',
        'payment_term' => 'PaymentTerm',
        'contact_first_name' => 'ContactFirstName',
        'contact_last_name' => 'ContactLastName',
        'source_id' => 'SourceId',
        'created_by' => 'CreatedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'addresses' => 'setAddresses',
        'customer_code' => 'setCustomerCode',
        'customer_name' => 'setCustomerName',
        'gstvat_number' => 'setGstvatNumber',
        'bank_name' => 'setBankName',
        'bank_branch' => 'setBankBranch',
        'bank_account' => 'setBankAccount',
        'website' => 'setWebsite',
        'phone_number' => 'setPhoneNumber',
        'fax_number' => 'setFaxNumber',
        'mobile_number' => 'setMobileNumber',
        'ddi_number' => 'setDdiNumber',
        'toll_free_number' => 'setTollFreeNumber',
        'email' => 'setEmail',
        'email_cc' => 'setEmailCc',
        'currency' => 'setCurrency',
        'notes' => 'setNotes',
        'taxable' => 'setTaxable',
        'xero_contact_id' => 'setXeroContactId',
        'sales_person' => 'setSalesPerson',
        'discount_rate' => 'setDiscountRate',
        'print_packing_slip_instead_of_invoice' => 'setPrintPackingSlipInsteadOfInvoice',
        'print_invoice' => 'setPrintInvoice',
        'stop_credit' => 'setStopCredit',
        'obsolete' => 'setObsolete',
        'xero_sales_account' => 'setXeroSalesAccount',
        'xero_cost_of_goods_account' => 'setXeroCostOfGoodsAccount',
        'sell_price_tier' => 'setSellPriceTier',
        'customer_type' => 'setCustomerType',
        'payment_term' => 'setPaymentTerm',
        'contact_first_name' => 'setContactFirstName',
        'contact_last_name' => 'setContactLastName',
        'source_id' => 'setSourceId',
        'created_by' => 'setCreatedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'addresses' => 'getAddresses',
        'customer_code' => 'getCustomerCode',
        'customer_name' => 'getCustomerName',
        'gstvat_number' => 'getGstvatNumber',
        'bank_name' => 'getBankName',
        'bank_branch' => 'getBankBranch',
        'bank_account' => 'getBankAccount',
        'website' => 'getWebsite',
        'phone_number' => 'getPhoneNumber',
        'fax_number' => 'getFaxNumber',
        'mobile_number' => 'getMobileNumber',
        'ddi_number' => 'getDdiNumber',
        'toll_free_number' => 'getTollFreeNumber',
        'email' => 'getEmail',
        'email_cc' => 'getEmailCc',
        'currency' => 'getCurrency',
        'notes' => 'getNotes',
        'taxable' => 'getTaxable',
        'xero_contact_id' => 'getXeroContactId',
        'sales_person' => 'getSalesPerson',
        'discount_rate' => 'getDiscountRate',
        'print_packing_slip_instead_of_invoice' => 'getPrintPackingSlipInsteadOfInvoice',
        'print_invoice' => 'getPrintInvoice',
        'stop_credit' => 'getStopCredit',
        'obsolete' => 'getObsolete',
        'xero_sales_account' => 'getXeroSalesAccount',
        'xero_cost_of_goods_account' => 'getXeroCostOfGoodsAccount',
        'sell_price_tier' => 'getSellPriceTier',
        'customer_type' => 'getCustomerType',
        'payment_term' => 'getPaymentTerm',
        'contact_first_name' => 'getContactFirstName',
        'contact_last_name' => 'getContactLastName',
        'source_id' => 'getSourceId',
        'created_by' => 'getCreatedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['addresses'] = $data['addresses'] ?? null;
        $this->container['customer_code'] = $data['customer_code'] ?? null;
        $this->container['customer_name'] = $data['customer_name'] ?? null;
        $this->container['gstvat_number'] = $data['gstvat_number'] ?? null;
        $this->container['bank_name'] = $data['bank_name'] ?? null;
        $this->container['bank_branch'] = $data['bank_branch'] ?? null;
        $this->container['bank_account'] = $data['bank_account'] ?? null;
        $this->container['website'] = $data['website'] ?? null;
        $this->container['phone_number'] = $data['phone_number'] ?? null;
        $this->container['fax_number'] = $data['fax_number'] ?? null;
        $this->container['mobile_number'] = $data['mobile_number'] ?? null;
        $this->container['ddi_number'] = $data['ddi_number'] ?? null;
        $this->container['toll_free_number'] = $data['toll_free_number'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['email_cc'] = $data['email_cc'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['taxable'] = $data['taxable'] ?? null;
        $this->container['xero_contact_id'] = $data['xero_contact_id'] ?? null;
        $this->container['sales_person'] = $data['sales_person'] ?? null;
        $this->container['discount_rate'] = $data['discount_rate'] ?? null;
        $this->container['print_packing_slip_instead_of_invoice'] = $data['print_packing_slip_instead_of_invoice'] ?? null;
        $this->container['print_invoice'] = $data['print_invoice'] ?? null;
        $this->container['stop_credit'] = $data['stop_credit'] ?? null;
        $this->container['obsolete'] = $data['obsolete'] ?? null;
        $this->container['xero_sales_account'] = $data['xero_sales_account'] ?? null;
        $this->container['xero_cost_of_goods_account'] = $data['xero_cost_of_goods_account'] ?? null;
        $this->container['sell_price_tier'] = $data['sell_price_tier'] ?? null;
        $this->container['customer_type'] = $data['customer_type'] ?? null;
        $this->container['payment_term'] = $data['payment_term'] ?? null;
        $this->container['contact_first_name'] = $data['contact_first_name'] ?? null;
        $this->container['contact_last_name'] = $data['contact_last_name'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['created_by'] = $data['created_by'] ?? null;
        $this->container['guid'] = $data['guid'] ?? null;
        $this->container['last_modified_on'] = $data['last_modified_on'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets addresses
     *
     * @return \Unleashed\Model\Address[]|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \Unleashed\Model\Address[]|null $addresses addresses
     *
     * @return self
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets customer_code
     *
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->container['customer_code'];
    }

    /**
     * Sets customer_code
     *
     * @param string|null $customer_code customer_code
     *
     * @return self
     */
    public function setCustomerCode($customer_code)
    {
        $this->container['customer_code'] = $customer_code;

        return $this;
    }

    /**
     * Gets customer_name
     *
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->container['customer_name'];
    }

    /**
     * Sets customer_name
     *
     * @param string|null $customer_name customer_name
     *
     * @return self
     */
    public function setCustomerName($customer_name)
    {
        $this->container['customer_name'] = $customer_name;

        return $this;
    }

    /**
     * Gets gstvat_number
     *
     * @return string|null
     */
    public function getGstvatNumber()
    {
        return $this->container['gstvat_number'];
    }

    /**
     * Sets gstvat_number
     *
     * @param string|null $gstvat_number gstvat_number
     *
     * @return self
     */
    public function setGstvatNumber($gstvat_number)
    {
        $this->container['gstvat_number'] = $gstvat_number;

        return $this;
    }

    /**
     * Gets bank_name
     *
     * @return string|null
     */
    public function getBankName()
    {
        return $this->container['bank_name'];
    }

    /**
     * Sets bank_name
     *
     * @param string|null $bank_name bank_name
     *
     * @return self
     */
    public function setBankName($bank_name)
    {
        $this->container['bank_name'] = $bank_name;

        return $this;
    }

    /**
     * Gets bank_branch
     *
     * @return string|null
     */
    public function getBankBranch()
    {
        return $this->container['bank_branch'];
    }

    /**
     * Sets bank_branch
     *
     * @param string|null $bank_branch bank_branch
     *
     * @return self
     */
    public function setBankBranch($bank_branch)
    {
        $this->container['bank_branch'] = $bank_branch;

        return $this;
    }

    /**
     * Gets bank_account
     *
     * @return string|null
     */
    public function getBankAccount()
    {
        return $this->container['bank_account'];
    }

    /**
     * Sets bank_account
     *
     * @param string|null $bank_account bank_account
     *
     * @return self
     */
    public function setBankAccount($bank_account)
    {
        $this->container['bank_account'] = $bank_account;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets phone_number
     *
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     *
     * @param string|null $phone_number phone_number
     *
     * @return self
     */
    public function setPhoneNumber($phone_number)
    {
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number fax_number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets mobile_number
     *
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->container['mobile_number'];
    }

    /**
     * Sets mobile_number
     *
     * @param string|null $mobile_number mobile_number
     *
     * @return self
     */
    public function setMobileNumber($mobile_number)
    {
        $this->container['mobile_number'] = $mobile_number;

        return $this;
    }

    /**
     * Gets ddi_number
     *
     * @return string|null
     */
    public function getDdiNumber()
    {
        return $this->container['ddi_number'];
    }

    /**
     * Sets ddi_number
     *
     * @param string|null $ddi_number ddi_number
     *
     * @return self
     */
    public function setDdiNumber($ddi_number)
    {
        $this->container['ddi_number'] = $ddi_number;

        return $this;
    }

    /**
     * Gets toll_free_number
     *
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->container['toll_free_number'];
    }

    /**
     * Sets toll_free_number
     *
     * @param string|null $toll_free_number toll_free_number
     *
     * @return self
     */
    public function setTollFreeNumber($toll_free_number)
    {
        $this->container['toll_free_number'] = $toll_free_number;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets email_cc
     *
     * @return string|null
     */
    public function getEmailCc()
    {
        return $this->container['email_cc'];
    }

    /**
     * Sets email_cc
     *
     * @param string|null $email_cc email_cc
     *
     * @return self
     */
    public function setEmailCc($email_cc)
    {
        $this->container['email_cc'] = $email_cc;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets taxable
     *
     * @return bool|null
     */
    public function getTaxable()
    {
        return $this->container['taxable'];
    }

    /**
     * Sets taxable
     *
     * @param bool|null $taxable taxable
     *
     * @return self
     */
    public function setTaxable($taxable)
    {
        $this->container['taxable'] = $taxable;

        return $this;
    }

    /**
     * Gets xero_contact_id
     *
     * @return string|null
     */
    public function getXeroContactId()
    {
        return $this->container['xero_contact_id'];
    }

    /**
     * Sets xero_contact_id
     *
     * @param string|null $xero_contact_id xero_contact_id
     *
     * @return self
     */
    public function setXeroContactId($xero_contact_id)
    {
        $this->container['xero_contact_id'] = $xero_contact_id;

        return $this;
    }

    /**
     * Gets sales_person
     *
     * @return \Unleashed\Model\SalesPerson|null
     */
    public function getSalesPerson()
    {
        return $this->container['sales_person'];
    }

    /**
     * Sets sales_person
     *
     * @param \Unleashed\Model\SalesPerson|null $sales_person sales_person
     *
     * @return self
     */
    public function setSalesPerson($sales_person)
    {
        $this->container['sales_person'] = $sales_person;

        return $this;
    }

    /**
     * Gets discount_rate
     *
     * @return float|null
     */
    public function getDiscountRate()
    {
        return $this->container['discount_rate'];
    }

    /**
     * Sets discount_rate
     *
     * @param float|null $discount_rate discount_rate
     *
     * @return self
     */
    public function setDiscountRate($discount_rate)
    {
        $this->container['discount_rate'] = $discount_rate;

        return $this;
    }

    /**
     * Gets print_packing_slip_instead_of_invoice
     *
     * @return bool|null
     */
    public function getPrintPackingSlipInsteadOfInvoice()
    {
        return $this->container['print_packing_slip_instead_of_invoice'];
    }

    /**
     * Sets print_packing_slip_instead_of_invoice
     *
     * @param bool|null $print_packing_slip_instead_of_invoice print_packing_slip_instead_of_invoice
     *
     * @return self
     */
    public function setPrintPackingSlipInsteadOfInvoice($print_packing_slip_instead_of_invoice)
    {
        $this->container['print_packing_slip_instead_of_invoice'] = $print_packing_slip_instead_of_invoice;

        return $this;
    }

    /**
     * Gets print_invoice
     *
     * @return bool|null
     */
    public function getPrintInvoice()
    {
        return $this->container['print_invoice'];
    }

    /**
     * Sets print_invoice
     *
     * @param bool|null $print_invoice print_invoice
     *
     * @return self
     */
    public function setPrintInvoice($print_invoice)
    {
        $this->container['print_invoice'] = $print_invoice;

        return $this;
    }

    /**
     * Gets stop_credit
     *
     * @return bool|null
     */
    public function getStopCredit()
    {
        return $this->container['stop_credit'];
    }

    /**
     * Sets stop_credit
     *
     * @param bool|null $stop_credit stop_credit
     *
     * @return self
     */
    public function setStopCredit($stop_credit)
    {
        $this->container['stop_credit'] = $stop_credit;

        return $this;
    }

    /**
     * Gets obsolete
     *
     * @return bool|null
     */
    public function getObsolete()
    {
        return $this->container['obsolete'];
    }

    /**
     * Sets obsolete
     *
     * @param bool|null $obsolete obsolete
     *
     * @return self
     */
    public function setObsolete($obsolete)
    {
        $this->container['obsolete'] = $obsolete;

        return $this;
    }

    /**
     * Gets xero_sales_account
     *
     * @return string|null
     */
    public function getXeroSalesAccount()
    {
        return $this->container['xero_sales_account'];
    }

    /**
     * Sets xero_sales_account
     *
     * @param string|null $xero_sales_account xero_sales_account
     *
     * @return self
     */
    public function setXeroSalesAccount($xero_sales_account)
    {
        $this->container['xero_sales_account'] = $xero_sales_account;

        return $this;
    }

    /**
     * Gets xero_cost_of_goods_account
     *
     * @return string|null
     */
    public function getXeroCostOfGoodsAccount()
    {
        return $this->container['xero_cost_of_goods_account'];
    }

    /**
     * Sets xero_cost_of_goods_account
     *
     * @param string|null $xero_cost_of_goods_account xero_cost_of_goods_account
     *
     * @return self
     */
    public function setXeroCostOfGoodsAccount($xero_cost_of_goods_account)
    {
        $this->container['xero_cost_of_goods_account'] = $xero_cost_of_goods_account;

        return $this;
    }

    /**
     * Gets sell_price_tier
     *
     * @return string|null
     */
    public function getSellPriceTier()
    {
        return $this->container['sell_price_tier'];
    }

    /**
     * Sets sell_price_tier
     *
     * @param string|null $sell_price_tier sell_price_tier
     *
     * @return self
     */
    public function setSellPriceTier($sell_price_tier)
    {
        $this->container['sell_price_tier'] = $sell_price_tier;

        return $this;
    }

    /**
     * Gets customer_type
     *
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->container['customer_type'];
    }

    /**
     * Sets customer_type
     *
     * @param string|null $customer_type customer_type
     *
     * @return self
     */
    public function setCustomerType($customer_type)
    {
        $this->container['customer_type'] = $customer_type;

        return $this;
    }

    /**
     * Gets payment_term
     *
     * @return string|null
     */
    public function getPaymentTerm()
    {
        return $this->container['payment_term'];
    }

    /**
     * Sets payment_term
     *
     * @param string|null $payment_term payment_term
     *
     * @return self
     */
    public function setPaymentTerm($payment_term)
    {
        $this->container['payment_term'] = $payment_term;

        return $this;
    }

    /**
     * Gets contact_first_name
     *
     * @return string|null
     */
    public function getContactFirstName()
    {
        return $this->container['contact_first_name'];
    }

    /**
     * Sets contact_first_name
     *
     * @param string|null $contact_first_name contact_first_name
     *
     * @return self
     */
    public function setContactFirstName($contact_first_name)
    {
        $this->container['contact_first_name'] = $contact_first_name;

        return $this;
    }

    /**
     * Gets contact_last_name
     *
     * @return string|null
     */
    public function getContactLastName()
    {
        return $this->container['contact_last_name'];
    }

    /**
     * Sets contact_last_name
     *
     * @param string|null $contact_last_name contact_last_name
     *
     * @return self
     */
    public function setContactLastName($contact_last_name)
    {
        $this->container['contact_last_name'] = $contact_last_name;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id source_id
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


