<?php
/**
 * SearchReturnsRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * SearchReturnsRequest Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SearchReturnsRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SearchReturnsRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'arbitration_status' => 'string[]',
        'buyer_user_ids' => 'string[]',
        'create_time_ge' => 'int',
        'create_time_lt' => 'int',
        'locale' => 'string',
        'order_ids' => 'string[]',
        'return_ids' => 'string[]',
        'return_status' => 'string[]',
        'return_types' => 'string[]',
        'update_time_ge' => 'int',
        'update_time_lt' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'arbitration_status' => null,
        'buyer_user_ids' => null,
        'create_time_ge' => null,
        'create_time_lt' => null,
        'locale' => null,
        'order_ids' => null,
        'return_ids' => null,
        'return_status' => null,
        'return_types' => null,
        'update_time_ge' => null,
        'update_time_lt' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'arbitration_status' => false,
        'buyer_user_ids' => false,
        'create_time_ge' => false,
        'create_time_lt' => false,
        'locale' => false,
        'order_ids' => false,
        'return_ids' => false,
        'return_status' => false,
        'return_types' => false,
        'update_time_ge' => false,
        'update_time_lt' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'arbitration_status' => 'arbitration_status',
        'buyer_user_ids' => 'buyer_user_ids',
        'create_time_ge' => 'create_time_ge',
        'create_time_lt' => 'create_time_lt',
        'locale' => 'locale',
        'order_ids' => 'order_ids',
        'return_ids' => 'return_ids',
        'return_status' => 'return_status',
        'return_types' => 'return_types',
        'update_time_ge' => 'update_time_ge',
        'update_time_lt' => 'update_time_lt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'arbitration_status' => 'setArbitrationStatus',
        'buyer_user_ids' => 'setBuyerUserIds',
        'create_time_ge' => 'setCreateTimeGe',
        'create_time_lt' => 'setCreateTimeLt',
        'locale' => 'setLocale',
        'order_ids' => 'setOrderIds',
        'return_ids' => 'setReturnIds',
        'return_status' => 'setReturnStatus',
        'return_types' => 'setReturnTypes',
        'update_time_ge' => 'setUpdateTimeGe',
        'update_time_lt' => 'setUpdateTimeLt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'arbitration_status' => 'getArbitrationStatus',
        'buyer_user_ids' => 'getBuyerUserIds',
        'create_time_ge' => 'getCreateTimeGe',
        'create_time_lt' => 'getCreateTimeLt',
        'locale' => 'getLocale',
        'order_ids' => 'getOrderIds',
        'return_ids' => 'getReturnIds',
        'return_status' => 'getReturnStatus',
        'return_types' => 'getReturnTypes',
        'update_time_ge' => 'getUpdateTimeGe',
        'update_time_lt' => 'getUpdateTimeLt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('arbitration_status', $data ?? [], null);
        $this->setIfExists('buyer_user_ids', $data ?? [], null);
        $this->setIfExists('create_time_ge', $data ?? [], null);
        $this->setIfExists('create_time_lt', $data ?? [], null);
        $this->setIfExists('locale', $data ?? [], null);
        $this->setIfExists('order_ids', $data ?? [], null);
        $this->setIfExists('return_ids', $data ?? [], null);
        $this->setIfExists('return_status', $data ?? [], null);
        $this->setIfExists('return_types', $data ?? [], null);
        $this->setIfExists('update_time_ge', $data ?? [], null);
        $this->setIfExists('update_time_lt', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets arbitration_status
     *
     * @return string[]|null
     */
    public function getArbitrationStatus()
    {
        return $this->container['arbitration_status'];
    }

    /**
     * Sets arbitration_status
     *
     * @param string[]|null $arbitration_status arbitration_status
     *
     * @return self
     */
    public function setArbitrationStatus($arbitration_status)
    {
        if (is_null($arbitration_status)) {
            throw new \InvalidArgumentException('non-nullable arbitration_status cannot be null');
        }
        $this->container['arbitration_status'] = $arbitration_status;

        return $this;
    }

    /**
     * Gets buyer_user_ids
     *
     * @return string[]|null
     */
    public function getBuyerUserIds()
    {
        return $this->container['buyer_user_ids'];
    }

    /**
     * Sets buyer_user_ids
     *
     * @param string[]|null $buyer_user_ids buyer_user_ids
     *
     * @return self
     */
    public function setBuyerUserIds($buyer_user_ids)
    {
        if (is_null($buyer_user_ids)) {
            throw new \InvalidArgumentException('non-nullable buyer_user_ids cannot be null');
        }
        $this->container['buyer_user_ids'] = $buyer_user_ids;

        return $this;
    }

    /**
     * Gets create_time_ge
     *
     * @return int|null
     */
    public function getCreateTimeGe()
    {
        return $this->container['create_time_ge'];
    }

    /**
     * Sets create_time_ge
     *
     * @param int|null $create_time_ge create_time_ge
     *
     * @return self
     */
    public function setCreateTimeGe($create_time_ge)
    {
        if (is_null($create_time_ge)) {
            throw new \InvalidArgumentException('non-nullable create_time_ge cannot be null');
        }
        $this->container['create_time_ge'] = $create_time_ge;

        return $this;
    }

    /**
     * Gets create_time_lt
     *
     * @return int|null
     */
    public function getCreateTimeLt()
    {
        return $this->container['create_time_lt'];
    }

    /**
     * Sets create_time_lt
     *
     * @param int|null $create_time_lt create_time_lt
     *
     * @return self
     */
    public function setCreateTimeLt($create_time_lt)
    {
        if (is_null($create_time_lt)) {
            throw new \InvalidArgumentException('non-nullable create_time_lt cannot be null');
        }
        $this->container['create_time_lt'] = $create_time_lt;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string|null
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string|null $locale locale
     *
     * @return self
     */
    public function setLocale($locale)
    {
        if (is_null($locale)) {
            throw new \InvalidArgumentException('non-nullable locale cannot be null');
        }
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets order_ids
     *
     * @return string[]|null
     */
    public function getOrderIds()
    {
        return $this->container['order_ids'];
    }

    /**
     * Sets order_ids
     *
     * @param string[]|null $order_ids order_ids
     *
     * @return self
     */
    public function setOrderIds($order_ids)
    {
        if (is_null($order_ids)) {
            throw new \InvalidArgumentException('non-nullable order_ids cannot be null');
        }
        $this->container['order_ids'] = $order_ids;

        return $this;
    }

    /**
     * Gets return_ids
     *
     * @return string[]|null
     */
    public function getReturnIds()
    {
        return $this->container['return_ids'];
    }

    /**
     * Sets return_ids
     *
     * @param string[]|null $return_ids return_ids
     *
     * @return self
     */
    public function setReturnIds($return_ids)
    {
        if (is_null($return_ids)) {
            throw new \InvalidArgumentException('non-nullable return_ids cannot be null');
        }
        $this->container['return_ids'] = $return_ids;

        return $this;
    }

    /**
     * Gets return_status
     *
     * @return string[]|null
     */
    public function getReturnStatus()
    {
        return $this->container['return_status'];
    }

    /**
     * Sets return_status
     *
     * @param string[]|null $return_status return_status
     *
     * @return self
     */
    public function setReturnStatus($return_status)
    {
        if (is_null($return_status)) {
            throw new \InvalidArgumentException('non-nullable return_status cannot be null');
        }
        $this->container['return_status'] = $return_status;

        return $this;
    }

    /**
     * Gets return_types
     *
     * @return string[]|null
     */
    public function getReturnTypes()
    {
        return $this->container['return_types'];
    }

    /**
     * Sets return_types
     *
     * @param string[]|null $return_types return_types
     *
     * @return self
     */
    public function setReturnTypes($return_types)
    {
        if (is_null($return_types)) {
            throw new \InvalidArgumentException('non-nullable return_types cannot be null');
        }
        $this->container['return_types'] = $return_types;

        return $this;
    }

    /**
     * Gets update_time_ge
     *
     * @return int|null
     */
    public function getUpdateTimeGe()
    {
        return $this->container['update_time_ge'];
    }

    /**
     * Sets update_time_ge
     *
     * @param int|null $update_time_ge update_time_ge
     *
     * @return self
     */
    public function setUpdateTimeGe($update_time_ge)
    {
        if (is_null($update_time_ge)) {
            throw new \InvalidArgumentException('non-nullable update_time_ge cannot be null');
        }
        $this->container['update_time_ge'] = $update_time_ge;

        return $this;
    }

    /**
     * Gets update_time_lt
     *
     * @return int|null
     */
    public function getUpdateTimeLt()
    {
        return $this->container['update_time_lt'];
    }

    /**
     * Sets update_time_lt
     *
     * @param int|null $update_time_lt update_time_lt
     *
     * @return self
     */
    public function setUpdateTimeLt($update_time_lt)
    {
        if (is_null($update_time_lt)) {
            throw new \InvalidArgumentException('non-nullable update_time_lt cannot be null');
        }
        $this->container['update_time_lt'] = $update_time_lt;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


