<?php
/**
 * SearchCancellationsRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * SearchCancellationsRequest Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SearchCancellationsRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SearchCancellationsRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'buyer_user_ids' => 'string[]',
        'cancel_ids' => 'string[]',
        'cancel_status' => 'string[]',
        'cancel_types' => 'string[]',
        'create_time_ge' => 'int',
        'create_time_lt' => 'int',
        'locale' => 'string',
        'order_ids' => 'string[]',
        'update_time_ge' => 'int',
        'update_time_lt' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'buyer_user_ids' => null,
        'cancel_ids' => null,
        'cancel_status' => null,
        'cancel_types' => null,
        'create_time_ge' => null,
        'create_time_lt' => null,
        'locale' => null,
        'order_ids' => null,
        'update_time_ge' => null,
        'update_time_lt' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'buyer_user_ids' => false,
        'cancel_ids' => false,
        'cancel_status' => false,
        'cancel_types' => false,
        'create_time_ge' => false,
        'create_time_lt' => false,
        'locale' => false,
        'order_ids' => false,
        'update_time_ge' => false,
        'update_time_lt' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'buyer_user_ids' => 'buyer_user_ids',
        'cancel_ids' => 'cancel_ids',
        'cancel_status' => 'cancel_status',
        'cancel_types' => 'cancel_types',
        'create_time_ge' => 'create_time_ge',
        'create_time_lt' => 'create_time_lt',
        'locale' => 'locale',
        'order_ids' => 'order_ids',
        'update_time_ge' => 'update_time_ge',
        'update_time_lt' => 'update_time_lt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'buyer_user_ids' => 'setBuyerUserIds',
        'cancel_ids' => 'setCancelIds',
        'cancel_status' => 'setCancelStatus',
        'cancel_types' => 'setCancelTypes',
        'create_time_ge' => 'setCreateTimeGe',
        'create_time_lt' => 'setCreateTimeLt',
        'locale' => 'setLocale',
        'order_ids' => 'setOrderIds',
        'update_time_ge' => 'setUpdateTimeGe',
        'update_time_lt' => 'setUpdateTimeLt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'buyer_user_ids' => 'getBuyerUserIds',
        'cancel_ids' => 'getCancelIds',
        'cancel_status' => 'getCancelStatus',
        'cancel_types' => 'getCancelTypes',
        'create_time_ge' => 'getCreateTimeGe',
        'create_time_lt' => 'getCreateTimeLt',
        'locale' => 'getLocale',
        'order_ids' => 'getOrderIds',
        'update_time_ge' => 'getUpdateTimeGe',
        'update_time_lt' => 'getUpdateTimeLt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('buyer_user_ids', $data ?? [], null);
        $this->setIfExists('cancel_ids', $data ?? [], null);
        $this->setIfExists('cancel_status', $data ?? [], null);
        $this->setIfExists('cancel_types', $data ?? [], null);
        $this->setIfExists('create_time_ge', $data ?? [], null);
        $this->setIfExists('create_time_lt', $data ?? [], null);
        $this->setIfExists('locale', $data ?? [], null);
        $this->setIfExists('order_ids', $data ?? [], null);
        $this->setIfExists('update_time_ge', $data ?? [], null);
        $this->setIfExists('update_time_lt', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets buyer_user_ids
     *
     * @return string[]|null
     */
    public function getBuyerUserIds()
    {
        return $this->container['buyer_user_ids'];
    }

    /**
     * Sets buyer_user_ids
     *
     * @param string[]|null $buyer_user_ids buyer_user_ids
     *
     * @return self
     */
    public function setBuyerUserIds($buyer_user_ids)
    {
        if (is_null($buyer_user_ids)) {
            throw new \InvalidArgumentException('non-nullable buyer_user_ids cannot be null');
        }
        $this->container['buyer_user_ids'] = $buyer_user_ids;

        return $this;
    }

    /**
     * Gets cancel_ids
     *
     * @return string[]|null
     */
    public function getCancelIds()
    {
        return $this->container['cancel_ids'];
    }

    /**
     * Sets cancel_ids
     *
     * @param string[]|null $cancel_ids cancel_ids
     *
     * @return self
     */
    public function setCancelIds($cancel_ids)
    {
        if (is_null($cancel_ids)) {
            throw new \InvalidArgumentException('non-nullable cancel_ids cannot be null');
        }
        $this->container['cancel_ids'] = $cancel_ids;

        return $this;
    }

    /**
     * Gets cancel_status
     *
     * @return string[]|null
     */
    public function getCancelStatus()
    {
        return $this->container['cancel_status'];
    }

    /**
     * Sets cancel_status
     *
     * @param string[]|null $cancel_status cancel_status
     *
     * @return self
     */
    public function setCancelStatus($cancel_status)
    {
        if (is_null($cancel_status)) {
            throw new \InvalidArgumentException('non-nullable cancel_status cannot be null');
        }
        $this->container['cancel_status'] = $cancel_status;

        return $this;
    }

    /**
     * Gets cancel_types
     *
     * @return string[]|null
     */
    public function getCancelTypes()
    {
        return $this->container['cancel_types'];
    }

    /**
     * Sets cancel_types
     *
     * @param string[]|null $cancel_types cancel_types
     *
     * @return self
     */
    public function setCancelTypes($cancel_types)
    {
        if (is_null($cancel_types)) {
            throw new \InvalidArgumentException('non-nullable cancel_types cannot be null');
        }
        $this->container['cancel_types'] = $cancel_types;

        return $this;
    }

    /**
     * Gets create_time_ge
     *
     * @return int|null
     */
    public function getCreateTimeGe()
    {
        return $this->container['create_time_ge'];
    }

    /**
     * Sets create_time_ge
     *
     * @param int|null $create_time_ge create_time_ge
     *
     * @return self
     */
    public function setCreateTimeGe($create_time_ge)
    {
        if (is_null($create_time_ge)) {
            throw new \InvalidArgumentException('non-nullable create_time_ge cannot be null');
        }
        $this->container['create_time_ge'] = $create_time_ge;

        return $this;
    }

    /**
     * Gets create_time_lt
     *
     * @return int|null
     */
    public function getCreateTimeLt()
    {
        return $this->container['create_time_lt'];
    }

    /**
     * Sets create_time_lt
     *
     * @param int|null $create_time_lt create_time_lt
     *
     * @return self
     */
    public function setCreateTimeLt($create_time_lt)
    {
        if (is_null($create_time_lt)) {
            throw new \InvalidArgumentException('non-nullable create_time_lt cannot be null');
        }
        $this->container['create_time_lt'] = $create_time_lt;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string|null
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string|null $locale locale
     *
     * @return self
     */
    public function setLocale($locale)
    {
        if (is_null($locale)) {
            throw new \InvalidArgumentException('non-nullable locale cannot be null');
        }
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets order_ids
     *
     * @return string[]|null
     */
    public function getOrderIds()
    {
        return $this->container['order_ids'];
    }

    /**
     * Sets order_ids
     *
     * @param string[]|null $order_ids order_ids
     *
     * @return self
     */
    public function setOrderIds($order_ids)
    {
        if (is_null($order_ids)) {
            throw new \InvalidArgumentException('non-nullable order_ids cannot be null');
        }
        $this->container['order_ids'] = $order_ids;

        return $this;
    }

    /**
     * Gets update_time_ge
     *
     * @return int|null
     */
    public function getUpdateTimeGe()
    {
        return $this->container['update_time_ge'];
    }

    /**
     * Sets update_time_ge
     *
     * @param int|null $update_time_ge update_time_ge
     *
     * @return self
     */
    public function setUpdateTimeGe($update_time_ge)
    {
        if (is_null($update_time_ge)) {
            throw new \InvalidArgumentException('non-nullable update_time_ge cannot be null');
        }
        $this->container['update_time_ge'] = $update_time_ge;

        return $this;
    }

    /**
     * Gets update_time_lt
     *
     * @return int|null
     */
    public function getUpdateTimeLt()
    {
        return $this->container['update_time_lt'];
    }

    /**
     * Sets update_time_lt
     *
     * @param int|null $update_time_lt update_time_lt
     *
     * @return self
     */
    public function setUpdateTimeLt($update_time_lt)
    {
        if (is_null($update_time_lt)) {
            throw new \InvalidArgumentException('non-nullable update_time_lt cannot be null');
        }
        $this->container['update_time_lt'] = $update_time_lt;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


