<?php
/**
 * ReturnOrder
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * ReturnOrder Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReturnOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReturnOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'arbitration_status' => 'string',
        'can_buyer_keep_item' => 'bool',
        'create_time' => 'int',
        'discount_amount' => '\Tiktok\Model\DiscountAmount[]',
        'handover_method' => 'string',
        'next_return_id' => 'string',
        'order_id' => 'string',
        'pre_return_id' => 'string',
        'refund_amount' => '\Tiktok\Model\RefundAmount',
        'return_id' => 'string',
        'return_line_items' => '\Tiktok\Model\ReturnLineItem[]',
        'return_provider_id' => 'string',
        'return_provider_name' => 'string',
        'return_reason' => 'string',
        'return_reason_text' => 'string',
        'return_status' => 'string',
        'return_tracking_number' => 'string',
        'return_type' => 'string',
        'role' => 'string',
        'seller_next_action_response' => '\Tiktok\Model\SellerNextActionResponse[]',
        'shipment_type' => 'string',
        'shipping_fee_amount' => '\Tiktok\Model\ShippingFeeAmount[]',
        'update_time' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'arbitration_status' => null,
        'can_buyer_keep_item' => null,
        'create_time' => null,
        'discount_amount' => null,
        'handover_method' => null,
        'next_return_id' => null,
        'order_id' => null,
        'pre_return_id' => null,
        'refund_amount' => null,
        'return_id' => null,
        'return_line_items' => null,
        'return_provider_id' => null,
        'return_provider_name' => null,
        'return_reason' => null,
        'return_reason_text' => null,
        'return_status' => null,
        'return_tracking_number' => null,
        'return_type' => null,
        'role' => null,
        'seller_next_action_response' => null,
        'shipment_type' => null,
        'shipping_fee_amount' => null,
        'update_time' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'arbitration_status' => false,
        'can_buyer_keep_item' => false,
        'create_time' => false,
        'discount_amount' => false,
        'handover_method' => false,
        'next_return_id' => false,
        'order_id' => false,
        'pre_return_id' => false,
        'refund_amount' => false,
        'return_id' => false,
        'return_line_items' => false,
        'return_provider_id' => false,
        'return_provider_name' => false,
        'return_reason' => false,
        'return_reason_text' => false,
        'return_status' => false,
        'return_tracking_number' => false,
        'return_type' => false,
        'role' => false,
        'seller_next_action_response' => false,
        'shipment_type' => false,
        'shipping_fee_amount' => false,
        'update_time' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'arbitration_status' => 'arbitration_status',
        'can_buyer_keep_item' => 'can_buyer_keep_item',
        'create_time' => 'create_time',
        'discount_amount' => 'discount_amount',
        'handover_method' => 'handover_method',
        'next_return_id' => 'next_return_id',
        'order_id' => 'order_id',
        'pre_return_id' => 'pre_return_id',
        'refund_amount' => 'refund_amount',
        'return_id' => 'return_id',
        'return_line_items' => 'return_line_items',
        'return_provider_id' => 'return_provider_id',
        'return_provider_name' => 'return_provider_name',
        'return_reason' => 'return_reason',
        'return_reason_text' => 'return_reason_text',
        'return_status' => 'return_status',
        'return_tracking_number' => 'return_tracking_number',
        'return_type' => 'return_type',
        'role' => 'role',
        'seller_next_action_response' => 'seller_next_action_response',
        'shipment_type' => 'shipment_type',
        'shipping_fee_amount' => 'shipping_fee_amount',
        'update_time' => 'update_time'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'arbitration_status' => 'setArbitrationStatus',
        'can_buyer_keep_item' => 'setCanBuyerKeepItem',
        'create_time' => 'setCreateTime',
        'discount_amount' => 'setDiscountAmount',
        'handover_method' => 'setHandoverMethod',
        'next_return_id' => 'setNextReturnId',
        'order_id' => 'setOrderId',
        'pre_return_id' => 'setPreReturnId',
        'refund_amount' => 'setRefundAmount',
        'return_id' => 'setReturnId',
        'return_line_items' => 'setReturnLineItems',
        'return_provider_id' => 'setReturnProviderId',
        'return_provider_name' => 'setReturnProviderName',
        'return_reason' => 'setReturnReason',
        'return_reason_text' => 'setReturnReasonText',
        'return_status' => 'setReturnStatus',
        'return_tracking_number' => 'setReturnTrackingNumber',
        'return_type' => 'setReturnType',
        'role' => 'setRole',
        'seller_next_action_response' => 'setSellerNextActionResponse',
        'shipment_type' => 'setShipmentType',
        'shipping_fee_amount' => 'setShippingFeeAmount',
        'update_time' => 'setUpdateTime'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'arbitration_status' => 'getArbitrationStatus',
        'can_buyer_keep_item' => 'getCanBuyerKeepItem',
        'create_time' => 'getCreateTime',
        'discount_amount' => 'getDiscountAmount',
        'handover_method' => 'getHandoverMethod',
        'next_return_id' => 'getNextReturnId',
        'order_id' => 'getOrderId',
        'pre_return_id' => 'getPreReturnId',
        'refund_amount' => 'getRefundAmount',
        'return_id' => 'getReturnId',
        'return_line_items' => 'getReturnLineItems',
        'return_provider_id' => 'getReturnProviderId',
        'return_provider_name' => 'getReturnProviderName',
        'return_reason' => 'getReturnReason',
        'return_reason_text' => 'getReturnReasonText',
        'return_status' => 'getReturnStatus',
        'return_tracking_number' => 'getReturnTrackingNumber',
        'return_type' => 'getReturnType',
        'role' => 'getRole',
        'seller_next_action_response' => 'getSellerNextActionResponse',
        'shipment_type' => 'getShipmentType',
        'shipping_fee_amount' => 'getShippingFeeAmount',
        'update_time' => 'getUpdateTime'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('arbitration_status', $data ?? [], null);
        $this->setIfExists('can_buyer_keep_item', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('discount_amount', $data ?? [], null);
        $this->setIfExists('handover_method', $data ?? [], null);
        $this->setIfExists('next_return_id', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('pre_return_id', $data ?? [], null);
        $this->setIfExists('refund_amount', $data ?? [], null);
        $this->setIfExists('return_id', $data ?? [], null);
        $this->setIfExists('return_line_items', $data ?? [], null);
        $this->setIfExists('return_provider_id', $data ?? [], null);
        $this->setIfExists('return_provider_name', $data ?? [], null);
        $this->setIfExists('return_reason', $data ?? [], null);
        $this->setIfExists('return_reason_text', $data ?? [], null);
        $this->setIfExists('return_status', $data ?? [], null);
        $this->setIfExists('return_tracking_number', $data ?? [], null);
        $this->setIfExists('return_type', $data ?? [], null);
        $this->setIfExists('role', $data ?? [], null);
        $this->setIfExists('seller_next_action_response', $data ?? [], null);
        $this->setIfExists('shipment_type', $data ?? [], null);
        $this->setIfExists('shipping_fee_amount', $data ?? [], null);
        $this->setIfExists('update_time', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets arbitration_status
     *
     * @return string|null
     */
    public function getArbitrationStatus()
    {
        return $this->container['arbitration_status'];
    }

    /**
     * Sets arbitration_status
     *
     * @param string|null $arbitration_status arbitration_status
     *
     * @return self
     */
    public function setArbitrationStatus($arbitration_status)
    {
        if (is_null($arbitration_status)) {
            throw new \InvalidArgumentException('non-nullable arbitration_status cannot be null');
        }
        $this->container['arbitration_status'] = $arbitration_status;

        return $this;
    }

    /**
     * Gets can_buyer_keep_item
     *
     * @return bool|null
     */
    public function getCanBuyerKeepItem()
    {
        return $this->container['can_buyer_keep_item'];
    }

    /**
     * Sets can_buyer_keep_item
     *
     * @param bool|null $can_buyer_keep_item can_buyer_keep_item
     *
     * @return self
     */
    public function setCanBuyerKeepItem($can_buyer_keep_item)
    {
        if (is_null($can_buyer_keep_item)) {
            throw new \InvalidArgumentException('non-nullable can_buyer_keep_item cannot be null');
        }
        $this->container['can_buyer_keep_item'] = $can_buyer_keep_item;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return int|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param int|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return \Tiktok\Model\DiscountAmount[]|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param \Tiktok\Model\DiscountAmount[]|null $discount_amount discount_amount
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        if (is_null($discount_amount)) {
            throw new \InvalidArgumentException('non-nullable discount_amount cannot be null');
        }
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets handover_method
     *
     * @return string|null
     */
    public function getHandoverMethod()
    {
        return $this->container['handover_method'];
    }

    /**
     * Sets handover_method
     *
     * @param string|null $handover_method handover_method
     *
     * @return self
     */
    public function setHandoverMethod($handover_method)
    {
        if (is_null($handover_method)) {
            throw new \InvalidArgumentException('non-nullable handover_method cannot be null');
        }
        $this->container['handover_method'] = $handover_method;

        return $this;
    }

    /**
     * Gets next_return_id
     *
     * @return string|null
     */
    public function getNextReturnId()
    {
        return $this->container['next_return_id'];
    }

    /**
     * Sets next_return_id
     *
     * @param string|null $next_return_id next_return_id
     *
     * @return self
     */
    public function setNextReturnId($next_return_id)
    {
        if (is_null($next_return_id)) {
            throw new \InvalidArgumentException('non-nullable next_return_id cannot be null');
        }
        $this->container['next_return_id'] = $next_return_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id order_id
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets pre_return_id
     *
     * @return string|null
     */
    public function getPreReturnId()
    {
        return $this->container['pre_return_id'];
    }

    /**
     * Sets pre_return_id
     *
     * @param string|null $pre_return_id pre_return_id
     *
     * @return self
     */
    public function setPreReturnId($pre_return_id)
    {
        if (is_null($pre_return_id)) {
            throw new \InvalidArgumentException('non-nullable pre_return_id cannot be null');
        }
        $this->container['pre_return_id'] = $pre_return_id;

        return $this;
    }

    /**
     * Gets refund_amount
     *
     * @return \Tiktok\Model\RefundAmount|null
     */
    public function getRefundAmount()
    {
        return $this->container['refund_amount'];
    }

    /**
     * Sets refund_amount
     *
     * @param \Tiktok\Model\RefundAmount|null $refund_amount refund_amount
     *
     * @return self
     */
    public function setRefundAmount($refund_amount)
    {
        if (is_null($refund_amount)) {
            throw new \InvalidArgumentException('non-nullable refund_amount cannot be null');
        }
        $this->container['refund_amount'] = $refund_amount;

        return $this;
    }

    /**
     * Gets return_id
     *
     * @return string|null
     */
    public function getReturnId()
    {
        return $this->container['return_id'];
    }

    /**
     * Sets return_id
     *
     * @param string|null $return_id return_id
     *
     * @return self
     */
    public function setReturnId($return_id)
    {
        if (is_null($return_id)) {
            throw new \InvalidArgumentException('non-nullable return_id cannot be null');
        }
        $this->container['return_id'] = $return_id;

        return $this;
    }

    /**
     * Gets return_line_items
     *
     * @return \Tiktok\Model\ReturnLineItem[]|null
     */
    public function getReturnLineItems()
    {
        return $this->container['return_line_items'];
    }

    /**
     * Sets return_line_items
     *
     * @param \Tiktok\Model\ReturnLineItem[]|null $return_line_items return_line_items
     *
     * @return self
     */
    public function setReturnLineItems($return_line_items)
    {
        if (is_null($return_line_items)) {
            throw new \InvalidArgumentException('non-nullable return_line_items cannot be null');
        }
        $this->container['return_line_items'] = $return_line_items;

        return $this;
    }

    /**
     * Gets return_provider_id
     *
     * @return string|null
     */
    public function getReturnProviderId()
    {
        return $this->container['return_provider_id'];
    }

    /**
     * Sets return_provider_id
     *
     * @param string|null $return_provider_id return_provider_id
     *
     * @return self
     */
    public function setReturnProviderId($return_provider_id)
    {
        if (is_null($return_provider_id)) {
            throw new \InvalidArgumentException('non-nullable return_provider_id cannot be null');
        }
        $this->container['return_provider_id'] = $return_provider_id;

        return $this;
    }

    /**
     * Gets return_provider_name
     *
     * @return string|null
     */
    public function getReturnProviderName()
    {
        return $this->container['return_provider_name'];
    }

    /**
     * Sets return_provider_name
     *
     * @param string|null $return_provider_name return_provider_name
     *
     * @return self
     */
    public function setReturnProviderName($return_provider_name)
    {
        if (is_null($return_provider_name)) {
            throw new \InvalidArgumentException('non-nullable return_provider_name cannot be null');
        }
        $this->container['return_provider_name'] = $return_provider_name;

        return $this;
    }

    /**
     * Gets return_reason
     *
     * @return string|null
     */
    public function getReturnReason()
    {
        return $this->container['return_reason'];
    }

    /**
     * Sets return_reason
     *
     * @param string|null $return_reason return_reason
     *
     * @return self
     */
    public function setReturnReason($return_reason)
    {
        if (is_null($return_reason)) {
            throw new \InvalidArgumentException('non-nullable return_reason cannot be null');
        }
        $this->container['return_reason'] = $return_reason;

        return $this;
    }

    /**
     * Gets return_reason_text
     *
     * @return string|null
     */
    public function getReturnReasonText()
    {
        return $this->container['return_reason_text'];
    }

    /**
     * Sets return_reason_text
     *
     * @param string|null $return_reason_text return_reason_text
     *
     * @return self
     */
    public function setReturnReasonText($return_reason_text)
    {
        if (is_null($return_reason_text)) {
            throw new \InvalidArgumentException('non-nullable return_reason_text cannot be null');
        }
        $this->container['return_reason_text'] = $return_reason_text;

        return $this;
    }

    /**
     * Gets return_status
     *
     * @return string|null
     */
    public function getReturnStatus()
    {
        return $this->container['return_status'];
    }

    /**
     * Sets return_status
     *
     * @param string|null $return_status return_status
     *
     * @return self
     */
    public function setReturnStatus($return_status)
    {
        if (is_null($return_status)) {
            throw new \InvalidArgumentException('non-nullable return_status cannot be null');
        }
        $this->container['return_status'] = $return_status;

        return $this;
    }

    /**
     * Gets return_tracking_number
     *
     * @return string|null
     */
    public function getReturnTrackingNumber()
    {
        return $this->container['return_tracking_number'];
    }

    /**
     * Sets return_tracking_number
     *
     * @param string|null $return_tracking_number return_tracking_number
     *
     * @return self
     */
    public function setReturnTrackingNumber($return_tracking_number)
    {
        if (is_null($return_tracking_number)) {
            throw new \InvalidArgumentException('non-nullable return_tracking_number cannot be null');
        }
        $this->container['return_tracking_number'] = $return_tracking_number;

        return $this;
    }

    /**
     * Gets return_type
     *
     * @return string|null
     */
    public function getReturnType()
    {
        return $this->container['return_type'];
    }

    /**
     * Sets return_type
     *
     * @param string|null $return_type return_type
     *
     * @return self
     */
    public function setReturnType($return_type)
    {
        if (is_null($return_type)) {
            throw new \InvalidArgumentException('non-nullable return_type cannot be null');
        }
        $this->container['return_type'] = $return_type;

        return $this;
    }

    /**
     * Gets role
     *
     * @return string|null
     */
    public function getRole()
    {
        return $this->container['role'];
    }

    /**
     * Sets role
     *
     * @param string|null $role role
     *
     * @return self
     */
    public function setRole($role)
    {
        if (is_null($role)) {
            throw new \InvalidArgumentException('non-nullable role cannot be null');
        }
        $this->container['role'] = $role;

        return $this;
    }

    /**
     * Gets seller_next_action_response
     *
     * @return \Tiktok\Model\SellerNextActionResponse[]|null
     */
    public function getSellerNextActionResponse()
    {
        return $this->container['seller_next_action_response'];
    }

    /**
     * Sets seller_next_action_response
     *
     * @param \Tiktok\Model\SellerNextActionResponse[]|null $seller_next_action_response seller_next_action_response
     *
     * @return self
     */
    public function setSellerNextActionResponse($seller_next_action_response)
    {
        if (is_null($seller_next_action_response)) {
            throw new \InvalidArgumentException('non-nullable seller_next_action_response cannot be null');
        }
        $this->container['seller_next_action_response'] = $seller_next_action_response;

        return $this;
    }

    /**
     * Gets shipment_type
     *
     * @return string|null
     */
    public function getShipmentType()
    {
        return $this->container['shipment_type'];
    }

    /**
     * Sets shipment_type
     *
     * @param string|null $shipment_type shipment_type
     *
     * @return self
     */
    public function setShipmentType($shipment_type)
    {
        if (is_null($shipment_type)) {
            throw new \InvalidArgumentException('non-nullable shipment_type cannot be null');
        }
        $this->container['shipment_type'] = $shipment_type;

        return $this;
    }

    /**
     * Gets shipping_fee_amount
     *
     * @return \Tiktok\Model\ShippingFeeAmount[]|null
     */
    public function getShippingFeeAmount()
    {
        return $this->container['shipping_fee_amount'];
    }

    /**
     * Sets shipping_fee_amount
     *
     * @param \Tiktok\Model\ShippingFeeAmount[]|null $shipping_fee_amount shipping_fee_amount
     *
     * @return self
     */
    public function setShippingFeeAmount($shipping_fee_amount)
    {
        if (is_null($shipping_fee_amount)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_amount cannot be null');
        }
        $this->container['shipping_fee_amount'] = $shipping_fee_amount;

        return $this;
    }

    /**
     * Gets update_time
     *
     * @return int|null
     */
    public function getUpdateTime()
    {
        return $this->container['update_time'];
    }

    /**
     * Sets update_time
     *
     * @param int|null $update_time update_time
     *
     * @return self
     */
    public function setUpdateTime($update_time)
    {
        if (is_null($update_time)) {
            throw new \InvalidArgumentException('non-nullable update_time cannot be null');
        }
        $this->container['update_time'] = $update_time;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


