<?php
/**
 * ProductSku
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * ProductSku Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductSku implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductSku';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'combined_skus' => '\Tiktok\Model\CombinedSku[]',
        'external_sku_id' => 'string',
        'external_urls' => 'string',
        'identifier_code' => '\Tiktok\Model\IdentifierCode',
        'inventory' => '\Tiktok\Model\WarehouseInventory[]',
        'price' => '\Tiktok\Model\ProductPrice',
        'sales_attributes' => '\Tiktok\Model\SalesAttribute[]',
        'seller_sku' => 'string',
        'sku_unit_count' => 'string',
        'id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'combined_skus' => null,
        'external_sku_id' => null,
        'external_urls' => null,
        'identifier_code' => null,
        'inventory' => null,
        'price' => null,
        'sales_attributes' => null,
        'seller_sku' => null,
        'sku_unit_count' => null,
        'id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'combined_skus' => false,
        'external_sku_id' => false,
        'external_urls' => false,
        'identifier_code' => false,
        'inventory' => false,
        'price' => false,
        'sales_attributes' => false,
        'seller_sku' => false,
        'sku_unit_count' => false,
        'id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'combined_skus' => 'combined_skus',
        'external_sku_id' => 'external_sku_id',
        'external_urls' => 'external_urls',
        'identifier_code' => 'identifier_code',
        'inventory' => 'inventory',
        'price' => 'price',
        'sales_attributes' => 'sales_attributes',
        'seller_sku' => 'seller_sku',
        'sku_unit_count' => 'sku_unit_count',
        'id' => 'id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'combined_skus' => 'setCombinedSkus',
        'external_sku_id' => 'setExternalSkuId',
        'external_urls' => 'setExternalUrls',
        'identifier_code' => 'setIdentifierCode',
        'inventory' => 'setInventory',
        'price' => 'setPrice',
        'sales_attributes' => 'setSalesAttributes',
        'seller_sku' => 'setSellerSku',
        'sku_unit_count' => 'setSkuUnitCount',
        'id' => 'setId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'combined_skus' => 'getCombinedSkus',
        'external_sku_id' => 'getExternalSkuId',
        'external_urls' => 'getExternalUrls',
        'identifier_code' => 'getIdentifierCode',
        'inventory' => 'getInventory',
        'price' => 'getPrice',
        'sales_attributes' => 'getSalesAttributes',
        'seller_sku' => 'getSellerSku',
        'sku_unit_count' => 'getSkuUnitCount',
        'id' => 'getId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('combined_skus', $data ?? [], null);
        $this->setIfExists('external_sku_id', $data ?? [], null);
        $this->setIfExists('external_urls', $data ?? [], null);
        $this->setIfExists('identifier_code', $data ?? [], null);
        $this->setIfExists('inventory', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('sales_attributes', $data ?? [], null);
        $this->setIfExists('seller_sku', $data ?? [], null);
        $this->setIfExists('sku_unit_count', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets combined_skus
     *
     * @return \Tiktok\Model\CombinedSku[]|null
     */
    public function getCombinedSkus()
    {
        return $this->container['combined_skus'];
    }

    /**
     * Sets combined_skus
     *
     * @param \Tiktok\Model\CombinedSku[]|null $combined_skus combined_skus
     *
     * @return self
     */
    public function setCombinedSkus($combined_skus)
    {
        if (is_null($combined_skus)) {
            throw new \InvalidArgumentException('non-nullable combined_skus cannot be null');
        }
        $this->container['combined_skus'] = $combined_skus;

        return $this;
    }

    /**
     * Gets external_sku_id
     *
     * @return string|null
     */
    public function getExternalSkuId()
    {
        return $this->container['external_sku_id'];
    }

    /**
     * Sets external_sku_id
     *
     * @param string|null $external_sku_id external_sku_id
     *
     * @return self
     */
    public function setExternalSkuId($external_sku_id)
    {
        if (is_null($external_sku_id)) {
            throw new \InvalidArgumentException('non-nullable external_sku_id cannot be null');
        }
        $this->container['external_sku_id'] = $external_sku_id;

        return $this;
    }

    /**
     * Gets external_urls
     *
     * @return string|null
     */
    public function getExternalUrls()
    {
        return $this->container['external_urls'];
    }

    /**
     * Sets external_urls
     *
     * @param string|null $external_urls external_urls
     *
     * @return self
     */
    public function setExternalUrls($external_urls)
    {
        if (is_null($external_urls)) {
            throw new \InvalidArgumentException('non-nullable external_urls cannot be null');
        }
        $this->container['external_urls'] = $external_urls;

        return $this;
    }

    /**
     * Gets identifier_code
     *
     * @return \Tiktok\Model\IdentifierCode|null
     */
    public function getIdentifierCode()
    {
        return $this->container['identifier_code'];
    }

    /**
     * Sets identifier_code
     *
     * @param \Tiktok\Model\IdentifierCode|null $identifier_code identifier_code
     *
     * @return self
     */
    public function setIdentifierCode($identifier_code)
    {
        if (is_null($identifier_code)) {
            throw new \InvalidArgumentException('non-nullable identifier_code cannot be null');
        }
        $this->container['identifier_code'] = $identifier_code;

        return $this;
    }

    /**
     * Gets inventory
     *
     * @return \Tiktok\Model\WarehouseInventory[]|null
     */
    public function getInventory()
    {
        return $this->container['inventory'];
    }

    /**
     * Sets inventory
     *
     * @param \Tiktok\Model\WarehouseInventory[]|null $inventory inventory
     *
     * @return self
     */
    public function setInventory($inventory)
    {
        if (is_null($inventory)) {
            throw new \InvalidArgumentException('non-nullable inventory cannot be null');
        }
        $this->container['inventory'] = $inventory;

        return $this;
    }

    /**
     * Gets price
     *
     * @return \Tiktok\Model\ProductPrice|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param \Tiktok\Model\ProductPrice|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets sales_attributes
     *
     * @return \Tiktok\Model\SalesAttribute[]|null
     */
    public function getSalesAttributes()
    {
        return $this->container['sales_attributes'];
    }

    /**
     * Sets sales_attributes
     *
     * @param \Tiktok\Model\SalesAttribute[]|null $sales_attributes sales_attributes
     *
     * @return self
     */
    public function setSalesAttributes($sales_attributes)
    {
        if (is_null($sales_attributes)) {
            throw new \InvalidArgumentException('non-nullable sales_attributes cannot be null');
        }
        $this->container['sales_attributes'] = $sales_attributes;

        return $this;
    }

    /**
     * Gets seller_sku
     *
     * @return string|null
     */
    public function getSellerSku()
    {
        return $this->container['seller_sku'];
    }

    /**
     * Sets seller_sku
     *
     * @param string|null $seller_sku seller_sku
     *
     * @return self
     */
    public function setSellerSku($seller_sku)
    {
        if (is_null($seller_sku)) {
            throw new \InvalidArgumentException('non-nullable seller_sku cannot be null');
        }
        $this->container['seller_sku'] = $seller_sku;

        return $this;
    }

    /**
     * Gets sku_unit_count
     *
     * @return string|null
     */
    public function getSkuUnitCount()
    {
        return $this->container['sku_unit_count'];
    }

    /**
     * Sets sku_unit_count
     *
     * @param string|null $sku_unit_count sku_unit_count
     *
     * @return self
     */
    public function setSkuUnitCount($sku_unit_count)
    {
        if (is_null($sku_unit_count)) {
            throw new \InvalidArgumentException('non-nullable sku_unit_count cannot be null');
        }
        $this->container['sku_unit_count'] = $sku_unit_count;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


