<?php
/**
 * ProductSearch
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * ProductSearch Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ProductSearch implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductSearch';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'create_time_ge' => 'int',
        'create_time_le' => 'int',
        'seller_skus' => 'string[]',
        'status' => 'string',
        'update_time_ge' => 'int',
        'update_time_le' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'create_time_ge' => null,
        'create_time_le' => null,
        'seller_skus' => null,
        'status' => null,
        'update_time_ge' => null,
        'update_time_le' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'create_time_ge' => false,
        'create_time_le' => false,
        'seller_skus' => false,
        'status' => false,
        'update_time_ge' => false,
        'update_time_le' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'create_time_ge' => 'create_time_ge',
        'create_time_le' => 'create_time_le',
        'seller_skus' => 'seller_skus',
        'status' => 'status',
        'update_time_ge' => 'update_time_ge',
        'update_time_le' => 'update_time_le'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'create_time_ge' => 'setCreateTimeGe',
        'create_time_le' => 'setCreateTimeLe',
        'seller_skus' => 'setSellerSkus',
        'status' => 'setStatus',
        'update_time_ge' => 'setUpdateTimeGe',
        'update_time_le' => 'setUpdateTimeLe'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'create_time_ge' => 'getCreateTimeGe',
        'create_time_le' => 'getCreateTimeLe',
        'seller_skus' => 'getSellerSkus',
        'status' => 'getStatus',
        'update_time_ge' => 'getUpdateTimeGe',
        'update_time_le' => 'getUpdateTimeLe'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('create_time_ge', $data ?? [], null);
        $this->setIfExists('create_time_le', $data ?? [], null);
        $this->setIfExists('seller_skus', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('update_time_ge', $data ?? [], null);
        $this->setIfExists('update_time_le', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets create_time_ge
     *
     * @return int|null
     */
    public function getCreateTimeGe()
    {
        return $this->container['create_time_ge'];
    }

    /**
     * Sets create_time_ge
     *
     * @param int|null $create_time_ge create_time_ge
     *
     * @return self
     */
    public function setCreateTimeGe($create_time_ge)
    {
        if (is_null($create_time_ge)) {
            throw new \InvalidArgumentException('non-nullable create_time_ge cannot be null');
        }
        $this->container['create_time_ge'] = $create_time_ge;

        return $this;
    }

    /**
     * Gets create_time_le
     *
     * @return int|null
     */
    public function getCreateTimeLe()
    {
        return $this->container['create_time_le'];
    }

    /**
     * Sets create_time_le
     *
     * @param int|null $create_time_le create_time_le
     *
     * @return self
     */
    public function setCreateTimeLe($create_time_le)
    {
        if (is_null($create_time_le)) {
            throw new \InvalidArgumentException('non-nullable create_time_le cannot be null');
        }
        $this->container['create_time_le'] = $create_time_le;

        return $this;
    }

    /**
     * Gets seller_skus
     *
     * @return string[]|null
     */
    public function getSellerSkus()
    {
        return $this->container['seller_skus'];
    }

    /**
     * Sets seller_skus
     *
     * @param string[]|null $seller_skus seller_skus
     *
     * @return self
     */
    public function setSellerSkus($seller_skus)
    {
        if (is_null($seller_skus)) {
            throw new \InvalidArgumentException('non-nullable seller_skus cannot be null');
        }
        $this->container['seller_skus'] = $seller_skus;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets update_time_ge
     *
     * @return int|null
     */
    public function getUpdateTimeGe()
    {
        return $this->container['update_time_ge'];
    }

    /**
     * Sets update_time_ge
     *
     * @param int|null $update_time_ge update_time_ge
     *
     * @return self
     */
    public function setUpdateTimeGe($update_time_ge)
    {
        if (is_null($update_time_ge)) {
            throw new \InvalidArgumentException('non-nullable update_time_ge cannot be null');
        }
        $this->container['update_time_ge'] = $update_time_ge;

        return $this;
    }

    /**
     * Gets update_time_le
     *
     * @return int|null
     */
    public function getUpdateTimeLe()
    {
        return $this->container['update_time_le'];
    }

    /**
     * Sets update_time_le
     *
     * @param int|null $update_time_le update_time_le
     *
     * @return self
     */
    public function setUpdateTimeLe($update_time_le)
    {
        if (is_null($update_time_le)) {
            throw new \InvalidArgumentException('non-nullable update_time_le cannot be null');
        }
        $this->container['update_time_le'] = $update_time_le;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


