<?php
/**
 * PriceDetailItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * PriceDetailItem Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PriceDetailItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PriceDetailItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cod_fee' => 'string',
        'cod_fee_amount' => 'string',
        'currency' => 'string',
        'id' => 'string',
        'net_price_amount' => 'string',
        'payment' => 'string',
        'shipping_fee_deduction_platform' => 'string',
        'shipping_fee_deduction_platform_voucher' => 'string',
        'shipping_fee_deduction_seller' => 'string',
        'shipping_list_price' => 'string',
        'shipping_sale_price' => 'string',
        'sku_gift_net_price' => 'string',
        'sku_gift_original_price' => 'string',
        'sku_list_price' => 'string',
        'sku_sale_price' => 'string',
        'subtotal' => 'string',
        'subtotal_deduction_platform' => 'string',
        'subtotal_deduction_seller' => 'string',
        'subtotal_tax_amount' => 'string',
        'tax_amount' => 'string',
        'tax_rate' => 'string',
        'total' => 'string',
        'voucher_deduction_platform' => 'string',
        'voucher_deduction_seller' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cod_fee' => null,
        'cod_fee_amount' => null,
        'currency' => null,
        'id' => null,
        'net_price_amount' => null,
        'payment' => null,
        'shipping_fee_deduction_platform' => null,
        'shipping_fee_deduction_platform_voucher' => null,
        'shipping_fee_deduction_seller' => null,
        'shipping_list_price' => null,
        'shipping_sale_price' => null,
        'sku_gift_net_price' => null,
        'sku_gift_original_price' => null,
        'sku_list_price' => null,
        'sku_sale_price' => null,
        'subtotal' => null,
        'subtotal_deduction_platform' => null,
        'subtotal_deduction_seller' => null,
        'subtotal_tax_amount' => null,
        'tax_amount' => null,
        'tax_rate' => null,
        'total' => null,
        'voucher_deduction_platform' => null,
        'voucher_deduction_seller' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'cod_fee' => false,
        'cod_fee_amount' => false,
        'currency' => false,
        'id' => false,
        'net_price_amount' => false,
        'payment' => false,
        'shipping_fee_deduction_platform' => false,
        'shipping_fee_deduction_platform_voucher' => false,
        'shipping_fee_deduction_seller' => false,
        'shipping_list_price' => false,
        'shipping_sale_price' => false,
        'sku_gift_net_price' => false,
        'sku_gift_original_price' => false,
        'sku_list_price' => false,
        'sku_sale_price' => false,
        'subtotal' => false,
        'subtotal_deduction_platform' => false,
        'subtotal_deduction_seller' => false,
        'subtotal_tax_amount' => false,
        'tax_amount' => false,
        'tax_rate' => false,
        'total' => false,
        'voucher_deduction_platform' => false,
        'voucher_deduction_seller' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cod_fee' => 'cod_fee',
        'cod_fee_amount' => 'cod_fee_amount',
        'currency' => 'currency',
        'id' => 'id',
        'net_price_amount' => 'net_price_amount',
        'payment' => 'payment',
        'shipping_fee_deduction_platform' => 'shipping_fee_deduction_platform',
        'shipping_fee_deduction_platform_voucher' => 'shipping_fee_deduction_platform_voucher',
        'shipping_fee_deduction_seller' => 'shipping_fee_deduction_seller',
        'shipping_list_price' => 'shipping_list_price',
        'shipping_sale_price' => 'shipping_sale_price',
        'sku_gift_net_price' => 'sku_gift_net_price',
        'sku_gift_original_price' => 'sku_gift_original_price',
        'sku_list_price' => 'sku_list_price',
        'sku_sale_price' => 'sku_sale_price',
        'subtotal' => 'subtotal',
        'subtotal_deduction_platform' => 'subtotal_deduction_platform',
        'subtotal_deduction_seller' => 'subtotal_deduction_seller',
        'subtotal_tax_amount' => 'subtotal_tax_amount',
        'tax_amount' => 'tax_amount',
        'tax_rate' => 'tax_rate',
        'total' => 'total',
        'voucher_deduction_platform' => 'voucher_deduction_platform',
        'voucher_deduction_seller' => 'voucher_deduction_seller'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cod_fee' => 'setCodFee',
        'cod_fee_amount' => 'setCodFeeAmount',
        'currency' => 'setCurrency',
        'id' => 'setId',
        'net_price_amount' => 'setNetPriceAmount',
        'payment' => 'setPayment',
        'shipping_fee_deduction_platform' => 'setShippingFeeDeductionPlatform',
        'shipping_fee_deduction_platform_voucher' => 'setShippingFeeDeductionPlatformVoucher',
        'shipping_fee_deduction_seller' => 'setShippingFeeDeductionSeller',
        'shipping_list_price' => 'setShippingListPrice',
        'shipping_sale_price' => 'setShippingSalePrice',
        'sku_gift_net_price' => 'setSkuGiftNetPrice',
        'sku_gift_original_price' => 'setSkuGiftOriginalPrice',
        'sku_list_price' => 'setSkuListPrice',
        'sku_sale_price' => 'setSkuSalePrice',
        'subtotal' => 'setSubtotal',
        'subtotal_deduction_platform' => 'setSubtotalDeductionPlatform',
        'subtotal_deduction_seller' => 'setSubtotalDeductionSeller',
        'subtotal_tax_amount' => 'setSubtotalTaxAmount',
        'tax_amount' => 'setTaxAmount',
        'tax_rate' => 'setTaxRate',
        'total' => 'setTotal',
        'voucher_deduction_platform' => 'setVoucherDeductionPlatform',
        'voucher_deduction_seller' => 'setVoucherDeductionSeller'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cod_fee' => 'getCodFee',
        'cod_fee_amount' => 'getCodFeeAmount',
        'currency' => 'getCurrency',
        'id' => 'getId',
        'net_price_amount' => 'getNetPriceAmount',
        'payment' => 'getPayment',
        'shipping_fee_deduction_platform' => 'getShippingFeeDeductionPlatform',
        'shipping_fee_deduction_platform_voucher' => 'getShippingFeeDeductionPlatformVoucher',
        'shipping_fee_deduction_seller' => 'getShippingFeeDeductionSeller',
        'shipping_list_price' => 'getShippingListPrice',
        'shipping_sale_price' => 'getShippingSalePrice',
        'sku_gift_net_price' => 'getSkuGiftNetPrice',
        'sku_gift_original_price' => 'getSkuGiftOriginalPrice',
        'sku_list_price' => 'getSkuListPrice',
        'sku_sale_price' => 'getSkuSalePrice',
        'subtotal' => 'getSubtotal',
        'subtotal_deduction_platform' => 'getSubtotalDeductionPlatform',
        'subtotal_deduction_seller' => 'getSubtotalDeductionSeller',
        'subtotal_tax_amount' => 'getSubtotalTaxAmount',
        'tax_amount' => 'getTaxAmount',
        'tax_rate' => 'getTaxRate',
        'total' => 'getTotal',
        'voucher_deduction_platform' => 'getVoucherDeductionPlatform',
        'voucher_deduction_seller' => 'getVoucherDeductionSeller'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cod_fee', $data ?? [], null);
        $this->setIfExists('cod_fee_amount', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('net_price_amount', $data ?? [], null);
        $this->setIfExists('payment', $data ?? [], null);
        $this->setIfExists('shipping_fee_deduction_platform', $data ?? [], null);
        $this->setIfExists('shipping_fee_deduction_platform_voucher', $data ?? [], null);
        $this->setIfExists('shipping_fee_deduction_seller', $data ?? [], null);
        $this->setIfExists('shipping_list_price', $data ?? [], null);
        $this->setIfExists('shipping_sale_price', $data ?? [], null);
        $this->setIfExists('sku_gift_net_price', $data ?? [], null);
        $this->setIfExists('sku_gift_original_price', $data ?? [], null);
        $this->setIfExists('sku_list_price', $data ?? [], null);
        $this->setIfExists('sku_sale_price', $data ?? [], null);
        $this->setIfExists('subtotal', $data ?? [], null);
        $this->setIfExists('subtotal_deduction_platform', $data ?? [], null);
        $this->setIfExists('subtotal_deduction_seller', $data ?? [], null);
        $this->setIfExists('subtotal_tax_amount', $data ?? [], null);
        $this->setIfExists('tax_amount', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('voucher_deduction_platform', $data ?? [], null);
        $this->setIfExists('voucher_deduction_seller', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cod_fee
     *
     * @return string|null
     */
    public function getCodFee()
    {
        return $this->container['cod_fee'];
    }

    /**
     * Sets cod_fee
     *
     * @param string|null $cod_fee cod_fee
     *
     * @return self
     */
    public function setCodFee($cod_fee)
    {
        if (is_null($cod_fee)) {
            throw new \InvalidArgumentException('non-nullable cod_fee cannot be null');
        }
        $this->container['cod_fee'] = $cod_fee;

        return $this;
    }

    /**
     * Gets cod_fee_amount
     *
     * @return string|null
     */
    public function getCodFeeAmount()
    {
        return $this->container['cod_fee_amount'];
    }

    /**
     * Sets cod_fee_amount
     *
     * @param string|null $cod_fee_amount cod_fee_amount
     *
     * @return self
     */
    public function setCodFeeAmount($cod_fee_amount)
    {
        if (is_null($cod_fee_amount)) {
            throw new \InvalidArgumentException('non-nullable cod_fee_amount cannot be null');
        }
        $this->container['cod_fee_amount'] = $cod_fee_amount;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets net_price_amount
     *
     * @return string|null
     */
    public function getNetPriceAmount()
    {
        return $this->container['net_price_amount'];
    }

    /**
     * Sets net_price_amount
     *
     * @param string|null $net_price_amount net_price_amount
     *
     * @return self
     */
    public function setNetPriceAmount($net_price_amount)
    {
        if (is_null($net_price_amount)) {
            throw new \InvalidArgumentException('non-nullable net_price_amount cannot be null');
        }
        $this->container['net_price_amount'] = $net_price_amount;

        return $this;
    }

    /**
     * Gets payment
     *
     * @return string|null
     */
    public function getPayment()
    {
        return $this->container['payment'];
    }

    /**
     * Sets payment
     *
     * @param string|null $payment payment
     *
     * @return self
     */
    public function setPayment($payment)
    {
        if (is_null($payment)) {
            throw new \InvalidArgumentException('non-nullable payment cannot be null');
        }
        $this->container['payment'] = $payment;

        return $this;
    }

    /**
     * Gets shipping_fee_deduction_platform
     *
     * @return string|null
     */
    public function getShippingFeeDeductionPlatform()
    {
        return $this->container['shipping_fee_deduction_platform'];
    }

    /**
     * Sets shipping_fee_deduction_platform
     *
     * @param string|null $shipping_fee_deduction_platform shipping_fee_deduction_platform
     *
     * @return self
     */
    public function setShippingFeeDeductionPlatform($shipping_fee_deduction_platform)
    {
        if (is_null($shipping_fee_deduction_platform)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_deduction_platform cannot be null');
        }
        $this->container['shipping_fee_deduction_platform'] = $shipping_fee_deduction_platform;

        return $this;
    }

    /**
     * Gets shipping_fee_deduction_platform_voucher
     *
     * @return string|null
     */
    public function getShippingFeeDeductionPlatformVoucher()
    {
        return $this->container['shipping_fee_deduction_platform_voucher'];
    }

    /**
     * Sets shipping_fee_deduction_platform_voucher
     *
     * @param string|null $shipping_fee_deduction_platform_voucher shipping_fee_deduction_platform_voucher
     *
     * @return self
     */
    public function setShippingFeeDeductionPlatformVoucher($shipping_fee_deduction_platform_voucher)
    {
        if (is_null($shipping_fee_deduction_platform_voucher)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_deduction_platform_voucher cannot be null');
        }
        $this->container['shipping_fee_deduction_platform_voucher'] = $shipping_fee_deduction_platform_voucher;

        return $this;
    }

    /**
     * Gets shipping_fee_deduction_seller
     *
     * @return string|null
     */
    public function getShippingFeeDeductionSeller()
    {
        return $this->container['shipping_fee_deduction_seller'];
    }

    /**
     * Sets shipping_fee_deduction_seller
     *
     * @param string|null $shipping_fee_deduction_seller shipping_fee_deduction_seller
     *
     * @return self
     */
    public function setShippingFeeDeductionSeller($shipping_fee_deduction_seller)
    {
        if (is_null($shipping_fee_deduction_seller)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_deduction_seller cannot be null');
        }
        $this->container['shipping_fee_deduction_seller'] = $shipping_fee_deduction_seller;

        return $this;
    }

    /**
     * Gets shipping_list_price
     *
     * @return string|null
     */
    public function getShippingListPrice()
    {
        return $this->container['shipping_list_price'];
    }

    /**
     * Sets shipping_list_price
     *
     * @param string|null $shipping_list_price shipping_list_price
     *
     * @return self
     */
    public function setShippingListPrice($shipping_list_price)
    {
        if (is_null($shipping_list_price)) {
            throw new \InvalidArgumentException('non-nullable shipping_list_price cannot be null');
        }
        $this->container['shipping_list_price'] = $shipping_list_price;

        return $this;
    }

    /**
     * Gets shipping_sale_price
     *
     * @return string|null
     */
    public function getShippingSalePrice()
    {
        return $this->container['shipping_sale_price'];
    }

    /**
     * Sets shipping_sale_price
     *
     * @param string|null $shipping_sale_price shipping_sale_price
     *
     * @return self
     */
    public function setShippingSalePrice($shipping_sale_price)
    {
        if (is_null($shipping_sale_price)) {
            throw new \InvalidArgumentException('non-nullable shipping_sale_price cannot be null');
        }
        $this->container['shipping_sale_price'] = $shipping_sale_price;

        return $this;
    }

    /**
     * Gets sku_gift_net_price
     *
     * @return string|null
     */
    public function getSkuGiftNetPrice()
    {
        return $this->container['sku_gift_net_price'];
    }

    /**
     * Sets sku_gift_net_price
     *
     * @param string|null $sku_gift_net_price sku_gift_net_price
     *
     * @return self
     */
    public function setSkuGiftNetPrice($sku_gift_net_price)
    {
        if (is_null($sku_gift_net_price)) {
            throw new \InvalidArgumentException('non-nullable sku_gift_net_price cannot be null');
        }
        $this->container['sku_gift_net_price'] = $sku_gift_net_price;

        return $this;
    }

    /**
     * Gets sku_gift_original_price
     *
     * @return string|null
     */
    public function getSkuGiftOriginalPrice()
    {
        return $this->container['sku_gift_original_price'];
    }

    /**
     * Sets sku_gift_original_price
     *
     * @param string|null $sku_gift_original_price sku_gift_original_price
     *
     * @return self
     */
    public function setSkuGiftOriginalPrice($sku_gift_original_price)
    {
        if (is_null($sku_gift_original_price)) {
            throw new \InvalidArgumentException('non-nullable sku_gift_original_price cannot be null');
        }
        $this->container['sku_gift_original_price'] = $sku_gift_original_price;

        return $this;
    }

    /**
     * Gets sku_list_price
     *
     * @return string|null
     */
    public function getSkuListPrice()
    {
        return $this->container['sku_list_price'];
    }

    /**
     * Sets sku_list_price
     *
     * @param string|null $sku_list_price sku_list_price
     *
     * @return self
     */
    public function setSkuListPrice($sku_list_price)
    {
        if (is_null($sku_list_price)) {
            throw new \InvalidArgumentException('non-nullable sku_list_price cannot be null');
        }
        $this->container['sku_list_price'] = $sku_list_price;

        return $this;
    }

    /**
     * Gets sku_sale_price
     *
     * @return string|null
     */
    public function getSkuSalePrice()
    {
        return $this->container['sku_sale_price'];
    }

    /**
     * Sets sku_sale_price
     *
     * @param string|null $sku_sale_price sku_sale_price
     *
     * @return self
     */
    public function setSkuSalePrice($sku_sale_price)
    {
        if (is_null($sku_sale_price)) {
            throw new \InvalidArgumentException('non-nullable sku_sale_price cannot be null');
        }
        $this->container['sku_sale_price'] = $sku_sale_price;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return string|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param string|null $subtotal subtotal
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        if (is_null($subtotal)) {
            throw new \InvalidArgumentException('non-nullable subtotal cannot be null');
        }
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets subtotal_deduction_platform
     *
     * @return string|null
     */
    public function getSubtotalDeductionPlatform()
    {
        return $this->container['subtotal_deduction_platform'];
    }

    /**
     * Sets subtotal_deduction_platform
     *
     * @param string|null $subtotal_deduction_platform subtotal_deduction_platform
     *
     * @return self
     */
    public function setSubtotalDeductionPlatform($subtotal_deduction_platform)
    {
        if (is_null($subtotal_deduction_platform)) {
            throw new \InvalidArgumentException('non-nullable subtotal_deduction_platform cannot be null');
        }
        $this->container['subtotal_deduction_platform'] = $subtotal_deduction_platform;

        return $this;
    }

    /**
     * Gets subtotal_deduction_seller
     *
     * @return string|null
     */
    public function getSubtotalDeductionSeller()
    {
        return $this->container['subtotal_deduction_seller'];
    }

    /**
     * Sets subtotal_deduction_seller
     *
     * @param string|null $subtotal_deduction_seller subtotal_deduction_seller
     *
     * @return self
     */
    public function setSubtotalDeductionSeller($subtotal_deduction_seller)
    {
        if (is_null($subtotal_deduction_seller)) {
            throw new \InvalidArgumentException('non-nullable subtotal_deduction_seller cannot be null');
        }
        $this->container['subtotal_deduction_seller'] = $subtotal_deduction_seller;

        return $this;
    }

    /**
     * Gets subtotal_tax_amount
     *
     * @return string|null
     */
    public function getSubtotalTaxAmount()
    {
        return $this->container['subtotal_tax_amount'];
    }

    /**
     * Sets subtotal_tax_amount
     *
     * @param string|null $subtotal_tax_amount subtotal_tax_amount
     *
     * @return self
     */
    public function setSubtotalTaxAmount($subtotal_tax_amount)
    {
        if (is_null($subtotal_tax_amount)) {
            throw new \InvalidArgumentException('non-nullable subtotal_tax_amount cannot be null');
        }
        $this->container['subtotal_tax_amount'] = $subtotal_tax_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return string|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param string|null $tax_amount tax_amount
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        if (is_null($tax_amount)) {
            throw new \InvalidArgumentException('non-nullable tax_amount cannot be null');
        }
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return string|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param string|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets total
     *
     * @return string|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param string|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets voucher_deduction_platform
     *
     * @return string|null
     */
    public function getVoucherDeductionPlatform()
    {
        return $this->container['voucher_deduction_platform'];
    }

    /**
     * Sets voucher_deduction_platform
     *
     * @param string|null $voucher_deduction_platform voucher_deduction_platform
     *
     * @return self
     */
    public function setVoucherDeductionPlatform($voucher_deduction_platform)
    {
        if (is_null($voucher_deduction_platform)) {
            throw new \InvalidArgumentException('non-nullable voucher_deduction_platform cannot be null');
        }
        $this->container['voucher_deduction_platform'] = $voucher_deduction_platform;

        return $this;
    }

    /**
     * Gets voucher_deduction_seller
     *
     * @return string|null
     */
    public function getVoucherDeductionSeller()
    {
        return $this->container['voucher_deduction_seller'];
    }

    /**
     * Sets voucher_deduction_seller
     *
     * @param string|null $voucher_deduction_seller voucher_deduction_seller
     *
     * @return self
     */
    public function setVoucherDeductionSeller($voucher_deduction_seller)
    {
        if (is_null($voucher_deduction_seller)) {
            throw new \InvalidArgumentException('non-nullable voucher_deduction_seller cannot be null');
        }
        $this->container['voucher_deduction_seller'] = $voucher_deduction_seller;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


