<?php
/**
 * Payment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * Payment Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Payment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Payment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'buyer_service_fee' => 'string',
        'currency' => 'string',
        'original_shipping_fee' => 'string',
        'original_total_product_price' => 'string',
        'platform_discount' => 'string',
        'product_tax' => 'string',
        'retail_delivery_fee' => 'string',
        'seller_discount' => 'string',
        'shipping_fee' => 'string',
        'shipping_fee_platform_discount' => 'string',
        'shipping_fee_seller_discount' => 'string',
        'shipping_fee_tax' => 'string',
        'small_order_fee' => 'string',
        'sub_total' => 'string',
        'tax' => 'string',
        'total_amount' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'buyer_service_fee' => null,
        'currency' => null,
        'original_shipping_fee' => null,
        'original_total_product_price' => null,
        'platform_discount' => null,
        'product_tax' => null,
        'retail_delivery_fee' => null,
        'seller_discount' => null,
        'shipping_fee' => null,
        'shipping_fee_platform_discount' => null,
        'shipping_fee_seller_discount' => null,
        'shipping_fee_tax' => null,
        'small_order_fee' => null,
        'sub_total' => null,
        'tax' => null,
        'total_amount' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'buyer_service_fee' => false,
        'currency' => false,
        'original_shipping_fee' => false,
        'original_total_product_price' => false,
        'platform_discount' => false,
        'product_tax' => false,
        'retail_delivery_fee' => false,
        'seller_discount' => false,
        'shipping_fee' => false,
        'shipping_fee_platform_discount' => false,
        'shipping_fee_seller_discount' => false,
        'shipping_fee_tax' => false,
        'small_order_fee' => false,
        'sub_total' => false,
        'tax' => false,
        'total_amount' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'buyer_service_fee' => 'buyer_service_fee',
        'currency' => 'currency',
        'original_shipping_fee' => 'original_shipping_fee',
        'original_total_product_price' => 'original_total_product_price',
        'platform_discount' => 'platform_discount',
        'product_tax' => 'product_tax',
        'retail_delivery_fee' => 'retail_delivery_fee',
        'seller_discount' => 'seller_discount',
        'shipping_fee' => 'shipping_fee',
        'shipping_fee_platform_discount' => 'shipping_fee_platform_discount',
        'shipping_fee_seller_discount' => 'shipping_fee_seller_discount',
        'shipping_fee_tax' => 'shipping_fee_tax',
        'small_order_fee' => 'small_order_fee',
        'sub_total' => 'sub_total',
        'tax' => 'tax',
        'total_amount' => 'total_amount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'buyer_service_fee' => 'setBuyerServiceFee',
        'currency' => 'setCurrency',
        'original_shipping_fee' => 'setOriginalShippingFee',
        'original_total_product_price' => 'setOriginalTotalProductPrice',
        'platform_discount' => 'setPlatformDiscount',
        'product_tax' => 'setProductTax',
        'retail_delivery_fee' => 'setRetailDeliveryFee',
        'seller_discount' => 'setSellerDiscount',
        'shipping_fee' => 'setShippingFee',
        'shipping_fee_platform_discount' => 'setShippingFeePlatformDiscount',
        'shipping_fee_seller_discount' => 'setShippingFeeSellerDiscount',
        'shipping_fee_tax' => 'setShippingFeeTax',
        'small_order_fee' => 'setSmallOrderFee',
        'sub_total' => 'setSubTotal',
        'tax' => 'setTax',
        'total_amount' => 'setTotalAmount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'buyer_service_fee' => 'getBuyerServiceFee',
        'currency' => 'getCurrency',
        'original_shipping_fee' => 'getOriginalShippingFee',
        'original_total_product_price' => 'getOriginalTotalProductPrice',
        'platform_discount' => 'getPlatformDiscount',
        'product_tax' => 'getProductTax',
        'retail_delivery_fee' => 'getRetailDeliveryFee',
        'seller_discount' => 'getSellerDiscount',
        'shipping_fee' => 'getShippingFee',
        'shipping_fee_platform_discount' => 'getShippingFeePlatformDiscount',
        'shipping_fee_seller_discount' => 'getShippingFeeSellerDiscount',
        'shipping_fee_tax' => 'getShippingFeeTax',
        'small_order_fee' => 'getSmallOrderFee',
        'sub_total' => 'getSubTotal',
        'tax' => 'getTax',
        'total_amount' => 'getTotalAmount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('buyer_service_fee', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('original_shipping_fee', $data ?? [], null);
        $this->setIfExists('original_total_product_price', $data ?? [], null);
        $this->setIfExists('platform_discount', $data ?? [], null);
        $this->setIfExists('product_tax', $data ?? [], null);
        $this->setIfExists('retail_delivery_fee', $data ?? [], null);
        $this->setIfExists('seller_discount', $data ?? [], null);
        $this->setIfExists('shipping_fee', $data ?? [], null);
        $this->setIfExists('shipping_fee_platform_discount', $data ?? [], null);
        $this->setIfExists('shipping_fee_seller_discount', $data ?? [], null);
        $this->setIfExists('shipping_fee_tax', $data ?? [], null);
        $this->setIfExists('small_order_fee', $data ?? [], null);
        $this->setIfExists('sub_total', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('total_amount', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets buyer_service_fee
     *
     * @return string|null
     */
    public function getBuyerServiceFee()
    {
        return $this->container['buyer_service_fee'];
    }

    /**
     * Sets buyer_service_fee
     *
     * @param string|null $buyer_service_fee buyer_service_fee
     *
     * @return self
     */
    public function setBuyerServiceFee($buyer_service_fee)
    {
        if (is_null($buyer_service_fee)) {
            throw new \InvalidArgumentException('non-nullable buyer_service_fee cannot be null');
        }
        $this->container['buyer_service_fee'] = $buyer_service_fee;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets original_shipping_fee
     *
     * @return string|null
     */
    public function getOriginalShippingFee()
    {
        return $this->container['original_shipping_fee'];
    }

    /**
     * Sets original_shipping_fee
     *
     * @param string|null $original_shipping_fee original_shipping_fee
     *
     * @return self
     */
    public function setOriginalShippingFee($original_shipping_fee)
    {
        if (is_null($original_shipping_fee)) {
            throw new \InvalidArgumentException('non-nullable original_shipping_fee cannot be null');
        }
        $this->container['original_shipping_fee'] = $original_shipping_fee;

        return $this;
    }

    /**
     * Gets original_total_product_price
     *
     * @return string|null
     */
    public function getOriginalTotalProductPrice()
    {
        return $this->container['original_total_product_price'];
    }

    /**
     * Sets original_total_product_price
     *
     * @param string|null $original_total_product_price original_total_product_price
     *
     * @return self
     */
    public function setOriginalTotalProductPrice($original_total_product_price)
    {
        if (is_null($original_total_product_price)) {
            throw new \InvalidArgumentException('non-nullable original_total_product_price cannot be null');
        }
        $this->container['original_total_product_price'] = $original_total_product_price;

        return $this;
    }

    /**
     * Gets platform_discount
     *
     * @return string|null
     */
    public function getPlatformDiscount()
    {
        return $this->container['platform_discount'];
    }

    /**
     * Sets platform_discount
     *
     * @param string|null $platform_discount platform_discount
     *
     * @return self
     */
    public function setPlatformDiscount($platform_discount)
    {
        if (is_null($platform_discount)) {
            throw new \InvalidArgumentException('non-nullable platform_discount cannot be null');
        }
        $this->container['platform_discount'] = $platform_discount;

        return $this;
    }

    /**
     * Gets product_tax
     *
     * @return string|null
     */
    public function getProductTax()
    {
        return $this->container['product_tax'];
    }

    /**
     * Sets product_tax
     *
     * @param string|null $product_tax product_tax
     *
     * @return self
     */
    public function setProductTax($product_tax)
    {
        if (is_null($product_tax)) {
            throw new \InvalidArgumentException('non-nullable product_tax cannot be null');
        }
        $this->container['product_tax'] = $product_tax;

        return $this;
    }

    /**
     * Gets retail_delivery_fee
     *
     * @return string|null
     */
    public function getRetailDeliveryFee()
    {
        return $this->container['retail_delivery_fee'];
    }

    /**
     * Sets retail_delivery_fee
     *
     * @param string|null $retail_delivery_fee retail_delivery_fee
     *
     * @return self
     */
    public function setRetailDeliveryFee($retail_delivery_fee)
    {
        if (is_null($retail_delivery_fee)) {
            throw new \InvalidArgumentException('non-nullable retail_delivery_fee cannot be null');
        }
        $this->container['retail_delivery_fee'] = $retail_delivery_fee;

        return $this;
    }

    /**
     * Gets seller_discount
     *
     * @return string|null
     */
    public function getSellerDiscount()
    {
        return $this->container['seller_discount'];
    }

    /**
     * Sets seller_discount
     *
     * @param string|null $seller_discount seller_discount
     *
     * @return self
     */
    public function setSellerDiscount($seller_discount)
    {
        if (is_null($seller_discount)) {
            throw new \InvalidArgumentException('non-nullable seller_discount cannot be null');
        }
        $this->container['seller_discount'] = $seller_discount;

        return $this;
    }

    /**
     * Gets shipping_fee
     *
     * @return string|null
     */
    public function getShippingFee()
    {
        return $this->container['shipping_fee'];
    }

    /**
     * Sets shipping_fee
     *
     * @param string|null $shipping_fee shipping_fee
     *
     * @return self
     */
    public function setShippingFee($shipping_fee)
    {
        if (is_null($shipping_fee)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee cannot be null');
        }
        $this->container['shipping_fee'] = $shipping_fee;

        return $this;
    }

    /**
     * Gets shipping_fee_platform_discount
     *
     * @return string|null
     */
    public function getShippingFeePlatformDiscount()
    {
        return $this->container['shipping_fee_platform_discount'];
    }

    /**
     * Sets shipping_fee_platform_discount
     *
     * @param string|null $shipping_fee_platform_discount shipping_fee_platform_discount
     *
     * @return self
     */
    public function setShippingFeePlatformDiscount($shipping_fee_platform_discount)
    {
        if (is_null($shipping_fee_platform_discount)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_platform_discount cannot be null');
        }
        $this->container['shipping_fee_platform_discount'] = $shipping_fee_platform_discount;

        return $this;
    }

    /**
     * Gets shipping_fee_seller_discount
     *
     * @return string|null
     */
    public function getShippingFeeSellerDiscount()
    {
        return $this->container['shipping_fee_seller_discount'];
    }

    /**
     * Sets shipping_fee_seller_discount
     *
     * @param string|null $shipping_fee_seller_discount shipping_fee_seller_discount
     *
     * @return self
     */
    public function setShippingFeeSellerDiscount($shipping_fee_seller_discount)
    {
        if (is_null($shipping_fee_seller_discount)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_seller_discount cannot be null');
        }
        $this->container['shipping_fee_seller_discount'] = $shipping_fee_seller_discount;

        return $this;
    }

    /**
     * Gets shipping_fee_tax
     *
     * @return string|null
     */
    public function getShippingFeeTax()
    {
        return $this->container['shipping_fee_tax'];
    }

    /**
     * Sets shipping_fee_tax
     *
     * @param string|null $shipping_fee_tax shipping_fee_tax
     *
     * @return self
     */
    public function setShippingFeeTax($shipping_fee_tax)
    {
        if (is_null($shipping_fee_tax)) {
            throw new \InvalidArgumentException('non-nullable shipping_fee_tax cannot be null');
        }
        $this->container['shipping_fee_tax'] = $shipping_fee_tax;

        return $this;
    }

    /**
     * Gets small_order_fee
     *
     * @return string|null
     */
    public function getSmallOrderFee()
    {
        return $this->container['small_order_fee'];
    }

    /**
     * Sets small_order_fee
     *
     * @param string|null $small_order_fee small_order_fee
     *
     * @return self
     */
    public function setSmallOrderFee($small_order_fee)
    {
        if (is_null($small_order_fee)) {
            throw new \InvalidArgumentException('non-nullable small_order_fee cannot be null');
        }
        $this->container['small_order_fee'] = $small_order_fee;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return string|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param string|null $sub_total sub_total
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        if (is_null($sub_total)) {
            throw new \InvalidArgumentException('non-nullable sub_total cannot be null');
        }
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return string|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param string|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param string|null $total_amount total_amount
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        if (is_null($total_amount)) {
            throw new \InvalidArgumentException('non-nullable total_amount cannot be null');
        }
        $this->container['total_amount'] = $total_amount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


