<?php
/**
 * PackageDetailResponseData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * PackageDetailResponseData Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PackageDetailResponseData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PackageDetailResponse_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'create_time' => 'int',
        'delivery_option_id' => 'string',
        'delivery_option_name' => 'string',
        'dimension' => '\Tiktok\Model\Dimension',
        'handover_method' => 'string',
        'has_multi_skus' => 'bool',
        'last_mile_tracking_number' => 'string',
        'note_tag' => 'string',
        'order_line_item_ids' => 'string[]',
        'orders' => '\Tiktok\Model\PackageDetailsOrder',
        'package_id' => 'string',
        'package_status' => 'string',
        'pickup_slot' => '\Tiktok\Model\PackageDetailResponseDataPickupSlot',
        'recipient_address' => '\Tiktok\Model\Address',
        'sender_address' => '\Tiktok\Model\Address',
        'shipping_provider_id' => 'string',
        'shipping_provider_name' => 'string',
        'shipping_type' => 'string',
        'split_and_combine_tag' => 'string',
        'tracking_number' => 'string',
        'update_time' => 'int',
        'weight' => '\Tiktok\Model\PackageDetailResponseDataWeight'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'create_time' => null,
        'delivery_option_id' => null,
        'delivery_option_name' => null,
        'dimension' => null,
        'handover_method' => null,
        'has_multi_skus' => null,
        'last_mile_tracking_number' => null,
        'note_tag' => null,
        'order_line_item_ids' => null,
        'orders' => null,
        'package_id' => null,
        'package_status' => null,
        'pickup_slot' => null,
        'recipient_address' => null,
        'sender_address' => null,
        'shipping_provider_id' => null,
        'shipping_provider_name' => null,
        'shipping_type' => null,
        'split_and_combine_tag' => null,
        'tracking_number' => null,
        'update_time' => null,
        'weight' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'create_time' => false,
        'delivery_option_id' => false,
        'delivery_option_name' => false,
        'dimension' => false,
        'handover_method' => false,
        'has_multi_skus' => false,
        'last_mile_tracking_number' => false,
        'note_tag' => false,
        'order_line_item_ids' => false,
        'orders' => false,
        'package_id' => false,
        'package_status' => false,
        'pickup_slot' => false,
        'recipient_address' => false,
        'sender_address' => false,
        'shipping_provider_id' => false,
        'shipping_provider_name' => false,
        'shipping_type' => false,
        'split_and_combine_tag' => false,
        'tracking_number' => false,
        'update_time' => false,
        'weight' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'create_time' => 'create_time',
        'delivery_option_id' => 'delivery_option_id',
        'delivery_option_name' => 'delivery_option_name',
        'dimension' => 'dimension',
        'handover_method' => 'handover_method',
        'has_multi_skus' => 'has_multi_skus',
        'last_mile_tracking_number' => 'last_mile_tracking_number',
        'note_tag' => 'note_tag',
        'order_line_item_ids' => 'order_line_item_ids',
        'orders' => 'orders',
        'package_id' => 'package_id',
        'package_status' => 'package_status',
        'pickup_slot' => 'pickup_slot',
        'recipient_address' => 'recipient_address',
        'sender_address' => 'sender_address',
        'shipping_provider_id' => 'shipping_provider_id',
        'shipping_provider_name' => 'shipping_provider_name',
        'shipping_type' => 'shipping_type',
        'split_and_combine_tag' => 'split_and_combine_tag',
        'tracking_number' => 'tracking_number',
        'update_time' => 'update_time',
        'weight' => 'weight'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'create_time' => 'setCreateTime',
        'delivery_option_id' => 'setDeliveryOptionId',
        'delivery_option_name' => 'setDeliveryOptionName',
        'dimension' => 'setDimension',
        'handover_method' => 'setHandoverMethod',
        'has_multi_skus' => 'setHasMultiSkus',
        'last_mile_tracking_number' => 'setLastMileTrackingNumber',
        'note_tag' => 'setNoteTag',
        'order_line_item_ids' => 'setOrderLineItemIds',
        'orders' => 'setOrders',
        'package_id' => 'setPackageId',
        'package_status' => 'setPackageStatus',
        'pickup_slot' => 'setPickupSlot',
        'recipient_address' => 'setRecipientAddress',
        'sender_address' => 'setSenderAddress',
        'shipping_provider_id' => 'setShippingProviderId',
        'shipping_provider_name' => 'setShippingProviderName',
        'shipping_type' => 'setShippingType',
        'split_and_combine_tag' => 'setSplitAndCombineTag',
        'tracking_number' => 'setTrackingNumber',
        'update_time' => 'setUpdateTime',
        'weight' => 'setWeight'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'create_time' => 'getCreateTime',
        'delivery_option_id' => 'getDeliveryOptionId',
        'delivery_option_name' => 'getDeliveryOptionName',
        'dimension' => 'getDimension',
        'handover_method' => 'getHandoverMethod',
        'has_multi_skus' => 'getHasMultiSkus',
        'last_mile_tracking_number' => 'getLastMileTrackingNumber',
        'note_tag' => 'getNoteTag',
        'order_line_item_ids' => 'getOrderLineItemIds',
        'orders' => 'getOrders',
        'package_id' => 'getPackageId',
        'package_status' => 'getPackageStatus',
        'pickup_slot' => 'getPickupSlot',
        'recipient_address' => 'getRecipientAddress',
        'sender_address' => 'getSenderAddress',
        'shipping_provider_id' => 'getShippingProviderId',
        'shipping_provider_name' => 'getShippingProviderName',
        'shipping_type' => 'getShippingType',
        'split_and_combine_tag' => 'getSplitAndCombineTag',
        'tracking_number' => 'getTrackingNumber',
        'update_time' => 'getUpdateTime',
        'weight' => 'getWeight'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('delivery_option_id', $data ?? [], null);
        $this->setIfExists('delivery_option_name', $data ?? [], null);
        $this->setIfExists('dimension', $data ?? [], null);
        $this->setIfExists('handover_method', $data ?? [], null);
        $this->setIfExists('has_multi_skus', $data ?? [], null);
        $this->setIfExists('last_mile_tracking_number', $data ?? [], null);
        $this->setIfExists('note_tag', $data ?? [], null);
        $this->setIfExists('order_line_item_ids', $data ?? [], null);
        $this->setIfExists('orders', $data ?? [], null);
        $this->setIfExists('package_id', $data ?? [], null);
        $this->setIfExists('package_status', $data ?? [], null);
        $this->setIfExists('pickup_slot', $data ?? [], null);
        $this->setIfExists('recipient_address', $data ?? [], null);
        $this->setIfExists('sender_address', $data ?? [], null);
        $this->setIfExists('shipping_provider_id', $data ?? [], null);
        $this->setIfExists('shipping_provider_name', $data ?? [], null);
        $this->setIfExists('shipping_type', $data ?? [], null);
        $this->setIfExists('split_and_combine_tag', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('update_time', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets create_time
     *
     * @return int|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param int|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets delivery_option_id
     *
     * @return string|null
     */
    public function getDeliveryOptionId()
    {
        return $this->container['delivery_option_id'];
    }

    /**
     * Sets delivery_option_id
     *
     * @param string|null $delivery_option_id delivery_option_id
     *
     * @return self
     */
    public function setDeliveryOptionId($delivery_option_id)
    {
        if (is_null($delivery_option_id)) {
            throw new \InvalidArgumentException('non-nullable delivery_option_id cannot be null');
        }
        $this->container['delivery_option_id'] = $delivery_option_id;

        return $this;
    }

    /**
     * Gets delivery_option_name
     *
     * @return string|null
     */
    public function getDeliveryOptionName()
    {
        return $this->container['delivery_option_name'];
    }

    /**
     * Sets delivery_option_name
     *
     * @param string|null $delivery_option_name delivery_option_name
     *
     * @return self
     */
    public function setDeliveryOptionName($delivery_option_name)
    {
        if (is_null($delivery_option_name)) {
            throw new \InvalidArgumentException('non-nullable delivery_option_name cannot be null');
        }
        $this->container['delivery_option_name'] = $delivery_option_name;

        return $this;
    }

    /**
     * Gets dimension
     *
     * @return \Tiktok\Model\Dimension|null
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     *
     * @param \Tiktok\Model\Dimension|null $dimension dimension
     *
     * @return self
     */
    public function setDimension($dimension)
    {
        if (is_null($dimension)) {
            throw new \InvalidArgumentException('non-nullable dimension cannot be null');
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets handover_method
     *
     * @return string|null
     */
    public function getHandoverMethod()
    {
        return $this->container['handover_method'];
    }

    /**
     * Sets handover_method
     *
     * @param string|null $handover_method handover_method
     *
     * @return self
     */
    public function setHandoverMethod($handover_method)
    {
        if (is_null($handover_method)) {
            throw new \InvalidArgumentException('non-nullable handover_method cannot be null');
        }
        $this->container['handover_method'] = $handover_method;

        return $this;
    }

    /**
     * Gets has_multi_skus
     *
     * @return bool|null
     */
    public function getHasMultiSkus()
    {
        return $this->container['has_multi_skus'];
    }

    /**
     * Sets has_multi_skus
     *
     * @param bool|null $has_multi_skus has_multi_skus
     *
     * @return self
     */
    public function setHasMultiSkus($has_multi_skus)
    {
        if (is_null($has_multi_skus)) {
            throw new \InvalidArgumentException('non-nullable has_multi_skus cannot be null');
        }
        $this->container['has_multi_skus'] = $has_multi_skus;

        return $this;
    }

    /**
     * Gets last_mile_tracking_number
     *
     * @return string|null
     */
    public function getLastMileTrackingNumber()
    {
        return $this->container['last_mile_tracking_number'];
    }

    /**
     * Sets last_mile_tracking_number
     *
     * @param string|null $last_mile_tracking_number last_mile_tracking_number
     *
     * @return self
     */
    public function setLastMileTrackingNumber($last_mile_tracking_number)
    {
        if (is_null($last_mile_tracking_number)) {
            throw new \InvalidArgumentException('non-nullable last_mile_tracking_number cannot be null');
        }
        $this->container['last_mile_tracking_number'] = $last_mile_tracking_number;

        return $this;
    }

    /**
     * Gets note_tag
     *
     * @return string|null
     */
    public function getNoteTag()
    {
        return $this->container['note_tag'];
    }

    /**
     * Sets note_tag
     *
     * @param string|null $note_tag note_tag
     *
     * @return self
     */
    public function setNoteTag($note_tag)
    {
        if (is_null($note_tag)) {
            throw new \InvalidArgumentException('non-nullable note_tag cannot be null');
        }
        $this->container['note_tag'] = $note_tag;

        return $this;
    }

    /**
     * Gets order_line_item_ids
     *
     * @return string[]|null
     */
    public function getOrderLineItemIds()
    {
        return $this->container['order_line_item_ids'];
    }

    /**
     * Sets order_line_item_ids
     *
     * @param string[]|null $order_line_item_ids order_line_item_ids
     *
     * @return self
     */
    public function setOrderLineItemIds($order_line_item_ids)
    {
        if (is_null($order_line_item_ids)) {
            throw new \InvalidArgumentException('non-nullable order_line_item_ids cannot be null');
        }
        $this->container['order_line_item_ids'] = $order_line_item_ids;

        return $this;
    }

    /**
     * Gets orders
     *
     * @return \Tiktok\Model\PackageDetailsOrder|null
     */
    public function getOrders()
    {
        return $this->container['orders'];
    }

    /**
     * Sets orders
     *
     * @param \Tiktok\Model\PackageDetailsOrder|null $orders orders
     *
     * @return self
     */
    public function setOrders($orders)
    {
        if (is_null($orders)) {
            throw new \InvalidArgumentException('non-nullable orders cannot be null');
        }
        $this->container['orders'] = $orders;

        return $this;
    }

    /**
     * Gets package_id
     *
     * @return string|null
     */
    public function getPackageId()
    {
        return $this->container['package_id'];
    }

    /**
     * Sets package_id
     *
     * @param string|null $package_id package_id
     *
     * @return self
     */
    public function setPackageId($package_id)
    {
        if (is_null($package_id)) {
            throw new \InvalidArgumentException('non-nullable package_id cannot be null');
        }
        $this->container['package_id'] = $package_id;

        return $this;
    }

    /**
     * Gets package_status
     *
     * @return string|null
     */
    public function getPackageStatus()
    {
        return $this->container['package_status'];
    }

    /**
     * Sets package_status
     *
     * @param string|null $package_status package_status
     *
     * @return self
     */
    public function setPackageStatus($package_status)
    {
        if (is_null($package_status)) {
            throw new \InvalidArgumentException('non-nullable package_status cannot be null');
        }
        $this->container['package_status'] = $package_status;

        return $this;
    }

    /**
     * Gets pickup_slot
     *
     * @return \Tiktok\Model\PackageDetailResponseDataPickupSlot|null
     */
    public function getPickupSlot()
    {
        return $this->container['pickup_slot'];
    }

    /**
     * Sets pickup_slot
     *
     * @param \Tiktok\Model\PackageDetailResponseDataPickupSlot|null $pickup_slot pickup_slot
     *
     * @return self
     */
    public function setPickupSlot($pickup_slot)
    {
        if (is_null($pickup_slot)) {
            throw new \InvalidArgumentException('non-nullable pickup_slot cannot be null');
        }
        $this->container['pickup_slot'] = $pickup_slot;

        return $this;
    }

    /**
     * Gets recipient_address
     *
     * @return \Tiktok\Model\Address|null
     */
    public function getRecipientAddress()
    {
        return $this->container['recipient_address'];
    }

    /**
     * Sets recipient_address
     *
     * @param \Tiktok\Model\Address|null $recipient_address recipient_address
     *
     * @return self
     */
    public function setRecipientAddress($recipient_address)
    {
        if (is_null($recipient_address)) {
            throw new \InvalidArgumentException('non-nullable recipient_address cannot be null');
        }
        $this->container['recipient_address'] = $recipient_address;

        return $this;
    }

    /**
     * Gets sender_address
     *
     * @return \Tiktok\Model\Address|null
     */
    public function getSenderAddress()
    {
        return $this->container['sender_address'];
    }

    /**
     * Sets sender_address
     *
     * @param \Tiktok\Model\Address|null $sender_address sender_address
     *
     * @return self
     */
    public function setSenderAddress($sender_address)
    {
        if (is_null($sender_address)) {
            throw new \InvalidArgumentException('non-nullable sender_address cannot be null');
        }
        $this->container['sender_address'] = $sender_address;

        return $this;
    }

    /**
     * Gets shipping_provider_id
     *
     * @return string|null
     */
    public function getShippingProviderId()
    {
        return $this->container['shipping_provider_id'];
    }

    /**
     * Sets shipping_provider_id
     *
     * @param string|null $shipping_provider_id shipping_provider_id
     *
     * @return self
     */
    public function setShippingProviderId($shipping_provider_id)
    {
        if (is_null($shipping_provider_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_provider_id cannot be null');
        }
        $this->container['shipping_provider_id'] = $shipping_provider_id;

        return $this;
    }

    /**
     * Gets shipping_provider_name
     *
     * @return string|null
     */
    public function getShippingProviderName()
    {
        return $this->container['shipping_provider_name'];
    }

    /**
     * Sets shipping_provider_name
     *
     * @param string|null $shipping_provider_name shipping_provider_name
     *
     * @return self
     */
    public function setShippingProviderName($shipping_provider_name)
    {
        if (is_null($shipping_provider_name)) {
            throw new \InvalidArgumentException('non-nullable shipping_provider_name cannot be null');
        }
        $this->container['shipping_provider_name'] = $shipping_provider_name;

        return $this;
    }

    /**
     * Gets shipping_type
     *
     * @return string|null
     */
    public function getShippingType()
    {
        return $this->container['shipping_type'];
    }

    /**
     * Sets shipping_type
     *
     * @param string|null $shipping_type shipping_type
     *
     * @return self
     */
    public function setShippingType($shipping_type)
    {
        if (is_null($shipping_type)) {
            throw new \InvalidArgumentException('non-nullable shipping_type cannot be null');
        }
        $this->container['shipping_type'] = $shipping_type;

        return $this;
    }

    /**
     * Gets split_and_combine_tag
     *
     * @return string|null
     */
    public function getSplitAndCombineTag()
    {
        return $this->container['split_and_combine_tag'];
    }

    /**
     * Sets split_and_combine_tag
     *
     * @param string|null $split_and_combine_tag split_and_combine_tag
     *
     * @return self
     */
    public function setSplitAndCombineTag($split_and_combine_tag)
    {
        if (is_null($split_and_combine_tag)) {
            throw new \InvalidArgumentException('non-nullable split_and_combine_tag cannot be null');
        }
        $this->container['split_and_combine_tag'] = $split_and_combine_tag;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number tracking_number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets update_time
     *
     * @return int|null
     */
    public function getUpdateTime()
    {
        return $this->container['update_time'];
    }

    /**
     * Sets update_time
     *
     * @param int|null $update_time update_time
     *
     * @return self
     */
    public function setUpdateTime($update_time)
    {
        if (is_null($update_time)) {
            throw new \InvalidArgumentException('non-nullable update_time cannot be null');
        }
        $this->container['update_time'] = $update_time;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return \Tiktok\Model\PackageDetailResponseDataWeight|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param \Tiktok\Model\PackageDetailResponseDataWeight|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


