<?php
/**
 * OrderSearch
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * OrderSearch Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderSearch implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderSearch';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'buyer_user_id' => 'string',
        'create_time_ge' => 'int',
        'create_time_lt' => 'int',
        'is_buyer_request_cancel' => 'bool',
        'order_status' => 'string',
        'shipping_type' => 'string',
        'update_time_ge' => 'int',
        'update_time_lt' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'buyer_user_id' => null,
        'create_time_ge' => null,
        'create_time_lt' => null,
        'is_buyer_request_cancel' => null,
        'order_status' => null,
        'shipping_type' => null,
        'update_time_ge' => null,
        'update_time_lt' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'buyer_user_id' => false,
        'create_time_ge' => false,
        'create_time_lt' => false,
        'is_buyer_request_cancel' => false,
        'order_status' => false,
        'shipping_type' => false,
        'update_time_ge' => false,
        'update_time_lt' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'buyer_user_id' => 'buyer_user_id',
        'create_time_ge' => 'create_time_ge',
        'create_time_lt' => 'create_time_lt',
        'is_buyer_request_cancel' => 'is_buyer_request_cancel',
        'order_status' => 'order_status',
        'shipping_type' => 'shipping_type',
        'update_time_ge' => 'update_time_ge',
        'update_time_lt' => 'update_time_lt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'buyer_user_id' => 'setBuyerUserId',
        'create_time_ge' => 'setCreateTimeGe',
        'create_time_lt' => 'setCreateTimeLt',
        'is_buyer_request_cancel' => 'setIsBuyerRequestCancel',
        'order_status' => 'setOrderStatus',
        'shipping_type' => 'setShippingType',
        'update_time_ge' => 'setUpdateTimeGe',
        'update_time_lt' => 'setUpdateTimeLt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'buyer_user_id' => 'getBuyerUserId',
        'create_time_ge' => 'getCreateTimeGe',
        'create_time_lt' => 'getCreateTimeLt',
        'is_buyer_request_cancel' => 'getIsBuyerRequestCancel',
        'order_status' => 'getOrderStatus',
        'shipping_type' => 'getShippingType',
        'update_time_ge' => 'getUpdateTimeGe',
        'update_time_lt' => 'getUpdateTimeLt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('buyer_user_id', $data ?? [], null);
        $this->setIfExists('create_time_ge', $data ?? [], null);
        $this->setIfExists('create_time_lt', $data ?? [], null);
        $this->setIfExists('is_buyer_request_cancel', $data ?? [], null);
        $this->setIfExists('order_status', $data ?? [], null);
        $this->setIfExists('shipping_type', $data ?? [], null);
        $this->setIfExists('update_time_ge', $data ?? [], null);
        $this->setIfExists('update_time_lt', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets buyer_user_id
     *
     * @return string|null
     */
    public function getBuyerUserId()
    {
        return $this->container['buyer_user_id'];
    }

    /**
     * Sets buyer_user_id
     *
     * @param string|null $buyer_user_id buyer_user_id
     *
     * @return self
     */
    public function setBuyerUserId($buyer_user_id)
    {
        if (is_null($buyer_user_id)) {
            throw new \InvalidArgumentException('non-nullable buyer_user_id cannot be null');
        }
        $this->container['buyer_user_id'] = $buyer_user_id;

        return $this;
    }

    /**
     * Gets create_time_ge
     *
     * @return int|null
     */
    public function getCreateTimeGe()
    {
        return $this->container['create_time_ge'];
    }

    /**
     * Sets create_time_ge
     *
     * @param int|null $create_time_ge create_time_ge
     *
     * @return self
     */
    public function setCreateTimeGe($create_time_ge)
    {
        if (is_null($create_time_ge)) {
            throw new \InvalidArgumentException('non-nullable create_time_ge cannot be null');
        }
        $this->container['create_time_ge'] = $create_time_ge;

        return $this;
    }

    /**
     * Gets create_time_lt
     *
     * @return int|null
     */
    public function getCreateTimeLt()
    {
        return $this->container['create_time_lt'];
    }

    /**
     * Sets create_time_lt
     *
     * @param int|null $create_time_lt create_time_lt
     *
     * @return self
     */
    public function setCreateTimeLt($create_time_lt)
    {
        if (is_null($create_time_lt)) {
            throw new \InvalidArgumentException('non-nullable create_time_lt cannot be null');
        }
        $this->container['create_time_lt'] = $create_time_lt;

        return $this;
    }

    /**
     * Gets is_buyer_request_cancel
     *
     * @return bool|null
     */
    public function getIsBuyerRequestCancel()
    {
        return $this->container['is_buyer_request_cancel'];
    }

    /**
     * Sets is_buyer_request_cancel
     *
     * @param bool|null $is_buyer_request_cancel is_buyer_request_cancel
     *
     * @return self
     */
    public function setIsBuyerRequestCancel($is_buyer_request_cancel)
    {
        if (is_null($is_buyer_request_cancel)) {
            throw new \InvalidArgumentException('non-nullable is_buyer_request_cancel cannot be null');
        }
        $this->container['is_buyer_request_cancel'] = $is_buyer_request_cancel;

        return $this;
    }

    /**
     * Gets order_status
     *
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->container['order_status'];
    }

    /**
     * Sets order_status
     *
     * @param string|null $order_status order_status
     *
     * @return self
     */
    public function setOrderStatus($order_status)
    {
        if (is_null($order_status)) {
            throw new \InvalidArgumentException('non-nullable order_status cannot be null');
        }
        $this->container['order_status'] = $order_status;

        return $this;
    }

    /**
     * Gets shipping_type
     *
     * @return string|null
     */
    public function getShippingType()
    {
        return $this->container['shipping_type'];
    }

    /**
     * Sets shipping_type
     *
     * @param string|null $shipping_type shipping_type
     *
     * @return self
     */
    public function setShippingType($shipping_type)
    {
        if (is_null($shipping_type)) {
            throw new \InvalidArgumentException('non-nullable shipping_type cannot be null');
        }
        $this->container['shipping_type'] = $shipping_type;

        return $this;
    }

    /**
     * Gets update_time_ge
     *
     * @return int|null
     */
    public function getUpdateTimeGe()
    {
        return $this->container['update_time_ge'];
    }

    /**
     * Sets update_time_ge
     *
     * @param int|null $update_time_ge update_time_ge
     *
     * @return self
     */
    public function setUpdateTimeGe($update_time_ge)
    {
        if (is_null($update_time_ge)) {
            throw new \InvalidArgumentException('non-nullable update_time_ge cannot be null');
        }
        $this->container['update_time_ge'] = $update_time_ge;

        return $this;
    }

    /**
     * Gets update_time_lt
     *
     * @return int|null
     */
    public function getUpdateTimeLt()
    {
        return $this->container['update_time_lt'];
    }

    /**
     * Sets update_time_lt
     *
     * @param int|null $update_time_lt update_time_lt
     *
     * @return self
     */
    public function setUpdateTimeLt($update_time_lt)
    {
        if (is_null($update_time_lt)) {
            throw new \InvalidArgumentException('non-nullable update_time_lt cannot be null');
        }
        $this->container['update_time_lt'] = $update_time_lt;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


