<?php
/**
 * Order
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'buyer_email' => 'string',
        'buyer_message' => 'string',
        'cancel_order_sla_time' => 'int',
        'cancel_reason' => 'string',
        'cancel_time' => 'int',
        'cancellation_initiator' => 'string',
        'collection_due_time' => 'int',
        'collection_time' => 'int',
        'cpf' => 'string',
        'create_time' => 'int',
        'delivery_due_time' => 'int',
        'delivery_option_id' => 'string',
        'delivery_option_name' => 'string',
        'delivery_option_required_delivery_time' => 'int',
        'delivery_sla_time' => 'int',
        'delivery_time' => 'int',
        'delivery_type' => 'string',
        'fulfillment_type' => 'string',
        'has_updated_recipient_address' => 'bool',
        'id' => 'string',
        'is_buyer_request_cancel' => 'bool',
        'is_cod' => 'bool',
        'is_on_hold_order' => 'bool',
        'is_replacement_order' => 'bool',
        'is_sample_order' => 'bool',
        'line_items' => '\Tiktok\Model\LineItem[]',
        'need_upload_invoice' => 'string',
        'packages' => '\Tiktok\Model\Package[]',
        'paid_time' => 'int',
        'payment' => '\Tiktok\Model\Payment',
        'payment_method_name' => 'string',
        'recipient_address' => '\Tiktok\Model\Address',
        'replaced_order_id' => 'string',
        'request_cancel_time' => 'int',
        'rts_sla_time' => 'int',
        'rts_time' => 'int',
        'seller_note' => 'string',
        'shipping_due_time' => 'int',
        'shipping_provider' => 'string',
        'shipping_provider_id' => 'string',
        'shipping_type' => 'string',
        'split_or_combine_tag' => 'string',
        'status' => 'string',
        'tracking_number' => 'string',
        'tts_sla_time' => 'int',
        'update_time' => 'int',
        'user_id' => 'string',
        'warehouse_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'buyer_email' => null,
        'buyer_message' => null,
        'cancel_order_sla_time' => null,
        'cancel_reason' => null,
        'cancel_time' => null,
        'cancellation_initiator' => null,
        'collection_due_time' => null,
        'collection_time' => null,
        'cpf' => null,
        'create_time' => null,
        'delivery_due_time' => null,
        'delivery_option_id' => null,
        'delivery_option_name' => null,
        'delivery_option_required_delivery_time' => null,
        'delivery_sla_time' => null,
        'delivery_time' => null,
        'delivery_type' => null,
        'fulfillment_type' => null,
        'has_updated_recipient_address' => null,
        'id' => null,
        'is_buyer_request_cancel' => null,
        'is_cod' => null,
        'is_on_hold_order' => null,
        'is_replacement_order' => null,
        'is_sample_order' => null,
        'line_items' => null,
        'need_upload_invoice' => null,
        'packages' => null,
        'paid_time' => null,
        'payment' => null,
        'payment_method_name' => null,
        'recipient_address' => null,
        'replaced_order_id' => null,
        'request_cancel_time' => null,
        'rts_sla_time' => null,
        'rts_time' => null,
        'seller_note' => null,
        'shipping_due_time' => null,
        'shipping_provider' => null,
        'shipping_provider_id' => null,
        'shipping_type' => null,
        'split_or_combine_tag' => null,
        'status' => null,
        'tracking_number' => null,
        'tts_sla_time' => null,
        'update_time' => null,
        'user_id' => null,
        'warehouse_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'buyer_email' => false,
        'buyer_message' => false,
        'cancel_order_sla_time' => false,
        'cancel_reason' => false,
        'cancel_time' => false,
        'cancellation_initiator' => false,
        'collection_due_time' => false,
        'collection_time' => false,
        'cpf' => false,
        'create_time' => false,
        'delivery_due_time' => false,
        'delivery_option_id' => false,
        'delivery_option_name' => false,
        'delivery_option_required_delivery_time' => false,
        'delivery_sla_time' => false,
        'delivery_time' => false,
        'delivery_type' => false,
        'fulfillment_type' => false,
        'has_updated_recipient_address' => false,
        'id' => false,
        'is_buyer_request_cancel' => false,
        'is_cod' => false,
        'is_on_hold_order' => false,
        'is_replacement_order' => false,
        'is_sample_order' => false,
        'line_items' => false,
        'need_upload_invoice' => false,
        'packages' => false,
        'paid_time' => false,
        'payment' => false,
        'payment_method_name' => false,
        'recipient_address' => false,
        'replaced_order_id' => false,
        'request_cancel_time' => false,
        'rts_sla_time' => false,
        'rts_time' => false,
        'seller_note' => false,
        'shipping_due_time' => false,
        'shipping_provider' => false,
        'shipping_provider_id' => false,
        'shipping_type' => false,
        'split_or_combine_tag' => false,
        'status' => false,
        'tracking_number' => false,
        'tts_sla_time' => false,
        'update_time' => false,
        'user_id' => false,
        'warehouse_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'buyer_email' => 'buyer_email',
        'buyer_message' => 'buyer_message',
        'cancel_order_sla_time' => 'cancel_order_sla_time',
        'cancel_reason' => 'cancel_reason',
        'cancel_time' => 'cancel_time',
        'cancellation_initiator' => 'cancellation_initiator',
        'collection_due_time' => 'collection_due_time',
        'collection_time' => 'collection_time',
        'cpf' => 'cpf',
        'create_time' => 'create_time',
        'delivery_due_time' => 'delivery_due_time',
        'delivery_option_id' => 'delivery_option_id',
        'delivery_option_name' => 'delivery_option_name',
        'delivery_option_required_delivery_time' => 'delivery_option_required_delivery_time',
        'delivery_sla_time' => 'delivery_sla_time',
        'delivery_time' => 'delivery_time',
        'delivery_type' => 'delivery_type',
        'fulfillment_type' => 'fulfillment_type',
        'has_updated_recipient_address' => 'has_updated_recipient_address',
        'id' => 'id',
        'is_buyer_request_cancel' => 'is_buyer_request_cancel',
        'is_cod' => 'is_cod',
        'is_on_hold_order' => 'is_on_hold_order',
        'is_replacement_order' => 'is_replacement_order',
        'is_sample_order' => 'is_sample_order',
        'line_items' => 'line_items',
        'need_upload_invoice' => 'need_upload_invoice',
        'packages' => 'packages',
        'paid_time' => 'paid_time',
        'payment' => 'payment',
        'payment_method_name' => 'payment_method_name',
        'recipient_address' => 'recipient_address',
        'replaced_order_id' => 'replaced_order_id',
        'request_cancel_time' => 'request_cancel_time',
        'rts_sla_time' => 'rts_sla_time',
        'rts_time' => 'rts_time',
        'seller_note' => 'seller_note',
        'shipping_due_time' => 'shipping_due_time',
        'shipping_provider' => 'shipping_provider',
        'shipping_provider_id' => 'shipping_provider_id',
        'shipping_type' => 'shipping_type',
        'split_or_combine_tag' => 'split_or_combine_tag',
        'status' => 'status',
        'tracking_number' => 'tracking_number',
        'tts_sla_time' => 'tts_sla_time',
        'update_time' => 'update_time',
        'user_id' => 'user_id',
        'warehouse_id' => 'warehouse_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'buyer_email' => 'setBuyerEmail',
        'buyer_message' => 'setBuyerMessage',
        'cancel_order_sla_time' => 'setCancelOrderSlaTime',
        'cancel_reason' => 'setCancelReason',
        'cancel_time' => 'setCancelTime',
        'cancellation_initiator' => 'setCancellationInitiator',
        'collection_due_time' => 'setCollectionDueTime',
        'collection_time' => 'setCollectionTime',
        'cpf' => 'setCpf',
        'create_time' => 'setCreateTime',
        'delivery_due_time' => 'setDeliveryDueTime',
        'delivery_option_id' => 'setDeliveryOptionId',
        'delivery_option_name' => 'setDeliveryOptionName',
        'delivery_option_required_delivery_time' => 'setDeliveryOptionRequiredDeliveryTime',
        'delivery_sla_time' => 'setDeliverySlaTime',
        'delivery_time' => 'setDeliveryTime',
        'delivery_type' => 'setDeliveryType',
        'fulfillment_type' => 'setFulfillmentType',
        'has_updated_recipient_address' => 'setHasUpdatedRecipientAddress',
        'id' => 'setId',
        'is_buyer_request_cancel' => 'setIsBuyerRequestCancel',
        'is_cod' => 'setIsCod',
        'is_on_hold_order' => 'setIsOnHoldOrder',
        'is_replacement_order' => 'setIsReplacementOrder',
        'is_sample_order' => 'setIsSampleOrder',
        'line_items' => 'setLineItems',
        'need_upload_invoice' => 'setNeedUploadInvoice',
        'packages' => 'setPackages',
        'paid_time' => 'setPaidTime',
        'payment' => 'setPayment',
        'payment_method_name' => 'setPaymentMethodName',
        'recipient_address' => 'setRecipientAddress',
        'replaced_order_id' => 'setReplacedOrderId',
        'request_cancel_time' => 'setRequestCancelTime',
        'rts_sla_time' => 'setRtsSlaTime',
        'rts_time' => 'setRtsTime',
        'seller_note' => 'setSellerNote',
        'shipping_due_time' => 'setShippingDueTime',
        'shipping_provider' => 'setShippingProvider',
        'shipping_provider_id' => 'setShippingProviderId',
        'shipping_type' => 'setShippingType',
        'split_or_combine_tag' => 'setSplitOrCombineTag',
        'status' => 'setStatus',
        'tracking_number' => 'setTrackingNumber',
        'tts_sla_time' => 'setTtsSlaTime',
        'update_time' => 'setUpdateTime',
        'user_id' => 'setUserId',
        'warehouse_id' => 'setWarehouseId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'buyer_email' => 'getBuyerEmail',
        'buyer_message' => 'getBuyerMessage',
        'cancel_order_sla_time' => 'getCancelOrderSlaTime',
        'cancel_reason' => 'getCancelReason',
        'cancel_time' => 'getCancelTime',
        'cancellation_initiator' => 'getCancellationInitiator',
        'collection_due_time' => 'getCollectionDueTime',
        'collection_time' => 'getCollectionTime',
        'cpf' => 'getCpf',
        'create_time' => 'getCreateTime',
        'delivery_due_time' => 'getDeliveryDueTime',
        'delivery_option_id' => 'getDeliveryOptionId',
        'delivery_option_name' => 'getDeliveryOptionName',
        'delivery_option_required_delivery_time' => 'getDeliveryOptionRequiredDeliveryTime',
        'delivery_sla_time' => 'getDeliverySlaTime',
        'delivery_time' => 'getDeliveryTime',
        'delivery_type' => 'getDeliveryType',
        'fulfillment_type' => 'getFulfillmentType',
        'has_updated_recipient_address' => 'getHasUpdatedRecipientAddress',
        'id' => 'getId',
        'is_buyer_request_cancel' => 'getIsBuyerRequestCancel',
        'is_cod' => 'getIsCod',
        'is_on_hold_order' => 'getIsOnHoldOrder',
        'is_replacement_order' => 'getIsReplacementOrder',
        'is_sample_order' => 'getIsSampleOrder',
        'line_items' => 'getLineItems',
        'need_upload_invoice' => 'getNeedUploadInvoice',
        'packages' => 'getPackages',
        'paid_time' => 'getPaidTime',
        'payment' => 'getPayment',
        'payment_method_name' => 'getPaymentMethodName',
        'recipient_address' => 'getRecipientAddress',
        'replaced_order_id' => 'getReplacedOrderId',
        'request_cancel_time' => 'getRequestCancelTime',
        'rts_sla_time' => 'getRtsSlaTime',
        'rts_time' => 'getRtsTime',
        'seller_note' => 'getSellerNote',
        'shipping_due_time' => 'getShippingDueTime',
        'shipping_provider' => 'getShippingProvider',
        'shipping_provider_id' => 'getShippingProviderId',
        'shipping_type' => 'getShippingType',
        'split_or_combine_tag' => 'getSplitOrCombineTag',
        'status' => 'getStatus',
        'tracking_number' => 'getTrackingNumber',
        'tts_sla_time' => 'getTtsSlaTime',
        'update_time' => 'getUpdateTime',
        'user_id' => 'getUserId',
        'warehouse_id' => 'getWarehouseId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('buyer_email', $data ?? [], null);
        $this->setIfExists('buyer_message', $data ?? [], null);
        $this->setIfExists('cancel_order_sla_time', $data ?? [], null);
        $this->setIfExists('cancel_reason', $data ?? [], null);
        $this->setIfExists('cancel_time', $data ?? [], null);
        $this->setIfExists('cancellation_initiator', $data ?? [], null);
        $this->setIfExists('collection_due_time', $data ?? [], null);
        $this->setIfExists('collection_time', $data ?? [], null);
        $this->setIfExists('cpf', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('delivery_due_time', $data ?? [], null);
        $this->setIfExists('delivery_option_id', $data ?? [], null);
        $this->setIfExists('delivery_option_name', $data ?? [], null);
        $this->setIfExists('delivery_option_required_delivery_time', $data ?? [], null);
        $this->setIfExists('delivery_sla_time', $data ?? [], null);
        $this->setIfExists('delivery_time', $data ?? [], null);
        $this->setIfExists('delivery_type', $data ?? [], null);
        $this->setIfExists('fulfillment_type', $data ?? [], null);
        $this->setIfExists('has_updated_recipient_address', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_buyer_request_cancel', $data ?? [], null);
        $this->setIfExists('is_cod', $data ?? [], null);
        $this->setIfExists('is_on_hold_order', $data ?? [], null);
        $this->setIfExists('is_replacement_order', $data ?? [], null);
        $this->setIfExists('is_sample_order', $data ?? [], null);
        $this->setIfExists('line_items', $data ?? [], null);
        $this->setIfExists('need_upload_invoice', $data ?? [], null);
        $this->setIfExists('packages', $data ?? [], null);
        $this->setIfExists('paid_time', $data ?? [], null);
        $this->setIfExists('payment', $data ?? [], null);
        $this->setIfExists('payment_method_name', $data ?? [], null);
        $this->setIfExists('recipient_address', $data ?? [], null);
        $this->setIfExists('replaced_order_id', $data ?? [], null);
        $this->setIfExists('request_cancel_time', $data ?? [], null);
        $this->setIfExists('rts_sla_time', $data ?? [], null);
        $this->setIfExists('rts_time', $data ?? [], null);
        $this->setIfExists('seller_note', $data ?? [], null);
        $this->setIfExists('shipping_due_time', $data ?? [], null);
        $this->setIfExists('shipping_provider', $data ?? [], null);
        $this->setIfExists('shipping_provider_id', $data ?? [], null);
        $this->setIfExists('shipping_type', $data ?? [], null);
        $this->setIfExists('split_or_combine_tag', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('tts_sla_time', $data ?? [], null);
        $this->setIfExists('update_time', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('warehouse_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets buyer_email
     *
     * @return string|null
     */
    public function getBuyerEmail()
    {
        return $this->container['buyer_email'];
    }

    /**
     * Sets buyer_email
     *
     * @param string|null $buyer_email buyer_email
     *
     * @return self
     */
    public function setBuyerEmail($buyer_email)
    {
        if (is_null($buyer_email)) {
            throw new \InvalidArgumentException('non-nullable buyer_email cannot be null');
        }
        $this->container['buyer_email'] = $buyer_email;

        return $this;
    }

    /**
     * Gets buyer_message
     *
     * @return string|null
     */
    public function getBuyerMessage()
    {
        return $this->container['buyer_message'];
    }

    /**
     * Sets buyer_message
     *
     * @param string|null $buyer_message buyer_message
     *
     * @return self
     */
    public function setBuyerMessage($buyer_message)
    {
        if (is_null($buyer_message)) {
            throw new \InvalidArgumentException('non-nullable buyer_message cannot be null');
        }
        $this->container['buyer_message'] = $buyer_message;

        return $this;
    }

    /**
     * Gets cancel_order_sla_time
     *
     * @return int|null
     */
    public function getCancelOrderSlaTime()
    {
        return $this->container['cancel_order_sla_time'];
    }

    /**
     * Sets cancel_order_sla_time
     *
     * @param int|null $cancel_order_sla_time cancel_order_sla_time
     *
     * @return self
     */
    public function setCancelOrderSlaTime($cancel_order_sla_time)
    {
        if (is_null($cancel_order_sla_time)) {
            throw new \InvalidArgumentException('non-nullable cancel_order_sla_time cannot be null');
        }
        $this->container['cancel_order_sla_time'] = $cancel_order_sla_time;

        return $this;
    }

    /**
     * Gets cancel_reason
     *
     * @return string|null
     */
    public function getCancelReason()
    {
        return $this->container['cancel_reason'];
    }

    /**
     * Sets cancel_reason
     *
     * @param string|null $cancel_reason cancel_reason
     *
     * @return self
     */
    public function setCancelReason($cancel_reason)
    {
        if (is_null($cancel_reason)) {
            throw new \InvalidArgumentException('non-nullable cancel_reason cannot be null');
        }
        $this->container['cancel_reason'] = $cancel_reason;

        return $this;
    }

    /**
     * Gets cancel_time
     *
     * @return int|null
     */
    public function getCancelTime()
    {
        return $this->container['cancel_time'];
    }

    /**
     * Sets cancel_time
     *
     * @param int|null $cancel_time cancel_time
     *
     * @return self
     */
    public function setCancelTime($cancel_time)
    {
        if (is_null($cancel_time)) {
            throw new \InvalidArgumentException('non-nullable cancel_time cannot be null');
        }
        $this->container['cancel_time'] = $cancel_time;

        return $this;
    }

    /**
     * Gets cancellation_initiator
     *
     * @return string|null
     */
    public function getCancellationInitiator()
    {
        return $this->container['cancellation_initiator'];
    }

    /**
     * Sets cancellation_initiator
     *
     * @param string|null $cancellation_initiator cancellation_initiator
     *
     * @return self
     */
    public function setCancellationInitiator($cancellation_initiator)
    {
        if (is_null($cancellation_initiator)) {
            throw new \InvalidArgumentException('non-nullable cancellation_initiator cannot be null');
        }
        $this->container['cancellation_initiator'] = $cancellation_initiator;

        return $this;
    }

    /**
     * Gets collection_due_time
     *
     * @return int|null
     */
    public function getCollectionDueTime()
    {
        return $this->container['collection_due_time'];
    }

    /**
     * Sets collection_due_time
     *
     * @param int|null $collection_due_time collection_due_time
     *
     * @return self
     */
    public function setCollectionDueTime($collection_due_time)
    {
        if (is_null($collection_due_time)) {
            throw new \InvalidArgumentException('non-nullable collection_due_time cannot be null');
        }
        $this->container['collection_due_time'] = $collection_due_time;

        return $this;
    }

    /**
     * Gets collection_time
     *
     * @return int|null
     */
    public function getCollectionTime()
    {
        return $this->container['collection_time'];
    }

    /**
     * Sets collection_time
     *
     * @param int|null $collection_time collection_time
     *
     * @return self
     */
    public function setCollectionTime($collection_time)
    {
        if (is_null($collection_time)) {
            throw new \InvalidArgumentException('non-nullable collection_time cannot be null');
        }
        $this->container['collection_time'] = $collection_time;

        return $this;
    }

    /**
     * Gets cpf
     *
     * @return string|null
     */
    public function getCpf()
    {
        return $this->container['cpf'];
    }

    /**
     * Sets cpf
     *
     * @param string|null $cpf cpf
     *
     * @return self
     */
    public function setCpf($cpf)
    {
        if (is_null($cpf)) {
            throw new \InvalidArgumentException('non-nullable cpf cannot be null');
        }
        $this->container['cpf'] = $cpf;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return int|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param int|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets delivery_due_time
     *
     * @return int|null
     */
    public function getDeliveryDueTime()
    {
        return $this->container['delivery_due_time'];
    }

    /**
     * Sets delivery_due_time
     *
     * @param int|null $delivery_due_time delivery_due_time
     *
     * @return self
     */
    public function setDeliveryDueTime($delivery_due_time)
    {
        if (is_null($delivery_due_time)) {
            throw new \InvalidArgumentException('non-nullable delivery_due_time cannot be null');
        }
        $this->container['delivery_due_time'] = $delivery_due_time;

        return $this;
    }

    /**
     * Gets delivery_option_id
     *
     * @return string|null
     */
    public function getDeliveryOptionId()
    {
        return $this->container['delivery_option_id'];
    }

    /**
     * Sets delivery_option_id
     *
     * @param string|null $delivery_option_id delivery_option_id
     *
     * @return self
     */
    public function setDeliveryOptionId($delivery_option_id)
    {
        if (is_null($delivery_option_id)) {
            throw new \InvalidArgumentException('non-nullable delivery_option_id cannot be null');
        }
        $this->container['delivery_option_id'] = $delivery_option_id;

        return $this;
    }

    /**
     * Gets delivery_option_name
     *
     * @return string|null
     */
    public function getDeliveryOptionName()
    {
        return $this->container['delivery_option_name'];
    }

    /**
     * Sets delivery_option_name
     *
     * @param string|null $delivery_option_name delivery_option_name
     *
     * @return self
     */
    public function setDeliveryOptionName($delivery_option_name)
    {
        if (is_null($delivery_option_name)) {
            throw new \InvalidArgumentException('non-nullable delivery_option_name cannot be null');
        }
        $this->container['delivery_option_name'] = $delivery_option_name;

        return $this;
    }

    /**
     * Gets delivery_option_required_delivery_time
     *
     * @return int|null
     */
    public function getDeliveryOptionRequiredDeliveryTime()
    {
        return $this->container['delivery_option_required_delivery_time'];
    }

    /**
     * Sets delivery_option_required_delivery_time
     *
     * @param int|null $delivery_option_required_delivery_time delivery_option_required_delivery_time
     *
     * @return self
     */
    public function setDeliveryOptionRequiredDeliveryTime($delivery_option_required_delivery_time)
    {
        if (is_null($delivery_option_required_delivery_time)) {
            throw new \InvalidArgumentException('non-nullable delivery_option_required_delivery_time cannot be null');
        }
        $this->container['delivery_option_required_delivery_time'] = $delivery_option_required_delivery_time;

        return $this;
    }

    /**
     * Gets delivery_sla_time
     *
     * @return int|null
     */
    public function getDeliverySlaTime()
    {
        return $this->container['delivery_sla_time'];
    }

    /**
     * Sets delivery_sla_time
     *
     * @param int|null $delivery_sla_time delivery_sla_time
     *
     * @return self
     */
    public function setDeliverySlaTime($delivery_sla_time)
    {
        if (is_null($delivery_sla_time)) {
            throw new \InvalidArgumentException('non-nullable delivery_sla_time cannot be null');
        }
        $this->container['delivery_sla_time'] = $delivery_sla_time;

        return $this;
    }

    /**
     * Gets delivery_time
     *
     * @return int|null
     */
    public function getDeliveryTime()
    {
        return $this->container['delivery_time'];
    }

    /**
     * Sets delivery_time
     *
     * @param int|null $delivery_time delivery_time
     *
     * @return self
     */
    public function setDeliveryTime($delivery_time)
    {
        if (is_null($delivery_time)) {
            throw new \InvalidArgumentException('non-nullable delivery_time cannot be null');
        }
        $this->container['delivery_time'] = $delivery_time;

        return $this;
    }

    /**
     * Gets delivery_type
     *
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->container['delivery_type'];
    }

    /**
     * Sets delivery_type
     *
     * @param string|null $delivery_type delivery_type
     *
     * @return self
     */
    public function setDeliveryType($delivery_type)
    {
        if (is_null($delivery_type)) {
            throw new \InvalidArgumentException('non-nullable delivery_type cannot be null');
        }
        $this->container['delivery_type'] = $delivery_type;

        return $this;
    }

    /**
     * Gets fulfillment_type
     *
     * @return string|null
     */
    public function getFulfillmentType()
    {
        return $this->container['fulfillment_type'];
    }

    /**
     * Sets fulfillment_type
     *
     * @param string|null $fulfillment_type fulfillment_type
     *
     * @return self
     */
    public function setFulfillmentType($fulfillment_type)
    {
        if (is_null($fulfillment_type)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_type cannot be null');
        }
        $this->container['fulfillment_type'] = $fulfillment_type;

        return $this;
    }

    /**
     * Gets has_updated_recipient_address
     *
     * @return bool|null
     */
    public function getHasUpdatedRecipientAddress()
    {
        return $this->container['has_updated_recipient_address'];
    }

    /**
     * Sets has_updated_recipient_address
     *
     * @param bool|null $has_updated_recipient_address has_updated_recipient_address
     *
     * @return self
     */
    public function setHasUpdatedRecipientAddress($has_updated_recipient_address)
    {
        if (is_null($has_updated_recipient_address)) {
            throw new \InvalidArgumentException('non-nullable has_updated_recipient_address cannot be null');
        }
        $this->container['has_updated_recipient_address'] = $has_updated_recipient_address;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_buyer_request_cancel
     *
     * @return bool|null
     */
    public function getIsBuyerRequestCancel()
    {
        return $this->container['is_buyer_request_cancel'];
    }

    /**
     * Sets is_buyer_request_cancel
     *
     * @param bool|null $is_buyer_request_cancel is_buyer_request_cancel
     *
     * @return self
     */
    public function setIsBuyerRequestCancel($is_buyer_request_cancel)
    {
        if (is_null($is_buyer_request_cancel)) {
            throw new \InvalidArgumentException('non-nullable is_buyer_request_cancel cannot be null');
        }
        $this->container['is_buyer_request_cancel'] = $is_buyer_request_cancel;

        return $this;
    }

    /**
     * Gets is_cod
     *
     * @return bool|null
     */
    public function getIsCod()
    {
        return $this->container['is_cod'];
    }

    /**
     * Sets is_cod
     *
     * @param bool|null $is_cod is_cod
     *
     * @return self
     */
    public function setIsCod($is_cod)
    {
        if (is_null($is_cod)) {
            throw new \InvalidArgumentException('non-nullable is_cod cannot be null');
        }
        $this->container['is_cod'] = $is_cod;

        return $this;
    }

    /**
     * Gets is_on_hold_order
     *
     * @return bool|null
     */
    public function getIsOnHoldOrder()
    {
        return $this->container['is_on_hold_order'];
    }

    /**
     * Sets is_on_hold_order
     *
     * @param bool|null $is_on_hold_order is_on_hold_order
     *
     * @return self
     */
    public function setIsOnHoldOrder($is_on_hold_order)
    {
        if (is_null($is_on_hold_order)) {
            throw new \InvalidArgumentException('non-nullable is_on_hold_order cannot be null');
        }
        $this->container['is_on_hold_order'] = $is_on_hold_order;

        return $this;
    }

    /**
     * Gets is_replacement_order
     *
     * @return bool|null
     */
    public function getIsReplacementOrder()
    {
        return $this->container['is_replacement_order'];
    }

    /**
     * Sets is_replacement_order
     *
     * @param bool|null $is_replacement_order is_replacement_order
     *
     * @return self
     */
    public function setIsReplacementOrder($is_replacement_order)
    {
        if (is_null($is_replacement_order)) {
            throw new \InvalidArgumentException('non-nullable is_replacement_order cannot be null');
        }
        $this->container['is_replacement_order'] = $is_replacement_order;

        return $this;
    }

    /**
     * Gets is_sample_order
     *
     * @return bool|null
     */
    public function getIsSampleOrder()
    {
        return $this->container['is_sample_order'];
    }

    /**
     * Sets is_sample_order
     *
     * @param bool|null $is_sample_order is_sample_order
     *
     * @return self
     */
    public function setIsSampleOrder($is_sample_order)
    {
        if (is_null($is_sample_order)) {
            throw new \InvalidArgumentException('non-nullable is_sample_order cannot be null');
        }
        $this->container['is_sample_order'] = $is_sample_order;

        return $this;
    }

    /**
     * Gets line_items
     *
     * @return \Tiktok\Model\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \Tiktok\Model\LineItem[]|null $line_items line_items
     *
     * @return self
     */
    public function setLineItems($line_items)
    {
        if (is_null($line_items)) {
            throw new \InvalidArgumentException('non-nullable line_items cannot be null');
        }
        $this->container['line_items'] = $line_items;

        return $this;
    }

    /**
     * Gets need_upload_invoice
     *
     * @return string|null
     */
    public function getNeedUploadInvoice()
    {
        return $this->container['need_upload_invoice'];
    }

    /**
     * Sets need_upload_invoice
     *
     * @param string|null $need_upload_invoice need_upload_invoice
     *
     * @return self
     */
    public function setNeedUploadInvoice($need_upload_invoice)
    {
        if (is_null($need_upload_invoice)) {
            throw new \InvalidArgumentException('non-nullable need_upload_invoice cannot be null');
        }
        $this->container['need_upload_invoice'] = $need_upload_invoice;

        return $this;
    }

    /**
     * Gets packages
     *
     * @return \Tiktok\Model\Package[]|null
     */
    public function getPackages()
    {
        return $this->container['packages'];
    }

    /**
     * Sets packages
     *
     * @param \Tiktok\Model\Package[]|null $packages packages
     *
     * @return self
     */
    public function setPackages($packages)
    {
        if (is_null($packages)) {
            throw new \InvalidArgumentException('non-nullable packages cannot be null');
        }
        $this->container['packages'] = $packages;

        return $this;
    }

    /**
     * Gets paid_time
     *
     * @return int|null
     */
    public function getPaidTime()
    {
        return $this->container['paid_time'];
    }

    /**
     * Sets paid_time
     *
     * @param int|null $paid_time paid_time
     *
     * @return self
     */
    public function setPaidTime($paid_time)
    {
        if (is_null($paid_time)) {
            throw new \InvalidArgumentException('non-nullable paid_time cannot be null');
        }
        $this->container['paid_time'] = $paid_time;

        return $this;
    }

    /**
     * Gets payment
     *
     * @return \Tiktok\Model\Payment|null
     */
    public function getPayment()
    {
        return $this->container['payment'];
    }

    /**
     * Sets payment
     *
     * @param \Tiktok\Model\Payment|null $payment payment
     *
     * @return self
     */
    public function setPayment($payment)
    {
        if (is_null($payment)) {
            throw new \InvalidArgumentException('non-nullable payment cannot be null');
        }
        $this->container['payment'] = $payment;

        return $this;
    }

    /**
     * Gets payment_method_name
     *
     * @return string|null
     */
    public function getPaymentMethodName()
    {
        return $this->container['payment_method_name'];
    }

    /**
     * Sets payment_method_name
     *
     * @param string|null $payment_method_name payment_method_name
     *
     * @return self
     */
    public function setPaymentMethodName($payment_method_name)
    {
        if (is_null($payment_method_name)) {
            throw new \InvalidArgumentException('non-nullable payment_method_name cannot be null');
        }
        $this->container['payment_method_name'] = $payment_method_name;

        return $this;
    }

    /**
     * Gets recipient_address
     *
     * @return \Tiktok\Model\Address|null
     */
    public function getRecipientAddress()
    {
        return $this->container['recipient_address'];
    }

    /**
     * Sets recipient_address
     *
     * @param \Tiktok\Model\Address|null $recipient_address recipient_address
     *
     * @return self
     */
    public function setRecipientAddress($recipient_address)
    {
        if (is_null($recipient_address)) {
            throw new \InvalidArgumentException('non-nullable recipient_address cannot be null');
        }
        $this->container['recipient_address'] = $recipient_address;

        return $this;
    }

    /**
     * Gets replaced_order_id
     *
     * @return string|null
     */
    public function getReplacedOrderId()
    {
        return $this->container['replaced_order_id'];
    }

    /**
     * Sets replaced_order_id
     *
     * @param string|null $replaced_order_id replaced_order_id
     *
     * @return self
     */
    public function setReplacedOrderId($replaced_order_id)
    {
        if (is_null($replaced_order_id)) {
            throw new \InvalidArgumentException('non-nullable replaced_order_id cannot be null');
        }
        $this->container['replaced_order_id'] = $replaced_order_id;

        return $this;
    }

    /**
     * Gets request_cancel_time
     *
     * @return int|null
     */
    public function getRequestCancelTime()
    {
        return $this->container['request_cancel_time'];
    }

    /**
     * Sets request_cancel_time
     *
     * @param int|null $request_cancel_time request_cancel_time
     *
     * @return self
     */
    public function setRequestCancelTime($request_cancel_time)
    {
        if (is_null($request_cancel_time)) {
            throw new \InvalidArgumentException('non-nullable request_cancel_time cannot be null');
        }
        $this->container['request_cancel_time'] = $request_cancel_time;

        return $this;
    }

    /**
     * Gets rts_sla_time
     *
     * @return int|null
     */
    public function getRtsSlaTime()
    {
        return $this->container['rts_sla_time'];
    }

    /**
     * Sets rts_sla_time
     *
     * @param int|null $rts_sla_time rts_sla_time
     *
     * @return self
     */
    public function setRtsSlaTime($rts_sla_time)
    {
        if (is_null($rts_sla_time)) {
            throw new \InvalidArgumentException('non-nullable rts_sla_time cannot be null');
        }
        $this->container['rts_sla_time'] = $rts_sla_time;

        return $this;
    }

    /**
     * Gets rts_time
     *
     * @return int|null
     */
    public function getRtsTime()
    {
        return $this->container['rts_time'];
    }

    /**
     * Sets rts_time
     *
     * @param int|null $rts_time rts_time
     *
     * @return self
     */
    public function setRtsTime($rts_time)
    {
        if (is_null($rts_time)) {
            throw new \InvalidArgumentException('non-nullable rts_time cannot be null');
        }
        $this->container['rts_time'] = $rts_time;

        return $this;
    }

    /**
     * Gets seller_note
     *
     * @return string|null
     */
    public function getSellerNote()
    {
        return $this->container['seller_note'];
    }

    /**
     * Sets seller_note
     *
     * @param string|null $seller_note seller_note
     *
     * @return self
     */
    public function setSellerNote($seller_note)
    {
        if (is_null($seller_note)) {
            throw new \InvalidArgumentException('non-nullable seller_note cannot be null');
        }
        $this->container['seller_note'] = $seller_note;

        return $this;
    }

    /**
     * Gets shipping_due_time
     *
     * @return int|null
     */
    public function getShippingDueTime()
    {
        return $this->container['shipping_due_time'];
    }

    /**
     * Sets shipping_due_time
     *
     * @param int|null $shipping_due_time shipping_due_time
     *
     * @return self
     */
    public function setShippingDueTime($shipping_due_time)
    {
        if (is_null($shipping_due_time)) {
            throw new \InvalidArgumentException('non-nullable shipping_due_time cannot be null');
        }
        $this->container['shipping_due_time'] = $shipping_due_time;

        return $this;
    }

    /**
     * Gets shipping_provider
     *
     * @return string|null
     */
    public function getShippingProvider()
    {
        return $this->container['shipping_provider'];
    }

    /**
     * Sets shipping_provider
     *
     * @param string|null $shipping_provider shipping_provider
     *
     * @return self
     */
    public function setShippingProvider($shipping_provider)
    {
        if (is_null($shipping_provider)) {
            throw new \InvalidArgumentException('non-nullable shipping_provider cannot be null');
        }
        $this->container['shipping_provider'] = $shipping_provider;

        return $this;
    }

    /**
     * Gets shipping_provider_id
     *
     * @return string|null
     */
    public function getShippingProviderId()
    {
        return $this->container['shipping_provider_id'];
    }

    /**
     * Sets shipping_provider_id
     *
     * @param string|null $shipping_provider_id shipping_provider_id
     *
     * @return self
     */
    public function setShippingProviderId($shipping_provider_id)
    {
        if (is_null($shipping_provider_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_provider_id cannot be null');
        }
        $this->container['shipping_provider_id'] = $shipping_provider_id;

        return $this;
    }

    /**
     * Gets shipping_type
     *
     * @return string|null
     */
    public function getShippingType()
    {
        return $this->container['shipping_type'];
    }

    /**
     * Sets shipping_type
     *
     * @param string|null $shipping_type shipping_type
     *
     * @return self
     */
    public function setShippingType($shipping_type)
    {
        if (is_null($shipping_type)) {
            throw new \InvalidArgumentException('non-nullable shipping_type cannot be null');
        }
        $this->container['shipping_type'] = $shipping_type;

        return $this;
    }

    /**
     * Gets split_or_combine_tag
     *
     * @return string|null
     */
    public function getSplitOrCombineTag()
    {
        return $this->container['split_or_combine_tag'];
    }

    /**
     * Sets split_or_combine_tag
     *
     * @param string|null $split_or_combine_tag split_or_combine_tag
     *
     * @return self
     */
    public function setSplitOrCombineTag($split_or_combine_tag)
    {
        if (is_null($split_or_combine_tag)) {
            throw new \InvalidArgumentException('non-nullable split_or_combine_tag cannot be null');
        }
        $this->container['split_or_combine_tag'] = $split_or_combine_tag;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number tracking_number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets tts_sla_time
     *
     * @return int|null
     */
    public function getTtsSlaTime()
    {
        return $this->container['tts_sla_time'];
    }

    /**
     * Sets tts_sla_time
     *
     * @param int|null $tts_sla_time tts_sla_time
     *
     * @return self
     */
    public function setTtsSlaTime($tts_sla_time)
    {
        if (is_null($tts_sla_time)) {
            throw new \InvalidArgumentException('non-nullable tts_sla_time cannot be null');
        }
        $this->container['tts_sla_time'] = $tts_sla_time;

        return $this;
    }

    /**
     * Gets update_time
     *
     * @return int|null
     */
    public function getUpdateTime()
    {
        return $this->container['update_time'];
    }

    /**
     * Sets update_time
     *
     * @param int|null $update_time update_time
     *
     * @return self
     */
    public function setUpdateTime($update_time)
    {
        if (is_null($update_time)) {
            throw new \InvalidArgumentException('non-nullable update_time cannot be null');
        }
        $this->container['update_time'] = $update_time;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string|null $user_id user_id
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets warehouse_id
     *
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->container['warehouse_id'];
    }

    /**
     * Sets warehouse_id
     *
     * @param string|null $warehouse_id warehouse_id
     *
     * @return self
     */
    public function setWarehouseId($warehouse_id)
    {
        if (is_null($warehouse_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_id cannot be null');
        }
        $this->container['warehouse_id'] = $warehouse_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


