<?php
/**
 * LineItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * LineItem Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class LineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'LineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'buyer_service_fee' => 'string',
        'cancel_reason' => 'string',
        'cancel_user' => 'string',
        'currency' => 'string',
        'display_status' => 'string',
        'id' => 'string',
        'is_gift' => 'bool',
        'item_tax' => '\Tiktok\Model\ItemTax[]',
        'original_price' => 'string',
        'package_id' => 'string',
        'package_status' => 'string',
        'platform_discount' => 'string',
        'product_id' => 'string',
        'product_name' => 'string',
        'retail_delivery_fee' => 'string',
        'rts_time' => 'int',
        'sale_price' => 'string',
        'seller_discount' => 'string',
        'seller_sku' => 'string',
        'shipping_provider_id' => 'string',
        'shipping_provider_name' => 'string',
        'sku_id' => 'string',
        'sku_image' => 'string',
        'sku_name' => 'string',
        'sku_type' => 'string',
        'small_order_fee' => 'string',
        'tracking_number' => 'string',
        'combined_listing_skus' => '\Tiktok\Model\CombinedSku[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'buyer_service_fee' => null,
        'cancel_reason' => null,
        'cancel_user' => null,
        'currency' => null,
        'display_status' => null,
        'id' => null,
        'is_gift' => null,
        'item_tax' => null,
        'original_price' => null,
        'package_id' => null,
        'package_status' => null,
        'platform_discount' => null,
        'product_id' => null,
        'product_name' => null,
        'retail_delivery_fee' => null,
        'rts_time' => null,
        'sale_price' => null,
        'seller_discount' => null,
        'seller_sku' => null,
        'shipping_provider_id' => null,
        'shipping_provider_name' => null,
        'sku_id' => null,
        'sku_image' => null,
        'sku_name' => null,
        'sku_type' => null,
        'small_order_fee' => null,
        'tracking_number' => null,
        'combined_listing_skus' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'buyer_service_fee' => false,
        'cancel_reason' => false,
        'cancel_user' => false,
        'currency' => false,
        'display_status' => false,
        'id' => false,
        'is_gift' => false,
        'item_tax' => false,
        'original_price' => false,
        'package_id' => false,
        'package_status' => false,
        'platform_discount' => false,
        'product_id' => false,
        'product_name' => false,
        'retail_delivery_fee' => false,
        'rts_time' => false,
        'sale_price' => false,
        'seller_discount' => false,
        'seller_sku' => false,
        'shipping_provider_id' => false,
        'shipping_provider_name' => false,
        'sku_id' => false,
        'sku_image' => false,
        'sku_name' => false,
        'sku_type' => false,
        'small_order_fee' => false,
        'tracking_number' => false,
        'combined_listing_skus' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'buyer_service_fee' => 'buyer_service_fee',
        'cancel_reason' => 'cancel_reason',
        'cancel_user' => 'cancel_user',
        'currency' => 'currency',
        'display_status' => 'display_status',
        'id' => 'id',
        'is_gift' => 'is_gift',
        'item_tax' => 'item_tax',
        'original_price' => 'original_price',
        'package_id' => 'package_id',
        'package_status' => 'package_status',
        'platform_discount' => 'platform_discount',
        'product_id' => 'product_id',
        'product_name' => 'product_name',
        'retail_delivery_fee' => 'retail_delivery_fee',
        'rts_time' => 'rts_time',
        'sale_price' => 'sale_price',
        'seller_discount' => 'seller_discount',
        'seller_sku' => 'seller_sku',
        'shipping_provider_id' => 'shipping_provider_id',
        'shipping_provider_name' => 'shipping_provider_name',
        'sku_id' => 'sku_id',
        'sku_image' => 'sku_image',
        'sku_name' => 'sku_name',
        'sku_type' => 'sku_type',
        'small_order_fee' => 'small_order_fee',
        'tracking_number' => 'tracking_number',
        'combined_listing_skus' => 'combined_listing_skus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'buyer_service_fee' => 'setBuyerServiceFee',
        'cancel_reason' => 'setCancelReason',
        'cancel_user' => 'setCancelUser',
        'currency' => 'setCurrency',
        'display_status' => 'setDisplayStatus',
        'id' => 'setId',
        'is_gift' => 'setIsGift',
        'item_tax' => 'setItemTax',
        'original_price' => 'setOriginalPrice',
        'package_id' => 'setPackageId',
        'package_status' => 'setPackageStatus',
        'platform_discount' => 'setPlatformDiscount',
        'product_id' => 'setProductId',
        'product_name' => 'setProductName',
        'retail_delivery_fee' => 'setRetailDeliveryFee',
        'rts_time' => 'setRtsTime',
        'sale_price' => 'setSalePrice',
        'seller_discount' => 'setSellerDiscount',
        'seller_sku' => 'setSellerSku',
        'shipping_provider_id' => 'setShippingProviderId',
        'shipping_provider_name' => 'setShippingProviderName',
        'sku_id' => 'setSkuId',
        'sku_image' => 'setSkuImage',
        'sku_name' => 'setSkuName',
        'sku_type' => 'setSkuType',
        'small_order_fee' => 'setSmallOrderFee',
        'tracking_number' => 'setTrackingNumber',
        'combined_listing_skus' => 'setCombinedListingSkus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'buyer_service_fee' => 'getBuyerServiceFee',
        'cancel_reason' => 'getCancelReason',
        'cancel_user' => 'getCancelUser',
        'currency' => 'getCurrency',
        'display_status' => 'getDisplayStatus',
        'id' => 'getId',
        'is_gift' => 'getIsGift',
        'item_tax' => 'getItemTax',
        'original_price' => 'getOriginalPrice',
        'package_id' => 'getPackageId',
        'package_status' => 'getPackageStatus',
        'platform_discount' => 'getPlatformDiscount',
        'product_id' => 'getProductId',
        'product_name' => 'getProductName',
        'retail_delivery_fee' => 'getRetailDeliveryFee',
        'rts_time' => 'getRtsTime',
        'sale_price' => 'getSalePrice',
        'seller_discount' => 'getSellerDiscount',
        'seller_sku' => 'getSellerSku',
        'shipping_provider_id' => 'getShippingProviderId',
        'shipping_provider_name' => 'getShippingProviderName',
        'sku_id' => 'getSkuId',
        'sku_image' => 'getSkuImage',
        'sku_name' => 'getSkuName',
        'sku_type' => 'getSkuType',
        'small_order_fee' => 'getSmallOrderFee',
        'tracking_number' => 'getTrackingNumber',
        'combined_listing_skus' => 'getCombinedListingSkus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('buyer_service_fee', $data ?? [], null);
        $this->setIfExists('cancel_reason', $data ?? [], null);
        $this->setIfExists('cancel_user', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('display_status', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_gift', $data ?? [], null);
        $this->setIfExists('item_tax', $data ?? [], null);
        $this->setIfExists('original_price', $data ?? [], null);
        $this->setIfExists('package_id', $data ?? [], null);
        $this->setIfExists('package_status', $data ?? [], null);
        $this->setIfExists('platform_discount', $data ?? [], null);
        $this->setIfExists('product_id', $data ?? [], null);
        $this->setIfExists('product_name', $data ?? [], null);
        $this->setIfExists('retail_delivery_fee', $data ?? [], null);
        $this->setIfExists('rts_time', $data ?? [], null);
        $this->setIfExists('sale_price', $data ?? [], null);
        $this->setIfExists('seller_discount', $data ?? [], null);
        $this->setIfExists('seller_sku', $data ?? [], null);
        $this->setIfExists('shipping_provider_id', $data ?? [], null);
        $this->setIfExists('shipping_provider_name', $data ?? [], null);
        $this->setIfExists('sku_id', $data ?? [], null);
        $this->setIfExists('sku_image', $data ?? [], null);
        $this->setIfExists('sku_name', $data ?? [], null);
        $this->setIfExists('sku_type', $data ?? [], null);
        $this->setIfExists('small_order_fee', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('combined_listing_skus', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets buyer_service_fee
     *
     * @return string|null
     */
    public function getBuyerServiceFee()
    {
        return $this->container['buyer_service_fee'];
    }

    /**
     * Sets buyer_service_fee
     *
     * @param string|null $buyer_service_fee buyer_service_fee
     *
     * @return self
     */
    public function setBuyerServiceFee($buyer_service_fee)
    {
        if (is_null($buyer_service_fee)) {
            throw new \InvalidArgumentException('non-nullable buyer_service_fee cannot be null');
        }
        $this->container['buyer_service_fee'] = $buyer_service_fee;

        return $this;
    }

    /**
     * Gets cancel_reason
     *
     * @return string|null
     */
    public function getCancelReason()
    {
        return $this->container['cancel_reason'];
    }

    /**
     * Sets cancel_reason
     *
     * @param string|null $cancel_reason cancel_reason
     *
     * @return self
     */
    public function setCancelReason($cancel_reason)
    {
        if (is_null($cancel_reason)) {
            throw new \InvalidArgumentException('non-nullable cancel_reason cannot be null');
        }
        $this->container['cancel_reason'] = $cancel_reason;

        return $this;
    }

    /**
     * Gets cancel_user
     *
     * @return string|null
     */
    public function getCancelUser()
    {
        return $this->container['cancel_user'];
    }

    /**
     * Sets cancel_user
     *
     * @param string|null $cancel_user cancel_user
     *
     * @return self
     */
    public function setCancelUser($cancel_user)
    {
        if (is_null($cancel_user)) {
            throw new \InvalidArgumentException('non-nullable cancel_user cannot be null');
        }
        $this->container['cancel_user'] = $cancel_user;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets display_status
     *
     * @return string|null
     */
    public function getDisplayStatus()
    {
        return $this->container['display_status'];
    }

    /**
     * Sets display_status
     *
     * @param string|null $display_status display_status
     *
     * @return self
     */
    public function setDisplayStatus($display_status)
    {
        if (is_null($display_status)) {
            throw new \InvalidArgumentException('non-nullable display_status cannot be null');
        }
        $this->container['display_status'] = $display_status;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_gift
     *
     * @return bool|null
     */
    public function getIsGift()
    {
        return $this->container['is_gift'];
    }

    /**
     * Sets is_gift
     *
     * @param bool|null $is_gift is_gift
     *
     * @return self
     */
    public function setIsGift($is_gift)
    {
        if (is_null($is_gift)) {
            throw new \InvalidArgumentException('non-nullable is_gift cannot be null');
        }
        $this->container['is_gift'] = $is_gift;

        return $this;
    }

    /**
     * Gets item_tax
     *
     * @return \Tiktok\Model\ItemTax[]|null
     */
    public function getItemTax()
    {
        return $this->container['item_tax'];
    }

    /**
     * Sets item_tax
     *
     * @param \Tiktok\Model\ItemTax[]|null $item_tax item_tax
     *
     * @return self
     */
    public function setItemTax($item_tax)
    {
        if (is_null($item_tax)) {
            throw new \InvalidArgumentException('non-nullable item_tax cannot be null');
        }
        $this->container['item_tax'] = $item_tax;

        return $this;
    }

    /**
     * Gets original_price
     *
     * @return string|null
     */
    public function getOriginalPrice()
    {
        return $this->container['original_price'];
    }

    /**
     * Sets original_price
     *
     * @param string|null $original_price original_price
     *
     * @return self
     */
    public function setOriginalPrice($original_price)
    {
        if (is_null($original_price)) {
            throw new \InvalidArgumentException('non-nullable original_price cannot be null');
        }
        $this->container['original_price'] = $original_price;

        return $this;
    }

    /**
     * Gets package_id
     *
     * @return string|null
     */
    public function getPackageId()
    {
        return $this->container['package_id'];
    }

    /**
     * Sets package_id
     *
     * @param string|null $package_id package_id
     *
     * @return self
     */
    public function setPackageId($package_id)
    {
        if (is_null($package_id)) {
            throw new \InvalidArgumentException('non-nullable package_id cannot be null');
        }
        $this->container['package_id'] = $package_id;

        return $this;
    }

    /**
     * Gets package_status
     *
     * @return string|null
     */
    public function getPackageStatus()
    {
        return $this->container['package_status'];
    }

    /**
     * Sets package_status
     *
     * @param string|null $package_status package_status
     *
     * @return self
     */
    public function setPackageStatus($package_status)
    {
        if (is_null($package_status)) {
            throw new \InvalidArgumentException('non-nullable package_status cannot be null');
        }
        $this->container['package_status'] = $package_status;

        return $this;
    }

    /**
     * Gets platform_discount
     *
     * @return string|null
     */
    public function getPlatformDiscount()
    {
        return $this->container['platform_discount'];
    }

    /**
     * Sets platform_discount
     *
     * @param string|null $platform_discount platform_discount
     *
     * @return self
     */
    public function setPlatformDiscount($platform_discount)
    {
        if (is_null($platform_discount)) {
            throw new \InvalidArgumentException('non-nullable platform_discount cannot be null');
        }
        $this->container['platform_discount'] = $platform_discount;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string|null $product_id product_id
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        if (is_null($product_id)) {
            throw new \InvalidArgumentException('non-nullable product_id cannot be null');
        }
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets product_name
     *
     * @return string|null
     */
    public function getProductName()
    {
        return $this->container['product_name'];
    }

    /**
     * Sets product_name
     *
     * @param string|null $product_name product_name
     *
     * @return self
     */
    public function setProductName($product_name)
    {
        if (is_null($product_name)) {
            throw new \InvalidArgumentException('non-nullable product_name cannot be null');
        }
        $this->container['product_name'] = $product_name;

        return $this;
    }

    /**
     * Gets retail_delivery_fee
     *
     * @return string|null
     */
    public function getRetailDeliveryFee()
    {
        return $this->container['retail_delivery_fee'];
    }

    /**
     * Sets retail_delivery_fee
     *
     * @param string|null $retail_delivery_fee retail_delivery_fee
     *
     * @return self
     */
    public function setRetailDeliveryFee($retail_delivery_fee)
    {
        if (is_null($retail_delivery_fee)) {
            throw new \InvalidArgumentException('non-nullable retail_delivery_fee cannot be null');
        }
        $this->container['retail_delivery_fee'] = $retail_delivery_fee;

        return $this;
    }

    /**
     * Gets rts_time
     *
     * @return int|null
     */
    public function getRtsTime()
    {
        return $this->container['rts_time'];
    }

    /**
     * Sets rts_time
     *
     * @param int|null $rts_time rts_time
     *
     * @return self
     */
    public function setRtsTime($rts_time)
    {
        if (is_null($rts_time)) {
            throw new \InvalidArgumentException('non-nullable rts_time cannot be null');
        }
        $this->container['rts_time'] = $rts_time;

        return $this;
    }

    /**
     * Gets sale_price
     *
     * @return string|null
     */
    public function getSalePrice()
    {
        return $this->container['sale_price'];
    }

    /**
     * Sets sale_price
     *
     * @param string|null $sale_price sale_price
     *
     * @return self
     */
    public function setSalePrice($sale_price)
    {
        if (is_null($sale_price)) {
            throw new \InvalidArgumentException('non-nullable sale_price cannot be null');
        }
        $this->container['sale_price'] = $sale_price;

        return $this;
    }

    /**
     * Gets seller_discount
     *
     * @return string|null
     */
    public function getSellerDiscount()
    {
        return $this->container['seller_discount'];
    }

    /**
     * Sets seller_discount
     *
     * @param string|null $seller_discount seller_discount
     *
     * @return self
     */
    public function setSellerDiscount($seller_discount)
    {
        if (is_null($seller_discount)) {
            throw new \InvalidArgumentException('non-nullable seller_discount cannot be null');
        }
        $this->container['seller_discount'] = $seller_discount;

        return $this;
    }

    /**
     * Gets seller_sku
     *
     * @return string|null
     */
    public function getSellerSku()
    {
        return $this->container['seller_sku'];
    }

    /**
     * Sets seller_sku
     *
     * @param string|null $seller_sku seller_sku
     *
     * @return self
     */
    public function setSellerSku($seller_sku)
    {
        if (is_null($seller_sku)) {
            throw new \InvalidArgumentException('non-nullable seller_sku cannot be null');
        }
        $this->container['seller_sku'] = $seller_sku;

        return $this;
    }

    /**
     * Gets shipping_provider_id
     *
     * @return string|null
     */
    public function getShippingProviderId()
    {
        return $this->container['shipping_provider_id'];
    }

    /**
     * Sets shipping_provider_id
     *
     * @param string|null $shipping_provider_id shipping_provider_id
     *
     * @return self
     */
    public function setShippingProviderId($shipping_provider_id)
    {
        if (is_null($shipping_provider_id)) {
            throw new \InvalidArgumentException('non-nullable shipping_provider_id cannot be null');
        }
        $this->container['shipping_provider_id'] = $shipping_provider_id;

        return $this;
    }

    /**
     * Gets shipping_provider_name
     *
     * @return string|null
     */
    public function getShippingProviderName()
    {
        return $this->container['shipping_provider_name'];
    }

    /**
     * Sets shipping_provider_name
     *
     * @param string|null $shipping_provider_name shipping_provider_name
     *
     * @return self
     */
    public function setShippingProviderName($shipping_provider_name)
    {
        if (is_null($shipping_provider_name)) {
            throw new \InvalidArgumentException('non-nullable shipping_provider_name cannot be null');
        }
        $this->container['shipping_provider_name'] = $shipping_provider_name;

        return $this;
    }

    /**
     * Gets sku_id
     *
     * @return string|null
     */
    public function getSkuId()
    {
        return $this->container['sku_id'];
    }

    /**
     * Sets sku_id
     *
     * @param string|null $sku_id sku_id
     *
     * @return self
     */
    public function setSkuId($sku_id)
    {
        if (is_null($sku_id)) {
            throw new \InvalidArgumentException('non-nullable sku_id cannot be null');
        }
        $this->container['sku_id'] = $sku_id;

        return $this;
    }

    /**
     * Gets sku_image
     *
     * @return string|null
     */
    public function getSkuImage()
    {
        return $this->container['sku_image'];
    }

    /**
     * Sets sku_image
     *
     * @param string|null $sku_image sku_image
     *
     * @return self
     */
    public function setSkuImage($sku_image)
    {
        if (is_null($sku_image)) {
            throw new \InvalidArgumentException('non-nullable sku_image cannot be null');
        }
        $this->container['sku_image'] = $sku_image;

        return $this;
    }

    /**
     * Gets sku_name
     *
     * @return string|null
     */
    public function getSkuName()
    {
        return $this->container['sku_name'];
    }

    /**
     * Sets sku_name
     *
     * @param string|null $sku_name sku_name
     *
     * @return self
     */
    public function setSkuName($sku_name)
    {
        if (is_null($sku_name)) {
            throw new \InvalidArgumentException('non-nullable sku_name cannot be null');
        }
        $this->container['sku_name'] = $sku_name;

        return $this;
    }

    /**
     * Gets sku_type
     *
     * @return string|null
     */
    public function getSkuType()
    {
        return $this->container['sku_type'];
    }

    /**
     * Sets sku_type
     *
     * @param string|null $sku_type sku_type
     *
     * @return self
     */
    public function setSkuType($sku_type)
    {
        if (is_null($sku_type)) {
            throw new \InvalidArgumentException('non-nullable sku_type cannot be null');
        }
        $this->container['sku_type'] = $sku_type;

        return $this;
    }

    /**
     * Gets small_order_fee
     *
     * @return string|null
     */
    public function getSmallOrderFee()
    {
        return $this->container['small_order_fee'];
    }

    /**
     * Sets small_order_fee
     *
     * @param string|null $small_order_fee small_order_fee
     *
     * @return self
     */
    public function setSmallOrderFee($small_order_fee)
    {
        if (is_null($small_order_fee)) {
            throw new \InvalidArgumentException('non-nullable small_order_fee cannot be null');
        }
        $this->container['small_order_fee'] = $small_order_fee;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number tracking_number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets combined_listing_skus
     *
     * @return \Tiktok\Model\CombinedSku[]|null
     */
    public function getCombinedListingSkus()
    {
        return $this->container['combined_listing_skus'];
    }

    /**
     * Sets combined_listing_skus
     *
     * @param \Tiktok\Model\CombinedSku[]|null $combined_listing_skus combined_listing_skus
     *
     * @return self
     */
    public function setCombinedListingSkus($combined_listing_skus)
    {
        if (is_null($combined_listing_skus)) {
            throw new \InvalidArgumentException('non-nullable combined_listing_skus cannot be null');
        }
        $this->container['combined_listing_skus'] = $combined_listing_skus;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


