<?php
/**
 * InventorySku
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * InventorySku Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InventorySku implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InventorySku';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'seller_sku' => 'string',
        'total_available_inventory_distribution' => '\Tiktok\Model\InventoryDistribution',
        'total_available_quantity' => 'int',
        'total_committed_quantity' => 'int',
        'warehouse_inventory' => '\Tiktok\Model\WarehouseInventory[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'seller_sku' => null,
        'total_available_inventory_distribution' => null,
        'total_available_quantity' => null,
        'total_committed_quantity' => null,
        'warehouse_inventory' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'seller_sku' => false,
        'total_available_inventory_distribution' => false,
        'total_available_quantity' => false,
        'total_committed_quantity' => false,
        'warehouse_inventory' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'seller_sku' => 'seller_sku',
        'total_available_inventory_distribution' => 'total_available_inventory_distribution',
        'total_available_quantity' => 'total_available_quantity',
        'total_committed_quantity' => 'total_committed_quantity',
        'warehouse_inventory' => 'warehouse_inventory'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'seller_sku' => 'setSellerSku',
        'total_available_inventory_distribution' => 'setTotalAvailableInventoryDistribution',
        'total_available_quantity' => 'setTotalAvailableQuantity',
        'total_committed_quantity' => 'setTotalCommittedQuantity',
        'warehouse_inventory' => 'setWarehouseInventory'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'seller_sku' => 'getSellerSku',
        'total_available_inventory_distribution' => 'getTotalAvailableInventoryDistribution',
        'total_available_quantity' => 'getTotalAvailableQuantity',
        'total_committed_quantity' => 'getTotalCommittedQuantity',
        'warehouse_inventory' => 'getWarehouseInventory'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('seller_sku', $data ?? [], null);
        $this->setIfExists('total_available_inventory_distribution', $data ?? [], null);
        $this->setIfExists('total_available_quantity', $data ?? [], null);
        $this->setIfExists('total_committed_quantity', $data ?? [], null);
        $this->setIfExists('warehouse_inventory', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets seller_sku
     *
     * @return string|null
     */
    public function getSellerSku()
    {
        return $this->container['seller_sku'];
    }

    /**
     * Sets seller_sku
     *
     * @param string|null $seller_sku seller_sku
     *
     * @return self
     */
    public function setSellerSku($seller_sku)
    {
        if (is_null($seller_sku)) {
            throw new \InvalidArgumentException('non-nullable seller_sku cannot be null');
        }
        $this->container['seller_sku'] = $seller_sku;

        return $this;
    }

    /**
     * Gets total_available_inventory_distribution
     *
     * @return \Tiktok\Model\InventoryDistribution|null
     */
    public function getTotalAvailableInventoryDistribution()
    {
        return $this->container['total_available_inventory_distribution'];
    }

    /**
     * Sets total_available_inventory_distribution
     *
     * @param \Tiktok\Model\InventoryDistribution|null $total_available_inventory_distribution total_available_inventory_distribution
     *
     * @return self
     */
    public function setTotalAvailableInventoryDistribution($total_available_inventory_distribution)
    {
        if (is_null($total_available_inventory_distribution)) {
            throw new \InvalidArgumentException('non-nullable total_available_inventory_distribution cannot be null');
        }
        $this->container['total_available_inventory_distribution'] = $total_available_inventory_distribution;

        return $this;
    }

    /**
     * Gets total_available_quantity
     *
     * @return int|null
     */
    public function getTotalAvailableQuantity()
    {
        return $this->container['total_available_quantity'];
    }

    /**
     * Sets total_available_quantity
     *
     * @param int|null $total_available_quantity total_available_quantity
     *
     * @return self
     */
    public function setTotalAvailableQuantity($total_available_quantity)
    {
        if (is_null($total_available_quantity)) {
            throw new \InvalidArgumentException('non-nullable total_available_quantity cannot be null');
        }
        $this->container['total_available_quantity'] = $total_available_quantity;

        return $this;
    }

    /**
     * Gets total_committed_quantity
     *
     * @return int|null
     */
    public function getTotalCommittedQuantity()
    {
        return $this->container['total_committed_quantity'];
    }

    /**
     * Sets total_committed_quantity
     *
     * @param int|null $total_committed_quantity total_committed_quantity
     *
     * @return self
     */
    public function setTotalCommittedQuantity($total_committed_quantity)
    {
        if (is_null($total_committed_quantity)) {
            throw new \InvalidArgumentException('non-nullable total_committed_quantity cannot be null');
        }
        $this->container['total_committed_quantity'] = $total_committed_quantity;

        return $this;
    }

    /**
     * Gets warehouse_inventory
     *
     * @return \Tiktok\Model\WarehouseInventory[]|null
     */
    public function getWarehouseInventory()
    {
        return $this->container['warehouse_inventory'];
    }

    /**
     * Sets warehouse_inventory
     *
     * @param \Tiktok\Model\WarehouseInventory[]|null $warehouse_inventory warehouse_inventory
     *
     * @return self
     */
    public function setWarehouseInventory($warehouse_inventory)
    {
        if (is_null($warehouse_inventory)) {
            throw new \InvalidArgumentException('non-nullable warehouse_inventory cannot be null');
        }
        $this->container['warehouse_inventory'] = $warehouse_inventory;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


