<?php
/**
 * CreateProductRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * CreateProductRequest Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateProductRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateProductRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'brand_id' => 'string',
        'category_id' => 'string',
        'category_version' => 'string',
        'certifications' => '\Tiktok\Model\Certification',
        'delivery_option_ids' => 'string',
        'description' => 'string',
        'external_product_id' => 'string',
        'is_cod_allowed' => 'bool',
        'is_not_for_sale' => 'bool',
        'main_images' => '\Tiktok\Model\Image[]',
        'manufacturer' => '\Tiktok\Model\Manufacturer',
        'package_dimensions' => '\Tiktok\Model\Dimension',
        'package_weight' => '\Tiktok\Model\Weight',
        'primary_combined_product_id' => 'string',
        'product_attributes' => '\Tiktok\Model\Attribute[]',
        'save_mode' => 'string',
        'size_chart' => '\Tiktok\Model\SizeChart',
        'skus' => '\Tiktok\Model\ProductSku[]',
        'title' => 'string',
        'video' => '\Tiktok\Model\IdResponseData'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'brand_id' => null,
        'category_id' => null,
        'category_version' => null,
        'certifications' => null,
        'delivery_option_ids' => null,
        'description' => null,
        'external_product_id' => null,
        'is_cod_allowed' => null,
        'is_not_for_sale' => null,
        'main_images' => null,
        'manufacturer' => null,
        'package_dimensions' => null,
        'package_weight' => null,
        'primary_combined_product_id' => null,
        'product_attributes' => null,
        'save_mode' => null,
        'size_chart' => null,
        'skus' => null,
        'title' => null,
        'video' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'brand_id' => false,
        'category_id' => false,
        'category_version' => false,
        'certifications' => false,
        'delivery_option_ids' => false,
        'description' => false,
        'external_product_id' => false,
        'is_cod_allowed' => false,
        'is_not_for_sale' => false,
        'main_images' => false,
        'manufacturer' => false,
        'package_dimensions' => false,
        'package_weight' => false,
        'primary_combined_product_id' => false,
        'product_attributes' => false,
        'save_mode' => false,
        'size_chart' => false,
        'skus' => false,
        'title' => false,
        'video' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'brand_id' => 'brand_id',
        'category_id' => 'category_id',
        'category_version' => 'category_version',
        'certifications' => 'certifications',
        'delivery_option_ids' => 'delivery_option_ids',
        'description' => 'description',
        'external_product_id' => 'external_product_id',
        'is_cod_allowed' => 'is_cod_allowed',
        'is_not_for_sale' => 'is_not_for_sale',
        'main_images' => 'main_images',
        'manufacturer' => 'manufacturer',
        'package_dimensions' => 'package_dimensions',
        'package_weight' => 'package_weight',
        'primary_combined_product_id' => 'primary_combined_product_id',
        'product_attributes' => 'product_attributes',
        'save_mode' => 'save_mode',
        'size_chart' => 'size_chart',
        'skus' => 'skus',
        'title' => 'title',
        'video' => 'video'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'brand_id' => 'setBrandId',
        'category_id' => 'setCategoryId',
        'category_version' => 'setCategoryVersion',
        'certifications' => 'setCertifications',
        'delivery_option_ids' => 'setDeliveryOptionIds',
        'description' => 'setDescription',
        'external_product_id' => 'setExternalProductId',
        'is_cod_allowed' => 'setIsCodAllowed',
        'is_not_for_sale' => 'setIsNotForSale',
        'main_images' => 'setMainImages',
        'manufacturer' => 'setManufacturer',
        'package_dimensions' => 'setPackageDimensions',
        'package_weight' => 'setPackageWeight',
        'primary_combined_product_id' => 'setPrimaryCombinedProductId',
        'product_attributes' => 'setProductAttributes',
        'save_mode' => 'setSaveMode',
        'size_chart' => 'setSizeChart',
        'skus' => 'setSkus',
        'title' => 'setTitle',
        'video' => 'setVideo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'brand_id' => 'getBrandId',
        'category_id' => 'getCategoryId',
        'category_version' => 'getCategoryVersion',
        'certifications' => 'getCertifications',
        'delivery_option_ids' => 'getDeliveryOptionIds',
        'description' => 'getDescription',
        'external_product_id' => 'getExternalProductId',
        'is_cod_allowed' => 'getIsCodAllowed',
        'is_not_for_sale' => 'getIsNotForSale',
        'main_images' => 'getMainImages',
        'manufacturer' => 'getManufacturer',
        'package_dimensions' => 'getPackageDimensions',
        'package_weight' => 'getPackageWeight',
        'primary_combined_product_id' => 'getPrimaryCombinedProductId',
        'product_attributes' => 'getProductAttributes',
        'save_mode' => 'getSaveMode',
        'size_chart' => 'getSizeChart',
        'skus' => 'getSkus',
        'title' => 'getTitle',
        'video' => 'getVideo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('brand_id', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('category_version', $data ?? [], null);
        $this->setIfExists('certifications', $data ?? [], null);
        $this->setIfExists('delivery_option_ids', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('external_product_id', $data ?? [], null);
        $this->setIfExists('is_cod_allowed', $data ?? [], null);
        $this->setIfExists('is_not_for_sale', $data ?? [], null);
        $this->setIfExists('main_images', $data ?? [], null);
        $this->setIfExists('manufacturer', $data ?? [], null);
        $this->setIfExists('package_dimensions', $data ?? [], null);
        $this->setIfExists('package_weight', $data ?? [], null);
        $this->setIfExists('primary_combined_product_id', $data ?? [], null);
        $this->setIfExists('product_attributes', $data ?? [], null);
        $this->setIfExists('save_mode', $data ?? [], null);
        $this->setIfExists('size_chart', $data ?? [], null);
        $this->setIfExists('skus', $data ?? [], null);
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('video', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id brand_id
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        if (is_null($brand_id)) {
            throw new \InvalidArgumentException('non-nullable brand_id cannot be null');
        }
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param string|null $category_id category_id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets category_version
     *
     * @return string|null
     */
    public function getCategoryVersion()
    {
        return $this->container['category_version'];
    }

    /**
     * Sets category_version
     *
     * @param string|null $category_version category_version
     *
     * @return self
     */
    public function setCategoryVersion($category_version)
    {
        if (is_null($category_version)) {
            throw new \InvalidArgumentException('non-nullable category_version cannot be null');
        }
        $this->container['category_version'] = $category_version;

        return $this;
    }

    /**
     * Gets certifications
     *
     * @return \Tiktok\Model\Certification|null
     */
    public function getCertifications()
    {
        return $this->container['certifications'];
    }

    /**
     * Sets certifications
     *
     * @param \Tiktok\Model\Certification|null $certifications certifications
     *
     * @return self
     */
    public function setCertifications($certifications)
    {
        if (is_null($certifications)) {
            throw new \InvalidArgumentException('non-nullable certifications cannot be null');
        }
        $this->container['certifications'] = $certifications;

        return $this;
    }

    /**
     * Gets delivery_option_ids
     *
     * @return string|null
     */
    public function getDeliveryOptionIds()
    {
        return $this->container['delivery_option_ids'];
    }

    /**
     * Sets delivery_option_ids
     *
     * @param string|null $delivery_option_ids delivery_option_ids
     *
     * @return self
     */
    public function setDeliveryOptionIds($delivery_option_ids)
    {
        if (is_null($delivery_option_ids)) {
            throw new \InvalidArgumentException('non-nullable delivery_option_ids cannot be null');
        }
        $this->container['delivery_option_ids'] = $delivery_option_ids;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets external_product_id
     *
     * @return string|null
     */
    public function getExternalProductId()
    {
        return $this->container['external_product_id'];
    }

    /**
     * Sets external_product_id
     *
     * @param string|null $external_product_id external_product_id
     *
     * @return self
     */
    public function setExternalProductId($external_product_id)
    {
        if (is_null($external_product_id)) {
            throw new \InvalidArgumentException('non-nullable external_product_id cannot be null');
        }
        $this->container['external_product_id'] = $external_product_id;

        return $this;
    }

    /**
     * Gets is_cod_allowed
     *
     * @return bool|null
     */
    public function getIsCodAllowed()
    {
        return $this->container['is_cod_allowed'];
    }

    /**
     * Sets is_cod_allowed
     *
     * @param bool|null $is_cod_allowed is_cod_allowed
     *
     * @return self
     */
    public function setIsCodAllowed($is_cod_allowed)
    {
        if (is_null($is_cod_allowed)) {
            throw new \InvalidArgumentException('non-nullable is_cod_allowed cannot be null');
        }
        $this->container['is_cod_allowed'] = $is_cod_allowed;

        return $this;
    }

    /**
     * Gets is_not_for_sale
     *
     * @return bool|null
     */
    public function getIsNotForSale()
    {
        return $this->container['is_not_for_sale'];
    }

    /**
     * Sets is_not_for_sale
     *
     * @param bool|null $is_not_for_sale is_not_for_sale
     *
     * @return self
     */
    public function setIsNotForSale($is_not_for_sale)
    {
        if (is_null($is_not_for_sale)) {
            throw new \InvalidArgumentException('non-nullable is_not_for_sale cannot be null');
        }
        $this->container['is_not_for_sale'] = $is_not_for_sale;

        return $this;
    }

    /**
     * Gets main_images
     *
     * @return \Tiktok\Model\Image[]|null
     */
    public function getMainImages()
    {
        return $this->container['main_images'];
    }

    /**
     * Sets main_images
     *
     * @param \Tiktok\Model\Image[]|null $main_images main_images
     *
     * @return self
     */
    public function setMainImages($main_images)
    {
        if (is_null($main_images)) {
            throw new \InvalidArgumentException('non-nullable main_images cannot be null');
        }
        $this->container['main_images'] = $main_images;

        return $this;
    }

    /**
     * Gets manufacturer
     *
     * @return \Tiktok\Model\Manufacturer|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param \Tiktok\Model\Manufacturer|null $manufacturer manufacturer
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        if (is_null($manufacturer)) {
            throw new \InvalidArgumentException('non-nullable manufacturer cannot be null');
        }
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }

    /**
     * Gets package_dimensions
     *
     * @return \Tiktok\Model\Dimension|null
     */
    public function getPackageDimensions()
    {
        return $this->container['package_dimensions'];
    }

    /**
     * Sets package_dimensions
     *
     * @param \Tiktok\Model\Dimension|null $package_dimensions package_dimensions
     *
     * @return self
     */
    public function setPackageDimensions($package_dimensions)
    {
        if (is_null($package_dimensions)) {
            throw new \InvalidArgumentException('non-nullable package_dimensions cannot be null');
        }
        $this->container['package_dimensions'] = $package_dimensions;

        return $this;
    }

    /**
     * Gets package_weight
     *
     * @return \Tiktok\Model\Weight|null
     */
    public function getPackageWeight()
    {
        return $this->container['package_weight'];
    }

    /**
     * Sets package_weight
     *
     * @param \Tiktok\Model\Weight|null $package_weight package_weight
     *
     * @return self
     */
    public function setPackageWeight($package_weight)
    {
        if (is_null($package_weight)) {
            throw new \InvalidArgumentException('non-nullable package_weight cannot be null');
        }
        $this->container['package_weight'] = $package_weight;

        return $this;
    }

    /**
     * Gets primary_combined_product_id
     *
     * @return string|null
     */
    public function getPrimaryCombinedProductId()
    {
        return $this->container['primary_combined_product_id'];
    }

    /**
     * Sets primary_combined_product_id
     *
     * @param string|null $primary_combined_product_id primary_combined_product_id
     *
     * @return self
     */
    public function setPrimaryCombinedProductId($primary_combined_product_id)
    {
        if (is_null($primary_combined_product_id)) {
            throw new \InvalidArgumentException('non-nullable primary_combined_product_id cannot be null');
        }
        $this->container['primary_combined_product_id'] = $primary_combined_product_id;

        return $this;
    }

    /**
     * Gets product_attributes
     *
     * @return \Tiktok\Model\Attribute[]|null
     */
    public function getProductAttributes()
    {
        return $this->container['product_attributes'];
    }

    /**
     * Sets product_attributes
     *
     * @param \Tiktok\Model\Attribute[]|null $product_attributes product_attributes
     *
     * @return self
     */
    public function setProductAttributes($product_attributes)
    {
        if (is_null($product_attributes)) {
            throw new \InvalidArgumentException('non-nullable product_attributes cannot be null');
        }
        $this->container['product_attributes'] = $product_attributes;

        return $this;
    }

    /**
     * Gets save_mode
     *
     * @return string|null
     */
    public function getSaveMode()
    {
        return $this->container['save_mode'];
    }

    /**
     * Sets save_mode
     *
     * @param string|null $save_mode save_mode
     *
     * @return self
     */
    public function setSaveMode($save_mode)
    {
        if (is_null($save_mode)) {
            throw new \InvalidArgumentException('non-nullable save_mode cannot be null');
        }
        $this->container['save_mode'] = $save_mode;

        return $this;
    }

    /**
     * Gets size_chart
     *
     * @return \Tiktok\Model\SizeChart|null
     */
    public function getSizeChart()
    {
        return $this->container['size_chart'];
    }

    /**
     * Sets size_chart
     *
     * @param \Tiktok\Model\SizeChart|null $size_chart size_chart
     *
     * @return self
     */
    public function setSizeChart($size_chart)
    {
        if (is_null($size_chart)) {
            throw new \InvalidArgumentException('non-nullable size_chart cannot be null');
        }
        $this->container['size_chart'] = $size_chart;

        return $this;
    }

    /**
     * Gets skus
     *
     * @return \Tiktok\Model\ProductSku[]|null
     */
    public function getSkus()
    {
        return $this->container['skus'];
    }

    /**
     * Sets skus
     *
     * @param \Tiktok\Model\ProductSku[]|null $skus skus
     *
     * @return self
     */
    public function setSkus($skus)
    {
        if (is_null($skus)) {
            throw new \InvalidArgumentException('non-nullable skus cannot be null');
        }
        $this->container['skus'] = $skus;

        return $this;
    }

    /**
     * Gets title
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string|null $title title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets video
     *
     * @return \Tiktok\Model\IdResponseData|null
     */
    public function getVideo()
    {
        return $this->container['video'];
    }

    /**
     * Sets video
     *
     * @param \Tiktok\Model\IdResponseData|null $video video
     *
     * @return self
     */
    public function setVideo($video)
    {
        if (is_null($video)) {
            throw new \InvalidArgumentException('non-nullable video cannot be null');
        }
        $this->container['video'] = $video;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


