<?php
/**
 * CategoryRuleResponseData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * CategoryRuleResponseData Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CategoryRuleResponseData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CategoryRuleResponse_data';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cod' => '\Tiktok\Model\CategoryRuleResponseDataCod',
        'epr' => '\Tiktok\Model\CategoryRuleResponseDataEpr',
        'package_dimension' => '\Tiktok\Model\CategoryRuleResponseDataEpr',
        'product_certifications' => '\Tiktok\Model\CategoryRuleResponseDataProductCertificationsInner[]',
        'size_chart' => '\Tiktok\Model\CategoryRuleResponseDataSizeChart'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cod' => null,
        'epr' => null,
        'package_dimension' => null,
        'product_certifications' => null,
        'size_chart' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'cod' => false,
        'epr' => false,
        'package_dimension' => false,
        'product_certifications' => false,
        'size_chart' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cod' => 'cod',
        'epr' => 'epr',
        'package_dimension' => 'package_dimension',
        'product_certifications' => 'product_certifications',
        'size_chart' => 'size_chart'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cod' => 'setCod',
        'epr' => 'setEpr',
        'package_dimension' => 'setPackageDimension',
        'product_certifications' => 'setProductCertifications',
        'size_chart' => 'setSizeChart'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cod' => 'getCod',
        'epr' => 'getEpr',
        'package_dimension' => 'getPackageDimension',
        'product_certifications' => 'getProductCertifications',
        'size_chart' => 'getSizeChart'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cod', $data ?? [], null);
        $this->setIfExists('epr', $data ?? [], null);
        $this->setIfExists('package_dimension', $data ?? [], null);
        $this->setIfExists('product_certifications', $data ?? [], null);
        $this->setIfExists('size_chart', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cod
     *
     * @return \Tiktok\Model\CategoryRuleResponseDataCod|null
     */
    public function getCod()
    {
        return $this->container['cod'];
    }

    /**
     * Sets cod
     *
     * @param \Tiktok\Model\CategoryRuleResponseDataCod|null $cod cod
     *
     * @return self
     */
    public function setCod($cod)
    {
        if (is_null($cod)) {
            throw new \InvalidArgumentException('non-nullable cod cannot be null');
        }
        $this->container['cod'] = $cod;

        return $this;
    }

    /**
     * Gets epr
     *
     * @return \Tiktok\Model\CategoryRuleResponseDataEpr|null
     */
    public function getEpr()
    {
        return $this->container['epr'];
    }

    /**
     * Sets epr
     *
     * @param \Tiktok\Model\CategoryRuleResponseDataEpr|null $epr epr
     *
     * @return self
     */
    public function setEpr($epr)
    {
        if (is_null($epr)) {
            throw new \InvalidArgumentException('non-nullable epr cannot be null');
        }
        $this->container['epr'] = $epr;

        return $this;
    }

    /**
     * Gets package_dimension
     *
     * @return \Tiktok\Model\CategoryRuleResponseDataEpr|null
     */
    public function getPackageDimension()
    {
        return $this->container['package_dimension'];
    }

    /**
     * Sets package_dimension
     *
     * @param \Tiktok\Model\CategoryRuleResponseDataEpr|null $package_dimension package_dimension
     *
     * @return self
     */
    public function setPackageDimension($package_dimension)
    {
        if (is_null($package_dimension)) {
            throw new \InvalidArgumentException('non-nullable package_dimension cannot be null');
        }
        $this->container['package_dimension'] = $package_dimension;

        return $this;
    }

    /**
     * Gets product_certifications
     *
     * @return \Tiktok\Model\CategoryRuleResponseDataProductCertificationsInner[]|null
     */
    public function getProductCertifications()
    {
        return $this->container['product_certifications'];
    }

    /**
     * Sets product_certifications
     *
     * @param \Tiktok\Model\CategoryRuleResponseDataProductCertificationsInner[]|null $product_certifications product_certifications
     *
     * @return self
     */
    public function setProductCertifications($product_certifications)
    {
        if (is_null($product_certifications)) {
            throw new \InvalidArgumentException('non-nullable product_certifications cannot be null');
        }
        $this->container['product_certifications'] = $product_certifications;

        return $this;
    }

    /**
     * Gets size_chart
     *
     * @return \Tiktok\Model\CategoryRuleResponseDataSizeChart|null
     */
    public function getSizeChart()
    {
        return $this->container['size_chart'];
    }

    /**
     * Sets size_chart
     *
     * @param \Tiktok\Model\CategoryRuleResponseDataSizeChart|null $size_chart size_chart
     *
     * @return self
     */
    public function setSizeChart($size_chart)
    {
        if (is_null($size_chart)) {
            throw new \InvalidArgumentException('non-nullable size_chart cannot be null');
        }
        $this->container['size_chart'] = $size_chart;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


