<?php
/**
 * Cancellation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * Cancellation Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Cancellation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Cancellation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cancel_id' => 'string',
        'cancel_line_items' => '\Tiktok\Model\CancelLineItem[]',
        'cancel_reason' => 'string',
        'cancel_reason_text' => 'string',
        'cancel_status' => 'string',
        'cancel_type' => 'string',
        'create_time' => 'int',
        'order_id' => 'string',
        'refund_amount' => '\Tiktok\Model\RefundAmount',
        'role' => 'string',
        'seller_next_action_response' => '\Tiktok\Model\SellerNextActionResponse[]',
        'update_time' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cancel_id' => null,
        'cancel_line_items' => null,
        'cancel_reason' => null,
        'cancel_reason_text' => null,
        'cancel_status' => null,
        'cancel_type' => null,
        'create_time' => null,
        'order_id' => null,
        'refund_amount' => null,
        'role' => null,
        'seller_next_action_response' => null,
        'update_time' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'cancel_id' => false,
        'cancel_line_items' => false,
        'cancel_reason' => false,
        'cancel_reason_text' => false,
        'cancel_status' => false,
        'cancel_type' => false,
        'create_time' => false,
        'order_id' => false,
        'refund_amount' => false,
        'role' => false,
        'seller_next_action_response' => false,
        'update_time' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cancel_id' => 'cancel_id',
        'cancel_line_items' => 'cancel_line_items',
        'cancel_reason' => 'cancel_reason',
        'cancel_reason_text' => 'cancel_reason_text',
        'cancel_status' => 'cancel_status',
        'cancel_type' => 'cancel_type',
        'create_time' => 'create_time',
        'order_id' => 'order_id',
        'refund_amount' => 'refund_amount',
        'role' => 'role',
        'seller_next_action_response' => 'seller_next_action_response',
        'update_time' => 'update_time'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cancel_id' => 'setCancelId',
        'cancel_line_items' => 'setCancelLineItems',
        'cancel_reason' => 'setCancelReason',
        'cancel_reason_text' => 'setCancelReasonText',
        'cancel_status' => 'setCancelStatus',
        'cancel_type' => 'setCancelType',
        'create_time' => 'setCreateTime',
        'order_id' => 'setOrderId',
        'refund_amount' => 'setRefundAmount',
        'role' => 'setRole',
        'seller_next_action_response' => 'setSellerNextActionResponse',
        'update_time' => 'setUpdateTime'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cancel_id' => 'getCancelId',
        'cancel_line_items' => 'getCancelLineItems',
        'cancel_reason' => 'getCancelReason',
        'cancel_reason_text' => 'getCancelReasonText',
        'cancel_status' => 'getCancelStatus',
        'cancel_type' => 'getCancelType',
        'create_time' => 'getCreateTime',
        'order_id' => 'getOrderId',
        'refund_amount' => 'getRefundAmount',
        'role' => 'getRole',
        'seller_next_action_response' => 'getSellerNextActionResponse',
        'update_time' => 'getUpdateTime'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cancel_id', $data ?? [], null);
        $this->setIfExists('cancel_line_items', $data ?? [], null);
        $this->setIfExists('cancel_reason', $data ?? [], null);
        $this->setIfExists('cancel_reason_text', $data ?? [], null);
        $this->setIfExists('cancel_status', $data ?? [], null);
        $this->setIfExists('cancel_type', $data ?? [], null);
        $this->setIfExists('create_time', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('refund_amount', $data ?? [], null);
        $this->setIfExists('role', $data ?? [], null);
        $this->setIfExists('seller_next_action_response', $data ?? [], null);
        $this->setIfExists('update_time', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cancel_id
     *
     * @return string|null
     */
    public function getCancelId()
    {
        return $this->container['cancel_id'];
    }

    /**
     * Sets cancel_id
     *
     * @param string|null $cancel_id cancel_id
     *
     * @return self
     */
    public function setCancelId($cancel_id)
    {
        if (is_null($cancel_id)) {
            throw new \InvalidArgumentException('non-nullable cancel_id cannot be null');
        }
        $this->container['cancel_id'] = $cancel_id;

        return $this;
    }

    /**
     * Gets cancel_line_items
     *
     * @return \Tiktok\Model\CancelLineItem[]|null
     */
    public function getCancelLineItems()
    {
        return $this->container['cancel_line_items'];
    }

    /**
     * Sets cancel_line_items
     *
     * @param \Tiktok\Model\CancelLineItem[]|null $cancel_line_items cancel_line_items
     *
     * @return self
     */
    public function setCancelLineItems($cancel_line_items)
    {
        if (is_null($cancel_line_items)) {
            throw new \InvalidArgumentException('non-nullable cancel_line_items cannot be null');
        }
        $this->container['cancel_line_items'] = $cancel_line_items;

        return $this;
    }

    /**
     * Gets cancel_reason
     *
     * @return string|null
     */
    public function getCancelReason()
    {
        return $this->container['cancel_reason'];
    }

    /**
     * Sets cancel_reason
     *
     * @param string|null $cancel_reason cancel_reason
     *
     * @return self
     */
    public function setCancelReason($cancel_reason)
    {
        if (is_null($cancel_reason)) {
            throw new \InvalidArgumentException('non-nullable cancel_reason cannot be null');
        }
        $this->container['cancel_reason'] = $cancel_reason;

        return $this;
    }

    /**
     * Gets cancel_reason_text
     *
     * @return string|null
     */
    public function getCancelReasonText()
    {
        return $this->container['cancel_reason_text'];
    }

    /**
     * Sets cancel_reason_text
     *
     * @param string|null $cancel_reason_text cancel_reason_text
     *
     * @return self
     */
    public function setCancelReasonText($cancel_reason_text)
    {
        if (is_null($cancel_reason_text)) {
            throw new \InvalidArgumentException('non-nullable cancel_reason_text cannot be null');
        }
        $this->container['cancel_reason_text'] = $cancel_reason_text;

        return $this;
    }

    /**
     * Gets cancel_status
     *
     * @return string|null
     */
    public function getCancelStatus()
    {
        return $this->container['cancel_status'];
    }

    /**
     * Sets cancel_status
     *
     * @param string|null $cancel_status cancel_status
     *
     * @return self
     */
    public function setCancelStatus($cancel_status)
    {
        if (is_null($cancel_status)) {
            throw new \InvalidArgumentException('non-nullable cancel_status cannot be null');
        }
        $this->container['cancel_status'] = $cancel_status;

        return $this;
    }

    /**
     * Gets cancel_type
     *
     * @return string|null
     */
    public function getCancelType()
    {
        return $this->container['cancel_type'];
    }

    /**
     * Sets cancel_type
     *
     * @param string|null $cancel_type cancel_type
     *
     * @return self
     */
    public function setCancelType($cancel_type)
    {
        if (is_null($cancel_type)) {
            throw new \InvalidArgumentException('non-nullable cancel_type cannot be null');
        }
        $this->container['cancel_type'] = $cancel_type;

        return $this;
    }

    /**
     * Gets create_time
     *
     * @return int|null
     */
    public function getCreateTime()
    {
        return $this->container['create_time'];
    }

    /**
     * Sets create_time
     *
     * @param int|null $create_time create_time
     *
     * @return self
     */
    public function setCreateTime($create_time)
    {
        if (is_null($create_time)) {
            throw new \InvalidArgumentException('non-nullable create_time cannot be null');
        }
        $this->container['create_time'] = $create_time;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id order_id
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets refund_amount
     *
     * @return \Tiktok\Model\RefundAmount|null
     */
    public function getRefundAmount()
    {
        return $this->container['refund_amount'];
    }

    /**
     * Sets refund_amount
     *
     * @param \Tiktok\Model\RefundAmount|null $refund_amount refund_amount
     *
     * @return self
     */
    public function setRefundAmount($refund_amount)
    {
        if (is_null($refund_amount)) {
            throw new \InvalidArgumentException('non-nullable refund_amount cannot be null');
        }
        $this->container['refund_amount'] = $refund_amount;

        return $this;
    }

    /**
     * Gets role
     *
     * @return string|null
     */
    public function getRole()
    {
        return $this->container['role'];
    }

    /**
     * Sets role
     *
     * @param string|null $role role
     *
     * @return self
     */
    public function setRole($role)
    {
        if (is_null($role)) {
            throw new \InvalidArgumentException('non-nullable role cannot be null');
        }
        $this->container['role'] = $role;

        return $this;
    }

    /**
     * Gets seller_next_action_response
     *
     * @return \Tiktok\Model\SellerNextActionResponse[]|null
     */
    public function getSellerNextActionResponse()
    {
        return $this->container['seller_next_action_response'];
    }

    /**
     * Sets seller_next_action_response
     *
     * @param \Tiktok\Model\SellerNextActionResponse[]|null $seller_next_action_response seller_next_action_response
     *
     * @return self
     */
    public function setSellerNextActionResponse($seller_next_action_response)
    {
        if (is_null($seller_next_action_response)) {
            throw new \InvalidArgumentException('non-nullable seller_next_action_response cannot be null');
        }
        $this->container['seller_next_action_response'] = $seller_next_action_response;

        return $this;
    }

    /**
     * Gets update_time
     *
     * @return int|null
     */
    public function getUpdateTime()
    {
        return $this->container['update_time'];
    }

    /**
     * Sets update_time
     *
     * @param int|null $update_time update_time
     *
     * @return self
     */
    public function setUpdateTime($update_time)
    {
        if (is_null($update_time)) {
            throw new \InvalidArgumentException('non-nullable update_time cannot be null');
        }
        $this->container['update_time'] = $update_time;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


