<?php
/**
 * Attribute
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Model;

use \ArrayAccess;
use \Tiktok\ObjectSerializer;

/**
 * Attribute Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Attribute implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Attribute';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'is_customizable' => 'bool',
        'is_multiple_selection' => 'bool',
        'is_requried' => 'bool',
        'name' => 'string',
        'requirement_conditions' => '\Tiktok\Model\RequirementCondition[]',
        'type' => 'string',
        'value_data_format' => 'string',
        'values' => '\Tiktok\Model\Value[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'is_customizable' => null,
        'is_multiple_selection' => null,
        'is_requried' => null,
        'name' => null,
        'requirement_conditions' => null,
        'type' => null,
        'value_data_format' => null,
        'values' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'is_customizable' => false,
        'is_multiple_selection' => false,
        'is_requried' => false,
        'name' => false,
        'requirement_conditions' => false,
        'type' => false,
        'value_data_format' => false,
        'values' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'is_customizable' => 'is_customizable',
        'is_multiple_selection' => 'is_multiple_selection',
        'is_requried' => 'is_requried',
        'name' => 'name',
        'requirement_conditions' => 'requirement_conditions',
        'type' => 'type',
        'value_data_format' => 'value_data_format',
        'values' => 'values'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'is_customizable' => 'setIsCustomizable',
        'is_multiple_selection' => 'setIsMultipleSelection',
        'is_requried' => 'setIsRequried',
        'name' => 'setName',
        'requirement_conditions' => 'setRequirementConditions',
        'type' => 'setType',
        'value_data_format' => 'setValueDataFormat',
        'values' => 'setValues'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'is_customizable' => 'getIsCustomizable',
        'is_multiple_selection' => 'getIsMultipleSelection',
        'is_requried' => 'getIsRequried',
        'name' => 'getName',
        'requirement_conditions' => 'getRequirementConditions',
        'type' => 'getType',
        'value_data_format' => 'getValueDataFormat',
        'values' => 'getValues'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('is_customizable', $data ?? [], null);
        $this->setIfExists('is_multiple_selection', $data ?? [], null);
        $this->setIfExists('is_requried', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('requirement_conditions', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('value_data_format', $data ?? [], null);
        $this->setIfExists('values', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets is_customizable
     *
     * @return bool|null
     */
    public function getIsCustomizable()
    {
        return $this->container['is_customizable'];
    }

    /**
     * Sets is_customizable
     *
     * @param bool|null $is_customizable is_customizable
     *
     * @return self
     */
    public function setIsCustomizable($is_customizable)
    {
        if (is_null($is_customizable)) {
            throw new \InvalidArgumentException('non-nullable is_customizable cannot be null');
        }
        $this->container['is_customizable'] = $is_customizable;

        return $this;
    }

    /**
     * Gets is_multiple_selection
     *
     * @return bool|null
     */
    public function getIsMultipleSelection()
    {
        return $this->container['is_multiple_selection'];
    }

    /**
     * Sets is_multiple_selection
     *
     * @param bool|null $is_multiple_selection is_multiple_selection
     *
     * @return self
     */
    public function setIsMultipleSelection($is_multiple_selection)
    {
        if (is_null($is_multiple_selection)) {
            throw new \InvalidArgumentException('non-nullable is_multiple_selection cannot be null');
        }
        $this->container['is_multiple_selection'] = $is_multiple_selection;

        return $this;
    }

    /**
     * Gets is_requried
     *
     * @return bool|null
     */
    public function getIsRequried()
    {
        return $this->container['is_requried'];
    }

    /**
     * Sets is_requried
     *
     * @param bool|null $is_requried is_requried
     *
     * @return self
     */
    public function setIsRequried($is_requried)
    {
        if (is_null($is_requried)) {
            throw new \InvalidArgumentException('non-nullable is_requried cannot be null');
        }
        $this->container['is_requried'] = $is_requried;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets requirement_conditions
     *
     * @return \Tiktok\Model\RequirementCondition[]|null
     */
    public function getRequirementConditions()
    {
        return $this->container['requirement_conditions'];
    }

    /**
     * Sets requirement_conditions
     *
     * @param \Tiktok\Model\RequirementCondition[]|null $requirement_conditions requirement_conditions
     *
     * @return self
     */
    public function setRequirementConditions($requirement_conditions)
    {
        if (is_null($requirement_conditions)) {
            throw new \InvalidArgumentException('non-nullable requirement_conditions cannot be null');
        }
        $this->container['requirement_conditions'] = $requirement_conditions;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets value_data_format
     *
     * @return string|null
     */
    public function getValueDataFormat()
    {
        return $this->container['value_data_format'];
    }

    /**
     * Sets value_data_format
     *
     * @param string|null $value_data_format value_data_format
     *
     * @return self
     */
    public function setValueDataFormat($value_data_format)
    {
        if (is_null($value_data_format)) {
            throw new \InvalidArgumentException('non-nullable value_data_format cannot be null');
        }
        $this->container['value_data_format'] = $value_data_format;

        return $this;
    }

    /**
     * Gets values
     *
     * @return \Tiktok\Model\Value[]|null
     */
    public function getValues()
    {
        return $this->container['values'];
    }

    /**
     * Sets values
     *
     * @param \Tiktok\Model\Value[]|null $values values
     *
     * @return self
     */
    public function setValues($values)
    {
        if (is_null($values)) {
            throw new \InvalidArgumentException('non-nullable values cannot be null');
        }
        $this->container['values'] = $values;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


