<?php
/**
 * ReturnRefundApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Tiktok\ApiException;
use Tiktok\Configuration;
use Tiktok\HeaderSelector;
use Tiktok\ObjectSerializer;

/**
 * ReturnRefundApi Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ReturnRefundApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getReturnRecords' => [
            'application/json',
        ],
        'searchCancellations' => [
            'application/json',
        ],
        'searchReturns' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getReturnRecords
     *
     * Get Return Records
     *
     * @param  string $return_id return_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \&quot;en\&quot;, effect multilingual text such as reason_text (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnRecords'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\ReturnRecordsResponse
     */
    public function getReturnRecords($return_id, $shop_cipher, $locale = null, string $contentType = self::contentTypes['getReturnRecords'][0])
    {
        list($response) = $this->getReturnRecordsWithHttpInfo($return_id, $shop_cipher, $locale, $contentType);
        return $response;
    }

    /**
     * Operation getReturnRecordsWithHttpInfo
     *
     * Get Return Records
     *
     * @param  string $return_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \&quot;en\&quot;, effect multilingual text such as reason_text (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnRecords'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\ReturnRecordsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnRecordsWithHttpInfo($return_id, $shop_cipher, $locale = null, string $contentType = self::contentTypes['getReturnRecords'][0])
    {
        $request = $this->getReturnRecordsRequest($return_id, $shop_cipher, $locale, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\ReturnRecordsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\ReturnRecordsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\ReturnRecordsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\ReturnRecordsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\ReturnRecordsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReturnRecordsAsync
     *
     * Get Return Records
     *
     * @param  string $return_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \&quot;en\&quot;, effect multilingual text such as reason_text (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnRecords'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnRecordsAsync($return_id, $shop_cipher, $locale = null, string $contentType = self::contentTypes['getReturnRecords'][0])
    {
        return $this->getReturnRecordsAsyncWithHttpInfo($return_id, $shop_cipher, $locale, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnRecordsAsyncWithHttpInfo
     *
     * Get Return Records
     *
     * @param  string $return_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \&quot;en\&quot;, effect multilingual text such as reason_text (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnRecords'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnRecordsAsyncWithHttpInfo($return_id, $shop_cipher, $locale = null, string $contentType = self::contentTypes['getReturnRecords'][0])
    {
        $returnType = '\Tiktok\Model\ReturnRecordsResponse';
        $request = $this->getReturnRecordsRequest($return_id, $shop_cipher, $locale, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnRecords'
     *
     * @param  string $return_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \&quot;en\&quot;, effect multilingual text such as reason_text (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnRecords'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnRecordsRequest($return_id, $shop_cipher, $locale = null, string $contentType = self::contentTypes['getReturnRecords'][0])
    {

        // verify the required parameter 'return_id' is set
        if ($return_id === null || (is_array($return_id) && count($return_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $return_id when calling getReturnRecords'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getReturnRecords'
            );
        }



        $resourcePath = '/return_refund/202309/returns/{return_id}/records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $locale,
            'locale', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($return_id !== null) {
            $resourcePath = str_replace(
                '{' . 'return_id' . '}',
                ObjectSerializer::toPathValue($return_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchCancellations
     *
     * Search Cancellations
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchCancellationsRequest $search_cancellations_request search_cancellations_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCancellations'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\SearchCancellationsResponse
     */
    public function searchCancellations($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_cancellations_request = null, string $contentType = self::contentTypes['searchCancellations'][0])
    {
        list($response) = $this->searchCancellationsWithHttpInfo($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_cancellations_request, $contentType);
        return $response;
    }

    /**
     * Operation searchCancellationsWithHttpInfo
     *
     * Search Cancellations
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchCancellationsRequest $search_cancellations_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCancellations'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\SearchCancellationsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchCancellationsWithHttpInfo($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_cancellations_request = null, string $contentType = self::contentTypes['searchCancellations'][0])
    {
        $request = $this->searchCancellationsRequest($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_cancellations_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\SearchCancellationsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\SearchCancellationsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\SearchCancellationsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\SearchCancellationsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\SearchCancellationsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchCancellationsAsync
     *
     * Search Cancellations
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchCancellationsRequest $search_cancellations_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCancellations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchCancellationsAsync($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_cancellations_request = null, string $contentType = self::contentTypes['searchCancellations'][0])
    {
        return $this->searchCancellationsAsyncWithHttpInfo($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_cancellations_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchCancellationsAsyncWithHttpInfo
     *
     * Search Cancellations
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchCancellationsRequest $search_cancellations_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCancellations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchCancellationsAsyncWithHttpInfo($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_cancellations_request = null, string $contentType = self::contentTypes['searchCancellations'][0])
    {
        $returnType = '\Tiktok\Model\SearchCancellationsResponse';
        $request = $this->searchCancellationsRequest($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_cancellations_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchCancellations'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchCancellationsRequest $search_cancellations_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCancellations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchCancellationsRequest($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_cancellations_request = null, string $contentType = self::contentTypes['searchCancellations'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling searchCancellations'
            );
        }







        $resourcePath = '/return_refund/202309/cancellations/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_field,
            'sort_field', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_token,
            'page_token', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($search_cancellations_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($search_cancellations_request));
            } else {
                $httpBody = $search_cancellations_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchReturns
     *
     * Search Returns
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchReturnsRequest $search_returns_request search_returns_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturns'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\SearchReturnsResponse
     */
    public function searchReturns($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_returns_request = null, string $contentType = self::contentTypes['searchReturns'][0])
    {
        list($response) = $this->searchReturnsWithHttpInfo($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_returns_request, $contentType);
        return $response;
    }

    /**
     * Operation searchReturnsWithHttpInfo
     *
     * Search Returns
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchReturnsRequest $search_returns_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturns'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\SearchReturnsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchReturnsWithHttpInfo($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_returns_request = null, string $contentType = self::contentTypes['searchReturns'][0])
    {
        $request = $this->searchReturnsRequest($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_returns_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\SearchReturnsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\SearchReturnsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\SearchReturnsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\SearchReturnsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\SearchReturnsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchReturnsAsync
     *
     * Search Returns
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchReturnsRequest $search_returns_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturns'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchReturnsAsync($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_returns_request = null, string $contentType = self::contentTypes['searchReturns'][0])
    {
        return $this->searchReturnsAsyncWithHttpInfo($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_returns_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchReturnsAsyncWithHttpInfo
     *
     * Search Returns
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchReturnsRequest $search_returns_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturns'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchReturnsAsyncWithHttpInfo($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_returns_request = null, string $contentType = self::contentTypes['searchReturns'][0])
    {
        $returnType = '\Tiktok\Model\SearchReturnsResponse';
        $request = $this->searchReturnsRequest($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_returns_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchReturns'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $sort_field (optional)
     * @param  string $sort_order Available value: ASC;DESC(default) (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\SearchReturnsRequest $search_returns_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturns'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchReturnsRequest($shop_cipher, $sort_field = null, $sort_order = null, $page_size = null, $page_token = null, $search_returns_request = null, string $contentType = self::contentTypes['searchReturns'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling searchReturns'
            );
        }







        $resourcePath = '/return_refund/202309/returns/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_field,
            'sort_field', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sort_order', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_token,
            'page_token', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($search_returns_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($search_returns_request));
            } else {
                $httpBody = $search_returns_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
