<?php
/**
 * ProductApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Tiktok\ApiException;
use Tiktok\Configuration;
use Tiktok\HeaderSelector;
use Tiktok\ObjectSerializer;

/**
 * ProductApi Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'activateProduct' => [
            'application/json',
        ],
        'createBrand' => [
            'application/json',
        ],
        'createProduct' => [
            'application/json',
        ],
        'deactivateProducts' => [
            'application/json',
        ],
        'deleteProducts' => [
            'application/json',
        ],
        'editProduct' => [
            'application/json',
        ],
        'getAttributes' => [
            'application/json',
        ],
        'getBrands' => [
            'application/json',
        ],
        'getCategories' => [
            'application/json',
        ],
        'getProduct' => [
            'application/json',
        ],
        'getProduct202309CategoriesCategoryIdRules' => [
            'application/json',
        ],
        'inventorySearch' => [
            'application/json',
        ],
        'partialEditProduct' => [
            'application/json',
        ],
        'recommendCategory' => [
            'application/json',
        ],
        'searchProducts' => [
            'application/json',
        ],
        'updateInventory' => [
            'application/json',
        ],
        'updatePrice' => [
            'application/json',
        ],
        'uploadProductFile' => [
            'multipart/form-data',
        ],
        'uploadProductImage' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation activateProduct
     *
     * Activate Products
     *
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\ProductIDsResponse
     */
    public function activateProduct($product_ids_request = null, string $contentType = self::contentTypes['activateProduct'][0])
    {
        list($response) = $this->activateProductWithHttpInfo($product_ids_request, $contentType);
        return $response;
    }

    /**
     * Operation activateProductWithHttpInfo
     *
     * Activate Products
     *
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\ProductIDsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function activateProductWithHttpInfo($product_ids_request = null, string $contentType = self::contentTypes['activateProduct'][0])
    {
        $request = $this->activateProductRequest($product_ids_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\ProductIDsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\ProductIDsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\ProductIDsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\ProductIDsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\ProductIDsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation activateProductAsync
     *
     * Activate Products
     *
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function activateProductAsync($product_ids_request = null, string $contentType = self::contentTypes['activateProduct'][0])
    {
        return $this->activateProductAsyncWithHttpInfo($product_ids_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation activateProductAsyncWithHttpInfo
     *
     * Activate Products
     *
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function activateProductAsyncWithHttpInfo($product_ids_request = null, string $contentType = self::contentTypes['activateProduct'][0])
    {
        $returnType = '\Tiktok\Model\ProductIDsResponse';
        $request = $this->activateProductRequest($product_ids_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'activateProduct'
     *
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['activateProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function activateProductRequest($product_ids_request = null, string $contentType = self::contentTypes['activateProduct'][0])
    {



        $resourcePath = '/product/202309/products/activate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product_ids_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product_ids_request));
            } else {
                $httpBody = $product_ids_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBrand
     *
     * Create Brands
     *
     * @param  \Tiktok\Model\Brand $brand brand (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrand'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\IdResponse
     */
    public function createBrand($brand = null, string $contentType = self::contentTypes['createBrand'][0])
    {
        list($response) = $this->createBrandWithHttpInfo($brand, $contentType);
        return $response;
    }

    /**
     * Operation createBrandWithHttpInfo
     *
     * Create Brands
     *
     * @param  \Tiktok\Model\Brand $brand (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrand'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\IdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandWithHttpInfo($brand = null, string $contentType = self::contentTypes['createBrand'][0])
    {
        $request = $this->createBrandRequest($brand, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\IdResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\IdResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\IdResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\IdResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\IdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBrandAsync
     *
     * Create Brands
     *
     * @param  \Tiktok\Model\Brand $brand (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrand'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandAsync($brand = null, string $contentType = self::contentTypes['createBrand'][0])
    {
        return $this->createBrandAsyncWithHttpInfo($brand, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBrandAsyncWithHttpInfo
     *
     * Create Brands
     *
     * @param  \Tiktok\Model\Brand $brand (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrand'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBrandAsyncWithHttpInfo($brand = null, string $contentType = self::contentTypes['createBrand'][0])
    {
        $returnType = '\Tiktok\Model\IdResponse';
        $request = $this->createBrandRequest($brand, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBrand'
     *
     * @param  \Tiktok\Model\Brand $brand (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBrand'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBrandRequest($brand = null, string $contentType = self::contentTypes['createBrand'][0])
    {



        $resourcePath = '/product/202309/brands';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($brand)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($brand));
            } else {
                $httpBody = $brand;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createProduct
     *
     * Create Product
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\CreateProductResponse
     */
    public function createProduct($shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        list($response) = $this->createProductWithHttpInfo($shop_cipher, $create_product_request, $contentType);
        return $response;
    }

    /**
     * Operation createProductWithHttpInfo
     *
     * Create Product
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\CreateProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createProductWithHttpInfo($shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        $request = $this->createProductRequest($shop_cipher, $create_product_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\CreateProductResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\CreateProductResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\CreateProductResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\CreateProductResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\CreateProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createProductAsync
     *
     * Create Product
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProductAsync($shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        return $this->createProductAsyncWithHttpInfo($shop_cipher, $create_product_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createProductAsyncWithHttpInfo
     *
     * Create Product
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createProductAsyncWithHttpInfo($shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['createProduct'][0])
    {
        $returnType = '\Tiktok\Model\CreateProductResponse';
        $request = $this->createProductRequest($shop_cipher, $create_product_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createProduct'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createProductRequest($shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['createProduct'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling createProduct'
            );
        }



        $resourcePath = '/product/202309/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_product_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_product_request));
            } else {
                $httpBody = $create_product_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deactivateProducts
     *
     * Deactivate Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deactivateProducts'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\ProductIDsResponse
     */
    public function deactivateProducts($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deactivateProducts'][0])
    {
        list($response) = $this->deactivateProductsWithHttpInfo($shop_cipher, $product_ids_request, $contentType);
        return $response;
    }

    /**
     * Operation deactivateProductsWithHttpInfo
     *
     * Deactivate Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deactivateProducts'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\ProductIDsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deactivateProductsWithHttpInfo($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deactivateProducts'][0])
    {
        $request = $this->deactivateProductsRequest($shop_cipher, $product_ids_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\ProductIDsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\ProductIDsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\ProductIDsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\ProductIDsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\ProductIDsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deactivateProductsAsync
     *
     * Deactivate Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deactivateProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deactivateProductsAsync($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deactivateProducts'][0])
    {
        return $this->deactivateProductsAsyncWithHttpInfo($shop_cipher, $product_ids_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deactivateProductsAsyncWithHttpInfo
     *
     * Deactivate Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deactivateProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deactivateProductsAsyncWithHttpInfo($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deactivateProducts'][0])
    {
        $returnType = '\Tiktok\Model\ProductIDsResponse';
        $request = $this->deactivateProductsRequest($shop_cipher, $product_ids_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deactivateProducts'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deactivateProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deactivateProductsRequest($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deactivateProducts'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling deactivateProducts'
            );
        }



        $resourcePath = '/product/202309/products/deactivate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product_ids_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product_ids_request));
            } else {
                $httpBody = $product_ids_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteProducts
     *
     * Delete Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\ProductIDsResponse
     */
    public function deleteProducts($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        list($response) = $this->deleteProductsWithHttpInfo($shop_cipher, $product_ids_request, $contentType);
        return $response;
    }

    /**
     * Operation deleteProductsWithHttpInfo
     *
     * Delete Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\ProductIDsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductsWithHttpInfo($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        $request = $this->deleteProductsRequest($shop_cipher, $product_ids_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\ProductIDsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\ProductIDsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\ProductIDsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\ProductIDsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\ProductIDsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteProductsAsync
     *
     * Delete Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductsAsync($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        return $this->deleteProductsAsyncWithHttpInfo($shop_cipher, $product_ids_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteProductsAsyncWithHttpInfo
     *
     * Delete Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductsAsyncWithHttpInfo($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {
        $returnType = '\Tiktok\Model\ProductIDsResponse';
        $request = $this->deleteProductsRequest($shop_cipher, $product_ids_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteProducts'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ProductIDsRequest $product_ids_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteProductsRequest($shop_cipher, $product_ids_request = null, string $contentType = self::contentTypes['deleteProducts'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling deleteProducts'
            );
        }



        $resourcePath = '/product/202309/products';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product_ids_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product_ids_request));
            } else {
                $httpBody = $product_ids_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation editProduct
     *
     * Edit Product
     *
     * @param  string $product_id product_id (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\CreateProductResponse
     */
    public function editProduct($product_id, $create_product_request = null, string $contentType = self::contentTypes['editProduct'][0])
    {
        list($response) = $this->editProductWithHttpInfo($product_id, $create_product_request, $contentType);
        return $response;
    }

    /**
     * Operation editProductWithHttpInfo
     *
     * Edit Product
     *
     * @param  string $product_id (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\CreateProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function editProductWithHttpInfo($product_id, $create_product_request = null, string $contentType = self::contentTypes['editProduct'][0])
    {
        $request = $this->editProductRequest($product_id, $create_product_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\CreateProductResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\CreateProductResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\CreateProductResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\CreateProductResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\CreateProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation editProductAsync
     *
     * Edit Product
     *
     * @param  string $product_id (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function editProductAsync($product_id, $create_product_request = null, string $contentType = self::contentTypes['editProduct'][0])
    {
        return $this->editProductAsyncWithHttpInfo($product_id, $create_product_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation editProductAsyncWithHttpInfo
     *
     * Edit Product
     *
     * @param  string $product_id (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function editProductAsyncWithHttpInfo($product_id, $create_product_request = null, string $contentType = self::contentTypes['editProduct'][0])
    {
        $returnType = '\Tiktok\Model\CreateProductResponse';
        $request = $this->editProductRequest($product_id, $create_product_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'editProduct'
     *
     * @param  string $product_id (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function editProductRequest($product_id, $create_product_request = null, string $contentType = self::contentTypes['editProduct'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling editProduct'
            );
        }



        $resourcePath = '/product/202309/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_product_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_product_request));
            } else {
                $httpBody = $create_product_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAttributes
     *
     * Get Attributes
     *
     * @param  int $category_id category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale locale (optional)
     * @param  string $category_version category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAttributes'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\AttributeResponse
     */
    public function getAttributes($category_id, $shop_cipher, $locale = null, $category_version = null, string $contentType = self::contentTypes['getAttributes'][0])
    {
        list($response) = $this->getAttributesWithHttpInfo($category_id, $shop_cipher, $locale, $category_version, $contentType);
        return $response;
    }

    /**
     * Operation getAttributesWithHttpInfo
     *
     * Get Attributes
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAttributes'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\AttributeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAttributesWithHttpInfo($category_id, $shop_cipher, $locale = null, $category_version = null, string $contentType = self::contentTypes['getAttributes'][0])
    {
        $request = $this->getAttributesRequest($category_id, $shop_cipher, $locale, $category_version, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\AttributeResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\AttributeResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\AttributeResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\AttributeResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\AttributeResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAttributesAsync
     *
     * Get Attributes
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAttributes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAttributesAsync($category_id, $shop_cipher, $locale = null, $category_version = null, string $contentType = self::contentTypes['getAttributes'][0])
    {
        return $this->getAttributesAsyncWithHttpInfo($category_id, $shop_cipher, $locale, $category_version, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAttributesAsyncWithHttpInfo
     *
     * Get Attributes
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAttributes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAttributesAsyncWithHttpInfo($category_id, $shop_cipher, $locale = null, $category_version = null, string $contentType = self::contentTypes['getAttributes'][0])
    {
        $returnType = '\Tiktok\Model\AttributeResponse';
        $request = $this->getAttributesRequest($category_id, $shop_cipher, $locale, $category_version, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAttributes'
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAttributes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAttributesRequest($category_id, $shop_cipher, $locale = null, $category_version = null, string $contentType = self::contentTypes['getAttributes'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling getAttributes'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getAttributes'
            );
        }




        $resourcePath = '/product/202309/categories/{category_id}/attributes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $locale,
            'locale', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $category_version,
            'category_version', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'category_id' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBrands
     *
     * Get Brands
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_id category_id (optional)
     * @param  bool $is_authorized is_authorized (optional)
     * @param  string $brand_name brand_name (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  string $category_version category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrands'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\BrandsResponse
     */
    public function getBrands($shop_cipher, $category_id = null, $is_authorized = null, $brand_name = null, $page_size = null, $page_token = null, $category_version = null, string $contentType = self::contentTypes['getBrands'][0])
    {
        list($response) = $this->getBrandsWithHttpInfo($shop_cipher, $category_id, $is_authorized, $brand_name, $page_size, $page_token, $category_version, $contentType);
        return $response;
    }

    /**
     * Operation getBrandsWithHttpInfo
     *
     * Get Brands
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_id (optional)
     * @param  bool $is_authorized (optional)
     * @param  string $brand_name (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrands'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandsWithHttpInfo($shop_cipher, $category_id = null, $is_authorized = null, $brand_name = null, $page_size = null, $page_token = null, $category_version = null, string $contentType = self::contentTypes['getBrands'][0])
    {
        $request = $this->getBrandsRequest($shop_cipher, $category_id, $is_authorized, $brand_name, $page_size, $page_token, $category_version, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\BrandsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\BrandsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\BrandsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\BrandsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\BrandsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBrandsAsync
     *
     * Get Brands
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_id (optional)
     * @param  bool $is_authorized (optional)
     * @param  string $brand_name (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrands'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandsAsync($shop_cipher, $category_id = null, $is_authorized = null, $brand_name = null, $page_size = null, $page_token = null, $category_version = null, string $contentType = self::contentTypes['getBrands'][0])
    {
        return $this->getBrandsAsyncWithHttpInfo($shop_cipher, $category_id, $is_authorized, $brand_name, $page_size, $page_token, $category_version, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBrandsAsyncWithHttpInfo
     *
     * Get Brands
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_id (optional)
     * @param  bool $is_authorized (optional)
     * @param  string $brand_name (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrands'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBrandsAsyncWithHttpInfo($shop_cipher, $category_id = null, $is_authorized = null, $brand_name = null, $page_size = null, $page_token = null, $category_version = null, string $contentType = self::contentTypes['getBrands'][0])
    {
        $returnType = '\Tiktok\Model\BrandsResponse';
        $request = $this->getBrandsRequest($shop_cipher, $category_id, $is_authorized, $brand_name, $page_size, $page_token, $category_version, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBrands'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_id (optional)
     * @param  bool $is_authorized (optional)
     * @param  string $brand_name (optional)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBrands'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBrandsRequest($shop_cipher, $category_id = null, $is_authorized = null, $brand_name = null, $page_size = null, $page_token = null, $category_version = null, string $contentType = self::contentTypes['getBrands'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getBrands'
            );
        }








        $resourcePath = '/product/202309/brands';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $category_id,
            'category_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_authorized,
            'is_authorized', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $brand_name,
            'brand_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_token,
            'page_token', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $category_version,
            'category_version', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCategories
     *
     * Get Categories
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale locale (optional)
     * @param  string $keyword keyword (optional)
     * @param  string $category_version category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\CategoriesResponse
     */
    public function getCategories($shop_cipher, $locale = null, $keyword = null, $category_version = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        list($response) = $this->getCategoriesWithHttpInfo($shop_cipher, $locale, $keyword, $category_version, $contentType);
        return $response;
    }

    /**
     * Operation getCategoriesWithHttpInfo
     *
     * Get Categories
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $keyword (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\CategoriesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoriesWithHttpInfo($shop_cipher, $locale = null, $keyword = null, $category_version = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        $request = $this->getCategoriesRequest($shop_cipher, $locale, $keyword, $category_version, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\CategoriesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\CategoriesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\CategoriesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\CategoriesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\CategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCategoriesAsync
     *
     * Get Categories
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $keyword (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoriesAsync($shop_cipher, $locale = null, $keyword = null, $category_version = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        return $this->getCategoriesAsyncWithHttpInfo($shop_cipher, $locale, $keyword, $category_version, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCategoriesAsyncWithHttpInfo
     *
     * Get Categories
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $keyword (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoriesAsyncWithHttpInfo($shop_cipher, $locale = null, $keyword = null, $category_version = null, string $contentType = self::contentTypes['getCategories'][0])
    {
        $returnType = '\Tiktok\Model\CategoriesResponse';
        $request = $this->getCategoriesRequest($shop_cipher, $locale, $keyword, $category_version, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCategories'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $locale (optional)
     * @param  string $keyword (optional)
     * @param  string $category_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCategoriesRequest($shop_cipher, $locale = null, $keyword = null, $category_version = null, string $contentType = self::contentTypes['getCategories'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getCategories'
            );
        }





        $resourcePath = '/product/202309/categories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $locale,
            'locale', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $keyword,
            'keyword', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $category_version,
            'category_version', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProduct
     *
     * Get Product
     *
     * @param  string $product_id product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  bool $return_under_review_version return_under_review_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\GetProductResponse
     */
    public function getProduct($product_id, $shop_cipher, $return_under_review_version = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        list($response) = $this->getProductWithHttpInfo($product_id, $shop_cipher, $return_under_review_version, $contentType);
        return $response;
    }

    /**
     * Operation getProductWithHttpInfo
     *
     * Get Product
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  bool $return_under_review_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\GetProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProductWithHttpInfo($product_id, $shop_cipher, $return_under_review_version = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        $request = $this->getProductRequest($product_id, $shop_cipher, $return_under_review_version, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\GetProductResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\GetProductResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\GetProductResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\GetProductResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\GetProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProductAsync
     *
     * Get Product
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  bool $return_under_review_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductAsync($product_id, $shop_cipher, $return_under_review_version = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        return $this->getProductAsyncWithHttpInfo($product_id, $shop_cipher, $return_under_review_version, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProductAsyncWithHttpInfo
     *
     * Get Product
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  bool $return_under_review_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProductAsyncWithHttpInfo($product_id, $shop_cipher, $return_under_review_version = null, string $contentType = self::contentTypes['getProduct'][0])
    {
        $returnType = '\Tiktok\Model\GetProductResponse';
        $request = $this->getProductRequest($product_id, $shop_cipher, $return_under_review_version, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProduct'
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  bool $return_under_review_version (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProductRequest($product_id, $shop_cipher, $return_under_review_version = null, string $contentType = self::contentTypes['getProduct'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling getProduct'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getProduct'
            );
        }



        $resourcePath = '/product/202309/products/{product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $return_under_review_version,
            'return_under_review_version', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProduct202309CategoriesCategoryIdRules
     *
     * Get Category Rules
     *
     * @param  int $category_id category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_version The version id of the category tree.The new version id is \&quot;v2\&quot; and will return data from our new 7-level category tree.The old version id is \&quot;v1\&quot; and will return data from the current 3-level category tree.The old version of category data will be given by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct202309CategoriesCategoryIdRules'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\CategoryRuleResponse
     */
    public function getProduct202309CategoriesCategoryIdRules($category_id, $shop_cipher, $category_version = null, string $contentType = self::contentTypes['getProduct202309CategoriesCategoryIdRules'][0])
    {
        list($response) = $this->getProduct202309CategoriesCategoryIdRulesWithHttpInfo($category_id, $shop_cipher, $category_version, $contentType);
        return $response;
    }

    /**
     * Operation getProduct202309CategoriesCategoryIdRulesWithHttpInfo
     *
     * Get Category Rules
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_version The version id of the category tree.The new version id is \&quot;v2\&quot; and will return data from our new 7-level category tree.The old version id is \&quot;v1\&quot; and will return data from the current 3-level category tree.The old version of category data will be given by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct202309CategoriesCategoryIdRules'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\CategoryRuleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProduct202309CategoriesCategoryIdRulesWithHttpInfo($category_id, $shop_cipher, $category_version = null, string $contentType = self::contentTypes['getProduct202309CategoriesCategoryIdRules'][0])
    {
        $request = $this->getProduct202309CategoriesCategoryIdRulesRequest($category_id, $shop_cipher, $category_version, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\CategoryRuleResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\CategoryRuleResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\CategoryRuleResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\CategoryRuleResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\CategoryRuleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProduct202309CategoriesCategoryIdRulesAsync
     *
     * Get Category Rules
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_version The version id of the category tree.The new version id is \&quot;v2\&quot; and will return data from our new 7-level category tree.The old version id is \&quot;v1\&quot; and will return data from the current 3-level category tree.The old version of category data will be given by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct202309CategoriesCategoryIdRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProduct202309CategoriesCategoryIdRulesAsync($category_id, $shop_cipher, $category_version = null, string $contentType = self::contentTypes['getProduct202309CategoriesCategoryIdRules'][0])
    {
        return $this->getProduct202309CategoriesCategoryIdRulesAsyncWithHttpInfo($category_id, $shop_cipher, $category_version, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProduct202309CategoriesCategoryIdRulesAsyncWithHttpInfo
     *
     * Get Category Rules
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_version The version id of the category tree.The new version id is \&quot;v2\&quot; and will return data from our new 7-level category tree.The old version id is \&quot;v1\&quot; and will return data from the current 3-level category tree.The old version of category data will be given by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct202309CategoriesCategoryIdRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProduct202309CategoriesCategoryIdRulesAsyncWithHttpInfo($category_id, $shop_cipher, $category_version = null, string $contentType = self::contentTypes['getProduct202309CategoriesCategoryIdRules'][0])
    {
        $returnType = '\Tiktok\Model\CategoryRuleResponse';
        $request = $this->getProduct202309CategoriesCategoryIdRulesRequest($category_id, $shop_cipher, $category_version, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProduct202309CategoriesCategoryIdRules'
     *
     * @param  int $category_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $category_version The version id of the category tree.The new version id is \&quot;v2\&quot; and will return data from our new 7-level category tree.The old version id is \&quot;v1\&quot; and will return data from the current 3-level category tree.The old version of category data will be given by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProduct202309CategoriesCategoryIdRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProduct202309CategoriesCategoryIdRulesRequest($category_id, $shop_cipher, $category_version = null, string $contentType = self::contentTypes['getProduct202309CategoriesCategoryIdRules'][0])
    {

        // verify the required parameter 'category_id' is set
        if ($category_id === null || (is_array($category_id) && count($category_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $category_id when calling getProduct202309CategoriesCategoryIdRules'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getProduct202309CategoriesCategoryIdRules'
            );
        }



        $resourcePath = '/product/202309/categories/{category_id}/rules';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $category_version,
            'category_version', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($category_id !== null) {
            $resourcePath = str_replace(
                '{' . 'category_id' . '}',
                ObjectSerializer::toPathValue($category_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation inventorySearch
     *
     * Inventory Search
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventorySearch $inventory_search inventory_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['inventorySearch'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\InventorySearchResponse
     */
    public function inventorySearch($shop_cipher, $inventory_search = null, string $contentType = self::contentTypes['inventorySearch'][0])
    {
        list($response) = $this->inventorySearchWithHttpInfo($shop_cipher, $inventory_search, $contentType);
        return $response;
    }

    /**
     * Operation inventorySearchWithHttpInfo
     *
     * Inventory Search
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventorySearch $inventory_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['inventorySearch'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\InventorySearchResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function inventorySearchWithHttpInfo($shop_cipher, $inventory_search = null, string $contentType = self::contentTypes['inventorySearch'][0])
    {
        $request = $this->inventorySearchRequest($shop_cipher, $inventory_search, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\InventorySearchResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\InventorySearchResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\InventorySearchResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\InventorySearchResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\InventorySearchResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation inventorySearchAsync
     *
     * Inventory Search
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventorySearch $inventory_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['inventorySearch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function inventorySearchAsync($shop_cipher, $inventory_search = null, string $contentType = self::contentTypes['inventorySearch'][0])
    {
        return $this->inventorySearchAsyncWithHttpInfo($shop_cipher, $inventory_search, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation inventorySearchAsyncWithHttpInfo
     *
     * Inventory Search
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventorySearch $inventory_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['inventorySearch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function inventorySearchAsyncWithHttpInfo($shop_cipher, $inventory_search = null, string $contentType = self::contentTypes['inventorySearch'][0])
    {
        $returnType = '\Tiktok\Model\InventorySearchResponse';
        $request = $this->inventorySearchRequest($shop_cipher, $inventory_search, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'inventorySearch'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventorySearch $inventory_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['inventorySearch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function inventorySearchRequest($shop_cipher, $inventory_search = null, string $contentType = self::contentTypes['inventorySearch'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling inventorySearch'
            );
        }



        $resourcePath = '/product/202309/inventory/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_search)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_search));
            } else {
                $httpBody = $inventory_search;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation partialEditProduct
     *
     * Partial Edit Product
     *
     * @param  string $product_id product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['partialEditProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\CreateProductResponse
     */
    public function partialEditProduct($product_id, $shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['partialEditProduct'][0])
    {
        list($response) = $this->partialEditProductWithHttpInfo($product_id, $shop_cipher, $create_product_request, $contentType);
        return $response;
    }

    /**
     * Operation partialEditProductWithHttpInfo
     *
     * Partial Edit Product
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['partialEditProduct'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\CreateProductResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function partialEditProductWithHttpInfo($product_id, $shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['partialEditProduct'][0])
    {
        $request = $this->partialEditProductRequest($product_id, $shop_cipher, $create_product_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\CreateProductResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\CreateProductResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\CreateProductResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\CreateProductResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\CreateProductResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation partialEditProductAsync
     *
     * Partial Edit Product
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['partialEditProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function partialEditProductAsync($product_id, $shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['partialEditProduct'][0])
    {
        return $this->partialEditProductAsyncWithHttpInfo($product_id, $shop_cipher, $create_product_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation partialEditProductAsyncWithHttpInfo
     *
     * Partial Edit Product
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['partialEditProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function partialEditProductAsyncWithHttpInfo($product_id, $shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['partialEditProduct'][0])
    {
        $returnType = '\Tiktok\Model\CreateProductResponse';
        $request = $this->partialEditProductRequest($product_id, $shop_cipher, $create_product_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'partialEditProduct'
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreateProductRequest $create_product_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['partialEditProduct'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function partialEditProductRequest($product_id, $shop_cipher, $create_product_request = null, string $contentType = self::contentTypes['partialEditProduct'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling partialEditProduct'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling partialEditProduct'
            );
        }



        $resourcePath = '/product/202309/products/{product_id}/partial_edit';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_product_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_product_request));
            } else {
                $httpBody = $create_product_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation recommendCategory
     *
     * Recommend Category
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\RecommendCategoryRequest $recommend_category_request recommend_category_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recommendCategory'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\RecommendCategoryResponse
     */
    public function recommendCategory($shop_cipher, $recommend_category_request = null, string $contentType = self::contentTypes['recommendCategory'][0])
    {
        list($response) = $this->recommendCategoryWithHttpInfo($shop_cipher, $recommend_category_request, $contentType);
        return $response;
    }

    /**
     * Operation recommendCategoryWithHttpInfo
     *
     * Recommend Category
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\RecommendCategoryRequest $recommend_category_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recommendCategory'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\RecommendCategoryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function recommendCategoryWithHttpInfo($shop_cipher, $recommend_category_request = null, string $contentType = self::contentTypes['recommendCategory'][0])
    {
        $request = $this->recommendCategoryRequest($shop_cipher, $recommend_category_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\RecommendCategoryResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\RecommendCategoryResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\RecommendCategoryResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\RecommendCategoryResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\RecommendCategoryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation recommendCategoryAsync
     *
     * Recommend Category
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\RecommendCategoryRequest $recommend_category_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recommendCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function recommendCategoryAsync($shop_cipher, $recommend_category_request = null, string $contentType = self::contentTypes['recommendCategory'][0])
    {
        return $this->recommendCategoryAsyncWithHttpInfo($shop_cipher, $recommend_category_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation recommendCategoryAsyncWithHttpInfo
     *
     * Recommend Category
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\RecommendCategoryRequest $recommend_category_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recommendCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function recommendCategoryAsyncWithHttpInfo($shop_cipher, $recommend_category_request = null, string $contentType = self::contentTypes['recommendCategory'][0])
    {
        $returnType = '\Tiktok\Model\RecommendCategoryResponse';
        $request = $this->recommendCategoryRequest($shop_cipher, $recommend_category_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'recommendCategory'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\RecommendCategoryRequest $recommend_category_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['recommendCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function recommendCategoryRequest($shop_cipher, $recommend_category_request = null, string $contentType = self::contentTypes['recommendCategory'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling recommendCategory'
            );
        }



        $resourcePath = '/product/202309/categories/recommend';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($recommend_category_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($recommend_category_request));
            } else {
                $httpBody = $recommend_category_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchProducts
     *
     * Search Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\ProductSearch $product_search product_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProducts'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\ProductSearchResponse
     */
    public function searchProducts($shop_cipher, $page_size = null, $page_token = null, $product_search = null, string $contentType = self::contentTypes['searchProducts'][0])
    {
        list($response) = $this->searchProductsWithHttpInfo($shop_cipher, $page_size, $page_token, $product_search, $contentType);
        return $response;
    }

    /**
     * Operation searchProductsWithHttpInfo
     *
     * Search Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\ProductSearch $product_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProducts'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\ProductSearchResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchProductsWithHttpInfo($shop_cipher, $page_size = null, $page_token = null, $product_search = null, string $contentType = self::contentTypes['searchProducts'][0])
    {
        $request = $this->searchProductsRequest($shop_cipher, $page_size, $page_token, $product_search, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\ProductSearchResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\ProductSearchResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\ProductSearchResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\ProductSearchResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\ProductSearchResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchProductsAsync
     *
     * Search Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\ProductSearch $product_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchProductsAsync($shop_cipher, $page_size = null, $page_token = null, $product_search = null, string $contentType = self::contentTypes['searchProducts'][0])
    {
        return $this->searchProductsAsyncWithHttpInfo($shop_cipher, $page_size, $page_token, $product_search, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchProductsAsyncWithHttpInfo
     *
     * Search Products
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\ProductSearch $product_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchProductsAsyncWithHttpInfo($shop_cipher, $page_size = null, $page_token = null, $product_search = null, string $contentType = self::contentTypes['searchProducts'][0])
    {
        $returnType = '\Tiktok\Model\ProductSearchResponse';
        $request = $this->searchProductsRequest($shop_cipher, $page_size, $page_token, $product_search, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchProducts'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  int $page_size Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. (optional)
     * @param  string $page_token This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search (optional)
     * @param  \Tiktok\Model\ProductSearch $product_search (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchProducts'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchProductsRequest($shop_cipher, $page_size = null, $page_token = null, $product_search = null, string $contentType = self::contentTypes['searchProducts'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling searchProducts'
            );
        }





        $resourcePath = '/product/202312/products/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_token,
            'page_token', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($product_search)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($product_search));
            } else {
                $httpBody = $product_search;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateInventory
     *
     * Update Inventory
     *
     * @param  string $product_id The product id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventoryUpdate $inventory_update inventory_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateInventory'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\InventoryUpdateResponse
     */
    public function updateInventory($product_id, $shop_cipher, $inventory_update = null, string $contentType = self::contentTypes['updateInventory'][0])
    {
        list($response) = $this->updateInventoryWithHttpInfo($product_id, $shop_cipher, $inventory_update, $contentType);
        return $response;
    }

    /**
     * Operation updateInventoryWithHttpInfo
     *
     * Update Inventory
     *
     * @param  string $product_id The product id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventoryUpdate $inventory_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateInventory'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\InventoryUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateInventoryWithHttpInfo($product_id, $shop_cipher, $inventory_update = null, string $contentType = self::contentTypes['updateInventory'][0])
    {
        $request = $this->updateInventoryRequest($product_id, $shop_cipher, $inventory_update, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\InventoryUpdateResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\InventoryUpdateResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\InventoryUpdateResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\InventoryUpdateResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\InventoryUpdateResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateInventoryAsync
     *
     * Update Inventory
     *
     * @param  string $product_id The product id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventoryUpdate $inventory_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateInventory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateInventoryAsync($product_id, $shop_cipher, $inventory_update = null, string $contentType = self::contentTypes['updateInventory'][0])
    {
        return $this->updateInventoryAsyncWithHttpInfo($product_id, $shop_cipher, $inventory_update, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateInventoryAsyncWithHttpInfo
     *
     * Update Inventory
     *
     * @param  string $product_id The product id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventoryUpdate $inventory_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateInventory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateInventoryAsyncWithHttpInfo($product_id, $shop_cipher, $inventory_update = null, string $contentType = self::contentTypes['updateInventory'][0])
    {
        $returnType = '\Tiktok\Model\InventoryUpdateResponse';
        $request = $this->updateInventoryRequest($product_id, $shop_cipher, $inventory_update, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateInventory'
     *
     * @param  string $product_id The product id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\InventoryUpdate $inventory_update (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateInventory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateInventoryRequest($product_id, $shop_cipher, $inventory_update = null, string $contentType = self::contentTypes['updateInventory'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updateInventory'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling updateInventory'
            );
        }



        $resourcePath = '/product/202309/products/{product_id}/inventory/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_update)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_update));
            } else {
                $httpBody = $inventory_update;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePrice
     *
     * Update Price
     *
     * @param  string $product_id product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrice'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\Response
     */
    public function updatePrice($product_id, $shop_cipher, string $contentType = self::contentTypes['updatePrice'][0])
    {
        list($response) = $this->updatePriceWithHttpInfo($product_id, $shop_cipher, $contentType);
        return $response;
    }

    /**
     * Operation updatePriceWithHttpInfo
     *
     * Update Price
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrice'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePriceWithHttpInfo($product_id, $shop_cipher, string $contentType = self::contentTypes['updatePrice'][0])
    {
        $request = $this->updatePriceRequest($product_id, $shop_cipher, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePriceAsync
     *
     * Update Price
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePriceAsync($product_id, $shop_cipher, string $contentType = self::contentTypes['updatePrice'][0])
    {
        return $this->updatePriceAsyncWithHttpInfo($product_id, $shop_cipher, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePriceAsyncWithHttpInfo
     *
     * Update Price
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePriceAsyncWithHttpInfo($product_id, $shop_cipher, string $contentType = self::contentTypes['updatePrice'][0])
    {
        $returnType = '\Tiktok\Model\Response';
        $request = $this->updatePriceRequest($product_id, $shop_cipher, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePrice'
     *
     * @param  string $product_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePriceRequest($product_id, $shop_cipher, string $contentType = self::contentTypes['updatePrice'][0])
    {

        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling updatePrice'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling updatePrice'
            );
        }


        $resourcePath = '/product/202309/products/{product_id}/prices/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'product_id' . '}',
                ObjectSerializer::toPathValue($product_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadProductFile
     *
     * Upload Product File
     *
     * @param  \SplFileObject $data data (optional)
     * @param  string $name name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductFile'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\FileUploadResponse
     */
    public function uploadProductFile($data = null, $name = null, string $contentType = self::contentTypes['uploadProductFile'][0])
    {
        list($response) = $this->uploadProductFileWithHttpInfo($data, $name, $contentType);
        return $response;
    }

    /**
     * Operation uploadProductFileWithHttpInfo
     *
     * Upload Product File
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductFile'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\FileUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadProductFileWithHttpInfo($data = null, $name = null, string $contentType = self::contentTypes['uploadProductFile'][0])
    {
        $request = $this->uploadProductFileRequest($data, $name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\FileUploadResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\FileUploadResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\FileUploadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\FileUploadResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\FileUploadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadProductFileAsync
     *
     * Upload Product File
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadProductFileAsync($data = null, $name = null, string $contentType = self::contentTypes['uploadProductFile'][0])
    {
        return $this->uploadProductFileAsyncWithHttpInfo($data, $name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadProductFileAsyncWithHttpInfo
     *
     * Upload Product File
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadProductFileAsyncWithHttpInfo($data = null, $name = null, string $contentType = self::contentTypes['uploadProductFile'][0])
    {
        $returnType = '\Tiktok\Model\FileUploadResponse';
        $request = $this->uploadProductFileRequest($data, $name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadProductFile'
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $name (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadProductFileRequest($data = null, $name = null, string $contentType = self::contentTypes['uploadProductFile'][0])
    {




        $resourcePath = '/product/202309/files/upload';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        if ($data !== null) {
            $multipart = true;
            $formParams['data'] = [];
            $paramFiles = is_array($data) ? $data : [$data];
            foreach ($paramFiles as $paramFile) {
                $formParams['data'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($name !== null) {
            $formParams['name'] = ObjectSerializer::toFormValue($name);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadProductImage
     *
     * Upload Product Image
     *
     * @param  \SplFileObject $data data (optional)
     * @param  string $use_case use_case (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductImage'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\ImageUploadResponse
     */
    public function uploadProductImage($data = null, $use_case = null, string $contentType = self::contentTypes['uploadProductImage'][0])
    {
        list($response) = $this->uploadProductImageWithHttpInfo($data, $use_case, $contentType);
        return $response;
    }

    /**
     * Operation uploadProductImageWithHttpInfo
     *
     * Upload Product Image
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $use_case (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductImage'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\ImageUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadProductImageWithHttpInfo($data = null, $use_case = null, string $contentType = self::contentTypes['uploadProductImage'][0])
    {
        $request = $this->uploadProductImageRequest($data, $use_case, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\ImageUploadResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\ImageUploadResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\ImageUploadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\ImageUploadResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\ImageUploadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation uploadProductImageAsync
     *
     * Upload Product Image
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $use_case (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadProductImageAsync($data = null, $use_case = null, string $contentType = self::contentTypes['uploadProductImage'][0])
    {
        return $this->uploadProductImageAsyncWithHttpInfo($data, $use_case, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadProductImageAsyncWithHttpInfo
     *
     * Upload Product Image
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $use_case (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadProductImageAsyncWithHttpInfo($data = null, $use_case = null, string $contentType = self::contentTypes['uploadProductImage'][0])
    {
        $returnType = '\Tiktok\Model\ImageUploadResponse';
        $request = $this->uploadProductImageRequest($data, $use_case, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadProductImage'
     *
     * @param  \SplFileObject $data (optional)
     * @param  string $use_case (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadProductImage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadProductImageRequest($data = null, $use_case = null, string $contentType = self::contentTypes['uploadProductImage'][0])
    {




        $resourcePath = '/product/202309/images/upload';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        if ($data !== null) {
            $multipart = true;
            $formParams['data'] = [];
            $paramFiles = is_array($data) ? $data : [$data];
            foreach ($paramFiles as $paramFile) {
                $formParams['data'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($use_case !== null) {
            $formParams['use_case'] = ObjectSerializer::toFormValue($use_case);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
