<?php
/**
 * FulfilmentApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * tiktok
 *
 * See https://partner.tiktokshop.com/docv2/page/656559fcf4488c02dfe8ce82    TikTok Shop provides a comprehensive range of APIs known as TTS API, which allows TTS developers access to user data within the app, including catalogs, orders, shipments, payments, and more. Leveraging the capabilities of the TTS API, developers can create apps that extend Seller Center's existing functionalities. These apps can enhance product catalog listings, streamline order fulfillment, minimize operational burdens, and accelerate customer interactions
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.5.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Tiktok\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Tiktok\ApiException;
use Tiktok\Configuration;
use Tiktok\HeaderSelector;
use Tiktok\ObjectSerializer;

/**
 * FulfilmentApi Class Doc Comment
 *
 * @category Class
 * @package  Tiktok
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FulfilmentApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createPackages' => [
            'application/json',
        ],
        'getPackageDetail' => [
            'application/json',
        ],
        'markPackageAsShipped' => [
            'application/json',
        ],
        'shipPackage' => [
            'application/json',
        ],
        'updatePackageDeliveryStatus' => [
            'application/json',
        ],
        'updateShippingInfo' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createPackages
     *
     * Create Packages
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreatePackagesRequest $create_packages_request create_packages_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPackages'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\CreatePackagesResponse
     */
    public function createPackages($shop_cipher, $create_packages_request = null, string $contentType = self::contentTypes['createPackages'][0])
    {
        list($response) = $this->createPackagesWithHttpInfo($shop_cipher, $create_packages_request, $contentType);
        return $response;
    }

    /**
     * Operation createPackagesWithHttpInfo
     *
     * Create Packages
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreatePackagesRequest $create_packages_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPackages'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\CreatePackagesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPackagesWithHttpInfo($shop_cipher, $create_packages_request = null, string $contentType = self::contentTypes['createPackages'][0])
    {
        $request = $this->createPackagesRequest($shop_cipher, $create_packages_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\CreatePackagesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\CreatePackagesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\CreatePackagesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\CreatePackagesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\CreatePackagesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPackagesAsync
     *
     * Create Packages
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreatePackagesRequest $create_packages_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPackages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPackagesAsync($shop_cipher, $create_packages_request = null, string $contentType = self::contentTypes['createPackages'][0])
    {
        return $this->createPackagesAsyncWithHttpInfo($shop_cipher, $create_packages_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPackagesAsyncWithHttpInfo
     *
     * Create Packages
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreatePackagesRequest $create_packages_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPackages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPackagesAsyncWithHttpInfo($shop_cipher, $create_packages_request = null, string $contentType = self::contentTypes['createPackages'][0])
    {
        $returnType = '\Tiktok\Model\CreatePackagesResponse';
        $request = $this->createPackagesRequest($shop_cipher, $create_packages_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPackages'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\CreatePackagesRequest $create_packages_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPackages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPackagesRequest($shop_cipher, $create_packages_request = null, string $contentType = self::contentTypes['createPackages'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling createPackages'
            );
        }



        $resourcePath = '/fulfillment/202309/packages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_packages_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_packages_request));
            } else {
                $httpBody = $create_packages_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPackageDetail
     *
     * Get Package Detail
     *
     * @param  string $package_id package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageDetail'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\PackageDetailResponse
     */
    public function getPackageDetail($package_id, $shop_cipher, string $contentType = self::contentTypes['getPackageDetail'][0])
    {
        list($response) = $this->getPackageDetailWithHttpInfo($package_id, $shop_cipher, $contentType);
        return $response;
    }

    /**
     * Operation getPackageDetailWithHttpInfo
     *
     * Get Package Detail
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageDetail'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\PackageDetailResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPackageDetailWithHttpInfo($package_id, $shop_cipher, string $contentType = self::contentTypes['getPackageDetail'][0])
    {
        $request = $this->getPackageDetailRequest($package_id, $shop_cipher, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\PackageDetailResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\PackageDetailResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\PackageDetailResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\PackageDetailResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\PackageDetailResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPackageDetailAsync
     *
     * Get Package Detail
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageDetail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackageDetailAsync($package_id, $shop_cipher, string $contentType = self::contentTypes['getPackageDetail'][0])
    {
        return $this->getPackageDetailAsyncWithHttpInfo($package_id, $shop_cipher, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPackageDetailAsyncWithHttpInfo
     *
     * Get Package Detail
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageDetail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackageDetailAsyncWithHttpInfo($package_id, $shop_cipher, string $contentType = self::contentTypes['getPackageDetail'][0])
    {
        $returnType = '\Tiktok\Model\PackageDetailResponse';
        $request = $this->getPackageDetailRequest($package_id, $shop_cipher, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPackageDetail'
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageDetail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPackageDetailRequest($package_id, $shop_cipher, string $contentType = self::contentTypes['getPackageDetail'][0])
    {

        // verify the required parameter 'package_id' is set
        if ($package_id === null || (is_array($package_id) && count($package_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $package_id when calling getPackageDetail'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling getPackageDetail'
            );
        }


        $resourcePath = '/fulfillment/202309/packages/{package_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                '{' . 'package_id' . '}',
                ObjectSerializer::toPathValue($package_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation markPackageAsShipped
     *
     * Mark Package As Shipped
     *
     * @param  string $order_id order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageShippedRequest $package_shipped_request package_shipped_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markPackageAsShipped'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\PackageShippedResponse
     */
    public function markPackageAsShipped($order_id, $shop_cipher, $package_shipped_request = null, string $contentType = self::contentTypes['markPackageAsShipped'][0])
    {
        list($response) = $this->markPackageAsShippedWithHttpInfo($order_id, $shop_cipher, $package_shipped_request, $contentType);
        return $response;
    }

    /**
     * Operation markPackageAsShippedWithHttpInfo
     *
     * Mark Package As Shipped
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageShippedRequest $package_shipped_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markPackageAsShipped'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\PackageShippedResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function markPackageAsShippedWithHttpInfo($order_id, $shop_cipher, $package_shipped_request = null, string $contentType = self::contentTypes['markPackageAsShipped'][0])
    {
        $request = $this->markPackageAsShippedRequest($order_id, $shop_cipher, $package_shipped_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\PackageShippedResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\PackageShippedResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\PackageShippedResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\PackageShippedResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\PackageShippedResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation markPackageAsShippedAsync
     *
     * Mark Package As Shipped
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageShippedRequest $package_shipped_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markPackageAsShipped'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markPackageAsShippedAsync($order_id, $shop_cipher, $package_shipped_request = null, string $contentType = self::contentTypes['markPackageAsShipped'][0])
    {
        return $this->markPackageAsShippedAsyncWithHttpInfo($order_id, $shop_cipher, $package_shipped_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation markPackageAsShippedAsyncWithHttpInfo
     *
     * Mark Package As Shipped
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageShippedRequest $package_shipped_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markPackageAsShipped'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markPackageAsShippedAsyncWithHttpInfo($order_id, $shop_cipher, $package_shipped_request = null, string $contentType = self::contentTypes['markPackageAsShipped'][0])
    {
        $returnType = '\Tiktok\Model\PackageShippedResponse';
        $request = $this->markPackageAsShippedRequest($order_id, $shop_cipher, $package_shipped_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'markPackageAsShipped'
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageShippedRequest $package_shipped_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['markPackageAsShipped'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function markPackageAsShippedRequest($order_id, $shop_cipher, $package_shipped_request = null, string $contentType = self::contentTypes['markPackageAsShipped'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling markPackageAsShipped'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling markPackageAsShipped'
            );
        }



        $resourcePath = '/fulfillment/202309/orders/{order_id}/packages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($package_shipped_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($package_shipped_request));
            } else {
                $httpBody = $package_shipped_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation shipPackage
     *
     * Ship Package
     *
     * @param  string $package_id package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShipPackageRequest $ship_package_request ship_package_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['shipPackage'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\Response
     */
    public function shipPackage($package_id, $shop_cipher, $ship_package_request = null, string $contentType = self::contentTypes['shipPackage'][0])
    {
        list($response) = $this->shipPackageWithHttpInfo($package_id, $shop_cipher, $ship_package_request, $contentType);
        return $response;
    }

    /**
     * Operation shipPackageWithHttpInfo
     *
     * Ship Package
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShipPackageRequest $ship_package_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['shipPackage'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function shipPackageWithHttpInfo($package_id, $shop_cipher, $ship_package_request = null, string $contentType = self::contentTypes['shipPackage'][0])
    {
        $request = $this->shipPackageRequest($package_id, $shop_cipher, $ship_package_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation shipPackageAsync
     *
     * Ship Package
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShipPackageRequest $ship_package_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['shipPackage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function shipPackageAsync($package_id, $shop_cipher, $ship_package_request = null, string $contentType = self::contentTypes['shipPackage'][0])
    {
        return $this->shipPackageAsyncWithHttpInfo($package_id, $shop_cipher, $ship_package_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation shipPackageAsyncWithHttpInfo
     *
     * Ship Package
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShipPackageRequest $ship_package_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['shipPackage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function shipPackageAsyncWithHttpInfo($package_id, $shop_cipher, $ship_package_request = null, string $contentType = self::contentTypes['shipPackage'][0])
    {
        $returnType = '\Tiktok\Model\Response';
        $request = $this->shipPackageRequest($package_id, $shop_cipher, $ship_package_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'shipPackage'
     *
     * @param  string $package_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShipPackageRequest $ship_package_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['shipPackage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function shipPackageRequest($package_id, $shop_cipher, $ship_package_request = null, string $contentType = self::contentTypes['shipPackage'][0])
    {

        // verify the required parameter 'package_id' is set
        if ($package_id === null || (is_array($package_id) && count($package_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $package_id when calling shipPackage'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling shipPackage'
            );
        }



        $resourcePath = '/fulfillment/202309/packages/{package_id}/ship';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($package_id !== null) {
            $resourcePath = str_replace(
                '{' . 'package_id' . '}',
                ObjectSerializer::toPathValue($package_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($ship_package_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($ship_package_request));
            } else {
                $httpBody = $ship_package_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePackageDeliveryStatus
     *
     * Update Package Delivery Status
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageDeliveryStatusRequest $package_delivery_status_request package_delivery_status_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePackageDeliveryStatus'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\PackageDeliveryStatusResponse
     */
    public function updatePackageDeliveryStatus($shop_cipher, $package_delivery_status_request = null, string $contentType = self::contentTypes['updatePackageDeliveryStatus'][0])
    {
        list($response) = $this->updatePackageDeliveryStatusWithHttpInfo($shop_cipher, $package_delivery_status_request, $contentType);
        return $response;
    }

    /**
     * Operation updatePackageDeliveryStatusWithHttpInfo
     *
     * Update Package Delivery Status
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageDeliveryStatusRequest $package_delivery_status_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePackageDeliveryStatus'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\PackageDeliveryStatusResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePackageDeliveryStatusWithHttpInfo($shop_cipher, $package_delivery_status_request = null, string $contentType = self::contentTypes['updatePackageDeliveryStatus'][0])
    {
        $request = $this->updatePackageDeliveryStatusRequest($shop_cipher, $package_delivery_status_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\PackageDeliveryStatusResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\PackageDeliveryStatusResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\PackageDeliveryStatusResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\PackageDeliveryStatusResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\PackageDeliveryStatusResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePackageDeliveryStatusAsync
     *
     * Update Package Delivery Status
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageDeliveryStatusRequest $package_delivery_status_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePackageDeliveryStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePackageDeliveryStatusAsync($shop_cipher, $package_delivery_status_request = null, string $contentType = self::contentTypes['updatePackageDeliveryStatus'][0])
    {
        return $this->updatePackageDeliveryStatusAsyncWithHttpInfo($shop_cipher, $package_delivery_status_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePackageDeliveryStatusAsyncWithHttpInfo
     *
     * Update Package Delivery Status
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageDeliveryStatusRequest $package_delivery_status_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePackageDeliveryStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePackageDeliveryStatusAsyncWithHttpInfo($shop_cipher, $package_delivery_status_request = null, string $contentType = self::contentTypes['updatePackageDeliveryStatus'][0])
    {
        $returnType = '\Tiktok\Model\PackageDeliveryStatusResponse';
        $request = $this->updatePackageDeliveryStatusRequest($shop_cipher, $package_delivery_status_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePackageDeliveryStatus'
     *
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\PackageDeliveryStatusRequest $package_delivery_status_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePackageDeliveryStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePackageDeliveryStatusRequest($shop_cipher, $package_delivery_status_request = null, string $contentType = self::contentTypes['updatePackageDeliveryStatus'][0])
    {

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling updatePackageDeliveryStatus'
            );
        }



        $resourcePath = '/fulfillment/202309/packages/deliver';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($package_delivery_status_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($package_delivery_status_request));
            } else {
                $httpBody = $package_delivery_status_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateShippingInfo
     *
     * Update Shipping Info
     *
     * @param  string $order_id order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShippingInfoRequest $shipping_info_request shipping_info_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShippingInfo'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Tiktok\Model\Response
     */
    public function updateShippingInfo($order_id, $shop_cipher, $shipping_info_request = null, string $contentType = self::contentTypes['updateShippingInfo'][0])
    {
        list($response) = $this->updateShippingInfoWithHttpInfo($order_id, $shop_cipher, $shipping_info_request, $contentType);
        return $response;
    }

    /**
     * Operation updateShippingInfoWithHttpInfo
     *
     * Update Shipping Info
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShippingInfoRequest $shipping_info_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShippingInfo'] to see the possible values for this operation
     *
     * @throws \Tiktok\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Tiktok\Model\Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateShippingInfoWithHttpInfo($order_id, $shop_cipher, $shipping_info_request = null, string $contentType = self::contentTypes['updateShippingInfo'][0])
    {
        $request = $this->updateShippingInfoRequest($order_id, $shop_cipher, $shipping_info_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Tiktok\Model\Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Tiktok\Model\Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Tiktok\Model\Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Tiktok\Model\Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Tiktok\Model\Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateShippingInfoAsync
     *
     * Update Shipping Info
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShippingInfoRequest $shipping_info_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShippingInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShippingInfoAsync($order_id, $shop_cipher, $shipping_info_request = null, string $contentType = self::contentTypes['updateShippingInfo'][0])
    {
        return $this->updateShippingInfoAsyncWithHttpInfo($order_id, $shop_cipher, $shipping_info_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateShippingInfoAsyncWithHttpInfo
     *
     * Update Shipping Info
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShippingInfoRequest $shipping_info_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShippingInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShippingInfoAsyncWithHttpInfo($order_id, $shop_cipher, $shipping_info_request = null, string $contentType = self::contentTypes['updateShippingInfo'][0])
    {
        $returnType = '\Tiktok\Model\Response';
        $request = $this->updateShippingInfoRequest($order_id, $shop_cipher, $shipping_info_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateShippingInfo'
     *
     * @param  string $order_id (required)
     * @param  string $shop_cipher Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. (required)
     * @param  \Tiktok\Model\ShippingInfoRequest $shipping_info_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateShippingInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateShippingInfoRequest($order_id, $shop_cipher, $shipping_info_request = null, string $contentType = self::contentTypes['updateShippingInfo'][0])
    {

        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling updateShippingInfo'
            );
        }

        // verify the required parameter 'shop_cipher' is set
        if ($shop_cipher === null || (is_array($shop_cipher) && count($shop_cipher) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shop_cipher when calling updateShippingInfo'
            );
        }



        $resourcePath = '/fulfillment/202309/orders/{order_id}/shipping_info/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shop_cipher,
            'shop_cipher', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'order_id' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($shipping_info_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($shipping_info_request));
            } else {
                $httpBody = $shipping_info_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
