# Tiktok\ReturnRefundApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getReturnRecords()**](ReturnRefundApi.md#getReturnRecords) | **GET** /return_refund/202309/returns/{return_id}/records | Get Return Records |
| [**searchCancellations()**](ReturnRefundApi.md#searchCancellations) | **POST** /return_refund/202309/cancellations/search | Search Cancellations |
| [**searchReturns()**](ReturnRefundApi.md#searchReturns) | **POST** /return_refund/202309/returns/search | Search Returns |


## `getReturnRecords()`

```php
getReturnRecords($return_id, $shop_cipher, $locale): \Tiktok\Model\ReturnRecordsResponse
```

Get Return Records

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ReturnRefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$return_id = 'return_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$locale = 'locale_example'; // string | BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \"en\", effect multilingual text such as reason_text

try {
    $result = $apiInstance->getReturnRecords($return_id, $shop_cipher, $locale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnRefundApi->getReturnRecords: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **return_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **locale** | **string**| BCP 47 locale identifier, reference to http://www.unicode.org/reports/tr35/#Unicode_locale_identifier, default \&quot;en\&quot;, effect multilingual text such as reason_text | [optional] |

### Return type

[**\Tiktok\Model\ReturnRecordsResponse**](../Model/ReturnRecordsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchCancellations()`

```php
searchCancellations($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_cancellations_request): \Tiktok\Model\SearchCancellationsResponse
```

Search Cancellations

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ReturnRefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$sort_field = 'sort_field_example'; // string
$sort_order = 'sort_order_example'; // string | Available value: ASC;DESC(default)
$page_size = 56; // int | Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100.
$page_token = 'page_token_example'; // string | This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search
$search_cancellations_request = new \Tiktok\Model\SearchCancellationsRequest(); // \Tiktok\Model\SearchCancellationsRequest

try {
    $result = $apiInstance->searchCancellations($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_cancellations_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnRefundApi->searchCancellations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **sort_field** | **string**|  | [optional] |
| **sort_order** | **string**| Available value: ASC;DESC(default) | [optional] |
| **page_size** | **int**| Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. | [optional] |
| **page_token** | **string**| This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search | [optional] |
| **search_cancellations_request** | [**\Tiktok\Model\SearchCancellationsRequest**](../Model/SearchCancellationsRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\SearchCancellationsResponse**](../Model/SearchCancellationsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchReturns()`

```php
searchReturns($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_returns_request): \Tiktok\Model\SearchReturnsResponse
```

Search Returns

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ReturnRefundApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$sort_field = 'sort_field_example'; // string
$sort_order = 'sort_order_example'; // string | Available value: ASC;DESC(default)
$page_size = 56; // int | Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100.
$page_token = 'page_token_example'; // string | This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search
$search_returns_request = new \Tiktok\Model\SearchReturnsRequest(); // \Tiktok\Model\SearchReturnsRequest

try {
    $result = $apiInstance->searchReturns($shop_cipher, $sort_field, $sort_order, $page_size, $page_token, $search_returns_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnRefundApi->searchReturns: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **sort_field** | **string**|  | [optional] |
| **sort_order** | **string**| Available value: ASC;DESC(default) | [optional] |
| **page_size** | **int**| Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. | [optional] |
| **page_token** | **string**| This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search | [optional] |
| **search_returns_request** | [**\Tiktok\Model\SearchReturnsRequest**](../Model/SearchReturnsRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\SearchReturnsResponse**](../Model/SearchReturnsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
