# Tiktok\ProductApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**activateProduct()**](ProductApi.md#activateProduct) | **POST** /product/202309/products/activate | Activate Products |
| [**createBrand()**](ProductApi.md#createBrand) | **POST** /product/202309/brands | Create Brands |
| [**createProduct()**](ProductApi.md#createProduct) | **POST** /product/202309/products | Create Product |
| [**deactivateProducts()**](ProductApi.md#deactivateProducts) | **POST** /product/202309/products/deactivate | Deactivate Products |
| [**deleteProducts()**](ProductApi.md#deleteProducts) | **DELETE** /product/202309/products | Delete Products |
| [**editProduct()**](ProductApi.md#editProduct) | **PUT** /product/202309/products/{product_id} | Edit Product |
| [**getAttributes()**](ProductApi.md#getAttributes) | **GET** /product/202309/categories/{category_id}/attributes | Get Attributes |
| [**getBrands()**](ProductApi.md#getBrands) | **GET** /product/202309/brands | Get Brands |
| [**getCategories()**](ProductApi.md#getCategories) | **GET** /product/202309/categories | Get Categories |
| [**getProduct()**](ProductApi.md#getProduct) | **GET** /product/202309/products/{product_id} | Get Product |
| [**getProduct202309CategoriesCategoryIdRules()**](ProductApi.md#getProduct202309CategoriesCategoryIdRules) | **GET** /product/202309/categories/{category_id}/rules | Get Category Rules |
| [**inventorySearch()**](ProductApi.md#inventorySearch) | **POST** /product/202309/inventory/search | Inventory Search |
| [**partialEditProduct()**](ProductApi.md#partialEditProduct) | **POST** /product/202309/products/{product_id}/partial_edit | Partial Edit Product |
| [**recommendCategory()**](ProductApi.md#recommendCategory) | **POST** /product/202309/categories/recommend | Recommend Category |
| [**searchProducts()**](ProductApi.md#searchProducts) | **POST** /product/202312/products/search | Search Products |
| [**updateInventory()**](ProductApi.md#updateInventory) | **POST** /product/202309/products/{product_id}/inventory/update | Update Inventory |
| [**updatePrice()**](ProductApi.md#updatePrice) | **POST** /product/202309/products/{product_id}/prices/update | Update Price |
| [**uploadProductFile()**](ProductApi.md#uploadProductFile) | **POST** /product/202309/files/upload | Upload Product File |
| [**uploadProductImage()**](ProductApi.md#uploadProductImage) | **POST** /product/202309/images/upload | Upload Product Image |


## `activateProduct()`

```php
activateProduct($product_ids_request): \Tiktok\Model\ProductIDsResponse
```

Activate Products

This API is for sellers to activate a currently deactive product (off-shelf). It does not apply to deleted, frozen, or draft products. TTS will send the product to the TTS Marketplace team for auditing. The product will enter PENDING state, pending approval.  Usage requirements - Products need to be in deactive status.  - The user must have permission to activate these products.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_ids_request = new \Tiktok\Model\ProductIDsRequest(); // \Tiktok\Model\ProductIDsRequest

try {
    $result = $apiInstance->activateProduct($product_ids_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->activateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_ids_request** | [**\Tiktok\Model\ProductIDsRequest**](../Model/ProductIDsRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\ProductIDsResponse**](../Model/ProductIDsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createBrand()`

```php
createBrand($brand): \Tiktok\Model\IdResponse
```

Create Brands

Use this API, sellers can create custom brands exclusively for their own use.  Notice: - This API can be used to create brands for all markets. - Authorization is not required when creating a brand. You can create the brand first and then apply for authorization. Please refer to the following link for information about brand authorization. (i.e US market: https://seller-us.tiktok.com/profile/trademark?type=owner) - The seller can only create 50 brands per day, and a seller can create a maximum of 1000 brands in total.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$brand = new \Tiktok\Model\Brand(); // \Tiktok\Model\Brand

try {
    $result = $apiInstance->createBrand($brand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->createBrand: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **brand** | [**\Tiktok\Model\Brand**](../Model/Brand.md)|  | [optional] |

### Return type

[**\Tiktok\Model\IdResponse**](../Model/IdResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createProduct()`

```php
createProduct($shop_cipher, $create_product_request): \Tiktok\Model\CreateProductResponse
```

Create Product

Create Product API is used to list products for local shops. If you need to manage product listings for cross-border shops, use Create Global Product API. The process of creating a product is as follows, and you can refer to the guide document for more detailed instructions.  Note: In order to create products for invite-only categories, sellers need to contact account managers and apply for these categories. Know more about UK invite-only categories and US invite-only categories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$create_product_request = new \Tiktok\Model\CreateProductRequest(); // \Tiktok\Model\CreateProductRequest

try {
    $result = $apiInstance->createProduct($shop_cipher, $create_product_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->createProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **create_product_request** | [**\Tiktok\Model\CreateProductRequest**](../Model/CreateProductRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\CreateProductResponse**](../Model/CreateProductResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deactivateProducts()`

```php
deactivateProducts($shop_cipher, $product_ids_request): \Tiktok\Model\ProductIDsResponse
```

Deactivate Products

This API is for sellers to deactivate a currently activated product. It does not apply to deleted, frozen, or draft products. The product will be deactivated from TTS.  Usage requirements - Products need to be in active status.  - The user must have permission to deactivate these products.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$product_ids_request = new \Tiktok\Model\ProductIDsRequest(); // \Tiktok\Model\ProductIDsRequest

try {
    $result = $apiInstance->deactivateProducts($shop_cipher, $product_ids_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->deactivateProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **product_ids_request** | [**\Tiktok\Model\ProductIDsRequest**](../Model/ProductIDsRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\ProductIDsResponse**](../Model/ProductIDsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProducts()`

```php
deleteProducts($shop_cipher, $product_ids_request): \Tiktok\Model\ProductIDsResponse
```

Delete Products

This API supports deletion of a single product or multiple products (up to 20 at a time)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$product_ids_request = new \Tiktok\Model\ProductIDsRequest(); // \Tiktok\Model\ProductIDsRequest

try {
    $result = $apiInstance->deleteProducts($shop_cipher, $product_ids_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->deleteProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **product_ids_request** | [**\Tiktok\Model\ProductIDsRequest**](../Model/ProductIDsRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\ProductIDsResponse**](../Model/ProductIDsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `editProduct()`

```php
editProduct($product_id, $create_product_request): \Tiktok\Model\CreateProductResponse
```

Edit Product

Use this API to edit product information such as product description. Note that this API is for editing all product attributes at once; if the request payload contains a blank response, it will override the existing fields.  To edit specific properties such as inventory level or price, use Update Inventory or Update Price.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 'product_id_example'; // string
$create_product_request = new \Tiktok\Model\CreateProductRequest(); // \Tiktok\Model\CreateProductRequest

try {
    $result = $apiInstance->editProduct($product_id, $create_product_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->editProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **string**|  | |
| **create_product_request** | [**\Tiktok\Model\CreateProductRequest**](../Model/CreateProductRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\CreateProductResponse**](../Model/CreateProductResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAttributes()`

```php
getAttributes($category_id, $shop_cipher, $locale, $category_version): \Tiktok\Model\AttributeResponse
```

Get Attributes

Input a category to get the required product attributes and sales attributes that are required to list the product. You may specify the language using the locale parameter. This API returns the required attributes based on where your shop is currently based.  Please note that only leaf category IDs are supported for obtaining attributes.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$category_id = 56; // int
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$locale = 'locale_example'; // string
$category_version = 'category_version_example'; // string

try {
    $result = $apiInstance->getAttributes($category_id, $shop_cipher, $locale, $category_version);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getAttributes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **locale** | **string**|  | [optional] |
| **category_version** | **string**|  | [optional] |

### Return type

[**\Tiktok\Model\AttributeResponse**](../Model/AttributeResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBrands()`

```php
getBrands($shop_cipher, $category_id, $is_authorized, $brand_name, $page_size, $page_token, $category_version): \Tiktok\Model\BrandsResponse
```

Get Brands

Use this API to retrieve all product brands by page token in the system. It will include both the platform's built-in brands as well as the custom brands created by sellers using the \"Create Brand\" API

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$category_id = 'category_id_example'; // string
$is_authorized = True; // bool
$brand_name = 'brand_name_example'; // string
$page_size = 56; // int | Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100.
$page_token = 'page_token_example'; // string | This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search
$category_version = 'category_version_example'; // string

try {
    $result = $apiInstance->getBrands($shop_cipher, $category_id, $is_authorized, $brand_name, $page_size, $page_token, $category_version);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getBrands: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **category_id** | **string**|  | [optional] |
| **is_authorized** | **bool**|  | [optional] |
| **brand_name** | **string**|  | [optional] |
| **page_size** | **int**| Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. | [optional] |
| **page_token** | **string**| This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search | [optional] |
| **category_version** | **string**|  | [optional] |

### Return type

[**\Tiktok\Model\BrandsResponse**](../Model/BrandsResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategories()`

```php
getCategories($shop_cipher, $locale, $keyword, $category_version): \Tiktok\Model\CategoriesResponse
```

Get Categories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$locale = 'locale_example'; // string
$keyword = 'keyword_example'; // string
$category_version = 'category_version_example'; // string

try {
    $result = $apiInstance->getCategories($shop_cipher, $locale, $keyword, $category_version);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **locale** | **string**|  | [optional] |
| **keyword** | **string**|  | [optional] |
| **category_version** | **string**|  | [optional] |

### Return type

[**\Tiktok\Model\CategoriesResponse**](../Model/CategoriesResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProduct()`

```php
getProduct($product_id, $shop_cipher, $return_under_review_version): \Tiktok\Model\GetProductResponse
```

Get Product

Use this API to edit product information such as product description. Note that this API is for editing all product attributes at once; if the request payload contains a blank response, it will override the existing fields.  To edit specific properties such as inventory level or price, use Update Inventory or Update Price.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 'product_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$return_under_review_version = True; // bool

try {
    $result = $apiInstance->getProduct($product_id, $shop_cipher, $return_under_review_version);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **return_under_review_version** | **bool**|  | [optional] |

### Return type

[**\Tiktok\Model\GetProductResponse**](../Model/GetProductResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProduct202309CategoriesCategoryIdRules()`

```php
getProduct202309CategoriesCategoryIdRules($category_id, $shop_cipher, $category_version): \Tiktok\Model\CategoryRuleResponse
```

Get Category Rules

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$category_id = 56; // int
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$category_version = 'category_version_example'; // string | The version id of the category tree.The new version id is \"v2\" and will return data from our new 7-level category tree.The old version id is \"v1\" and will return data from the current 3-level category tree.The old version of category data will be given by default.

try {
    $result = $apiInstance->getProduct202309CategoriesCategoryIdRules($category_id, $shop_cipher, $category_version);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->getProduct202309CategoriesCategoryIdRules: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **category_version** | **string**| The version id of the category tree.The new version id is \&quot;v2\&quot; and will return data from our new 7-level category tree.The old version id is \&quot;v1\&quot; and will return data from the current 3-level category tree.The old version of category data will be given by default. | [optional] |

### Return type

[**\Tiktok\Model\CategoryRuleResponse**](../Model/CategoryRuleResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventorySearch()`

```php
inventorySearch($shop_cipher, $inventory_search): \Tiktok\Model\InventorySearchResponse
```

Inventory Search

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$inventory_search = new \Tiktok\Model\InventorySearch(); // \Tiktok\Model\InventorySearch

try {
    $result = $apiInstance->inventorySearch($shop_cipher, $inventory_search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->inventorySearch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **inventory_search** | [**\Tiktok\Model\InventorySearch**](../Model/InventorySearch.md)|  | [optional] |

### Return type

[**\Tiktok\Model\InventorySearchResponse**](../Model/InventorySearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `partialEditProduct()`

```php
partialEditProduct($product_id, $shop_cipher, $create_product_request): \Tiktok\Model\CreateProductResponse
```

Partial Edit Product

This interface is used to partially modify product information.  It allows local to local sellers to edit a subset of product information fields.  If the first level fields are not specified, then they will not be updated.  If the first level fields are specified and not empty, then the subfields will be overridden by the specified field values.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 'product_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$create_product_request = new \Tiktok\Model\CreateProductRequest(); // \Tiktok\Model\CreateProductRequest

try {
    $result = $apiInstance->partialEditProduct($product_id, $shop_cipher, $create_product_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->partialEditProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **create_product_request** | [**\Tiktok\Model\CreateProductRequest**](../Model/CreateProductRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\CreateProductResponse**](../Model/CreateProductResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `recommendCategory()`

```php
recommendCategory($shop_cipher, $recommend_category_request): \Tiktok\Model\RecommendCategoryResponse
```

Recommend Category

This API recommends the Category for each product, based on product title, description, main images and sku images. This API is generally used when a seller is syncing their product catalog from an external OMS system into TTS.  The platform will return the recommended category, which helps speed up product catalog syncs for the Seller.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$recommend_category_request = new \Tiktok\Model\RecommendCategoryRequest(); // \Tiktok\Model\RecommendCategoryRequest

try {
    $result = $apiInstance->recommendCategory($shop_cipher, $recommend_category_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->recommendCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **recommend_category_request** | [**\Tiktok\Model\RecommendCategoryRequest**](../Model/RecommendCategoryRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\RecommendCategoryResponse**](../Model/RecommendCategoryResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchProducts()`

```php
searchProducts($shop_cipher, $page_size, $page_token, $product_search): \Tiktok\Model\ProductSearchResponse
```

Search Products

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$page_size = 56; // int | Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100.
$page_token = 'page_token_example'; // string | This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search
$product_search = new \Tiktok\Model\ProductSearch(); // \Tiktok\Model\ProductSearch

try {
    $result = $apiInstance->searchProducts($shop_cipher, $page_size, $page_token, $product_search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->searchProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **page_size** | **int**| Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. | [optional] |
| **page_token** | **string**| This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search | [optional] |
| **product_search** | [**\Tiktok\Model\ProductSearch**](../Model/ProductSearch.md)|  | [optional] |

### Return type

[**\Tiktok\Model\ProductSearchResponse**](../Model/ProductSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventory()`

```php
updateInventory($product_id, $shop_cipher, $inventory_update): \Tiktok\Model\InventoryUpdateResponse
```

Update Inventory

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 'product_id_example'; // string | The product id
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$inventory_update = new \Tiktok\Model\InventoryUpdate(); // \Tiktok\Model\InventoryUpdate

try {
    $result = $apiInstance->updateInventory($product_id, $shop_cipher, $inventory_update);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->updateInventory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **string**| The product id | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **inventory_update** | [**\Tiktok\Model\InventoryUpdate**](../Model/InventoryUpdate.md)|  | [optional] |

### Return type

[**\Tiktok\Model\InventoryUpdateResponse**](../Model/InventoryUpdateResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePrice()`

```php
updatePrice($product_id, $shop_cipher): \Tiktok\Model\Response
```

Update Price

This API allows you to change the price of a SKU. You can update the price of multiple SKUs of the same product.  Usage requirements - Products need to be in living status.  - The user must have permission to manage this product.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_id = 'product_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->updatePrice($product_id, $shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->updatePrice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **product_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\Response**](../Model/Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `uploadProductFile()`

```php
uploadProductFile($data, $name): \Tiktok\Model\FileUploadResponse
```

Upload Product File

Products are easier to sell if customers can see videos of them. Product certification is required for products in certain categories. Upload File API is used to upload local files to the Tiktok Shop to meet these needs. The API currently supports upload of video in mp4 format and upload of product certification in pdf format.  Usage requirements - Support formats: mp4 and PDF files - The file size can not exceed 10MB. - The video aspect ratio is between 9:16 and 16:9.  To successfully upload the file, follow these best practices when naming your files: 1. Don't begin your file name with symbols. For example: $my_file_name.mp4 2. Don't use periods before the file extension. For example: my_product_name.mp4 3. Avoid using spaces in the file name. Example: my product video.mp4

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$data = "/path/to/file.txt"; // \SplFileObject
$name = 'name_example'; // string

try {
    $result = $apiInstance->uploadProductFile($data, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->uploadProductFile: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **data** | **\SplFileObject****\SplFileObject**|  | [optional] |
| **name** | **string**|  | [optional] |

### Return type

[**\Tiktok\Model\FileUploadResponse**](../Model/FileUploadResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `multipart/form-data`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `uploadProductImage()`

```php
uploadProductImage($data, $use_case): \Tiktok\Model\ImageUploadResponse
```

Upload Product Image

Upload Image API interface is used to upload local images to the Tiktok Shop. The uploaded images will be used for creating product main images, SKU images, size charts, qualification images, etc.  Usage requirements - The image format must be JPEG, PNG, or JPG. - The image size cannot exceed 5MB.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\ProductApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$data = "/path/to/file.txt"; // \SplFileObject
$use_case = 'use_case_example'; // string

try {
    $result = $apiInstance->uploadProductImage($data, $use_case);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductApi->uploadProductImage: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **data** | **\SplFileObject****\SplFileObject**|  | [optional] |
| **use_case** | **string**|  | [optional] |

### Return type

[**\Tiktok\Model\ImageUploadResponse**](../Model/ImageUploadResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `multipart/form-data`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
