# Tiktok\OrderApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getOrderDetail()**](OrderApi.md#getOrderDetail) | **GET** /order/202309/orders | Get Order Detail |
| [**getOrderList()**](OrderApi.md#getOrderList) | **POST** /order/202309/orders/search | Get Order List |
| [**getPriceDetail()**](OrderApi.md#getPriceDetail) | **GET** /order/202407/orders/{order_id}/price_detail | Get Price Detail |


## `getOrderDetail()`

```php
getOrderDetail($shop_cipher, $ids): \Tiktok\Model\OrderSearchResponse
```

Get Order Detail

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$ids = array(56); // int[]

try {
    $result = $apiInstance->getOrderDetail($shop_cipher, $ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getOrderDetail: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Tiktok\Model\OrderSearchResponse**](../Model/OrderSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderList()`

```php
getOrderList($shop_cipher, $page_size, $sort_order, $page_token, $sort_field, $order_search): \Tiktok\Model\OrderSearchResponse
```

Get Order List

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$page_size = 56; // int | Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100.
$sort_order = 'sort_order_example'; // string | Available value: ASC;DESC(default)
$page_token = 'page_token_example'; // string | This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search
$sort_field = 'sort_field_example'; // string
$order_search = new \Tiktok\Model\OrderSearch(); // \Tiktok\Model\OrderSearch

try {
    $result = $apiInstance->getOrderList($shop_cipher, $page_size, $sort_order, $page_token, $sort_field, $order_search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getOrderList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **page_size** | **int**| Use this field to specify the maximum number of orders to obtain in a single page. Must be 1-100. | [optional] |
| **sort_order** | **string**| Available value: ASC;DESC(default) | [optional] |
| **page_token** | **string**| This field value would be returned in response data and you can use this to search the data on the next page. You do not need it at first search | [optional] |
| **sort_field** | **string**|  | [optional] |
| **order_search** | [**\Tiktok\Model\OrderSearch**](../Model/OrderSearch.md)|  | [optional] |

### Return type

[**\Tiktok\Model\OrderSearchResponse**](../Model/OrderSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPriceDetail()`

```php
getPriceDetail($order_id, $shop_cipher): \Tiktok\Model\PriceDetailResponse
```

Get Price Detail

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$order_id = 'order_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->getPriceDetail($order_id, $shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->getPriceDetail: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\PriceDetailResponse**](../Model/PriceDetailResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
