# Tiktok\LogisticsApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**getShippingProviders()**](LogisticsApi.md#getShippingProviders) | **GET** /logistics/202309/delivery_options/{delivery_option_id}/shipping_providers | Get Shipping Providers |
| [**getWarehouseDeliveryOptions()**](LogisticsApi.md#getWarehouseDeliveryOptions) | **GET** /logistics/202309/warehouses/{warehouse_id}/delivery_options | Get Warehouse Delivery Options |
| [**getWarehouseList()**](LogisticsApi.md#getWarehouseList) | **GET** /logistics/202309/warehouses | Get Warehouse List |


## `getShippingProviders()`

```php
getShippingProviders($delivery_option_id, $shop_cipher): \Tiktok\Model\ShippingProvdersResponse
```

Get Shipping Providers

This API is used to obtain the shipping provider corresponding to the specified delivery option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\LogisticsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$delivery_option_id = 'delivery_option_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->getShippingProviders($delivery_option_id, $shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LogisticsApi->getShippingProviders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **delivery_option_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\ShippingProvdersResponse**](../Model/ShippingProvdersResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseDeliveryOptions()`

```php
getWarehouseDeliveryOptions($warehouse_id, $shop_cipher): \Tiktok\Model\WarehouseDeliveryOptionResponse
```

Get Warehouse Delivery Options

This API is used to obtain the list of Delivery options subscribed by the seller's designated warehouse

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\LogisticsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$warehouse_id = 'warehouse_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->getWarehouseDeliveryOptions($warehouse_id, $shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LogisticsApi->getWarehouseDeliveryOptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **warehouse_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\WarehouseDeliveryOptionResponse**](../Model/WarehouseDeliveryOptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseList()`

```php
getWarehouseList($shop_cipher): \Tiktok\Model\WarehouseListResponse
```

Get Warehouse List

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\LogisticsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->getWarehouseList($shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LogisticsApi->getWarehouseList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\WarehouseListResponse**](../Model/WarehouseListResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
