# Tiktok\FulfilmentApi

All URIs are relative to https://open-api.tiktokglobalshop.com, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createPackages()**](FulfilmentApi.md#createPackages) | **POST** /fulfillment/202309/packages | Create Packages |
| [**getPackageDetail()**](FulfilmentApi.md#getPackageDetail) | **GET** /fulfillment/202309/packages/{package_id} | Get Package Detail |
| [**markPackageAsShipped()**](FulfilmentApi.md#markPackageAsShipped) | **POST** /fulfillment/202309/orders/{order_id}/packages | Mark Package As Shipped |
| [**shipPackage()**](FulfilmentApi.md#shipPackage) | **POST** /fulfillment/202309/packages/{package_id}/ship | Ship Package |
| [**updatePackageDeliveryStatus()**](FulfilmentApi.md#updatePackageDeliveryStatus) | **POST** /fulfillment/202309/packages/deliver | Update Package Delivery Status |
| [**updateShippingInfo()**](FulfilmentApi.md#updateShippingInfo) | **POST** /fulfillment/202309/orders/{order_id}/shipping_info/update | Update Shipping Info |


## `createPackages()`

```php
createPackages($shop_cipher, $create_packages_request): \Tiktok\Model\CreatePackagesResponse
```

Create Packages

Use this API to ship orders (purchase labels). This API is region specific to the US. The shipping fee and delivery time is an estimate only and is based on the package dimensions and weight you provided. Based on the package attributes, options listed below may differ from your shipping subscriptions.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\FulfilmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$create_packages_request = new \Tiktok\Model\CreatePackagesRequest(); // \Tiktok\Model\CreatePackagesRequest

try {
    $result = $apiInstance->createPackages($shop_cipher, $create_packages_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfilmentApi->createPackages: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **create_packages_request** | [**\Tiktok\Model\CreatePackagesRequest**](../Model/CreatePackagesRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\CreatePackagesResponse**](../Model/CreatePackagesResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPackageDetail()`

```php
getPackageDetail($package_id, $shop_cipher): \Tiktok\Model\PackageDetailResponse
```

Get Package Detail

Returns information about a package, including time slot for handover, tracking number and shipping provider information

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\FulfilmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$package_id = 'package_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.

try {
    $result = $apiInstance->getPackageDetail($package_id, $shop_cipher);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfilmentApi->getPackageDetail: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **package_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |

### Return type

[**\Tiktok\Model\PackageDetailResponse**](../Model/PackageDetailResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `markPackageAsShipped()`

```php
markPackageAsShipped($order_id, $shop_cipher, $package_shipped_request): \Tiktok\Model\PackageShippedResponse
```

Mark Package As Shipped

This API is region specific to the US temporarily. This API is for sellers who fulfill orders through their own selected/preferred logistics carrier. This API allows sellers to upload valid package information (items in packages, shipping provider information, and tracking number) orders/order line items to TikTok Shop. Note: Use Get Logistics Service API to retrieve the shipping_provider_id for shipping providers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\FulfilmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$order_id = 'order_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$package_shipped_request = new \Tiktok\Model\PackageShippedRequest(); // \Tiktok\Model\PackageShippedRequest

try {
    $result = $apiInstance->markPackageAsShipped($order_id, $shop_cipher, $package_shipped_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfilmentApi->markPackageAsShipped: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **package_shipped_request** | [**\Tiktok\Model\PackageShippedRequest**](../Model/PackageShippedRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\PackageShippedResponse**](../Model/PackageShippedResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `shipPackage()`

```php
shipPackage($package_id, $shop_cipher, $ship_package_request): \Tiktok\Model\Response
```

Ship Package

Use this API to ship the package. There are two kinds of shipping options available: TikTok Shipping, or Seller Shipping.   - TikTok Shipping: Schedule a package handover time for TikTok Shipping carriers to pickup a package from Seller.   - Seller Shipping: Seller arranges their own shipping, and upload a tracking number and shipping provider_id. Package ID can be obtained from Get Order Details

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\FulfilmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$package_id = 'package_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$ship_package_request = new \Tiktok\Model\ShipPackageRequest(); // \Tiktok\Model\ShipPackageRequest

try {
    $result = $apiInstance->shipPackage($package_id, $shop_cipher, $ship_package_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfilmentApi->shipPackage: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **package_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **ship_package_request** | [**\Tiktok\Model\ShipPackageRequest**](../Model/ShipPackageRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\Response**](../Model/Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePackageDeliveryStatus()`

```php
updatePackageDeliveryStatus($shop_cipher, $package_delivery_status_request): \Tiktok\Model\PackageDeliveryStatusResponse
```

Update Package Delivery Status

Use this API to update the delivered status of the package from in transit status . Please note that only sellers utilizing the SOF(Seller Own Fleet) capability can use this API to update the package status to 'DELIVERED'. This API is only available for the SEA region.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\FulfilmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$package_delivery_status_request = new \Tiktok\Model\PackageDeliveryStatusRequest(); // \Tiktok\Model\PackageDeliveryStatusRequest

try {
    $result = $apiInstance->updatePackageDeliveryStatus($shop_cipher, $package_delivery_status_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfilmentApi->updatePackageDeliveryStatus: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **package_delivery_status_request** | [**\Tiktok\Model\PackageDeliveryStatusRequest**](../Model/PackageDeliveryStatusRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\PackageDeliveryStatusResponse**](../Model/PackageDeliveryStatusResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateShippingInfo()`

```php
updateShippingInfo($order_id, $shop_cipher, $shipping_info_request): \Tiktok\Model\Response
```

Update Shipping Info

If the seller entered an incorrect tracking number, this API allows the seller to update the tracking number and shipping provider for an order that has already been shipped. Attention: - This API is only applicable to orders (or packages) shipped by the seller.   - It is only used to update the tracking number and shipping provider for packages that have already been shipped. - For orders that have been split for shipping, please use the \"Update Package Shipping Info\" api. Please note that TikTok Shop only allows merchants to update shipping information within 72 hours after shipping.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Tiktok\Api\FulfilmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$order_id = 'order_id_example'; // string
$shop_cipher = 'shop_cipher_example'; // string | Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response.
$shipping_info_request = new \Tiktok\Model\ShippingInfoRequest(); // \Tiktok\Model\ShippingInfoRequest

try {
    $result = $apiInstance->updateShippingInfo($order_id, $shop_cipher, $shipping_info_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfilmentApi->updateShippingInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **string**|  | |
| **shop_cipher** | **string**| Use this property to pass shop information in requesting the API. Failure in passing the correct value when requesting the API for cross-border shops will return incorrect response. | |
| **shipping_info_request** | [**\Tiktok\Model\ShippingInfoRequest**](../Model/ShippingInfoRequest.md)|  | [optional] |

### Return type

[**\Tiktok\Model\Response**](../Model/Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
